/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SingleTypeReference
extends TypeReference {
    public char[] token;

    public SingleTypeReference(char[] cArray, long l) {
        this.token = cArray;
        this.sourceStart = (int)(l >>> 32);
        this.sourceEnd = (int)(l & 0xFFFFFFFFL);
    }

    public TypeReference copyDims(int n) {
        return new ArrayTypeReference(this.token, n, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    public char[] getLastToken() {
        return this.token;
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        this.resolvedType = scope.getType(this.token);
        if (scope.kind == 3 && this.resolvedType.isValidBinding() && ((ClassScope)scope).detectHierarchyCycle(this.resolvedType, this)) {
            return null;
        }
        return this.resolvedType;
    }

    public char[][] getTypeName() {
        return new char[][]{this.token};
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return stringBuffer.append(this.token);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope blockScope, ReferenceBinding referenceBinding) {
        TypeBinding typeBinding = this.resolvedType = blockScope.getMemberType(this.token, referenceBinding);
        boolean bl = false;
        if (!typeBinding.isValidBinding()) {
            bl = true;
            blockScope.problemReporter().invalidEnclosingType(this, typeBinding, referenceBinding);
            typeBinding = typeBinding.closestMatch();
            if (typeBinding == null) {
                return null;
            }
        }
        if (this.isTypeUseDeprecated(typeBinding, blockScope)) {
            this.reportDeprecatedType(typeBinding, blockScope);
        }
        if ((typeBinding = blockScope.environment().convertToRawType(typeBinding, false)).isRawType() && (this.bits & 0x40000000) == 0 && blockScope.compilerOptions().getSeverity(0x20010000) != 256) {
            blockScope.problemReporter().rawTypeReference(this, typeBinding);
        }
        if (bl) {
            return typeBinding;
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

