/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class StringLiteralConcatenation
extends StringLiteral {
    private static final int INITIAL_SIZE = 5;
    public Expression[] literals;
    public int counter;

    public StringLiteralConcatenation(StringLiteral stringLiteral, StringLiteral stringLiteral2) {
        super(stringLiteral.sourceStart, stringLiteral.sourceEnd);
        this.source = stringLiteral.source;
        this.literals = new StringLiteral[5];
        this.counter = 0;
        this.literals[this.counter++] = stringLiteral;
        this.extendsWith(stringLiteral2);
    }

    public StringLiteralConcatenation extendsWith(StringLiteral stringLiteral) {
        this.sourceEnd = stringLiteral.sourceEnd;
        int n = this.literals.length;
        if (this.counter == n) {
            this.literals = new StringLiteral[n + 5];
            System.arraycopy(this.literals, 0, this.literals, 0, n);
        }
        int n2 = this.source.length;
        this.source = new char[n2 + stringLiteral.source.length];
        System.arraycopy(this.source, 0, this.source, 0, n2);
        System.arraycopy(stringLiteral.source, 0, this.source, n2, stringLiteral.source.length);
        this.literals[this.counter++] = stringLiteral;
        return this;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append("StringLiteralConcatenation{");
        int n2 = this.counter;
        for (int i = 0; i < n2; ++i) {
            this.literals[i].printExpression(n, stringBuffer);
            stringBuffer.append("+\n");
        }
        return stringBuffer.append('}');
    }

    public char[] source() {
        return this.source;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = this.counter;
            for (int i = 0; i < n; ++i) {
                this.literals[i].traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

