/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ClassFilePool;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier15;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolymorphicMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public class LookupEnvironment
implements ProblemReasons,
TypeConstants {
    private Map accessRestrictions;
    ImportBinding[] defaultImports;
    public PackageBinding defaultPackage;
    HashtableOfPackage knownPackages;
    private int lastCompletedUnitIndex = -1;
    private int lastUnitIndex = -1;
    public INameEnvironment nameEnvironment;
    public CompilerOptions globalOptions;
    public ProblemReporter problemReporter;
    public ClassFilePool classFilePool;
    private int stepCompleted;
    public ITypeRequestor typeRequestor;
    private ArrayBinding[][] uniqueArrayBindings;
    private SimpleLookupTable uniqueParameterizedTypeBindings;
    private SimpleLookupTable uniqueRawTypeBindings;
    private SimpleLookupTable uniqueWildcardBindings;
    private SimpleLookupTable uniqueParameterizedGenericMethodBindings;
    private SimpleLookupTable uniquePolymorphicMethodBindings;
    private SimpleLookupTable uniqueGetClassMethodBinding;
    public CompilationUnitDeclaration unitBeingCompleted = null;
    public Object missingClassFileLocation = null;
    private CompilationUnitDeclaration[] units = new CompilationUnitDeclaration[4];
    private MethodVerifier verifier;
    public MethodBinding arrayClone;
    private ArrayList missingTypes;
    Set typesBeingConnected;
    public boolean isProcessingAnnotations = false;
    static final int BUILD_FIELDS_AND_METHODS = 4;
    static final int BUILD_TYPE_HIERARCHY = 1;
    static final int CHECK_AND_SET_IMPORTS = 2;
    static final int CONNECT_TYPE_HIERARCHY = 3;
    static final ProblemPackageBinding TheNotFoundPackage = new ProblemPackageBinding(CharOperation.NO_CHAR, 1);
    static final ProblemReferenceBinding TheNotFoundType = new ProblemReferenceBinding(CharOperation.NO_CHAR_CHAR, null, 1);

    public LookupEnvironment(ITypeRequestor iTypeRequestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, INameEnvironment iNameEnvironment) {
        this.typeRequestor = iTypeRequestor;
        this.globalOptions = compilerOptions;
        this.problemReporter = problemReporter;
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.nameEnvironment = iNameEnvironment;
        this.knownPackages = new HashtableOfPackage();
        this.uniqueArrayBindings = new ArrayBinding[5][];
        this.uniqueArrayBindings[0] = new ArrayBinding[50];
        this.uniqueParameterizedTypeBindings = new SimpleLookupTable(3);
        this.uniqueRawTypeBindings = new SimpleLookupTable(3);
        this.uniqueWildcardBindings = new SimpleLookupTable(3);
        this.uniqueParameterizedGenericMethodBindings = new SimpleLookupTable(3);
        this.uniquePolymorphicMethodBindings = new SimpleLookupTable(3);
        this.missingTypes = null;
        this.accessRestrictions = new HashMap(3);
        this.classFilePool = ClassFilePool.newInstance();
        this.typesBeingConnected = new HashSet();
    }

    public ReferenceBinding askForType(char[][] cArray) {
        NameEnvironmentAnswer nameEnvironmentAnswer = this.nameEnvironment.findType(cArray);
        if (nameEnvironmentAnswer == null) {
            return null;
        }
        if (nameEnvironmentAnswer.isBinaryType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getBinaryType(), this.computePackageFrom(cArray, false), nameEnvironmentAnswer.getAccessRestriction());
        } else if (nameEnvironmentAnswer.isCompilationUnit()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getCompilationUnit(), nameEnvironmentAnswer.getAccessRestriction());
        } else if (nameEnvironmentAnswer.isSourceType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getSourceTypes(), this.computePackageFrom(cArray, false), nameEnvironmentAnswer.getAccessRestriction());
        }
        return this.getCachedType(cArray);
    }

    ReferenceBinding askForType(PackageBinding packageBinding, char[] cArray) {
        NameEnvironmentAnswer nameEnvironmentAnswer;
        if (packageBinding == null) {
            packageBinding = this.defaultPackage;
        }
        if ((nameEnvironmentAnswer = this.nameEnvironment.findType(cArray, packageBinding.compoundName)) == null) {
            return null;
        }
        if (nameEnvironmentAnswer.isBinaryType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getBinaryType(), packageBinding, nameEnvironmentAnswer.getAccessRestriction());
        } else if (nameEnvironmentAnswer.isCompilationUnit()) {
            try {
                this.typeRequestor.accept(nameEnvironmentAnswer.getCompilationUnit(), nameEnvironmentAnswer.getAccessRestriction());
            }
            catch (AbortCompilation abortCompilation) {
                if (CharOperation.equals(cArray, TypeConstants.PACKAGE_INFO_NAME)) {
                    return null;
                }
                throw abortCompilation;
            }
        } else if (nameEnvironmentAnswer.isSourceType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getSourceTypes(), packageBinding, nameEnvironmentAnswer.getAccessRestriction());
        }
        return packageBinding.getType0(cArray);
    }

    public void buildTypeBindings(CompilationUnitDeclaration compilationUnitDeclaration, AccessRestriction accessRestriction) {
        CompilationUnitScope compilationUnitScope = new CompilationUnitScope(compilationUnitDeclaration, this);
        compilationUnitScope.buildTypeBindings(accessRestriction);
        int n = this.units.length;
        if (++this.lastUnitIndex >= n) {
            this.units = new CompilationUnitDeclaration[2 * n];
            System.arraycopy(this.units, 0, this.units, 0, n);
        }
        this.units[this.lastUnitIndex] = compilationUnitDeclaration;
    }

    public BinaryTypeBinding cacheBinaryType(IBinaryType iBinaryType, AccessRestriction accessRestriction) {
        return this.cacheBinaryType(iBinaryType, true, accessRestriction);
    }

    public BinaryTypeBinding cacheBinaryType(IBinaryType iBinaryType, boolean bl, AccessRestriction accessRestriction) {
        char[][] cArray = CharOperation.splitOn('/', iBinaryType.getName());
        ReferenceBinding referenceBinding = this.getCachedType(cArray);
        if (referenceBinding == null || referenceBinding instanceof UnresolvedReferenceBinding) {
            return this.createBinaryTypeFrom(iBinaryType, this.computePackageFrom(cArray, false), bl, accessRestriction);
        }
        return null;
    }

    public void completeTypeBindings() {
        int n;
        this.stepCompleted = 1;
        for (n = this.lastCompletedUnitIndex + 1; n <= this.lastUnitIndex; ++n) {
            this.unitBeingCompleted = this.units[n];
            this.unitBeingCompleted.scope.checkAndSetImports();
        }
        this.stepCompleted = 2;
        for (n = this.lastCompletedUnitIndex + 1; n <= this.lastUnitIndex; ++n) {
            this.unitBeingCompleted = this.units[n];
            this.unitBeingCompleted.scope.connectTypeHierarchy();
        }
        this.stepCompleted = 3;
        for (n = this.lastCompletedUnitIndex + 1; n <= this.lastUnitIndex; ++n) {
            this.unitBeingCompleted = this.units[n];
            CompilationUnitScope compilationUnitScope = this.unitBeingCompleted.scope;
            compilationUnitScope.checkParameterizedTypes();
            compilationUnitScope.buildFieldsAndMethods();
            this.units[n] = null;
        }
        this.stepCompleted = 4;
        this.lastCompletedUnitIndex = this.lastUnitIndex;
        this.unitBeingCompleted = null;
    }

    public void completeTypeBindings(CompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.stepCompleted == 4) {
            this.completeTypeBindings();
        } else {
            if (compilationUnitDeclaration.scope == null) {
                return;
            }
            if (this.stepCompleted >= 2) {
                this.unitBeingCompleted = compilationUnitDeclaration;
                this.unitBeingCompleted.scope.checkAndSetImports();
            }
            if (this.stepCompleted >= 3) {
                this.unitBeingCompleted = compilationUnitDeclaration;
                this.unitBeingCompleted.scope.connectTypeHierarchy();
            }
            this.unitBeingCompleted = null;
        }
    }

    public void completeTypeBindings(CompilationUnitDeclaration compilationUnitDeclaration, boolean bl) {
        if (compilationUnitDeclaration.scope == null) {
            return;
        }
        this.unitBeingCompleted = compilationUnitDeclaration;
        this.unitBeingCompleted.scope.checkAndSetImports();
        compilationUnitDeclaration.scope.connectTypeHierarchy();
        compilationUnitDeclaration.scope.checkParameterizedTypes();
        if (bl) {
            compilationUnitDeclaration.scope.buildFieldsAndMethods();
        }
        this.unitBeingCompleted = null;
    }

    public void completeTypeBindings(CompilationUnitDeclaration[] compilationUnitDeclarationArray, boolean[] blArray, int n) {
        CompilationUnitDeclaration compilationUnitDeclaration;
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            compilationUnitDeclaration = compilationUnitDeclarationArray[n2];
            if (compilationUnitDeclaration.scope == null) continue;
            this.unitBeingCompleted = compilationUnitDeclaration;
            this.unitBeingCompleted.scope.checkAndSetImports();
        }
        for (n2 = 0; n2 < n; ++n2) {
            compilationUnitDeclaration = compilationUnitDeclarationArray[n2];
            if (compilationUnitDeclaration.scope == null) continue;
            this.unitBeingCompleted = compilationUnitDeclaration;
            this.unitBeingCompleted.scope.connectTypeHierarchy();
        }
        for (n2 = 0; n2 < n; ++n2) {
            compilationUnitDeclaration = compilationUnitDeclarationArray[n2];
            if (compilationUnitDeclaration.scope == null) continue;
            this.unitBeingCompleted = compilationUnitDeclaration;
            this.unitBeingCompleted.scope.checkParameterizedTypes();
            if (!blArray[n2]) continue;
            compilationUnitDeclaration.scope.buildFieldsAndMethods();
        }
        this.unitBeingCompleted = null;
    }

    public MethodBinding computeArrayClone(MethodBinding methodBinding) {
        if (this.arrayClone == null) {
            this.arrayClone = new MethodBinding(methodBinding.modifiers & 0xFFFFFFFB | 1, TypeConstants.CLONE, methodBinding.returnType, Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, (ReferenceBinding)methodBinding.returnType);
        }
        return this.arrayClone;
    }

    public TypeBinding computeBoxingType(TypeBinding typeBinding) {
        switch (typeBinding.id) {
            case 33: {
                return TypeBinding.BOOLEAN;
            }
            case 26: {
                return TypeBinding.BYTE;
            }
            case 28: {
                return TypeBinding.CHAR;
            }
            case 27: {
                return TypeBinding.SHORT;
            }
            case 32: {
                return TypeBinding.DOUBLE;
            }
            case 31: {
                return TypeBinding.FLOAT;
            }
            case 29: {
                return TypeBinding.INT;
            }
            case 30: {
                return TypeBinding.LONG;
            }
            case 10: {
                ReferenceBinding referenceBinding = this.getType(TypeConstants.JAVA_LANG_INTEGER);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_INTEGER, null, 1);
            }
            case 3: {
                ReferenceBinding referenceBinding = this.getType(TypeConstants.JAVA_LANG_BYTE);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_BYTE, null, 1);
            }
            case 4: {
                ReferenceBinding referenceBinding = this.getType(TypeConstants.JAVA_LANG_SHORT);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_SHORT, null, 1);
            }
            case 2: {
                ReferenceBinding referenceBinding = this.getType(TypeConstants.JAVA_LANG_CHARACTER);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_CHARACTER, null, 1);
            }
            case 7: {
                ReferenceBinding referenceBinding = this.getType(TypeConstants.JAVA_LANG_LONG);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_LONG, null, 1);
            }
            case 9: {
                ReferenceBinding referenceBinding = this.getType(TypeConstants.JAVA_LANG_FLOAT);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_FLOAT, null, 1);
            }
            case 8: {
                ReferenceBinding referenceBinding = this.getType(TypeConstants.JAVA_LANG_DOUBLE);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_DOUBLE, null, 1);
            }
            case 5: {
                ReferenceBinding referenceBinding = this.getType(TypeConstants.JAVA_LANG_BOOLEAN);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_BOOLEAN, null, 1);
            }
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 4100: 
            case 8196: {
                switch (typeBinding.erasure().id) {
                    case 33: {
                        return TypeBinding.BOOLEAN;
                    }
                    case 26: {
                        return TypeBinding.BYTE;
                    }
                    case 28: {
                        return TypeBinding.CHAR;
                    }
                    case 27: {
                        return TypeBinding.SHORT;
                    }
                    case 32: {
                        return TypeBinding.DOUBLE;
                    }
                    case 31: {
                        return TypeBinding.FLOAT;
                    }
                    case 29: {
                        return TypeBinding.INT;
                    }
                    case 30: {
                        return TypeBinding.LONG;
                    }
                }
            }
        }
        return typeBinding;
    }

    private PackageBinding computePackageFrom(char[][] cArray, boolean bl) {
        if (cArray.length == 1) {
            return this.defaultPackage;
        }
        PackageBinding packageBinding = this.getPackage0(cArray[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            packageBinding = new PackageBinding(cArray[0], this);
            if (bl) {
                packageBinding.tagBits |= 0x80L;
            }
            this.knownPackages.put(cArray[0], packageBinding);
        }
        int n = cArray.length - 1;
        for (int i = 1; i < n; ++i) {
            PackageBinding packageBinding2 = packageBinding;
            if ((packageBinding = packageBinding2.getPackage0(cArray[i])) != null && packageBinding != TheNotFoundPackage) continue;
            packageBinding = new PackageBinding(CharOperation.subarray(cArray, 0, i + 1), packageBinding2, this);
            if (bl) {
                packageBinding.tagBits |= 0x80L;
            }
            packageBinding2.addPackage(packageBinding);
        }
        return packageBinding;
    }

    public ReferenceBinding convertToParameterizedType(ReferenceBinding referenceBinding) {
        if (referenceBinding != null) {
            ReferenceBinding referenceBinding2;
            boolean bl = referenceBinding.isGenericType();
            ReferenceBinding referenceBinding3 = referenceBinding2 = referenceBinding.enclosingType();
            boolean bl2 = bl;
            if (referenceBinding2 != null) {
                referenceBinding3 = referenceBinding.isStatic() ? (ReferenceBinding)this.convertToRawType(referenceBinding2, false) : this.convertToParameterizedType(referenceBinding2);
                bl2 |= referenceBinding2 != referenceBinding3;
            }
            if (bl2) {
                return this.createParameterizedType(referenceBinding, bl ? referenceBinding.typeVariables() : null, referenceBinding3);
            }
        }
        return referenceBinding;
    }

    public TypeBinding convertToRawType(TypeBinding typeBinding, boolean bl) {
        TypeBinding typeBinding2;
        ReferenceBinding referenceBinding;
        boolean bl2;
        TypeBinding typeBinding3;
        int n;
        switch (typeBinding.kind()) {
            case 132: 
            case 516: 
            case 1028: 
            case 4100: 
            case 8196: {
                return typeBinding;
            }
            case 68: {
                n = typeBinding.dimensions();
                typeBinding3 = typeBinding.leafComponentType();
                break;
            }
            default: {
                if (typeBinding.id == 1) {
                    return typeBinding;
                }
                n = 0;
                typeBinding3 = typeBinding;
            }
        }
        switch (typeBinding3.kind()) {
            case 132: {
                return typeBinding;
            }
            case 2052: {
                bl2 = true;
                break;
            }
            case 260: {
                referenceBinding = (ParameterizedTypeBinding)typeBinding3;
                bl2 = ((ParameterizedTypeBinding)referenceBinding).genericType().isGenericType();
                break;
            }
            default: {
                bl2 = false;
            }
        }
        referenceBinding = typeBinding3.enclosingType();
        if (referenceBinding == null) {
            typeBinding2 = bl2 ? this.createRawType((ReferenceBinding)typeBinding3.erasure(), null) : typeBinding3;
        } else {
            ReferenceBinding referenceBinding2;
            if (referenceBinding.kind() == 1028) {
                bl2 |= !((ReferenceBinding)typeBinding3).isStatic();
                referenceBinding2 = referenceBinding;
            } else if (bl && !bl2) {
                referenceBinding2 = (ReferenceBinding)this.convertToRawType(referenceBinding, bl);
                bl2 = referenceBinding != referenceBinding2;
            } else {
                referenceBinding2 = bl2 || ((ReferenceBinding)typeBinding3).isStatic() ? (ReferenceBinding)this.convertToRawType(referenceBinding, false) : this.convertToParameterizedType(referenceBinding);
            }
            typeBinding2 = bl2 ? this.createRawType((ReferenceBinding)typeBinding3.erasure(), referenceBinding2) : (referenceBinding != referenceBinding2 ? this.createParameterizedType((ReferenceBinding)typeBinding3.erasure(), null, referenceBinding2) : typeBinding3);
        }
        if (typeBinding3 != typeBinding2) {
            return n > 0 ? this.createArrayType(typeBinding2, n) : typeBinding2;
        }
        return typeBinding;
    }

    public ReferenceBinding[] convertToRawTypes(ReferenceBinding[] referenceBindingArray, boolean bl, boolean bl2) {
        if (referenceBindingArray == null) {
            return null;
        }
        ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
        int n = referenceBindingArray.length;
        for (int i = 0; i < n; ++i) {
            ReferenceBinding referenceBinding = referenceBindingArray[i];
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.convertToRawType(bl ? referenceBinding.erasure() : referenceBinding, bl2);
            if (referenceBinding2 != referenceBinding) {
                if (referenceBindingArray2 == referenceBindingArray) {
                    referenceBindingArray2 = new ReferenceBinding[n];
                    System.arraycopy(referenceBindingArray, 0, referenceBindingArray2, 0, i);
                }
                referenceBindingArray2[i] = referenceBinding2;
                continue;
            }
            if (referenceBindingArray2 == referenceBindingArray) continue;
            referenceBindingArray2[i] = referenceBinding;
        }
        return referenceBindingArray2;
    }

    public TypeBinding convertUnresolvedBinaryToRawType(TypeBinding typeBinding) {
        TypeBinding typeBinding2;
        ReferenceBinding referenceBinding;
        boolean bl;
        TypeBinding typeBinding3;
        int n;
        switch (typeBinding.kind()) {
            case 132: 
            case 516: 
            case 1028: 
            case 4100: 
            case 8196: {
                return typeBinding;
            }
            case 68: {
                n = typeBinding.dimensions();
                typeBinding3 = typeBinding.leafComponentType();
                break;
            }
            default: {
                if (typeBinding.id == 1) {
                    return typeBinding;
                }
                n = 0;
                typeBinding3 = typeBinding;
            }
        }
        switch (typeBinding3.kind()) {
            case 132: {
                return typeBinding;
            }
            case 2052: {
                bl = true;
                break;
            }
            case 260: {
                referenceBinding = (ParameterizedTypeBinding)typeBinding3;
                bl = referenceBinding.genericType().isGenericType();
                break;
            }
            default: {
                bl = false;
            }
        }
        referenceBinding = typeBinding3.enclosingType();
        if (referenceBinding == null) {
            typeBinding2 = bl ? this.createRawType((ReferenceBinding)typeBinding3.erasure(), null) : typeBinding3;
        } else {
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.convertUnresolvedBinaryToRawType(referenceBinding);
            if (referenceBinding2 != referenceBinding) {
                bl |= !((ReferenceBinding)typeBinding3).isStatic();
            }
            typeBinding2 = bl ? this.createRawType((ReferenceBinding)typeBinding3.erasure(), referenceBinding2) : (referenceBinding != referenceBinding2 ? this.createParameterizedType((ReferenceBinding)typeBinding3.erasure(), null, referenceBinding2) : typeBinding3);
        }
        if (typeBinding3 != typeBinding2) {
            return n > 0 ? this.createArrayType(typeBinding2, n) : typeBinding2;
        }
        return typeBinding;
    }

    public AnnotationBinding createAnnotation(ReferenceBinding referenceBinding, ElementValuePair[] elementValuePairArray) {
        if (elementValuePairArray.length != 0) {
            AnnotationBinding.setMethodBindings(referenceBinding, elementValuePairArray);
        }
        return new AnnotationBinding(referenceBinding, elementValuePairArray);
    }

    public ArrayBinding createArrayType(TypeBinding typeBinding, int n) {
        ArrayBinding[] arrayBindingArray;
        if (typeBinding instanceof LocalTypeBinding) {
            return ((LocalTypeBinding)typeBinding).createArrayType(n, this);
        }
        int n2 = n - 1;
        int n3 = this.uniqueArrayBindings.length;
        if (n2 < n3) {
            arrayBindingArray = this.uniqueArrayBindings[n2];
            if (arrayBindingArray == null) {
                arrayBindingArray = new ArrayBinding[10];
                this.uniqueArrayBindings[n2] = arrayBindingArray;
            }
        } else {
            this.uniqueArrayBindings = new ArrayBinding[n][];
            System.arraycopy(this.uniqueArrayBindings, 0, this.uniqueArrayBindings, 0, n3);
            arrayBindingArray = new ArrayBinding[10];
            this.uniqueArrayBindings[n2] = arrayBindingArray;
        }
        int n4 = -1;
        n3 = arrayBindingArray.length;
        while (++n4 < n3) {
            ArrayBinding arrayBinding = arrayBindingArray[n4];
            if (arrayBinding == null) {
                arrayBindingArray[n4] = new ArrayBinding(typeBinding, n, this);
                return arrayBindingArray[n4];
            }
            if (arrayBinding.leafComponentType != typeBinding) continue;
            return arrayBinding;
        }
        ArrayBinding[] arrayBindingArray2 = arrayBindingArray;
        arrayBindingArray = new ArrayBinding[n3 * 2];
        System.arraycopy(arrayBindingArray2, 0, arrayBindingArray, 0, n3);
        this.uniqueArrayBindings[n2] = arrayBindingArray;
        arrayBindingArray[n3] = new ArrayBinding(typeBinding, n, this);
        return arrayBindingArray[n3];
    }

    public BinaryTypeBinding createBinaryTypeFrom(IBinaryType iBinaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        return this.createBinaryTypeFrom(iBinaryType, packageBinding, true, accessRestriction);
    }

    public BinaryTypeBinding createBinaryTypeFrom(IBinaryType iBinaryType, PackageBinding packageBinding, boolean bl, AccessRestriction accessRestriction) {
        BinaryTypeBinding binaryTypeBinding = new BinaryTypeBinding(packageBinding, iBinaryType, this);
        ReferenceBinding referenceBinding = packageBinding.getType0(binaryTypeBinding.compoundName[binaryTypeBinding.compoundName.length - 1]);
        if (referenceBinding != null) {
            if (referenceBinding instanceof UnresolvedReferenceBinding) {
                ((UnresolvedReferenceBinding)referenceBinding).setResolvedType(binaryTypeBinding, this);
            } else {
                if (referenceBinding.isBinaryBinding()) {
                    return (BinaryTypeBinding)referenceBinding;
                }
                return null;
            }
        }
        packageBinding.addType(binaryTypeBinding);
        this.setAccessRestriction(binaryTypeBinding, accessRestriction);
        binaryTypeBinding.cachePartsFrom(iBinaryType, bl);
        return binaryTypeBinding;
    }

    public MissingTypeBinding createMissingType(PackageBinding packageBinding, char[][] cArray) {
        if (packageBinding == null && (packageBinding = this.computePackageFrom(cArray, true)) == TheNotFoundPackage) {
            packageBinding = this.defaultPackage;
        }
        MissingTypeBinding missingTypeBinding = new MissingTypeBinding(packageBinding, cArray, this);
        if (missingTypeBinding.id != 1) {
            ReferenceBinding referenceBinding = this.getType(TypeConstants.JAVA_LANG_OBJECT);
            if (referenceBinding == null) {
                referenceBinding = this.createMissingType(null, TypeConstants.JAVA_LANG_OBJECT);
            }
            missingTypeBinding.setMissingSuperclass(referenceBinding);
        }
        packageBinding.addType(missingTypeBinding);
        if (this.missingTypes == null) {
            this.missingTypes = new ArrayList(3);
        }
        this.missingTypes.add(missingTypeBinding);
        return missingTypeBinding;
    }

    public PackageBinding createPackage(char[][] cArray) {
        PackageBinding packageBinding = this.getPackage0(cArray[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            packageBinding = new PackageBinding(cArray[0], this);
            this.knownPackages.put(cArray[0], packageBinding);
        }
        int n = cArray.length;
        for (int i = 1; i < n; ++i) {
            ReferenceBinding referenceBinding = packageBinding.getType0(cArray[i]);
            if (referenceBinding != null && referenceBinding != TheNotFoundType && !(referenceBinding instanceof UnresolvedReferenceBinding)) {
                return null;
            }
            PackageBinding packageBinding2 = packageBinding;
            if ((packageBinding = packageBinding2.getPackage0(cArray[i])) != null && packageBinding != TheNotFoundPackage) continue;
            if (this.nameEnvironment.findType(cArray[i], packageBinding2.compoundName) != null) {
                return null;
            }
            packageBinding = new PackageBinding(CharOperation.subarray(cArray, 0, i + 1), packageBinding2, this);
            packageBinding2.addPackage(packageBinding);
        }
        return packageBinding;
    }

    public ParameterizedGenericMethodBinding createParameterizedGenericMethod(MethodBinding methodBinding, RawTypeBinding rawTypeBinding) {
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding;
        int n;
        int n2;
        ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray = (ParameterizedGenericMethodBinding[])this.uniqueParameterizedGenericMethodBindings.get(methodBinding);
        boolean bl = false;
        if (parameterizedGenericMethodBindingArray != null) {
            n2 = parameterizedGenericMethodBindingArray.length;
            for (n = 0; n < n2 && (parameterizedGenericMethodBinding = parameterizedGenericMethodBindingArray[n]) != null; ++n) {
                if (!parameterizedGenericMethodBinding.isRaw || parameterizedGenericMethodBinding.declaringClass != (rawTypeBinding == null ? methodBinding.declaringClass : rawTypeBinding)) continue;
                return parameterizedGenericMethodBinding;
            }
            bl = true;
        } else {
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[5];
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        n2 = parameterizedGenericMethodBindingArray.length;
        if (bl && n == n2) {
            ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray2 = parameterizedGenericMethodBindingArray;
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[n2 * 2];
            System.arraycopy(parameterizedGenericMethodBindingArray2, 0, parameterizedGenericMethodBindingArray, 0, n2);
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        parameterizedGenericMethodBindingArray[n] = parameterizedGenericMethodBinding = new ParameterizedGenericMethodBinding(methodBinding, rawTypeBinding, this);
        return parameterizedGenericMethodBinding;
    }

    public ParameterizedGenericMethodBinding createParameterizedGenericMethod(MethodBinding methodBinding, TypeBinding[] typeBindingArray) {
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding;
        int n;
        int n2;
        ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray = (ParameterizedGenericMethodBinding[])this.uniqueParameterizedGenericMethodBindings.get(methodBinding);
        int n3 = typeBindingArray == null ? 0 : typeBindingArray.length;
        boolean bl = false;
        if (parameterizedGenericMethodBindingArray != null) {
            n2 = parameterizedGenericMethodBindingArray.length;
            block0: for (n = 0; n < n2 && (parameterizedGenericMethodBinding = parameterizedGenericMethodBindingArray[n]) != null; ++n) {
                int n4;
                if (parameterizedGenericMethodBinding.isRaw) continue;
                TypeBinding[] typeBindingArray2 = parameterizedGenericMethodBinding.typeArguments;
                int n5 = n4 = typeBindingArray2 == null ? 0 : typeBindingArray2.length;
                if (n3 != n4) continue;
                for (int i = 0; i < n4; ++i) {
                    if (typeBindingArray[i] != typeBindingArray2[i]) continue block0;
                }
                return parameterizedGenericMethodBinding;
            }
            bl = true;
        } else {
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[5];
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        n2 = parameterizedGenericMethodBindingArray.length;
        if (bl && n == n2) {
            ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray2 = parameterizedGenericMethodBindingArray;
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[n2 * 2];
            System.arraycopy(parameterizedGenericMethodBindingArray2, 0, parameterizedGenericMethodBindingArray, 0, n2);
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        parameterizedGenericMethodBindingArray[n] = parameterizedGenericMethodBinding = new ParameterizedGenericMethodBinding(methodBinding, typeBindingArray, this);
        return parameterizedGenericMethodBinding;
    }

    public PolymorphicMethodBinding createPolymorphicMethod(MethodBinding methodBinding, TypeBinding[] typeBindingArray) {
        PolymorphicMethodBinding polymorphicMethodBinding;
        int n;
        int n2;
        int n3;
        String string = new String(methodBinding.selector);
        PolymorphicMethodBinding[] polymorphicMethodBindingArray = (PolymorphicMethodBinding[])this.uniquePolymorphicMethodBindings.get(string);
        int n4 = typeBindingArray == null ? 0 : typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = new TypeBinding[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            TypeBinding typeBinding = typeBindingArray[n3];
            typeBindingArray2[n3] = typeBinding.id == 12 ? this.getType(TypeConstants.JAVA_LANG_VOID) : typeBinding.erasure();
        }
        n3 = 0;
        if (polymorphicMethodBindingArray != null) {
            n2 = polymorphicMethodBindingArray.length;
            for (n = 0; n < n2 && (polymorphicMethodBinding = polymorphicMethodBindingArray[n]) != null; ++n) {
                if (!polymorphicMethodBinding.matches(typeBindingArray2, methodBinding.returnType)) continue;
                return polymorphicMethodBinding;
            }
            n3 = 1;
        } else {
            polymorphicMethodBindingArray = new PolymorphicMethodBinding[5];
            this.uniquePolymorphicMethodBindings.put(string, polymorphicMethodBindingArray);
        }
        n2 = polymorphicMethodBindingArray.length;
        if (n3 != 0 && n == n2) {
            PolymorphicMethodBinding[] polymorphicMethodBindingArray2 = polymorphicMethodBindingArray;
            polymorphicMethodBindingArray = new PolymorphicMethodBinding[n2 * 2];
            System.arraycopy(polymorphicMethodBindingArray2, 0, polymorphicMethodBindingArray, 0, n2);
            this.uniquePolymorphicMethodBindings.put(string, polymorphicMethodBindingArray);
        }
        polymorphicMethodBindingArray[n] = polymorphicMethodBinding = new PolymorphicMethodBinding(methodBinding, typeBindingArray2);
        return polymorphicMethodBinding;
    }

    public MethodBinding updatePolymorphicMethodReturnType(PolymorphicMethodBinding polymorphicMethodBinding, TypeBinding typeBinding) {
        PolymorphicMethodBinding polymorphicMethodBinding2;
        int n;
        int n2;
        String string = new String(polymorphicMethodBinding.selector);
        PolymorphicMethodBinding[] polymorphicMethodBindingArray = (PolymorphicMethodBinding[])this.uniquePolymorphicMethodBindings.get(string);
        boolean bl = false;
        TypeBinding[] typeBindingArray = polymorphicMethodBinding.parameters;
        if (polymorphicMethodBindingArray != null) {
            n2 = polymorphicMethodBindingArray.length;
            for (n = 0; n < n2 && (polymorphicMethodBinding2 = polymorphicMethodBindingArray[n]) != null; ++n) {
                if (!polymorphicMethodBinding2.matches(typeBindingArray, typeBinding)) continue;
                return polymorphicMethodBinding2;
            }
            bl = true;
        } else {
            polymorphicMethodBindingArray = new PolymorphicMethodBinding[5];
            this.uniquePolymorphicMethodBindings.put(string, polymorphicMethodBindingArray);
        }
        n2 = polymorphicMethodBindingArray.length;
        if (bl && n == n2) {
            PolymorphicMethodBinding[] polymorphicMethodBindingArray2 = polymorphicMethodBindingArray;
            polymorphicMethodBindingArray = new PolymorphicMethodBinding[n2 * 2];
            System.arraycopy(polymorphicMethodBindingArray2, 0, polymorphicMethodBindingArray, 0, n2);
            this.uniquePolymorphicMethodBindings.put(string, polymorphicMethodBindingArray);
        }
        polymorphicMethodBindingArray[n] = polymorphicMethodBinding2 = new PolymorphicMethodBinding(polymorphicMethodBinding.original(), typeBinding, typeBindingArray);
        return polymorphicMethodBinding2;
    }

    public ParameterizedMethodBinding createGetClassMethod(TypeBinding typeBinding, MethodBinding methodBinding, Scope scope) {
        ParameterizedMethodBinding parameterizedMethodBinding = null;
        if (this.uniqueGetClassMethodBinding == null) {
            this.uniqueGetClassMethodBinding = new SimpleLookupTable(3);
        } else {
            parameterizedMethodBinding = (ParameterizedMethodBinding)this.uniqueGetClassMethodBinding.get(typeBinding);
        }
        if (parameterizedMethodBinding == null) {
            parameterizedMethodBinding = ParameterizedMethodBinding.instantiateGetClass(typeBinding, methodBinding, scope);
            this.uniqueGetClassMethodBinding.put(typeBinding, parameterizedMethodBinding);
        }
        return parameterizedMethodBinding;
    }

    public ParameterizedTypeBinding createParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2) {
        ParameterizedTypeBinding parameterizedTypeBinding;
        int n;
        int n2;
        ParameterizedTypeBinding[] parameterizedTypeBindingArray = (ParameterizedTypeBinding[])this.uniqueParameterizedTypeBindings.get(referenceBinding);
        int n3 = typeBindingArray == null ? 0 : typeBindingArray.length;
        boolean bl = false;
        if (parameterizedTypeBindingArray != null) {
            n2 = parameterizedTypeBindingArray.length;
            block0: for (n = 0; n < n2 && (parameterizedTypeBinding = parameterizedTypeBindingArray[n]) != null; ++n) {
                int n4;
                if (parameterizedTypeBinding.actualType() != referenceBinding || parameterizedTypeBinding.enclosingType() != referenceBinding2) continue;
                TypeBinding[] typeBindingArray2 = parameterizedTypeBinding.arguments;
                int n5 = n4 = typeBindingArray2 == null ? 0 : typeBindingArray2.length;
                if (n3 != n4) continue;
                for (int i = 0; i < n4; ++i) {
                    if (typeBindingArray[i] != typeBindingArray2[i]) continue block0;
                }
                return parameterizedTypeBinding;
            }
            bl = true;
        } else {
            parameterizedTypeBindingArray = new ParameterizedTypeBinding[5];
            this.uniqueParameterizedTypeBindings.put(referenceBinding, parameterizedTypeBindingArray);
        }
        n2 = parameterizedTypeBindingArray.length;
        if (bl && n == n2) {
            ParameterizedTypeBinding[] parameterizedTypeBindingArray2 = parameterizedTypeBindingArray;
            parameterizedTypeBindingArray = new ParameterizedTypeBinding[n2 * 2];
            System.arraycopy(parameterizedTypeBindingArray2, 0, parameterizedTypeBindingArray, 0, n2);
            this.uniqueParameterizedTypeBindings.put(referenceBinding, parameterizedTypeBindingArray);
        }
        parameterizedTypeBindingArray[n] = parameterizedTypeBinding = new ParameterizedTypeBinding(referenceBinding, typeBindingArray, referenceBinding2, this);
        return parameterizedTypeBinding;
    }

    public RawTypeBinding createRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        RawTypeBinding rawTypeBinding;
        int n;
        int n2;
        RawTypeBinding[] rawTypeBindingArray = (RawTypeBinding[])this.uniqueRawTypeBindings.get(referenceBinding);
        boolean bl = false;
        if (rawTypeBindingArray != null) {
            n2 = rawTypeBindingArray.length;
            for (n = 0; n < n2 && (rawTypeBinding = rawTypeBindingArray[n]) != null; ++n) {
                if (rawTypeBinding.actualType() != referenceBinding || rawTypeBinding.enclosingType() != referenceBinding2) continue;
                return rawTypeBinding;
            }
            bl = true;
        } else {
            rawTypeBindingArray = new RawTypeBinding[1];
            this.uniqueRawTypeBindings.put(referenceBinding, rawTypeBindingArray);
        }
        n2 = rawTypeBindingArray.length;
        if (bl && n == n2) {
            RawTypeBinding[] rawTypeBindingArray2 = rawTypeBindingArray;
            rawTypeBindingArray = new RawTypeBinding[n2 * 2];
            System.arraycopy(rawTypeBindingArray2, 0, rawTypeBindingArray, 0, n2);
            this.uniqueRawTypeBindings.put(referenceBinding, rawTypeBindingArray);
        }
        rawTypeBindingArray[n] = rawTypeBinding = new RawTypeBinding(referenceBinding, referenceBinding2, this);
        return rawTypeBinding;
    }

    public WildcardBinding createWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2) {
        WildcardBinding wildcardBinding;
        int n3;
        int n4;
        if (referenceBinding == null) {
            referenceBinding = ReferenceBinding.LUB_GENERIC;
        }
        WildcardBinding[] wildcardBindingArray = (WildcardBinding[])this.uniqueWildcardBindings.get(referenceBinding);
        boolean bl = false;
        if (wildcardBindingArray != null) {
            n4 = wildcardBindingArray.length;
            block0: for (n3 = 0; n3 < n4 && (wildcardBinding = wildcardBindingArray[n3]) != null; ++n3) {
                if (wildcardBinding.genericType != referenceBinding || wildcardBinding.rank != n || wildcardBinding.boundKind != n2 || wildcardBinding.bound != typeBinding) continue;
                if (wildcardBinding.otherBounds != typeBindingArray) {
                    int n5;
                    int n6 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                    int n7 = n5 = typeBindingArray == null ? 0 : typeBindingArray.length;
                    if (n6 != n5) continue;
                    for (int i = 0; i < n5; ++i) {
                        if (wildcardBinding.otherBounds[i] != typeBindingArray[i]) continue block0;
                    }
                }
                return wildcardBinding;
            }
            bl = true;
        } else {
            wildcardBindingArray = new WildcardBinding[10];
            this.uniqueWildcardBindings.put(referenceBinding, wildcardBindingArray);
        }
        n4 = wildcardBindingArray.length;
        if (bl && n3 == n4) {
            WildcardBinding[] wildcardBindingArray2 = wildcardBindingArray;
            wildcardBindingArray = new WildcardBinding[n4 * 2];
            System.arraycopy(wildcardBindingArray2, 0, wildcardBindingArray, 0, n4);
            this.uniqueWildcardBindings.put(referenceBinding, wildcardBindingArray);
        }
        wildcardBindingArray[n3] = wildcardBinding = new WildcardBinding(referenceBinding, n, typeBinding, typeBindingArray, n2, this);
        return wildcardBinding;
    }

    public AccessRestriction getAccessRestriction(TypeBinding typeBinding) {
        return (AccessRestriction)this.accessRestrictions.get(typeBinding);
    }

    public ReferenceBinding getCachedType(char[][] cArray) {
        if (cArray.length == 1) {
            return this.defaultPackage.getType0(cArray[0]);
        }
        PackageBinding packageBinding = this.getPackage0(cArray[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            return null;
        }
        int n = cArray.length - 1;
        for (int i = 1; i < n; ++i) {
            if ((packageBinding = packageBinding.getPackage0(cArray[i])) != null && packageBinding != TheNotFoundPackage) continue;
            return null;
        }
        return packageBinding.getType0(cArray[cArray.length - 1]);
    }

    PackageBinding getPackage0(char[] cArray) {
        return this.knownPackages.get(cArray);
    }

    public ReferenceBinding getResolvedType(char[][] cArray, Scope scope) {
        ReferenceBinding referenceBinding = this.getType(cArray);
        if (referenceBinding != null) {
            return referenceBinding;
        }
        this.problemReporter.isClassPathCorrect(cArray, scope == null ? this.unitBeingCompleted : scope.referenceCompilationUnit(), this.missingClassFileLocation);
        return this.createMissingType(null, cArray);
    }

    PackageBinding getTopLevelPackage(char[] cArray) {
        PackageBinding packageBinding = this.getPackage0(cArray);
        if (packageBinding != null) {
            if (packageBinding == TheNotFoundPackage) {
                return null;
            }
            return packageBinding;
        }
        if (this.nameEnvironment.isPackage(null, cArray)) {
            packageBinding = new PackageBinding(cArray, this);
            this.knownPackages.put(cArray, packageBinding);
            return packageBinding;
        }
        this.knownPackages.put(cArray, TheNotFoundPackage);
        return null;
    }

    public ReferenceBinding getType(char[][] cArray) {
        ReferenceBinding referenceBinding;
        if (cArray.length == 1) {
            referenceBinding = this.defaultPackage.getType0(cArray[0]);
            if (referenceBinding == null) {
                PackageBinding packageBinding = this.getPackage0(cArray[0]);
                if (packageBinding != null && packageBinding != TheNotFoundPackage) {
                    return null;
                }
                referenceBinding = this.askForType(this.defaultPackage, cArray[0]);
            }
        } else {
            PackageBinding packageBinding = this.getPackage0(cArray[0]);
            if (packageBinding == TheNotFoundPackage) {
                return null;
            }
            if (packageBinding != null) {
                int n = cArray.length - 1;
                for (int i = 1; i < n && (packageBinding = packageBinding.getPackage0(cArray[i])) != null; ++i) {
                    if (packageBinding != TheNotFoundPackage) continue;
                    return null;
                }
            }
            if (packageBinding == null) {
                referenceBinding = this.askForType(cArray);
            } else {
                referenceBinding = packageBinding.getType0(cArray[cArray.length - 1]);
                if (referenceBinding == null) {
                    referenceBinding = this.askForType(packageBinding, cArray[cArray.length - 1]);
                }
            }
        }
        if (referenceBinding == null || referenceBinding == TheNotFoundType) {
            return null;
        }
        if ((referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this, false)).isNestedType()) {
            return new ProblemReferenceBinding(cArray, referenceBinding, 4);
        }
        return referenceBinding;
    }

    private TypeBinding[] getTypeArgumentsFromSignature(SignatureWrapper signatureWrapper, TypeVariableBinding[] typeVariableBindingArray, ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, char[][][] cArray) {
        ArrayList<TypeBinding> arrayList = new ArrayList<TypeBinding>(2);
        int n = 0;
        do {
            arrayList.add(this.getTypeFromVariantTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, referenceBinding2, n++, cArray));
        } while (signatureWrapper.signature[signatureWrapper.start] != '>');
        ++signatureWrapper.start;
        TypeBinding[] typeBindingArray = new TypeBinding[arrayList.size()];
        arrayList.toArray(typeBindingArray);
        return typeBindingArray;
    }

    private ReferenceBinding getTypeFromCompoundName(char[][] cArray, boolean bl, boolean bl2) {
        ReferenceBinding referenceBinding = this.getCachedType(cArray);
        if (referenceBinding == null) {
            PackageBinding packageBinding = this.computePackageFrom(cArray, false);
            referenceBinding = new UnresolvedReferenceBinding(cArray, packageBinding);
            if (bl2) {
                referenceBinding.tagBits |= 0x80L;
            }
            packageBinding.addType(referenceBinding);
        } else if (referenceBinding == TheNotFoundType) {
            if (!bl2) {
                this.problemReporter.isClassPathCorrect(cArray, this.unitBeingCompleted, this.missingClassFileLocation);
            }
            referenceBinding = this.createMissingType(null, cArray);
        } else if (!bl) {
            referenceBinding = (ReferenceBinding)this.convertUnresolvedBinaryToRawType(referenceBinding);
        }
        return referenceBinding;
    }

    ReferenceBinding getTypeFromConstantPoolName(char[] cArray, int n, int n2, boolean bl, char[][][] cArray2) {
        if (n2 == -1) {
            n2 = cArray.length;
        }
        char[][] cArray3 = CharOperation.splitOn('/', cArray, n, n2);
        boolean bl2 = false;
        if (cArray2 != null) {
            int n3 = cArray2.length;
            for (int i = 0; i < n3; ++i) {
                if (!CharOperation.equals(cArray3, cArray2[i])) continue;
                bl2 = true;
                break;
            }
        }
        return this.getTypeFromCompoundName(cArray3, bl, bl2);
    }

    TypeBinding getTypeFromSignature(char[] cArray, int n, int n2, boolean bl, TypeBinding typeBinding, char[][][] cArray2) {
        int n3 = 0;
        while (cArray[n] == '[') {
            ++n;
            ++n3;
        }
        if (n2 == -1) {
            n2 = cArray.length - 1;
        }
        TypeBinding typeBinding2 = null;
        if (n == n2) {
            switch (cArray[n]) {
                case 'I': {
                    typeBinding2 = TypeBinding.INT;
                    break;
                }
                case 'Z': {
                    typeBinding2 = TypeBinding.BOOLEAN;
                    break;
                }
                case 'V': {
                    typeBinding2 = TypeBinding.VOID;
                    break;
                }
                case 'C': {
                    typeBinding2 = TypeBinding.CHAR;
                    break;
                }
                case 'D': {
                    typeBinding2 = TypeBinding.DOUBLE;
                    break;
                }
                case 'B': {
                    typeBinding2 = TypeBinding.BYTE;
                    break;
                }
                case 'F': {
                    typeBinding2 = TypeBinding.FLOAT;
                    break;
                }
                case 'J': {
                    typeBinding2 = TypeBinding.LONG;
                    break;
                }
                case 'S': {
                    typeBinding2 = TypeBinding.SHORT;
                    break;
                }
                default: {
                    this.problemReporter.corruptedSignature(typeBinding, cArray, n);
                    break;
                }
            }
        } else {
            typeBinding2 = this.getTypeFromConstantPoolName(cArray, n + 1, n2, bl, cArray2);
        }
        if (n3 == 0) {
            return typeBinding2;
        }
        return this.createArrayType(typeBinding2, n3);
    }

    public TypeBinding getTypeFromTypeSignature(SignatureWrapper signatureWrapper, TypeVariableBinding[] typeVariableBindingArray, ReferenceBinding referenceBinding, char[][][] cArray) {
        ReferenceBinding referenceBinding2;
        int n = 0;
        while (signatureWrapper.signature[signatureWrapper.start] == '[') {
            ++signatureWrapper.start;
            ++n;
        }
        if (signatureWrapper.signature[signatureWrapper.start] == 'T') {
            int n2 = signatureWrapper.start + 1;
            int n3 = signatureWrapper.computeEnd();
            int n4 = typeVariableBindingArray.length;
            while (--n4 >= 0) {
                if (!CharOperation.equals(typeVariableBindingArray[n4].sourceName, signatureWrapper.signature, n2, n3)) continue;
                return n == 0 ? typeVariableBindingArray[n4] : this.createArrayType(typeVariableBindingArray[n4], n);
            }
            ReferenceBinding referenceBinding3 = referenceBinding;
            do {
                TypeVariableBinding[] typeVariableBindingArray2 = referenceBinding instanceof BinaryTypeBinding ? ((BinaryTypeBinding)referenceBinding).typeVariables : referenceBinding.typeVariables();
                int n5 = typeVariableBindingArray2.length;
                while (--n5 >= 0) {
                    if (!CharOperation.equals(typeVariableBindingArray2[n5].sourceName, signatureWrapper.signature, n2, n3)) continue;
                    return n == 0 ? typeVariableBindingArray2[n5] : this.createArrayType(typeVariableBindingArray2[n5], n);
                }
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            this.problemReporter.undefinedTypeVariableSignature(CharOperation.subarray(signatureWrapper.signature, n2, n3), referenceBinding3);
            return null;
        }
        boolean bl = signatureWrapper.end == signatureWrapper.bracket;
        TypeBinding typeBinding = this.getTypeFromSignature(signatureWrapper.signature, signatureWrapper.start, signatureWrapper.computeEnd(), bl, referenceBinding, cArray);
        if (!bl) {
            return n == 0 ? typeBinding : this.createArrayType(typeBinding, n);
        }
        ReferenceBinding referenceBinding4 = (ReferenceBinding)typeBinding;
        if (referenceBinding4 instanceof UnresolvedReferenceBinding && CharOperation.indexOf('$', referenceBinding4.compoundName[referenceBinding4.compoundName.length - 1]) > 0) {
            referenceBinding4 = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding4, this, false);
        }
        if ((referenceBinding2 = referenceBinding4.enclosingType()) != null) {
            referenceBinding2 = (ReferenceBinding)this.convertToRawType(referenceBinding2, false);
        }
        TypeBinding[] typeBindingArray = this.getTypeArgumentsFromSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, referenceBinding4, cArray);
        ParameterizedTypeBinding parameterizedTypeBinding = this.createParameterizedType(referenceBinding4, typeBindingArray, referenceBinding2);
        while (signatureWrapper.signature[signatureWrapper.start] == '.') {
            int n6 = ++signatureWrapper.start;
            char[] cArray2 = signatureWrapper.nextWord();
            BinaryTypeBinding.resolveType(parameterizedTypeBinding, this, false);
            ReferenceBinding referenceBinding5 = parameterizedTypeBinding.genericType().getMemberType(cArray2);
            if (referenceBinding5 == null) {
                this.problemReporter.corruptedSignature(parameterizedTypeBinding, signatureWrapper.signature, n6);
            }
            if (signatureWrapper.signature[signatureWrapper.start] == '<') {
                ++signatureWrapper.start;
                typeBindingArray = this.getTypeArgumentsFromSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, referenceBinding5, cArray);
            } else {
                typeBindingArray = null;
            }
            parameterizedTypeBinding = this.createParameterizedType(referenceBinding5, typeBindingArray, parameterizedTypeBinding);
        }
        ++signatureWrapper.start;
        return n == 0 ? parameterizedTypeBinding : this.createArrayType(parameterizedTypeBinding, n);
    }

    TypeBinding getTypeFromVariantTypeSignature(SignatureWrapper signatureWrapper, TypeVariableBinding[] typeVariableBindingArray, ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, int n, char[][][] cArray) {
        switch (signatureWrapper.signature[signatureWrapper.start]) {
            case '-': {
                ++signatureWrapper.start;
                TypeBinding typeBinding = this.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, cArray);
                return this.createWildcard(referenceBinding2, n, typeBinding, null, 2);
            }
            case '+': {
                ++signatureWrapper.start;
                TypeBinding typeBinding = this.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, cArray);
                return this.createWildcard(referenceBinding2, n, typeBinding, null, 1);
            }
            case '*': {
                ++signatureWrapper.start;
                return this.createWildcard(referenceBinding2, n, null, null, 0);
            }
        }
        return this.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, cArray);
    }

    boolean isMissingType(char[] cArray) {
        int n;
        int n2 = n = this.missingTypes == null ? 0 : this.missingTypes.size();
        while (--n >= 0) {
            MissingTypeBinding missingTypeBinding = (MissingTypeBinding)this.missingTypes.get(n);
            if (!CharOperation.equals(missingTypeBinding.sourceName, cArray)) continue;
            return true;
        }
        return false;
    }

    boolean isPackage(char[][] cArray, char[] cArray2) {
        if (cArray == null || cArray.length == 0) {
            return this.nameEnvironment.isPackage(null, cArray2);
        }
        return this.nameEnvironment.isPackage(cArray, cArray2);
    }

    public MethodVerifier methodVerifier() {
        if (this.verifier == null) {
            this.verifier = this.newMethodVerifier();
        }
        return this.verifier;
    }

    public MethodVerifier newMethodVerifier() {
        return new MethodVerifier15(this);
    }

    public void releaseClassFiles(ClassFile[] classFileArray) {
        int n = classFileArray.length;
        for (int i = 0; i < n; ++i) {
            this.classFilePool.release(classFileArray[i]);
        }
    }

    public void reset() {
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.knownPackages = new HashtableOfPackage();
        this.accessRestrictions = new HashMap(3);
        this.verifier = null;
        int n = this.uniqueArrayBindings.length;
        while (--n >= 0) {
            ArrayBinding[] arrayBindingArray = this.uniqueArrayBindings[n];
            if (arrayBindingArray == null) continue;
            int n2 = arrayBindingArray.length;
            while (--n2 >= 0) {
                arrayBindingArray[n2] = null;
            }
        }
        this.uniqueParameterizedTypeBindings = new SimpleLookupTable(3);
        this.uniqueRawTypeBindings = new SimpleLookupTable(3);
        this.uniqueWildcardBindings = new SimpleLookupTable(3);
        this.uniqueParameterizedGenericMethodBindings = new SimpleLookupTable(3);
        this.uniquePolymorphicMethodBindings = new SimpleLookupTable(3);
        this.uniqueGetClassMethodBinding = null;
        this.missingTypes = null;
        this.typesBeingConnected = new HashSet();
        n = this.units.length;
        while (--n >= 0) {
            this.units[n] = null;
        }
        this.lastUnitIndex = -1;
        this.lastCompletedUnitIndex = -1;
        this.unitBeingCompleted = null;
        this.classFilePool.reset();
    }

    public void setAccessRestriction(ReferenceBinding referenceBinding, AccessRestriction accessRestriction) {
        if (accessRestriction == null) {
            return;
        }
        referenceBinding.modifiers |= 0x40000;
        this.accessRestrictions.put(referenceBinding, accessRestriction);
    }

    void updateCaches(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding) {
        int n;
        int n2;
        Object[] objectArray;
        if (this.uniqueParameterizedTypeBindings.get(unresolvedReferenceBinding) != null) {
            objectArray = this.uniqueParameterizedTypeBindings.keyTable;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                if (objectArray[n] != unresolvedReferenceBinding) continue;
                objectArray[n] = referenceBinding;
                break;
            }
        }
        if (this.uniqueRawTypeBindings.get(unresolvedReferenceBinding) != null) {
            objectArray = this.uniqueRawTypeBindings.keyTable;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                if (objectArray[n] != unresolvedReferenceBinding) continue;
                objectArray[n] = referenceBinding;
                break;
            }
        }
        if (this.uniqueWildcardBindings.get(unresolvedReferenceBinding) != null) {
            objectArray = this.uniqueWildcardBindings.keyTable;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                if (objectArray[n] != unresolvedReferenceBinding) continue;
                objectArray[n] = referenceBinding;
                break;
            }
        }
    }
}

