/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class TypeVariableBinding
extends ReferenceBinding {
    public Binding declaringElement;
    public int rank;
    public TypeBinding firstBound;
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public char[] genericTypeSignature;
    LookupEnvironment environment;

    public TypeVariableBinding(char[] cArray, Binding binding, int n, LookupEnvironment lookupEnvironment) {
        this.sourceName = cArray;
        this.declaringElement = binding;
        this.rank = n;
        this.modifiers = 0x40000001;
        this.tagBits |= 0x20000000L;
        this.environment = lookupEnvironment;
    }

    public int boundCheck(Substitution substitution, TypeBinding typeBinding) {
        boolean bl;
        if (typeBinding == TypeBinding.NULL || typeBinding == this) {
            return 0;
        }
        boolean bl2 = bl = substitution != null;
        if (!(typeBinding instanceof ReferenceBinding) && !typeBinding.isArrayType()) {
            return 2;
        }
        if (this.superclass == null) {
            return 0;
        }
        if (typeBinding.kind() == 516) {
            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
            switch (wildcardBinding.boundKind) {
                case 1: {
                    TypeBinding typeBinding2 = wildcardBinding.bound;
                    if (typeBinding2 == this) {
                        return 0;
                    }
                    boolean bl3 = typeBinding2.isArrayType();
                    if (!typeBinding2.isInterface()) {
                        TypeBinding typeBinding3;
                        ReferenceBinding referenceBinding;
                        TypeBinding typeBinding4 = referenceBinding = bl ? Scope.substitute(substitution, this.superclass) : this.superclass;
                        if (referenceBinding.id != 1 && (bl3 ? !typeBinding2.isCompatibleWith(referenceBinding) : ((typeBinding3 = typeBinding2.findSuperTypeOriginatingFrom(referenceBinding)) != null ? referenceBinding.isProvablyDistinct(typeBinding3) : ((typeBinding3 = referenceBinding.findSuperTypeOriginatingFrom(typeBinding2)) != null ? typeBinding3.isProvablyDistinct(typeBinding2) : !typeBinding2.isTypeVariable() && !referenceBinding.isTypeVariable())))) {
                            return 2;
                        }
                    }
                    boolean bl4 = bl3 || ((ReferenceBinding)typeBinding2).isFinal();
                    int n = this.superInterfaces.length;
                    for (int i = 0; i < n; ++i) {
                        TypeBinding typeBinding5;
                        ReferenceBinding referenceBinding;
                        TypeBinding typeBinding6 = referenceBinding = bl ? Scope.substitute(substitution, this.superInterfaces[i]) : this.superInterfaces[i];
                        if (!(bl3 ? !typeBinding2.isCompatibleWith(referenceBinding) : ((typeBinding5 = typeBinding2.findSuperTypeOriginatingFrom(referenceBinding)) != null ? referenceBinding.isProvablyDistinct(typeBinding5) : bl4))) continue;
                        return 2;
                    }
                    break;
                }
                case 2: {
                    if (wildcardBinding.bound.isTypeVariable() && ((TypeVariableBinding)wildcardBinding.bound).superclass.id == 1) break;
                    return this.boundCheck(substitution, wildcardBinding.bound);
                }
            }
            return 0;
        }
        boolean bl5 = false;
        if (this.superclass.id != 1) {
            ReferenceBinding referenceBinding;
            TypeBinding typeBinding7 = referenceBinding = bl ? Scope.substitute(substitution, this.superclass) : this.superclass;
            if (referenceBinding != typeBinding) {
                if (!typeBinding.isCompatibleWith(referenceBinding)) {
                    return 2;
                }
                TypeBinding typeBinding8 = typeBinding.findSuperTypeOriginatingFrom(referenceBinding);
                if (typeBinding8 != null && typeBinding8.isRawType() && referenceBinding.isBoundParameterizedType()) {
                    bl5 = true;
                }
            }
        }
        int n = this.superInterfaces.length;
        for (int i = 0; i < n; ++i) {
            ReferenceBinding referenceBinding;
            TypeBinding typeBinding9 = referenceBinding = bl ? Scope.substitute(substitution, this.superInterfaces[i]) : this.superInterfaces[i];
            if (referenceBinding == typeBinding) continue;
            if (!typeBinding.isCompatibleWith(referenceBinding)) {
                return 2;
            }
            TypeBinding typeBinding10 = typeBinding.findSuperTypeOriginatingFrom(referenceBinding);
            if (typeBinding10 == null || !typeBinding10.isRawType() || !referenceBinding.isBoundParameterizedType()) continue;
            bl5 = true;
        }
        return bl5 ? 1 : 0;
    }

    public int boundsCount() {
        if (this.firstBound == null) {
            return 0;
        }
        if (this.firstBound == this.superclass) {
            return this.superInterfaces.length + 1;
        }
        return this.superInterfaces.length;
    }

    public boolean canBeInstantiated() {
        return false;
    }

    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
        int n2;
        if (this.declaringElement != inferenceContext.genericMethod) {
            return;
        }
        switch (typeBinding.kind()) {
            case 132: {
                if (typeBinding == TypeBinding.NULL) {
                    return;
                }
                TypeBinding typeBinding2 = scope.environment().computeBoxingType(typeBinding);
                if (typeBinding2 == typeBinding) {
                    return;
                }
                typeBinding = typeBinding2;
                break;
            }
            case 516: {
                return;
            }
        }
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        inferenceContext.recordSubstitute(this, typeBinding, n2);
    }

    public char[] computeUniqueKey(boolean bl) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Binding binding = this.declaringElement;
        if (!bl && binding.kind() == 8) {
            MethodBinding methodBinding = (MethodBinding)binding;
            object = methodBinding.declaringClass;
            stringBuffer.append(((ReferenceBinding)object).computeUniqueKey(false));
            stringBuffer.append(':');
            MethodBinding[] methodBindingArray = ((ReferenceBinding)object).methods();
            if (methodBindingArray != null) {
                int n = methodBindingArray.length;
                for (int i = 0; i < n; ++i) {
                    MethodBinding methodBinding2 = methodBindingArray[i];
                    if (methodBinding2 != methodBinding) continue;
                    stringBuffer.append(i);
                    break;
                }
            }
        } else {
            stringBuffer.append(binding.computeUniqueKey(false));
            stringBuffer.append(':');
        }
        stringBuffer.append(this.genericTypeSignature());
        int n = stringBuffer.length();
        object = new char[n];
        stringBuffer.getChars(0, n, (char[])object, 0);
        return object;
    }

    public char[] constantPoolName() {
        if (this.firstBound != null) {
            return this.firstBound.constantPoolName();
        }
        return this.superclass.constantPoolName();
    }

    public String debugName() {
        return new String(this.sourceName);
    }

    public TypeBinding erasure() {
        if (this.firstBound != null) {
            return this.firstBound.erasure();
        }
        return this.superclass;
    }

    public char[] genericSignature() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.sourceName).append(':');
        int n3 = n2 = this.superInterfaces == null ? 0 : this.superInterfaces.length;
        if ((n2 == 0 || this.firstBound == this.superclass) && this.superclass != null) {
            stringBuffer.append(this.superclass.genericTypeSignature());
        }
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(':').append(this.superInterfaces[n].genericTypeSignature());
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature != null) {
            return this.genericTypeSignature;
        }
        this.genericTypeSignature = CharOperation.concat('T', this.sourceName, ';');
        return this.genericTypeSignature;
    }

    boolean hasOnlyRawBounds() {
        if (this.superclass != null && this.firstBound == this.superclass && !this.superclass.isRawType()) {
            return false;
        }
        if (this.superInterfaces != null) {
            int n = this.superInterfaces.length;
            for (int i = 0; i < n; ++i) {
                if (this.superInterfaces[i].isRawType()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isErasureBoundTo(TypeBinding typeBinding) {
        if (this.superclass.erasure() == typeBinding) {
            return true;
        }
        int n = this.superInterfaces.length;
        for (int i = 0; i < n; ++i) {
            if (this.superInterfaces[i].erasure() != typeBinding) continue;
            return true;
        }
        return false;
    }

    public boolean isHierarchyConnected() {
        return (this.modifiers & 0x2000000) == 0;
    }

    public boolean isInterchangeableWith(TypeVariableBinding typeVariableBinding, Substitution substitution) {
        if (this == typeVariableBinding) {
            return true;
        }
        int n = this.superInterfaces.length;
        if (n != typeVariableBinding.superInterfaces.length) {
            return false;
        }
        if (this.superclass != Scope.substitute(substitution, typeVariableBinding.superclass)) {
            return false;
        }
        block0: for (int i = 0; i < n; ++i) {
            TypeBinding typeBinding = Scope.substitute(substitution, typeVariableBinding.superInterfaces[i]);
            for (int j = 0; j < n; ++j) {
                if (typeBinding == this.superInterfaces[j]) continue block0;
            }
            return false;
        }
        return true;
    }

    public boolean isTypeVariable() {
        return true;
    }

    public int kind() {
        return 4100;
    }

    public TypeBinding[] otherUpperBounds() {
        if (this.firstBound == null) {
            return Binding.NO_TYPES;
        }
        if (this.firstBound == this.superclass) {
            return this.superInterfaces;
        }
        int n = this.superInterfaces.length - 1;
        if (n > 0) {
            TypeBinding[] typeBindingArray = new TypeBinding[n];
            System.arraycopy(this.superInterfaces, 1, typeBindingArray, 0, n);
            return typeBindingArray;
        }
        return Binding.NO_TYPES;
    }

    public char[] readableName() {
        return this.sourceName;
    }

    ReferenceBinding resolve() {
        int n;
        Object object;
        if ((this.modifiers & 0x2000000) == 0) {
            return this;
        }
        ReferenceBinding referenceBinding = this.superclass;
        ReferenceBinding referenceBinding2 = null;
        if (this.superclass != null) {
            object = (ReferenceBinding)BinaryTypeBinding.resolveType(this.superclass, this.environment, true);
            this.tagBits |= object.tagBits & 0x800L;
            this.superclass = object;
        }
        if ((n = ((ReferenceBinding[])(object = this.superInterfaces)).length) != 0) {
            referenceBinding2 = object[0];
            int n2 = n;
            while (--n2 >= 0) {
                ReferenceBinding referenceBinding3 = (ReferenceBinding)BinaryTypeBinding.resolveType(object[n2], this.environment, true);
                this.tagBits |= referenceBinding3.tagBits & 0x800L;
                object[n2] = referenceBinding3;
            }
        }
        if (this.firstBound != null) {
            if (this.firstBound == referenceBinding) {
                this.firstBound = this.superclass;
            } else if (this.firstBound == referenceBinding2) {
                this.firstBound = object[0];
            }
        }
        this.modifiers &= 0xFDFFFFFF;
        return this;
    }

    public char[] shortReadableName() {
        return this.readableName();
    }

    public ReferenceBinding superclass() {
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        return this.superInterfaces;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append('<').append(this.sourceName);
        if (this.superclass != null && this.firstBound == this.superclass) {
            stringBuffer.append(" extends ").append(this.superclass.debugName());
        }
        if (this.superInterfaces != null && this.superInterfaces != Binding.NO_SUPERINTERFACES) {
            if (this.firstBound != this.superclass) {
                stringBuffer.append(" extends ");
            }
            int n = this.superInterfaces.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0 || this.firstBound == this.superclass) {
                    stringBuffer.append(" & ");
                }
                stringBuffer.append(this.superInterfaces[i].debugName());
            }
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public TypeBinding upperBound() {
        if (this.firstBound != null) {
            return this.firstBound;
        }
        return this.superclass;
    }
}

