/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.jdt.internal.compiler.parser.RecoveredInitializer;
import org.eclipse.jdt.internal.compiler.parser.RecoveredMethod;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.util.Util;

public class RecoveredElement {
    public RecoveredElement parent;
    public int bracketBalance;
    public boolean foundOpeningBrace;
    protected Parser recoveringParser;

    public RecoveredElement(RecoveredElement recoveredElement, int n) {
        this(recoveredElement, n, null);
    }

    public RecoveredElement(RecoveredElement recoveredElement, int n, Parser parser) {
        this.parent = recoveredElement;
        this.bracketBalance = n;
        this.recoveringParser = parser;
    }

    public RecoveredElement addAnnotationName(int n, int n2, int n3, int n4) {
        this.resetPendingModifiers();
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(n3 - 1));
        return this.parent.addAnnotationName(n, n2, n3, n4);
    }

    public RecoveredElement add(AbstractMethodDeclaration abstractMethodDeclaration, int n) {
        this.resetPendingModifiers();
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(abstractMethodDeclaration.declarationSourceStart - 1));
        return this.parent.add(abstractMethodDeclaration, n);
    }

    public RecoveredElement add(Block block, int n) {
        this.resetPendingModifiers();
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(block.sourceStart - 1));
        return this.parent.add(block, n);
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n) {
        this.resetPendingModifiers();
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
        return this.parent.add(fieldDeclaration, n);
    }

    public RecoveredElement add(ImportReference importReference, int n) {
        this.resetPendingModifiers();
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(importReference.declarationSourceStart - 1));
        return this.parent.add(importReference, n);
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n) {
        this.resetPendingModifiers();
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(localDeclaration.declarationSourceStart - 1));
        return this.parent.add(localDeclaration, n);
    }

    public RecoveredElement add(Statement statement, int n) {
        this.resetPendingModifiers();
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(statement.sourceStart - 1));
        return this.parent.add(statement, n);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        this.resetPendingModifiers();
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(typeDeclaration.declarationSourceStart - 1));
        return this.parent.add(typeDeclaration, n);
    }

    protected void addBlockStatement(RecoveredBlock recoveredBlock) {
        Block block = recoveredBlock.blockDeclaration;
        if (block.statements != null) {
            Statement[] statementArray = block.statements;
            for (int i = 0; i < statementArray.length; ++i) {
                recoveredBlock.add(statementArray[i], 0);
            }
        }
    }

    public void addModifier(int n, int n2) {
    }

    public int depth() {
        int n = 0;
        RecoveredElement recoveredElement = this;
        while ((recoveredElement = recoveredElement.parent) != null) {
            ++n;
        }
        return n;
    }

    public RecoveredInitializer enclosingInitializer() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredInitializer) {
                return (RecoveredInitializer)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public RecoveredMethod enclosingMethod() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredMethod) {
                return (RecoveredMethod)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public RecoveredType enclosingType() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredType) {
                return (RecoveredType)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public Parser parser() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement.recoveringParser != null) {
                return recoveredElement.recoveringParser;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public ASTNode parseTree() {
        return null;
    }

    public void resetPendingModifiers() {
    }

    public void preserveEnclosingBlocks() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredBlock) {
                ((RecoveredBlock)recoveredElement).preserveContent = true;
            }
            if (recoveredElement instanceof RecoveredType) {
                ((RecoveredType)recoveredElement).preserveContent = true;
            }
            recoveredElement = recoveredElement.parent;
        }
    }

    public int previousAvailableLineEnd(int n) {
        Parser parser = this.parser();
        if (parser == null) {
            return n;
        }
        Scanner scanner = parser.scanner;
        if (scanner.lineEnds == null) {
            return n;
        }
        int n2 = Util.getLineNumber(n, scanner.lineEnds, 0, scanner.linePtr);
        if (n2 < 2) {
            return n;
        }
        int n3 = scanner.lineEnds[n2 - 2];
        char[] cArray = scanner.source;
        for (int i = n3 + 1; i < n; ++i) {
            if (cArray[i] == ' ' || cArray[i] == '\t') continue;
            return n;
        }
        return n3;
    }

    public int sourceEnd() {
        return 0;
    }

    protected String tabString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i > 0; --i) {
            stringBuffer.append("  ");
        }
        return stringBuffer.toString();
    }

    public RecoveredElement topElement() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement.parent != null) {
            recoveredElement = recoveredElement.parent;
        }
        return recoveredElement;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        return super.toString();
    }

    public RecoveredType type() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredType) {
                return (RecoveredType)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public void updateBodyStart(int n) {
        this.foundOpeningBrace = true;
    }

    public void updateFromParserState() {
    }

    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n, n2);
            return this.parent;
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        if (this.bracketBalance++ == 0) {
            this.updateBodyStart(n2 + 1);
            return this;
        }
        return null;
    }

    public void updateParseTree() {
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
    }

    public void updateSourceEndIfNecessary(int n) {
        this.updateSourceEndIfNecessary(n + 1, n);
    }
}

