/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;

public class ReadManager
implements Runnable {
    ICompilationUnit[] units;
    int nextFileToRead;
    ICompilationUnit[] filesRead;
    char[][] contentsRead;
    int readyToReadPosition;
    int nextAvailablePosition;
    Thread[] readingThreads;
    char[] readInProcessMarker = new char[0];
    int sleepingThreadCount;
    private Throwable caughtException;
    static final int START_CUSHION = 5;
    public static final int THRESHOLD = 10;
    static final int CACHE_SIZE = 15;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadManager(ICompilationUnit[] iCompilationUnitArray, int n) {
        Object object;
        int n2 = 0;
        try {
            object = Class.forName("java.lang.Runtime");
            Method method = ((Class)object).getDeclaredMethod("availableProcessors", new Class[0]);
            if (method != null) {
                Integer n3 = (Integer)method.invoke((Object)Runtime.getRuntime(), null);
                n2 = n3 + 1;
                if (n2 < 2) {
                    n2 = 0;
                } else if (n2 > 15) {
                    n2 = 15;
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (n2 > 0) {
            object = this;
            synchronized (object) {
                this.units = new ICompilationUnit[n];
                System.arraycopy(iCompilationUnitArray, 0, this.units, 0, n);
                this.nextFileToRead = 5;
                this.filesRead = new ICompilationUnit[15];
                this.contentsRead = new char[15][];
                this.readyToReadPosition = 0;
                this.nextAvailablePosition = 0;
                this.sleepingThreadCount = 0;
                this.readingThreads = new Thread[n2];
                int n4 = n2;
                while (--n4 >= 0) {
                    this.readingThreads[n4] = new Thread((Runnable)this, "Compiler Source File Reader");
                    this.readingThreads[n4].setDaemon(true);
                    this.readingThreads[n4].start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getContents(ICompilationUnit iCompilationUnit) throws Error {
        if (this.readingThreads == null || this.units.length == 0) {
            if (this.caughtException != null) {
                if (this.caughtException instanceof Error) {
                    throw (Error)this.caughtException;
                }
                throw (RuntimeException)this.caughtException;
            }
            return iCompilationUnit.getContents();
        }
        boolean bl = false;
        char[] cArray = null;
        ReadManager readManager = this;
        synchronized (readManager) {
            if (iCompilationUnit == this.filesRead[this.readyToReadPosition]) {
                cArray = this.contentsRead[this.readyToReadPosition];
                while (cArray == this.readInProcessMarker || cArray == null) {
                    this.contentsRead[this.readyToReadPosition] = null;
                    try {
                        this.wait(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.caughtException != null) {
                        if (this.caughtException instanceof Error) {
                            throw (Error)this.caughtException;
                        }
                        throw (RuntimeException)this.caughtException;
                    }
                    cArray = this.contentsRead[this.readyToReadPosition];
                }
                this.filesRead[this.readyToReadPosition] = null;
                this.contentsRead[this.readyToReadPosition] = null;
                if (++this.readyToReadPosition >= this.contentsRead.length) {
                    this.readyToReadPosition = 0;
                }
                if (this.sleepingThreadCount > 0) {
                    this.notify();
                    bl = this.sleepingThreadCount == this.readingThreads.length;
                }
            } else {
                int n;
                int n2 = this.units.length;
                for (n = 0; n < n2 && this.units[n] != iCompilationUnit; ++n) {
                }
                if (n == this.units.length) {
                    this.units = new ICompilationUnit[0];
                } else if (n >= this.nextFileToRead) {
                    this.nextFileToRead = n + 5;
                    this.readyToReadPosition = 0;
                    this.nextAvailablePosition = 0;
                    this.filesRead = new ICompilationUnit[15];
                    this.contentsRead = new char[15][];
                    this.notifyAll();
                }
            }
        }
        if (bl) {
            Thread.yield();
        }
        if (cArray != null) {
            return cArray;
        }
        return iCompilationUnit.getContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.readingThreads != null && this.nextFileToRead < this.units.length) {
                ICompilationUnit iCompilationUnit = null;
                int n = -1;
                Object object = this;
                synchronized (object) {
                    if (this.readingThreads == null) {
                        return;
                    }
                    while (this.filesRead[this.nextAvailablePosition] != null) {
                        ++this.sleepingThreadCount;
                        try {
                            this.wait(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        --this.sleepingThreadCount;
                        if (this.readingThreads != null) continue;
                        return;
                    }
                    if (this.nextFileToRead >= this.units.length) {
                        return;
                    }
                    iCompilationUnit = this.units[this.nextFileToRead++];
                    n = this.nextAvailablePosition++;
                    if (this.nextAvailablePosition >= this.contentsRead.length) {
                        this.nextAvailablePosition = 0;
                    }
                    this.filesRead[n] = iCompilationUnit;
                    this.contentsRead[n] = this.readInProcessMarker;
                }
                object = iCompilationUnit.getContents();
                ReadManager readManager = this;
                synchronized (readManager) {
                    if (this.filesRead[n] == iCompilationUnit) {
                        if (this.contentsRead[n] == null) {
                            this.notifyAll();
                        }
                        this.contentsRead[n] = (char[])object;
                    }
                }
            }
            return;
        }
        catch (Error error) {
            ReadManager readManager = this;
            synchronized (readManager) {
                this.caughtException = error;
                this.shutdown();
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            ReadManager readManager = this;
            synchronized (readManager) {
                this.caughtException = runtimeException;
                this.shutdown();
                return;
            }
        }
    }

    public synchronized void shutdown() {
        this.readingThreads = null;
        this.notifyAll();
    }
}

