/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class TypeParameterElementImpl
extends ElementImpl
implements TypeParameterElement {
    private final Element _declaringElement;
    private List<? extends TypeMirror> _bounds = null;

    TypeParameterElementImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, TypeVariableBinding typeVariableBinding, Element element) {
        super(baseProcessingEnvImpl, typeVariableBinding);
        this._declaringElement = element;
    }

    TypeParameterElementImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, TypeVariableBinding typeVariableBinding) {
        super(baseProcessingEnvImpl, typeVariableBinding);
        this._declaringElement = this._env.getFactory().newElement(typeVariableBinding.declaringElement);
    }

    @Override
    public List<? extends TypeMirror> getBounds() {
        if (null == this._bounds) {
            this._bounds = this.calculateBounds();
        }
        return this._bounds;
    }

    private List<? extends TypeMirror> calculateBounds() {
        TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this._binding;
        ReferenceBinding referenceBinding = typeVariableBinding.superclass();
        TypeBinding typeBinding = typeVariableBinding.firstBound;
        int n = 0;
        boolean bl = false;
        if (typeBinding != null) {
            if (typeBinding.isTypeVariable()) {
                bl = true;
            }
            if (typeBinding == referenceBinding) {
                ++n;
                if (typeBinding.isTypeVariable()) {
                    bl = true;
                }
            } else if (typeBinding.isArrayType()) {
                ++n;
            } else {
                typeBinding = null;
            }
        }
        ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces();
        int n2 = 0;
        if (referenceBindingArray != null) {
            n2 = referenceBindingArray.length;
            n += n2;
        }
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(n);
        if (n != 0) {
            if (typeBinding != null) {
                TypeMirror typeMirror = this._env.getFactory().newTypeMirror(typeBinding);
                if (typeMirror == null) {
                    return Collections.emptyList();
                }
                arrayList.add(typeMirror);
            }
            if (referenceBindingArray != null && !bl) {
                for (int i = 0; i < n2; ++i) {
                    TypeMirror typeMirror = this._env.getFactory().newTypeMirror(referenceBindingArray[i]);
                    if (typeMirror == null) {
                        return Collections.emptyList();
                    }
                    arrayList.add(typeMirror);
                }
            }
        } else {
            arrayList.add(this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().getType(LookupEnvironment.JAVA_LANG_OBJECT)));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Element getGenericElement() {
        return this._declaringElement;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
        return elementVisitor.visitTypeParameter(this, p);
    }

    @Override
    protected AnnotationBinding[] getAnnotationBindings() {
        return null;
    }

    @Override
    public List<? extends Element> getEnclosedElements() {
        return Collections.emptyList();
    }

    @Override
    public Element getEnclosingElement() {
        return this.getGenericElement();
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.TYPE_PARAMETER;
    }

    @Override
    PackageElement getPackage() {
        return null;
    }

    @Override
    public String toString() {
        return new String(this._binding.readableName());
    }
}

