/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class SingleMemberAnnotation
extends Annotation {
    public Expression memberValue;
    private MemberValuePair[] singlePairs;

    public SingleMemberAnnotation(TypeReference typeReference, int n) {
        this.type = typeReference;
        this.sourceStart = n;
        this.sourceEnd = typeReference.sourceEnd;
    }

    public ElementValuePair[] computeElementValuePairs() {
        return new ElementValuePair[]{this.memberValuePairs()[0].compilerElementPair};
    }

    public MemberValuePair[] memberValuePairs() {
        if (this.singlePairs == null) {
            this.singlePairs = new MemberValuePair[]{new MemberValuePair(TypeConstants.VALUE, this.memberValue.sourceStart, this.memberValue.sourceEnd, this.memberValue)};
        }
        return this.singlePairs;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        super.printExpression(n, stringBuffer);
        stringBuffer.append('(');
        this.memberValue.printExpression(n, stringBuffer);
        return stringBuffer.append(')');
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.memberValue != null) {
                this.memberValue.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

