/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.Util;

public class TypeDeclaration
extends Statement
implements ProblemSeverities,
ReferenceContext {
    public static final int CLASS_DECL = 1;
    public static final int INTERFACE_DECL = 2;
    public static final int ENUM_DECL = 3;
    public static final int ANNOTATION_TYPE_DECL = 4;
    public int modifiers = 0;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public char[] name;
    public TypeReference superclass;
    public TypeReference[] superInterfaces;
    public FieldDeclaration[] fields;
    public AbstractMethodDeclaration[] methods;
    public TypeDeclaration[] memberTypes;
    public SourceTypeBinding binding;
    public ClassScope scope;
    public MethodScope initializerScope;
    public MethodScope staticInitializerScope;
    public boolean ignoreFurtherInvestigation = false;
    public int maxFieldCount;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int bodyStart;
    public int bodyEnd;
    public CompilationResult compilationResult;
    public MethodDeclaration[] missingAbstractMethods;
    public Javadoc javadoc;
    public QualifiedAllocationExpression allocation;
    public TypeDeclaration enclosingType;
    public FieldBinding enumValuesSyntheticfield;
    public int enumConstantsCounter;
    public TypeParameter[] typeParameters;

    public TypeDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, categorizedProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortType(this.compilationResult, categorizedProblem);
    }

    public final void addClinit() {
        if (this.needClassInitMethod()) {
            AbstractMethodDeclaration[] abstractMethodDeclarationArray = this.methods;
            if (this.methods == null) {
                boolean bl = false;
                abstractMethodDeclarationArray = new AbstractMethodDeclaration[1];
            } else {
                int n = abstractMethodDeclarationArray.length;
                AbstractMethodDeclaration[] abstractMethodDeclarationArray2 = abstractMethodDeclarationArray;
                abstractMethodDeclarationArray = new AbstractMethodDeclaration[n + 1];
                System.arraycopy(abstractMethodDeclarationArray2, 0, abstractMethodDeclarationArray, 1, n);
            }
            Clinit clinit = new Clinit(this.compilationResult);
            abstractMethodDeclarationArray[0] = clinit;
            clinit.declarationSourceStart = clinit.sourceStart = this.sourceStart;
            clinit.declarationSourceEnd = clinit.sourceEnd = this.sourceEnd;
            clinit.bodyEnd = this.sourceEnd;
            this.methods = abstractMethodDeclarationArray;
        }
    }

    public MethodDeclaration addMissingAbstractMethodFor(MethodBinding methodBinding) {
        MethodDeclaration[] methodDeclarationArray;
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = typeBindingArray.length;
        MethodDeclaration methodDeclaration = new MethodDeclaration(this.compilationResult);
        methodDeclaration.selector = methodBinding.selector;
        methodDeclaration.sourceStart = this.sourceStart;
        methodDeclaration.sourceEnd = this.sourceEnd;
        methodDeclaration.modifiers = methodBinding.getAccessFlags() & 0xFFFFFBFF;
        if (n > 0) {
            methodDeclarationArray = "arg";
            methodDeclaration.arguments = new Argument[n];
            Argument[] argumentArray = methodDeclaration.arguments;
            int n2 = n;
            while (--n2 >= 0) {
                argumentArray[n2] = new Argument(((String)methodDeclarationArray + n2).toCharArray(), 0L, null, 0);
            }
        }
        if (this.missingAbstractMethods == null) {
            this.missingAbstractMethods = new MethodDeclaration[]{methodDeclaration};
        } else {
            methodDeclarationArray = new MethodDeclaration[this.missingAbstractMethods.length + 1];
            System.arraycopy(this.missingAbstractMethods, 0, methodDeclarationArray, 1, this.missingAbstractMethods.length);
            methodDeclarationArray[0] = methodDeclaration;
            this.missingAbstractMethods = methodDeclarationArray;
        }
        methodDeclaration.binding = new MethodBinding(methodDeclaration.modifiers | 0x1000, methodBinding.selector, methodBinding.returnType, n == 0 ? Binding.NO_PARAMETERS : typeBindingArray, methodBinding.thrownExceptions, this.binding);
        methodDeclaration.scope = new MethodScope(this.scope, methodDeclaration, true);
        methodDeclaration.bindArguments();
        return methodDeclaration;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        try {
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.binding;
                localTypeBinding.setConstantPoolName(blockScope.compilationUnitScope().computeConstantPoolName(localTypeBinding));
            }
            this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
        return flowInfo;
    }

    public void analyseCode(ClassScope classScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.updateMaxFieldCount();
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(ClassScope classScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.binding;
                localTypeBinding.setConstantPoolName(classScope.compilationUnitScope().computeConstantPoolName(localTypeBinding));
            }
            this.manageEnclosingInstanceAccessIfNecessary(classScope, flowInfo);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(CompilationUnitScope compilationUnitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public boolean checkConstructors(Parser parser) {
        boolean bl = false;
        if (this.methods != null) {
            int n = this.methods.length;
            while (--n >= 0) {
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[n];
                if (!abstractMethodDeclaration.isConstructor()) continue;
                if (!CharOperation.equals(abstractMethodDeclaration.selector, this.name)) {
                    ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)abstractMethodDeclaration;
                    if (constructorDeclaration.constructorCall != null && !constructorDeclaration.constructorCall.isImplicitSuper()) continue;
                    MethodDeclaration methodDeclaration = parser.convertToMethodDeclaration(constructorDeclaration, this.compilationResult);
                    this.methods[n] = methodDeclaration;
                    continue;
                }
                switch (TypeDeclaration.kind(this.modifiers)) {
                    case 2: {
                        parser.problemReporter().interfaceCannotHaveConstructors((ConstructorDeclaration)abstractMethodDeclaration);
                        break;
                    }
                    case 4: {
                        parser.problemReporter().annotationTypeDeclarationCannotHaveConstructor((ConstructorDeclaration)abstractMethodDeclaration);
                    }
                }
                bl = true;
            }
        }
        return bl;
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public ConstructorDeclaration createDefaultConstructor(boolean bl, boolean bl2) {
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.compilationResult);
        constructorDeclaration.bits |= 0x80;
        constructorDeclaration.selector = this.name;
        constructorDeclaration.modifiers = this.modifiers & 7;
        constructorDeclaration.declarationSourceStart = constructorDeclaration.sourceStart = this.sourceStart;
        constructorDeclaration.sourceEnd = constructorDeclaration.bodyEnd = this.sourceEnd;
        constructorDeclaration.declarationSourceEnd = constructorDeclaration.bodyEnd;
        if (bl) {
            constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
            constructorDeclaration.constructorCall.sourceStart = this.sourceStart;
            constructorDeclaration.constructorCall.sourceEnd = this.sourceEnd;
        }
        if (bl2) {
            if (this.methods == null) {
                this.methods = new AbstractMethodDeclaration[]{constructorDeclaration};
            } else {
                AbstractMethodDeclaration[] abstractMethodDeclarationArray = new AbstractMethodDeclaration[this.methods.length + 1];
                System.arraycopy(this.methods, 0, abstractMethodDeclarationArray, 1, this.methods.length);
                abstractMethodDeclarationArray[0] = constructorDeclaration;
                this.methods = abstractMethodDeclarationArray;
            }
        }
        return constructorDeclaration;
    }

    public MethodBinding createDefaultConstructorWithBinding(MethodBinding methodBinding, boolean bl) {
        MethodBinding[] methodBindingArray;
        int n;
        Object[] objectArray;
        String string = "$anonymous";
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n2 = typeBindingArray.length;
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.compilationResult);
        constructorDeclaration.selector = new char[]{'x'};
        constructorDeclaration.sourceStart = this.sourceStart;
        constructorDeclaration.sourceEnd = this.sourceEnd;
        int n3 = this.modifiers & 7;
        if (methodBinding.isVarargs()) {
            n3 |= 0x80;
        }
        constructorDeclaration.modifiers = n3;
        constructorDeclaration.bits |= 0x80;
        if (n2 > 0) {
            constructorDeclaration.arguments = new Argument[n2];
            objectArray = constructorDeclaration.arguments;
            n = n2;
            while (--n >= 0) {
                objectArray[n] = new Argument((string + n).toCharArray(), 0L, null, 0);
            }
        }
        constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
        constructorDeclaration.constructorCall.sourceStart = this.sourceStart;
        constructorDeclaration.constructorCall.sourceEnd = this.sourceEnd;
        if (n2 > 0) {
            constructorDeclaration.constructorCall.arguments = new Expression[n2];
            objectArray = constructorDeclaration.constructorCall.arguments;
            n = n2;
            while (--n >= 0) {
                objectArray[n] = new SingleNameReference((string + n).toCharArray(), 0L);
            }
        }
        if (this.methods == null) {
            this.methods = new AbstractMethodDeclaration[]{constructorDeclaration};
        } else {
            objectArray = new AbstractMethodDeclaration[this.methods.length + 1];
            System.arraycopy(this.methods, 0, objectArray, 1, this.methods.length);
            objectArray[0] = constructorDeclaration;
            this.methods = objectArray;
        }
        objectArray = bl ? this.scope.environment().convertToRawTypes(methodBinding.thrownExceptions, true, true) : methodBinding.thrownExceptions;
        SourceTypeBinding sourceTypeBinding = this.binding;
        constructorDeclaration.binding = new MethodBinding(constructorDeclaration.modifiers, n2 == 0 ? Binding.NO_PARAMETERS : typeBindingArray, (ReferenceBinding[])objectArray, sourceTypeBinding);
        constructorDeclaration.binding.tagBits |= methodBinding.tagBits & 0x80L;
        constructorDeclaration.binding.modifiers |= 0x4000000;
        constructorDeclaration.scope = new MethodScope(this.scope, constructorDeclaration, true);
        constructorDeclaration.bindArguments();
        constructorDeclaration.constructorCall.resolve(constructorDeclaration.scope);
        MethodBinding[] methodBindingArray2 = methodBindingArray = sourceTypeBinding.methods();
        int n4 = methodBindingArray.length;
        methodBindingArray = new MethodBinding[n4 + 1];
        System.arraycopy(methodBindingArray2, 0, methodBindingArray, 1, n4);
        methodBindingArray[0] = constructorDeclaration.binding;
        if (++n4 > 1) {
            ReferenceBinding.sortMethods(methodBindingArray, 0, n4);
        }
        sourceTypeBinding.setMethods(methodBindingArray);
        return constructorDeclaration.binding;
    }

    public FieldDeclaration declarationOf(FieldBinding fieldBinding) {
        if (fieldBinding != null && this.fields != null) {
            int n = this.fields.length;
            for (int i = 0; i < n; ++i) {
                FieldDeclaration fieldDeclaration = this.fields[i];
                if (fieldDeclaration.binding != fieldBinding) continue;
                return fieldDeclaration;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOf(MemberTypeBinding memberTypeBinding) {
        if (memberTypeBinding != null && this.memberTypes != null) {
            int n = this.memberTypes.length;
            for (int i = 0; i < n; ++i) {
                TypeDeclaration typeDeclaration = this.memberTypes[i];
                if (typeDeclaration.binding != memberTypeBinding) continue;
                return typeDeclaration;
            }
        }
        return null;
    }

    public AbstractMethodDeclaration declarationOf(MethodBinding methodBinding) {
        if (methodBinding != null && this.methods != null) {
            int n = this.methods.length;
            for (int i = 0; i < n; ++i) {
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[i];
                if (abstractMethodDeclaration.binding != methodBinding) continue;
                return abstractMethodDeclaration;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOfType(char[][] cArray) {
        int n = cArray.length;
        if (n < 1 || !CharOperation.equals(cArray[0], this.name)) {
            return null;
        }
        if (n == 1) {
            return this;
        }
        char[][] cArrayArray = new char[n - 1][];
        System.arraycopy(cArray, 1, cArrayArray, 0, n - 1);
        for (int i = 0; i < this.memberTypes.length; ++i) {
            TypeDeclaration typeDeclaration = this.memberTypes[i].declarationOfType(cArrayArray);
            if (typeDeclaration == null) continue;
            return typeDeclaration;
        }
        return null;
    }

    public void generateCode(ClassFile classFile) {
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        this.bits |= 0x2000;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
            return;
        }
        try {
            Object object;
            int n;
            ClassFile classFile2 = ClassFile.getNewInstance(this.binding);
            classFile2.initialize(this.binding, classFile, false);
            if (this.binding.isMemberType()) {
                classFile2.recordInnerClasses(this.binding);
            } else if (this.binding.isLocalType()) {
                classFile.recordInnerClasses(this.binding);
                classFile2.recordInnerClasses(this.binding);
            }
            TypeVariableBinding[] typeVariableBindingArray = this.binding.typeVariables();
            int n2 = typeVariableBindingArray.length;
            for (n = 0; n < n2; ++n) {
                object = typeVariableBindingArray[n];
                if ((((TypeVariableBinding)object).tagBits & 0x800L) == 0L) continue;
                Util.recordNestedType(classFile2, (TypeBinding)object);
            }
            classFile2.addFieldInfos();
            if (this.memberTypes != null) {
                n2 = this.memberTypes.length;
                for (n = 0; n < n2; ++n) {
                    object = this.memberTypes[n];
                    classFile2.recordInnerClasses(((TypeDeclaration)object).binding);
                    ((TypeDeclaration)object).generateCode(this.scope, classFile2);
                }
            }
            classFile2.setForMethodInfos();
            if (this.methods != null) {
                n2 = this.methods.length;
                for (n = 0; n < n2; ++n) {
                    this.methods[n].generateCode(this.scope, classFile2);
                }
            }
            classFile2.addSpecialMethods();
            if (this.ignoreFurtherInvestigation) {
                throw new AbortType(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            classFile2.addAttributes();
            this.scope.referenceCompilationUnit().compilationResult.record(this.binding.constantPoolName(), classFile2);
        }
        catch (AbortType abortType) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        int n = codeStream.position;
        if (this.binding != null) {
            int n2;
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = ((NestedTypeBinding)this.binding).syntheticEnclosingInstances();
            int n3 = 0;
            int n4 = n2 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
            for (int i = 0; i < n2; ++i) {
                SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[i];
                syntheticArgumentBinding.resolvedPosition = ++n3;
                if (n3 <= 255) continue;
                blockScope.problemReporter().noMoreAvailableSpaceForArgument(syntheticArgumentBinding, blockScope.referenceType());
            }
        }
        this.generateCode(codeStream.classFile);
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        if (this.binding != null) {
            int n;
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = ((NestedTypeBinding)this.binding).syntheticEnclosingInstances();
            int n2 = 0;
            int n3 = n = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
            for (int i = 0; i < n; ++i) {
                SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[i];
                syntheticArgumentBinding.resolvedPosition = ++n2;
                if (n2 <= 255) continue;
                classScope.problemReporter().noMoreAvailableSpaceForArgument(syntheticArgumentBinding, classScope.referenceType());
            }
        }
        this.generateCode(classFile);
    }

    public void generateCode(CompilationUnitScope compilationUnitScope) {
        this.generateCode((ClassFile)null);
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    private void internalAnalyseCode(FlowContext flowContext, FlowInfo flowInfo) {
        int n;
        int n2;
        if (!this.binding.isUsed() && this.binding.isOrEnclosedByPrivateType() && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
            this.scope.problemReporter().unusedPrivateType(this);
        }
        InitializationFlowContext initializationFlowContext = new InitializationFlowContext(null, this, flowInfo, flowContext, this.initializerScope);
        InitializationFlowContext initializationFlowContext2 = new InitializationFlowContext(null, this, flowInfo, flowContext, this.staticInitializerScope);
        FlowInfo flowInfo2 = flowInfo.unconditionalFieldLessCopy();
        FlowInfo flowInfo3 = flowInfo.unconditionalFieldLessCopy();
        if (this.fields != null) {
            n2 = this.fields.length;
            for (n = 0; n < n2; ++n) {
                FieldDeclaration fieldDeclaration = this.fields[n];
                if (fieldDeclaration.isStatic()) {
                    if ((flowInfo3.tagBits & 1) != 0) {
                        fieldDeclaration.bits &= Integer.MAX_VALUE;
                    }
                    initializationFlowContext2.handledExceptions = Binding.ANY_EXCEPTION;
                    if ((flowInfo3 = fieldDeclaration.analyseCode(this.staticInitializerScope, (FlowContext)initializationFlowContext2, flowInfo3)) != FlowInfo.DEAD_END) continue;
                    this.staticInitializerScope.problemReporter().initializerMustCompleteNormally(fieldDeclaration);
                    flowInfo3 = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    continue;
                }
                if ((flowInfo2.tagBits & 1) != 0) {
                    fieldDeclaration.bits &= Integer.MAX_VALUE;
                }
                initializationFlowContext.handledExceptions = Binding.ANY_EXCEPTION;
                if ((flowInfo2 = fieldDeclaration.analyseCode(this.initializerScope, (FlowContext)initializationFlowContext, flowInfo2)) != FlowInfo.DEAD_END) continue;
                this.initializerScope.problemReporter().initializerMustCompleteNormally(fieldDeclaration);
                flowInfo2 = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
            }
        }
        if (this.memberTypes != null) {
            n2 = this.memberTypes.length;
            for (n = 0; n < n2; ++n) {
                if (flowContext != null) {
                    this.memberTypes[n].analyseCode(this.scope, flowContext, ((FlowInfo)flowInfo2).copy().setReachMode(flowInfo.reachMode()));
                    continue;
                }
                this.memberTypes[n].analyseCode(this.scope);
            }
        }
        if (this.methods != null) {
            UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.unconditionalFieldLessCopy();
            FlowInfo flowInfo4 = ((FlowInfo)flowInfo2).unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(unconditionalFlowInfo);
            int n3 = this.methods.length;
            for (int i = 0; i < n3; ++i) {
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[i];
                if (abstractMethodDeclaration.ignoreFurtherInvestigation) continue;
                if (abstractMethodDeclaration.isInitializationMethod()) {
                    if (abstractMethodDeclaration.isStatic()) {
                        abstractMethodDeclaration.analyseCode(this.scope, initializationFlowContext2, flowInfo3.unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(unconditionalFlowInfo));
                        continue;
                    }
                    ((ConstructorDeclaration)abstractMethodDeclaration).analyseCode(this.scope, initializationFlowContext, flowInfo4.copy(), flowInfo.reachMode());
                    continue;
                }
                abstractMethodDeclaration.analyseCode(this.scope, null, flowInfo.copy());
            }
        }
        if (this.binding.isEnum() && !this.binding.isAnonymousType()) {
            this.enumValuesSyntheticfield = this.binding.addSyntheticFieldForEnumValues();
        }
    }

    public static final int kind(int n) {
        switch (n & 0x6200) {
            case 512: {
                return 2;
            }
            case 8704: {
                return 4;
            }
            case 16384: {
                return 3;
            }
        }
        return 1;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)this.binding;
        MethodScope methodScope = blockScope.methodScope();
        if (!methodScope.isStatic && !methodScope.isConstructorCall) {
            nestedTypeBinding.addSyntheticArgumentAndField(nestedTypeBinding.enclosingType());
        }
        if (nestedTypeBinding.isAnonymousType()) {
            NestedTypeBinding nestedTypeBinding2;
            SyntheticArgumentBinding syntheticArgumentBinding;
            ReferenceBinding referenceBinding;
            ReferenceBinding referenceBinding2 = (ReferenceBinding)nestedTypeBinding.superclass.erasure();
            if (!(referenceBinding2.enclosingType() == null || referenceBinding2.isStatic() || referenceBinding2.isLocalType() && ((NestedTypeBinding)referenceBinding2).getSyntheticField(referenceBinding2.enclosingType(), true) == null)) {
                nestedTypeBinding.addSyntheticArgument(referenceBinding2.enclosingType());
            }
            if (!methodScope.isStatic && methodScope.isConstructorCall && blockScope.compilerOptions().complianceLevel >= 0x310000L && (referenceBinding = nestedTypeBinding.enclosingType()).isNestedType() && (syntheticArgumentBinding = (nestedTypeBinding2 = (NestedTypeBinding)referenceBinding).getSyntheticArgument(nestedTypeBinding2.enclosingType(), true)) != null) {
                nestedTypeBinding.addSyntheticArgumentAndField(syntheticArgumentBinding);
            }
        }
    }

    public void manageEnclosingInstanceAccessIfNecessary(ClassScope classScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)this.binding;
            nestedTypeBinding.addSyntheticArgumentAndField(this.binding.enclosingType());
        }
    }

    public final boolean needClassInitMethod() {
        if ((this.bits & 1) != 0) {
            return true;
        }
        switch (TypeDeclaration.kind(this.modifiers)) {
            case 2: 
            case 4: {
                return this.fields != null;
            }
            case 3: {
                return true;
            }
        }
        if (this.fields != null) {
            int n = this.fields.length;
            while (--n >= 0) {
                FieldDeclaration fieldDeclaration = this.fields[n];
                if ((fieldDeclaration.modifiers & 8) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public void parseMethods(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        ASTNode aSTNode;
        int n;
        int n2;
        if (compilationUnitDeclaration.ignoreMethodBodies) {
            return;
        }
        if (this.memberTypes != null) {
            n2 = this.memberTypes.length;
            for (n = 0; n < n2; ++n) {
                aSTNode = this.memberTypes[n];
                ((TypeDeclaration)aSTNode).parseMethods(parser, compilationUnitDeclaration);
                this.bits |= ((TypeDeclaration)aSTNode).bits & 0x80000;
            }
        }
        if (this.methods != null) {
            n2 = this.methods.length;
            for (n = 0; n < n2; ++n) {
                aSTNode = this.methods[n];
                ((AbstractMethodDeclaration)aSTNode).parseStatements(parser, compilationUnitDeclaration);
                this.bits |= ((AbstractMethodDeclaration)aSTNode).bits & 0x80000;
            }
        }
        if (this.fields != null) {
            n2 = this.fields.length;
            for (n = 0; n < n2; ++n) {
                aSTNode = this.fields[n];
                switch (((FieldDeclaration)aSTNode).getKind()) {
                    case 2: {
                        ((Initializer)aSTNode).parseStatements(parser, this, compilationUnitDeclaration);
                        this.bits |= ((FieldDeclaration)aSTNode).bits & 0x80000;
                    }
                }
            }
        }
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        if (this.javadoc != null) {
            this.javadoc.print(n, stringBuffer);
        }
        if ((this.bits & 0x200) == 0) {
            TypeDeclaration.printIndent(n, stringBuffer);
            this.printHeader(0, stringBuffer);
        }
        return this.printBody(n, stringBuffer);
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        int n2;
        stringBuffer.append(" {");
        if (this.memberTypes != null) {
            for (n2 = 0; n2 < this.memberTypes.length; ++n2) {
                if (this.memberTypes[n2] == null) continue;
                stringBuffer.append('\n');
                this.memberTypes[n2].print(n + 1, stringBuffer);
            }
        }
        if (this.fields != null) {
            for (n2 = 0; n2 < this.fields.length; ++n2) {
                if (this.fields[n2] == null) continue;
                stringBuffer.append('\n');
                this.fields[n2].print(n + 1, stringBuffer);
            }
        }
        if (this.methods != null) {
            for (n2 = 0; n2 < this.methods.length; ++n2) {
                if (this.methods[n2] == null) continue;
                stringBuffer.append('\n');
                this.methods[n2].print(n + 1, stringBuffer);
            }
        }
        stringBuffer.append('\n');
        return TypeDeclaration.printIndent(n, stringBuffer).append('}');
    }

    public StringBuffer printHeader(int n, StringBuffer stringBuffer) {
        int n2;
        TypeDeclaration.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            TypeDeclaration.printAnnotations(this.annotations, stringBuffer);
        }
        switch (TypeDeclaration.kind(this.modifiers)) {
            case 1: {
                stringBuffer.append("class ");
                break;
            }
            case 2: {
                stringBuffer.append("interface ");
                break;
            }
            case 3: {
                stringBuffer.append("enum ");
                break;
            }
            case 4: {
                stringBuffer.append("@interface ");
            }
        }
        stringBuffer.append(this.name);
        if (this.typeParameters != null) {
            stringBuffer.append("<");
            for (n2 = 0; n2 < this.typeParameters.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.typeParameters[n2].print(0, stringBuffer);
            }
            stringBuffer.append(">");
        }
        if (this.superclass != null) {
            stringBuffer.append(" extends ");
            this.superclass.print(0, stringBuffer);
        }
        if (this.superInterfaces != null && this.superInterfaces.length > 0) {
            switch (TypeDeclaration.kind(this.modifiers)) {
                case 1: 
                case 3: {
                    stringBuffer.append(" implements ");
                    break;
                }
                case 2: 
                case 4: {
                    stringBuffer.append(" extends ");
                }
            }
            for (n2 = 0; n2 < this.superInterfaces.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.superInterfaces[n2].print(0, stringBuffer);
            }
        }
        return stringBuffer;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void resolve() {
        var1_1 = this.binding;
        if (var1_1 == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        try {
            block60: {
                block57: {
                    block59: {
                        block58: {
                            var2_2 = this.staticInitializerScope.insideTypeAnnotation;
                            try {
                                this.staticInitializerScope.insideTypeAnnotation = true;
                                TypeDeclaration.resolveAnnotations(this.staticInitializerScope, this.annotations, var1_1);
                            }
                            finally {
                                this.staticInitializerScope.insideTypeAnnotation = var2_2;
                            }
                            if ((var1_1.getAnnotationTagBits() & 0x400000000000L) == 0L && (var1_1.modifiers & 0x100000) != 0 && this.scope.compilerOptions().sourceLevel >= 0x310000L) {
                                this.scope.problemReporter().missingDeprecatedAnnotationForType(this);
                            }
                            if ((this.bits & 8) != 0) {
                                this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd);
                            }
                            v0 = var3_5 = this.scope.compilerOptions().getSeverity(0x20000008) != 256 && var1_1.isClass() != false && var1_1.findSuperTypeOriginatingFrom(56, false) == null && var1_1.findSuperTypeOriginatingFrom(37, false) != null;
                            if (!var3_5) break block57;
                            var4_6 = this.scope.compilationUnitScope();
                            var5_8 = var1_1.getExactMethod(TypeConstants.WRITEREPLACE, Binding.NO_TYPES, (CompilationUnitScope)var4_6);
                            if (var5_8 == null || !var5_8.isValidBinding() || var5_8.returnType.id != 1) ** GOTO lbl-1000
                            var6_10 = var5_8.thrownExceptions;
                            if (var5_8.thrownExceptions.length != 1 || var6_10[0].id != 57) lbl-1000:
                            // 2 sources

                            {
                                v1 = true;
                            } else {
                                v1 = var3_5 = false;
                            }
                            if (!var3_5) break block57;
                            var7_12 = false;
                            var8_14 = 0;
                            var9_19 = this.scope.getType(TypeConstants.JAVA_IO_OBJECTOUTPUTSTREAM, 3);
                            if (!var9_19.isValidBinding()) break block58;
                            var5_8 = var1_1.getExactMethod(TypeConstants.WRITEOBJECT, new TypeBinding[]{var9_19}, (CompilationUnitScope)var4_6);
                            if (var5_8 == null || !var5_8.isValidBinding() || var5_8.modifiers != 2 || var5_8.returnType != TypeBinding.VOID) ** GOTO lbl-1000
                            var6_10 = var5_8.thrownExceptions;
                            if (var5_8.thrownExceptions.length == 1 && var6_10[0].id == 58) {
                                v2 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = var7_12 = false;
                            }
                        }
                        if (!(var9_19 = this.scope.getType(TypeConstants.JAVA_IO_OBJECTINPUTSTREAM, 3)).isValidBinding()) break block59;
                        var5_8 = var1_1.getExactMethod(TypeConstants.READOBJECT, new TypeBinding[]{var9_19}, (CompilationUnitScope)var4_6);
                        if (var5_8 == null || !var5_8.isValidBinding() || var5_8.modifiers != 2 || var5_8.returnType != TypeBinding.VOID) ** GOTO lbl-1000
                        var6_10 = var5_8.thrownExceptions;
                        if (var5_8.thrownExceptions.length == 1 && var6_10[0].id == 58) {
                            v3 = 1;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = 0;
                        }
                        var8_14 = v3;
                    }
                    v4 = var3_5 = var7_12 == false || var8_14 == 0;
                }
                if (var1_1.findSuperTypeOriginatingFrom(21, true) != null) {
                    var4_6 = var1_1;
                    do {
                        if (var4_6.isGenericType()) {
                            this.scope.problemReporter().genericTypeCannotExtendThrowable(this);
                            break;
                        }
                        if (var4_6.isStatic()) break;
                        if (!var4_6.isLocalType()) continue;
                        var5_8 = (NestedTypeBinding)var4_6.erasure();
                        if (var5_8.scope.methodScope().isStatic) break;
                    } while ((var4_6 = var4_6.enclosingType()) != null);
                }
                var4_7 = 0;
                var5_9 = -1;
                var6_11 = false;
                var7_13 = null;
                if (this.typeParameters != null) {
                    var9_20 = this.typeParameters.length;
                    for (var8_14 = 0; var8_14 < var9_20; ++var8_14) {
                        this.typeParameters[var8_14].resolve(this.scope);
                    }
                }
                if (this.memberTypes != null) {
                    var9_21 = this.memberTypes.length;
                    for (var8_14 = 0; var8_14 < var9_21; ++var8_14) {
                        this.memberTypes[var8_14].resolve(this.scope);
                    }
                }
                if (this.fields == null) break block60;
                var9_22 = this.fields.length;
                block17: for (var8_14 = 0; var8_14 < var9_22; ++var8_14) {
                    var10_27 = this.fields[var8_14];
                    switch (var10_27.getKind()) {
                        case 3: {
                            var6_11 = true;
                            if (!(var10_27.initialization instanceof QualifiedAllocationExpression)) {
                                if (var7_13 == null) {
                                    var7_13 = new FieldDeclaration[var9_22];
                                }
                                var7_13[var8_14] = var10_27;
                            }
                        }
                        case 1: {
                            var11_30 = var10_27.binding;
                            if (var11_30 == null) {
                                if (var10_27.initialization != null) {
                                    var10_27.initialization.resolve(var10_27.isStatic() != false ? this.staticInitializerScope : this.initializerScope);
                                }
                                this.ignoreFurtherInvestigation = true;
                                continue block17;
                            }
                            if (var3_5 && (var11_30.modifiers & 24) == 24 && CharOperation.equals(TypeConstants.SERIALVERSIONUID, var11_30.name) && TypeBinding.LONG == var11_30.type) {
                                var3_5 = false;
                            }
                            ++var4_7;
                            var5_9 = var10_27.binding.id;
                            ** GOTO lbl104
                        }
                        case 2: {
                            ((Initializer)var10_27).lastVisibleFieldID = var5_9 + 1;
                        }
lbl104:
                        // 3 sources

                        default: {
                            var10_27.resolve(var10_27.isStatic() != false ? this.staticInitializerScope : this.initializerScope);
                        }
                    }
                }
            }
            if (this.maxFieldCount < var4_7) {
                this.maxFieldCount = var4_7;
            }
            if (var3_5) {
                var8_15 = this.scope.getType(TypeConstants.JAVAX_RMI_CORBA_STUB, 4);
                if (var8_15.isValidBinding()) {
                    for (var9_23 = this.binding.superclass; var9_23 != null; var9_23 = var9_23.superclass()) {
                        if (var9_23 != var8_15) continue;
                        var3_5 = false;
                        break;
                    }
                }
                if (var3_5) {
                    this.scope.problemReporter().missingSerialVersion(this);
                }
            }
            switch (TypeDeclaration.kind(this.modifiers)) {
                case 4: {
                    if (this.superclass != null) {
                        this.scope.problemReporter().annotationTypeDeclarationCannotHaveSuperclass(this);
                    }
                    if (this.superInterfaces == null) break;
                    this.scope.problemReporter().annotationTypeDeclarationCannotHaveSuperinterfaces(this);
                    break;
                }
                case 3: {
                    if (!this.binding.isAbstract()) break;
                    if (!var6_11) {
                        var9_24 = this.methods.length;
                        for (var8_16 = 0; var8_16 < var9_24; ++var8_16) {
                            var10_27 = this.methods[var8_16];
                            if (!var10_27.isAbstract() || var10_27.binding == null) continue;
                            this.scope.problemReporter().enumAbstractMethodMustBeImplemented((AbstractMethodDeclaration)var10_27);
                        }
                    } else {
                        if (var7_13 == null) break;
                        var9_25 = this.methods.length;
                        for (var8_17 = 0; var8_17 < var9_25; ++var8_17) {
                            var10_27 = this.methods[var8_17];
                            if (!var10_27.isAbstract() || var10_27.binding == null) continue;
                            var12_34 = var7_13.length;
                            for (var11_31 = 0; var11_31 < var12_34; ++var11_31) {
                                if (var7_13[var11_31] == null) continue;
                                this.scope.problemReporter().enumConstantMustImplementAbstractMethod((AbstractMethodDeclaration)var10_27, var7_13[var11_31]);
                            }
                        }
                    }
                    break;
                }
            }
            var8_18 = this.missingAbstractMethods == null ? 0 : this.missingAbstractMethods.length;
            v5 = var9_26 = this.methods == null ? 0 : this.methods.length;
            if (var9_26 + var8_18 > 65535) {
                this.scope.problemReporter().tooManyMethods(this);
            }
            if (this.methods != null) {
                var11_32 = this.methods.length;
                for (var10_28 = 0; var10_28 < var11_32; ++var10_28) {
                    this.methods[var10_28].resolve(this.scope);
                }
            }
            if (this.javadoc != null) {
                if (this.scope != null && this.name != TypeConstants.PACKAGE_INFO_NAME) {
                    this.javadoc.resolve(this.scope);
                }
            } else if (!var1_1.isLocalType()) {
                var10_29 = var1_1.modifiers & 7;
                var11_33 = this.scope.problemReporter();
                var12_34 = var11_33.computeSeverity(-1610612250);
                if (var12_34 != 256) {
                    if (this.enclosingType != null) {
                        var10_29 = Util.computeOuterMostVisibility(this.enclosingType, var10_29);
                    }
                    var13_35 = this.binding.modifiers & -8 | var10_29;
                    var11_33.javadocMissing(this.sourceStart, this.sourceEnd, var12_34, var13_35);
                }
            }
        }
        catch (AbortType var2_3) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void resolve(BlockScope blockScope) {
        if ((this.bits & 0x200) == 0) {
            TypeBinding typeBinding = blockScope.getType(this.name);
            if (typeBinding instanceof ReferenceBinding && typeBinding != this.binding && typeBinding.isValidBinding()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
                if (referenceBinding instanceof TypeVariableBinding) {
                    blockScope.problemReporter().typeHiding(this, (TypeVariableBinding)referenceBinding);
                    Scope scope = blockScope.parent;
                    while (scope != null) {
                        TypeBinding typeBinding2 = scope.getType(this.name);
                        if (typeBinding2 instanceof TypeVariableBinding && typeBinding2.isValidBinding()) {
                            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)referenceBinding;
                            Binding binding = typeVariableBinding.declaringElement;
                            if (binding instanceof ReferenceBinding && CharOperation.equals(((ReferenceBinding)binding).sourceName(), this.name)) {
                                blockScope.problemReporter().typeCollidesWithEnclosingType(this);
                                break;
                            }
                        } else {
                            if (typeBinding2 instanceof ReferenceBinding && typeBinding2.isValidBinding() && scope.isDefinedInType((ReferenceBinding)typeBinding2)) {
                                blockScope.problemReporter().typeCollidesWithEnclosingType(this);
                                break;
                            }
                            if (typeBinding2 == null) break;
                        }
                        scope = scope.parent;
                    }
                } else if (referenceBinding instanceof LocalTypeBinding && ((LocalTypeBinding)referenceBinding).scope.methodScope() == blockScope.methodScope()) {
                    blockScope.problemReporter().duplicateNestedType(this);
                } else if (blockScope.isDefinedInType(referenceBinding)) {
                    blockScope.problemReporter().typeCollidesWithEnclosingType(this);
                } else if (blockScope.isDefinedInSameUnit(referenceBinding)) {
                    blockScope.problemReporter().typeHiding(this, referenceBinding);
                }
            }
            blockScope.addLocalType(this);
        }
        if (this.binding != null) {
            blockScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
            this.resolve();
            this.updateMaxFieldCount();
        }
    }

    public void resolve(ClassScope classScope) {
        if (this.binding != null && this.binding instanceof LocalTypeBinding) {
            classScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
        }
        this.resolve();
        this.updateMaxFieldCount();
    }

    public void resolve(CompilationUnitScope compilationUnitScope) {
        this.resolve();
        this.updateMaxFieldCount();
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        try {
            if (aSTVisitor.visit(this, compilationUnitScope)) {
                int n;
                int n2;
                if (this.javadoc != null) {
                    this.javadoc.traverse(aSTVisitor, this.scope);
                }
                if (this.annotations != null) {
                    n2 = this.annotations.length;
                    for (n = 0; n < n2; ++n) {
                        this.annotations[n].traverse(aSTVisitor, this.staticInitializerScope);
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n2 = this.superInterfaces.length;
                    for (n = 0; n < n2; ++n) {
                        this.superInterfaces[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.typeParameters != null) {
                    n2 = this.typeParameters.length;
                    for (n = 0; n < n2; ++n) {
                        this.typeParameters[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.memberTypes != null) {
                    n2 = this.memberTypes.length;
                    for (n = 0; n < n2; ++n) {
                        this.memberTypes[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.fields != null) {
                    n2 = this.fields.length;
                    for (n = 0; n < n2; ++n) {
                        FieldDeclaration fieldDeclaration = this.fields[n];
                        if (fieldDeclaration.isStatic()) {
                            fieldDeclaration.traverse(aSTVisitor, this.staticInitializerScope);
                            continue;
                        }
                        fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                    }
                }
                if (this.methods != null) {
                    n2 = this.methods.length;
                    for (n = 0; n < n2; ++n) {
                        this.methods[n].traverse(aSTVisitor, this.scope);
                    }
                }
            }
            aSTVisitor.endVisit(this, compilationUnitScope);
        }
        catch (AbortType abortType) {
            // empty catch block
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        try {
            if (aSTVisitor.visit(this, blockScope)) {
                int n;
                int n2;
                if (this.javadoc != null) {
                    this.javadoc.traverse(aSTVisitor, this.scope);
                }
                if (this.annotations != null) {
                    n2 = this.annotations.length;
                    for (n = 0; n < n2; ++n) {
                        this.annotations[n].traverse(aSTVisitor, this.staticInitializerScope);
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n2 = this.superInterfaces.length;
                    for (n = 0; n < n2; ++n) {
                        this.superInterfaces[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.typeParameters != null) {
                    n2 = this.typeParameters.length;
                    for (n = 0; n < n2; ++n) {
                        this.typeParameters[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.memberTypes != null) {
                    n2 = this.memberTypes.length;
                    for (n = 0; n < n2; ++n) {
                        this.memberTypes[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.fields != null) {
                    n2 = this.fields.length;
                    for (n = 0; n < n2; ++n) {
                        FieldDeclaration fieldDeclaration = this.fields[n];
                        if (fieldDeclaration.isStatic()) continue;
                        fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                    }
                }
                if (this.methods != null) {
                    n2 = this.methods.length;
                    for (n = 0; n < n2; ++n) {
                        this.methods[n].traverse(aSTVisitor, this.scope);
                    }
                }
            }
            aSTVisitor.endVisit(this, blockScope);
        }
        catch (AbortType abortType) {
            // empty catch block
        }
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        try {
            if (aSTVisitor.visit(this, classScope)) {
                int n;
                int n2;
                if (this.javadoc != null) {
                    this.javadoc.traverse(aSTVisitor, this.scope);
                }
                if (this.annotations != null) {
                    n2 = this.annotations.length;
                    for (n = 0; n < n2; ++n) {
                        this.annotations[n].traverse(aSTVisitor, this.staticInitializerScope);
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n2 = this.superInterfaces.length;
                    for (n = 0; n < n2; ++n) {
                        this.superInterfaces[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.typeParameters != null) {
                    n2 = this.typeParameters.length;
                    for (n = 0; n < n2; ++n) {
                        this.typeParameters[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.memberTypes != null) {
                    n2 = this.memberTypes.length;
                    for (n = 0; n < n2; ++n) {
                        this.memberTypes[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.fields != null) {
                    n2 = this.fields.length;
                    for (n = 0; n < n2; ++n) {
                        FieldDeclaration fieldDeclaration = this.fields[n];
                        if (fieldDeclaration.isStatic()) {
                            fieldDeclaration.traverse(aSTVisitor, this.staticInitializerScope);
                            continue;
                        }
                        fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                    }
                }
                if (this.methods != null) {
                    n2 = this.methods.length;
                    for (n = 0; n < n2; ++n) {
                        this.methods[n].traverse(aSTVisitor, this.scope);
                    }
                }
            }
            aSTVisitor.endVisit(this, classScope);
        }
        catch (AbortType abortType) {
            // empty catch block
        }
    }

    void updateMaxFieldCount() {
        if (this.binding == null) {
            return;
        }
        TypeDeclaration typeDeclaration = this.scope.outerMostClassScope().referenceType();
        if (this.maxFieldCount > typeDeclaration.maxFieldCount) {
            typeDeclaration.maxFieldCount = this.maxFieldCount;
        } else {
            this.maxFieldCount = typeDeclaration.maxFieldCount;
        }
    }

    public boolean isSecondary() {
        return (this.bits & 0x1000) != 0;
    }
}

