/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class TypeReference
extends Expression {
    public static final TypeReference[] NO_TYPE_ARGUMENTS = new TypeReference[0];

    public static final TypeReference baseTypeReference(int n, int n2) {
        if (n2 == 0) {
            switch (n) {
                case 6: {
                    return new SingleTypeReference(TypeBinding.VOID.simpleName, 0L);
                }
                case 5: {
                    return new SingleTypeReference(TypeBinding.BOOLEAN.simpleName, 0L);
                }
                case 2: {
                    return new SingleTypeReference(TypeBinding.CHAR.simpleName, 0L);
                }
                case 9: {
                    return new SingleTypeReference(TypeBinding.FLOAT.simpleName, 0L);
                }
                case 8: {
                    return new SingleTypeReference(TypeBinding.DOUBLE.simpleName, 0L);
                }
                case 3: {
                    return new SingleTypeReference(TypeBinding.BYTE.simpleName, 0L);
                }
                case 4: {
                    return new SingleTypeReference(TypeBinding.SHORT.simpleName, 0L);
                }
                case 10: {
                    return new SingleTypeReference(TypeBinding.INT.simpleName, 0L);
                }
            }
            return new SingleTypeReference(TypeBinding.LONG.simpleName, 0L);
        }
        switch (n) {
            case 6: {
                return new ArrayTypeReference(TypeBinding.VOID.simpleName, n2, 0L);
            }
            case 5: {
                return new ArrayTypeReference(TypeBinding.BOOLEAN.simpleName, n2, 0L);
            }
            case 2: {
                return new ArrayTypeReference(TypeBinding.CHAR.simpleName, n2, 0L);
            }
            case 9: {
                return new ArrayTypeReference(TypeBinding.FLOAT.simpleName, n2, 0L);
            }
            case 8: {
                return new ArrayTypeReference(TypeBinding.DOUBLE.simpleName, n2, 0L);
            }
            case 3: {
                return new ArrayTypeReference(TypeBinding.BYTE.simpleName, n2, 0L);
            }
            case 4: {
                return new ArrayTypeReference(TypeBinding.SHORT.simpleName, n2, 0L);
            }
            case 10: {
                return new ArrayTypeReference(TypeBinding.INT.simpleName, n2, 0L);
            }
        }
        return new ArrayTypeReference(TypeBinding.LONG.simpleName, n2, 0L);
    }

    public void aboutToResolve(Scope scope) {
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public void checkBounds(Scope scope) {
    }

    public abstract TypeReference copyDims(int var1);

    public int dimensions() {
        return 0;
    }

    public abstract char[] getLastToken();

    public char[][] getParameterizedTypeName() {
        return this.getTypeName();
    }

    protected abstract TypeBinding getTypeBinding(Scope var1);

    public abstract char[][] getTypeName();

    protected TypeBinding internalResolveType(Scope scope) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding typeBinding = this.resolvedType.closestMatch();
                    if (typeBinding == null) {
                        return null;
                    }
                    return scope.environment().convertToRawType(typeBinding, false);
                }
            }
            return null;
        }
        this.resolvedType = this.getTypeBinding(scope);
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return null;
        }
        boolean bl = !typeBinding.isValidBinding();
        if (bl) {
            this.reportInvalidType(scope);
            switch (typeBinding.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    typeBinding = typeBinding.closestMatch();
                    if (typeBinding != null) break;
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).leafComponentType == TypeBinding.VOID) {
            scope.problemReporter().cannotAllocateVoidArray(this);
            return null;
        }
        if (!(this instanceof QualifiedTypeReference) && this.isTypeUseDeprecated(typeBinding, scope)) {
            this.reportDeprecatedType(typeBinding, scope);
        }
        if ((typeBinding = scope.environment().convertToRawType(typeBinding, false)).leafComponentType().isRawType() && (this.bits & 0x40000000) == 0 && scope.compilerOptions().getSeverity(0x20010000) != 256) {
            scope.problemReporter().rawTypeReference(this, typeBinding);
        }
        if (bl) {
            return typeBinding;
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    public boolean isTypeReference() {
        return true;
    }

    protected void reportDeprecatedType(TypeBinding typeBinding, Scope scope, int n) {
        scope.problemReporter().deprecatedType(typeBinding, this, n);
    }

    protected void reportDeprecatedType(TypeBinding typeBinding, Scope scope) {
        scope.problemReporter().deprecatedType(typeBinding, this, Integer.MAX_VALUE);
    }

    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().invalidType(this, this.resolvedType);
    }

    public TypeBinding resolveSuperType(ClassScope classScope) {
        TypeBinding typeBinding = this.resolveType(classScope);
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isTypeVariable()) {
            if (this.resolvedType.isValidBinding()) {
                this.resolvedType = new ProblemReferenceBinding(this.getTypeName(), (ReferenceBinding)this.resolvedType, 9);
                this.reportInvalidType(classScope);
            }
            return null;
        }
        return typeBinding;
    }

    public final TypeBinding resolveType(BlockScope blockScope) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        return this.internalResolveType(blockScope);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope);
    }

    public TypeBinding resolveTypeArgument(BlockScope blockScope, ReferenceBinding referenceBinding, int n) {
        return this.resolveType(blockScope, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeBinding resolveTypeArgument(ClassScope classScope, ReferenceBinding referenceBinding, int n) {
        SourceTypeBinding sourceTypeBinding = classScope.referenceContext.binding;
        boolean bl = false;
        try {
            if (sourceTypeBinding.isHierarchyBeingConnected()) {
                sourceTypeBinding.tagBits |= 0x80000L;
                bl = true;
            }
            TypeBinding typeBinding = this.resolveType(classScope);
            return typeBinding;
        }
        finally {
            if (bl) {
                sourceTypeBinding.tagBits &= 0xFFFFFFFFFFF7FFFFL;
            }
        }
    }

    public abstract void traverse(ASTVisitor var1, BlockScope var2);

    public abstract void traverse(ASTVisitor var1, ClassScope var2);
}

