/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class ParameterizedTypeBinding
extends ReferenceBinding
implements Substitution {
    private ReferenceBinding type;
    public TypeBinding[] arguments;
    public LookupEnvironment environment;
    public char[] genericTypeSignature;
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public FieldBinding[] fields;
    public ReferenceBinding[] memberTypes;
    public MethodBinding[] methods;
    private ReferenceBinding enclosingType;

    public ParameterizedTypeBinding(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
        this.enclosingType = referenceBinding2;
        this.initialize(referenceBinding, typeBindingArray);
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)referenceBinding).addWrapper(this, lookupEnvironment);
        }
        if (typeBindingArray != null) {
            int n = typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                if (!(typeBindingArray[i] instanceof UnresolvedReferenceBinding)) continue;
                ((UnresolvedReferenceBinding)typeBindingArray[i]).addWrapper(this, lookupEnvironment);
            }
        }
        this.tagBits |= 0x1000000L;
    }

    protected ReferenceBinding actualType() {
        return this.type;
    }

    public void boundCheck(Scope scope, TypeReference[] typeReferenceArray) {
        if ((this.tagBits & 0x400000L) == 0L) {
            boolean bl = false;
            TypeVariableBinding[] typeVariableBindingArray = this.type.typeVariables();
            if (this.arguments != null && typeVariableBindingArray != null) {
                int n = typeVariableBindingArray.length;
                for (int i = 0; i < n; ++i) {
                    if (typeVariableBindingArray[i].boundCheck(this, this.arguments[i]) == 0) continue;
                    bl = true;
                    if ((this.arguments[i].tagBits & 0x80L) != 0L) continue;
                    scope.problemReporter().typeMismatchError(this.arguments[i], typeVariableBindingArray[i], this.type, (ASTNode)typeReferenceArray[i]);
                }
            }
            if (!bl) {
                this.tagBits |= 0x400000L;
            }
        }
    }

    public boolean canBeInstantiated() {
        return (this.tagBits & 0x40000000L) == 0L && super.canBeInstantiated();
    }

    public TypeBinding capture(Scope scope, int n) {
        if ((this.tagBits & 0x40000000L) == 0L) {
            return this;
        }
        TypeBinding[] typeBindingArray = this.arguments;
        int n2 = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = new TypeBinding[n2];
        ReferenceBinding referenceBinding = scope.enclosingSourceType();
        if (referenceBinding != null) {
            referenceBinding = referenceBinding.outermostEnclosingType();
        }
        for (int i = 0; i < n2; ++i) {
            TypeBinding typeBinding = typeBindingArray[i];
            typeBindingArray2[i] = typeBinding.kind() == 516 ? new CaptureBinding((WildcardBinding)typeBinding, referenceBinding, n, scope.compilationUnitScope().nextCaptureID()) : typeBinding;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.environment.createParameterizedType(this.type, typeBindingArray2, this.enclosingType());
        for (int i = 0; i < n2; ++i) {
            TypeBinding typeBinding = typeBindingArray2[i];
            if (!typeBinding.isCapture()) continue;
            ((CaptureBinding)typeBinding).initializeBounds(scope, parameterizedTypeBinding);
        }
        return parameterizedTypeBinding;
    }

    public List collectMissingTypes(List list) {
        if ((this.tagBits & 0x80L) != 0L) {
            if (this.enclosingType != null) {
                list = this.enclosingType.collectMissingTypes(list);
            }
            list = this.genericType().collectMissingTypes(list);
            if (this.arguments != null) {
                int n = this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    list = this.arguments[i].collectMissingTypes(list);
                }
            }
        }
        return list;
    }

    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
        TypeBinding[] typeBindingArray;
        TypeBinding[] typeBindingArray2;
        ReferenceBinding referenceBinding;
        TypeBinding typeBinding2;
        TypeBinding typeBinding3;
        if ((this.tagBits & 0x20000000L) == 0L) {
            TypeBinding typeBinding4 = typeBinding.findSuperTypeOriginatingFrom(this.type);
            if (typeBinding4 != null && typeBinding4.isRawType()) {
                inferenceContext.isUnchecked = true;
            }
            return;
        }
        if (typeBinding == TypeBinding.NULL) {
            return;
        }
        if (!(typeBinding instanceof ReferenceBinding)) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: {
                typeBinding3 = this;
                typeBinding2 = typeBinding.findSuperTypeOriginatingFrom(this.type);
                if (typeBinding2 != null) break;
                return;
            }
            default: {
                typeBinding3 = this.findSuperTypeOriginatingFrom(typeBinding);
                if (typeBinding3 == null) {
                    return;
                }
                typeBinding2 = typeBinding;
            }
        }
        if ((referenceBinding = typeBinding3.enclosingType()) != null) {
            referenceBinding.collectSubstitutes(scope, typeBinding2.enclosingType(), inferenceContext, n);
        }
        if (this.arguments == null) {
            return;
        }
        switch (typeBinding3.kind()) {
            case 2052: {
                typeBindingArray2 = typeBinding3.typeVariables();
                break;
            }
            case 260: {
                typeBindingArray2 = ((ParameterizedTypeBinding)typeBinding3).arguments;
                break;
            }
            case 1028: {
                if (inferenceContext.depth > 0) {
                    inferenceContext.status = 1;
                }
                return;
            }
            default: {
                return;
            }
        }
        switch (typeBinding2.kind()) {
            case 2052: {
                typeBindingArray = typeBinding2.typeVariables();
                break;
            }
            case 260: {
                typeBindingArray = ((ParameterizedTypeBinding)typeBinding2).arguments;
                break;
            }
            case 1028: {
                if (inferenceContext.depth > 0) {
                    inferenceContext.status = 1;
                } else {
                    inferenceContext.isUnchecked = true;
                }
                return;
            }
            default: {
                return;
            }
        }
        ++inferenceContext.depth;
        int n2 = typeBindingArray2.length;
        for (int i = 0; i < n2; ++i) {
            TypeBinding typeBinding5 = typeBindingArray2[i];
            TypeBinding typeBinding6 = typeBindingArray[i];
            if (typeBinding5.isWildcard()) {
                typeBinding5.collectSubstitutes(scope, typeBinding6, inferenceContext, n);
                continue;
            }
            if (typeBinding6.isWildcard()) {
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding6;
                if (wildcardBinding.otherBounds == null) {
                    if (n != 2) continue;
                    switch (wildcardBinding.boundKind) {
                        case 1: {
                            typeBinding5.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 2);
                            break;
                        }
                        case 2: {
                            typeBinding5.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 1);
                            break;
                        }
                    }
                    continue;
                }
            }
            typeBinding5.collectSubstitutes(scope, typeBinding6, inferenceContext, 0);
        }
        --inferenceContext.depth;
    }

    public void computeId() {
        this.id = Integer.MAX_VALUE;
    }

    public char[] computeUniqueKey(boolean bl) {
        char[] cArray;
        Object object;
        ReferenceBinding referenceBinding;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType() && ((referenceBinding = this.enclosingType()).isParameterizedType() || referenceBinding.isRawType())) {
            object = referenceBinding.computeUniqueKey(false);
            stringBuffer.append((char[])object, 0, ((Object)object).length - 1);
            stringBuffer.append('.').append(this.sourceName());
        } else if (this.type.isLocalType()) {
            ReferenceBinding referenceBinding2;
            object = (LocalTypeBinding)this.type;
            referenceBinding = ((NestedTypeBinding)object).enclosingType();
            while ((referenceBinding2 = referenceBinding.enclosingType()) != null) {
                referenceBinding = referenceBinding2;
            }
            cArray = referenceBinding.computeUniqueKey(false);
            stringBuffer.append(cArray, 0, cArray.length - 1);
            stringBuffer.append('$');
            stringBuffer.append(((LocalTypeBinding)object).sourceStart);
        } else {
            object = this.type.computeUniqueKey(false);
            stringBuffer.append((char[])object, 0, ((Object)object).length - 1);
        }
        object = null;
        if (this.arguments != null) {
            stringBuffer.append('<');
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding = this.arguments[i];
                stringBuffer.append(typeBinding.computeUniqueKey(false));
                if (!(typeBinding instanceof CaptureBinding)) continue;
                object = ((CaptureBinding)typeBinding).sourceType;
            }
            stringBuffer.append('>');
        }
        stringBuffer.append(';');
        if (object != null && object != this.type) {
            stringBuffer.insert(0, "&");
            stringBuffer.insert(0, ((ReferenceBinding)object).computeUniqueKey(false));
        }
        int n = stringBuffer.length();
        cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public char[] constantPoolName() {
        return this.type.constantPoolName();
    }

    public ParameterizedMethodBinding createParameterizedMethod(MethodBinding methodBinding) {
        return new ParameterizedMethodBinding(this, methodBinding);
    }

    public String debugName() {
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.type instanceof UnresolvedReferenceBinding) {
            stringBuffer.append(this.type);
        } else {
            stringBuffer.append(this.type.sourceName());
        }
        if (this.arguments != null) {
            stringBuffer.append('<');
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[i].debugName());
            }
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    public ReferenceBinding enclosingType() {
        return this.enclosingType;
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    public TypeBinding erasure() {
        return this.type.erasure();
    }

    public int fieldCount() {
        return this.type.fieldCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldBinding[] fields() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        try {
            FieldBinding[] fieldBindingArray = this.type.fields();
            int n = fieldBindingArray.length;
            FieldBinding[] fieldBindingArray2 = new FieldBinding[n];
            for (int i = 0; i < n; ++i) {
                fieldBindingArray2[i] = new ParameterizedFieldBinding(this, fieldBindingArray[i]);
            }
            this.fields = fieldBindingArray2;
        }
        finally {
            if (this.fields == null) {
                this.fields = Binding.NO_FIELDS;
            }
            this.tagBits |= 0x2000L;
        }
        return this.fields;
    }

    public ReferenceBinding genericType() {
        if (this.type instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)this.type).resolve(this.environment, false);
        }
        return this.type;
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            if ((this.modifiers & 0x40000000) == 0) {
                this.genericTypeSignature = this.type.signature();
            } else {
                Object object;
                StringBuffer stringBuffer = new StringBuffer(10);
                if (this.isMemberType()) {
                    object = this.enclosingType();
                    char[] cArray = ((TypeBinding)object).genericTypeSignature();
                    stringBuffer.append(cArray, 0, cArray.length - 1);
                    if ((((ReferenceBinding)object).modifiers & 0x40000000) != 0) {
                        stringBuffer.append('.');
                    } else {
                        stringBuffer.append('$');
                    }
                    stringBuffer.append(this.sourceName());
                } else {
                    object = this.type.signature();
                    stringBuffer.append((char[])object, 0, ((Object)object).length - 1);
                }
                if (this.arguments != null) {
                    stringBuffer.append('<');
                    int n = this.arguments.length;
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(this.arguments[i].genericTypeSignature());
                    }
                    stringBuffer.append('>');
                }
                stringBuffer.append(';');
                int n = stringBuffer.length();
                this.genericTypeSignature = new char[n];
                stringBuffer.getChars(0, n, this.genericTypeSignature, 0);
            }
        }
        return this.genericTypeSignature;
    }

    public long getAnnotationTagBits() {
        return this.type.getAnnotationTagBits();
    }

    public int getEnclosingInstancesSlotSize() {
        return this.genericType().getEnclosingInstancesSlotSize();
    }

    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        MethodBinding methodBinding;
        block7: {
            int n;
            block6: {
                n = typeBindingArray.length;
                methodBinding = null;
                if ((this.tagBits & 0x8000L) == 0L) break block6;
                long l = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
                if (l < 0L) break block7;
                int n2 = (int)(l >> 32);
                block0: for (int i = (int)l; i <= n2; ++i) {
                    MethodBinding methodBinding2 = this.methods[i];
                    if (methodBinding2.parameters.length != n) continue;
                    TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
                    for (int j = 0; j < n; ++j) {
                        if (typeBindingArray2[j] != typeBindingArray[j]) continue block0;
                    }
                    if (methodBinding != null) {
                        return null;
                    }
                    methodBinding = methodBinding2;
                }
                break block7;
            }
            MethodBinding[] methodBindingArray = this.getMethods(TypeConstants.INIT);
            int n3 = methodBindingArray.length;
            block2: while (--n3 >= 0) {
                MethodBinding methodBinding3 = methodBindingArray[n3];
                TypeBinding[] typeBindingArray3 = methodBinding3.parameters;
                if (typeBindingArray3.length != n) continue;
                for (int i = 0; i < n; ++i) {
                    if (typeBindingArray3[i] != typeBindingArray[i]) continue block2;
                }
                if (methodBinding != null) {
                    return null;
                }
                methodBinding = methodBinding3;
            }
        }
        return methodBinding;
    }

    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        int n = typeBindingArray.length;
        boolean bl = true;
        MethodBinding methodBinding = null;
        if ((this.tagBits & 0x8000L) != 0L) {
            long l = ReferenceBinding.binarySearch(cArray, this.methods);
            if (l >= 0L) {
                int n2 = (int)(l >> 32);
                block0: for (int i = (int)l; i <= n2; ++i) {
                    MethodBinding methodBinding2 = this.methods[i];
                    bl = false;
                    if (methodBinding2.parameters.length != n) continue;
                    TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
                    for (int j = 0; j < n; ++j) {
                        if (typeBindingArray2[j] != typeBindingArray[j]) continue block0;
                    }
                    if (methodBinding != null) {
                        return null;
                    }
                    methodBinding = methodBinding2;
                }
            }
        } else {
            MethodBinding[] methodBindingArray = this.getMethods(cArray);
            bl = methodBindingArray == Binding.NO_METHODS;
            int n3 = methodBindingArray.length;
            block2: while (--n3 >= 0) {
                MethodBinding methodBinding3 = methodBindingArray[n3];
                TypeBinding[] typeBindingArray3 = methodBinding3.parameters;
                if (typeBindingArray3.length != n) continue;
                for (int i = 0; i < n; ++i) {
                    if (typeBindingArray3[i] != typeBindingArray[i]) continue block2;
                }
                if (methodBinding != null) {
                    return null;
                }
                methodBinding = methodBinding3;
            }
        }
        if (methodBinding != null) {
            if (methodBinding.hasSubstitutedParameters()) {
                return null;
            }
            return methodBinding;
        }
        if (bl && (this.arguments == null || this.arguments.length <= 1)) {
            if (this.isInterface()) {
                if (this.superInterfaces().length == 1) {
                    if (compilationUnitScope != null) {
                        compilationUnitScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(cArray, typeBindingArray, compilationUnitScope);
                }
            } else if (this.superclass() != null) {
                if (compilationUnitScope != null) {
                    compilationUnitScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
            }
        }
        return null;
    }

    public FieldBinding getField(char[] cArray, boolean bl) {
        this.fields();
        return ReferenceBinding.binarySearch(cArray, this.fields);
    }

    public ReferenceBinding getMemberType(char[] cArray) {
        this.memberTypes();
        int n = cArray.length;
        int n2 = this.memberTypes.length;
        while (--n2 >= 0) {
            ReferenceBinding referenceBinding = this.memberTypes[n2];
            if (referenceBinding.sourceName.length != n || !CharOperation.equals(referenceBinding.sourceName, cArray)) continue;
            return referenceBinding;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodBinding[] getMethods(char[] cArray) {
        long l;
        if (this.methods != null && (l = ReferenceBinding.binarySearch(cArray, this.methods)) >= 0L) {
            int n = (int)l;
            int n2 = (int)(l >> 32) - n + 1;
            MethodBinding[] methodBindingArray = new MethodBinding[n2];
            System.arraycopy(this.methods, n, methodBindingArray, 0, n2);
            return methodBindingArray;
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            return Binding.NO_METHODS;
        }
        MethodBinding[] methodBindingArray = null;
        try {
            int n;
            MethodBinding[] methodBindingArray2 = this.type.getMethods(cArray);
            int n3 = methodBindingArray2.length;
            if (n3 == 0) {
                MethodBinding[] methodBindingArray3 = Binding.NO_METHODS;
                return methodBindingArray3;
            }
            methodBindingArray = new MethodBinding[n3];
            for (n = 0; n < n3; ++n) {
                methodBindingArray[n] = this.createParameterizedMethod(methodBindingArray2[n]);
            }
            if (this.methods == null) {
                MethodBinding[] methodBindingArray4 = new MethodBinding[n3];
                System.arraycopy(methodBindingArray, 0, methodBindingArray4, 0, n3);
                this.methods = methodBindingArray4;
            } else {
                n = n3 + this.methods.length;
                MethodBinding[] methodBindingArray5 = new MethodBinding[n];
                System.arraycopy(methodBindingArray, 0, methodBindingArray5, 0, n3);
                System.arraycopy(this.methods, 0, methodBindingArray5, n3, this.methods.length);
                if (n > 1) {
                    ReferenceBinding.sortMethods(methodBindingArray5, 0, n);
                }
                this.methods = methodBindingArray5;
            }
            MethodBinding[] methodBindingArray6 = methodBindingArray;
            return methodBindingArray6;
        }
        finally {
            if (methodBindingArray == null) {
                methodBindingArray = Binding.NO_METHODS;
                this.methods = Binding.NO_METHODS;
            }
        }
    }

    public int getOuterLocalVariablesSlotSize() {
        return this.genericType().getOuterLocalVariablesSlotSize();
    }

    public boolean hasMemberTypes() {
        return this.type.hasMemberTypes();
    }

    public boolean implementsMethod(MethodBinding methodBinding) {
        return this.type.implementsMethod(methodBinding);
    }

    void initialize(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray) {
        this.type = referenceBinding;
        this.sourceName = referenceBinding.sourceName;
        this.compoundName = referenceBinding.compoundName;
        this.fPackage = referenceBinding.fPackage;
        this.fileName = referenceBinding.fileName;
        this.modifiers = referenceBinding.modifiers & 0xBFFFFFFF;
        if (typeBindingArray != null) {
            this.modifiers |= 0x40000000;
        } else if (this.enclosingType != null) {
            this.modifiers |= this.enclosingType.modifiers & 0x40000000;
            this.tagBits |= this.enclosingType.tagBits & 0x20000080L;
        }
        if (typeBindingArray != null) {
            this.arguments = typeBindingArray;
            int n = typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding = typeBindingArray[i];
                switch (typeBinding.kind()) {
                    case 516: {
                        this.tagBits |= 0x40000000L;
                        if (((WildcardBinding)typeBinding).boundKind == 0) break;
                        this.tagBits |= 0x800000L;
                        break;
                    }
                    case 8196: {
                        this.tagBits |= 0x40800000L;
                        break;
                    }
                    default: {
                        this.tagBits |= 0x800000L;
                    }
                }
                this.tagBits |= typeBinding.tagBits & 0x20000880L;
            }
        }
        this.tagBits |= referenceBinding.tagBits & 0x89CL;
        this.tagBits &= 0xFFFFFFFFFFFF5FFFL;
    }

    protected void initializeArguments() {
    }

    void initializeForStaticImports() {
        this.type.initializeForStaticImports();
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 260: {
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                if (this.type != parameterizedTypeBinding.type) {
                    return false;
                }
                if (!this.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                    typeBindingArray = parameterizedTypeBinding.enclosingType();
                    if (typeBindingArray == null) {
                        return false;
                    }
                    if ((typeBindingArray.tagBits & 0x40000000L) == 0L ? referenceBinding != typeBindingArray : !referenceBinding.isEquivalentTo(parameterizedTypeBinding.enclosingType())) {
                        return false;
                    }
                }
                if (this.arguments == null) {
                    return parameterizedTypeBinding.arguments == null;
                }
                int n = this.arguments.length;
                typeBindingArray = parameterizedTypeBinding.arguments;
                if (typeBindingArray == null || typeBindingArray.length != n) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (this.arguments[i].isTypeArgumentContainedBy(typeBindingArray[i])) continue;
                    return false;
                }
                return true;
            }
            case 1028: {
                return this.erasure() == typeBinding.erasure();
            }
        }
        return this.erasure() == typeBinding;
    }

    public boolean isHierarchyConnected() {
        return this.superclass != null && this.superInterfaces != null;
    }

    public boolean isRawSubstitution() {
        return this.isRawType();
    }

    public int kind() {
        return 260;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceBinding[] memberTypes() {
        if (this.memberTypes == null) {
            try {
                ReferenceBinding[] referenceBindingArray = this.type.memberTypes();
                int n = referenceBindingArray.length;
                ReferenceBinding[] referenceBindingArray2 = new ReferenceBinding[n];
                for (int i = 0; i < n; ++i) {
                    referenceBindingArray2[i] = this.environment.createParameterizedType(referenceBindingArray[i], null, this);
                }
                this.memberTypes = referenceBindingArray2;
            }
            finally {
                if (this.memberTypes == null) {
                    this.memberTypes = Binding.NO_MEMBER_TYPES;
                }
            }
        }
        return this.memberTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodBinding[] methods() {
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        try {
            MethodBinding[] methodBindingArray = this.type.methods();
            int n = methodBindingArray.length;
            MethodBinding[] methodBindingArray2 = new MethodBinding[n];
            for (int i = 0; i < n; ++i) {
                methodBindingArray2[i] = this.createParameterizedMethod(methodBindingArray[i]);
            }
            this.methods = methodBindingArray2;
        }
        finally {
            if (this.methods == null) {
                this.methods = Binding.NO_METHODS;
            }
            this.tagBits |= 0x8000L;
        }
        return this.methods;
    }

    public int problemId() {
        return this.type.problemId();
    }

    public char[] qualifiedPackageName() {
        return this.type.qualifiedPackageName();
    }

    public char[] qualifiedSourceName() {
        return this.type.qualifiedSourceName();
    }

    public char[] readableName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.'));
        } else {
            stringBuffer.append(CharOperation.concatWith(this.type.compoundName, '.'));
        }
        if (this.arguments != null) {
            stringBuffer.append('<');
            int n2 = this.arguments.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].readableName());
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    ReferenceBinding resolve() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this;
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        ReferenceBinding referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(this.type, this.environment, false);
        this.tagBits |= referenceBinding.tagBits & 0x800L;
        if (this.arguments != null) {
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding;
                this.arguments[i] = typeBinding = BinaryTypeBinding.resolveType(this.arguments[i], this.environment, true);
                this.tagBits |= referenceBinding.tagBits & 0x800L;
            }
        }
        return this;
    }

    public char[] shortReadableName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.'));
        } else {
            stringBuffer.append(this.type.sourceName);
        }
        if (this.arguments != null) {
            stringBuffer.append('<');
            int n2 = this.arguments.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].shortReadableName());
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public char[] signature() {
        if (this.signature == null) {
            this.signature = this.type.signature();
        }
        return this.signature;
    }

    public char[] sourceName() {
        return this.type.sourceName();
    }

    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
        ParameterizedTypeBinding parameterizedTypeBinding = this;
        while (true) {
            ReferenceBinding referenceBinding;
            TypeVariableBinding[] typeVariableBindingArray;
            int n;
            if (typeVariableBinding.rank < (n = (typeVariableBindingArray = parameterizedTypeBinding.type.typeVariables()).length) && typeVariableBindingArray[typeVariableBinding.rank] == typeVariableBinding) {
                if (parameterizedTypeBinding.arguments == null) {
                    parameterizedTypeBinding.initializeArguments();
                }
                if (parameterizedTypeBinding.arguments != null) {
                    if (parameterizedTypeBinding.arguments.length == 0) {
                        return typeVariableBinding;
                    }
                    return parameterizedTypeBinding.arguments[typeVariableBinding.rank];
                }
            }
            if (parameterizedTypeBinding.isStatic() || !((referenceBinding = parameterizedTypeBinding.enclosingType()) instanceof ParameterizedTypeBinding)) break;
            parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding;
        }
        return typeVariableBinding;
    }

    public ReferenceBinding superclass() {
        if (this.superclass == null) {
            ReferenceBinding referenceBinding = this.type.superclass();
            if (referenceBinding == null) {
                return null;
            }
            this.superclass = (ReferenceBinding)Scope.substitute((Substitution)this, referenceBinding);
        }
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        if (this.superInterfaces == null) {
            if (this.type.isHierarchyBeingConnected()) {
                return Binding.NO_SUPERINTERFACES;
            }
            this.superInterfaces = Scope.substitute((Substitution)this, this.type.superInterfaces());
        }
        return this.superInterfaces;
    }

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        boolean bl = false;
        if (this.type == unresolvedReferenceBinding) {
            this.type = referenceBinding;
            bl = true;
            ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
            if (referenceBinding2 != null) {
                this.enclosingType = (ReferenceBinding)lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding2);
            }
        }
        if (this.arguments != null) {
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                if (this.arguments[i] != unresolvedReferenceBinding) continue;
                this.arguments[i] = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
                bl = true;
            }
        }
        if (bl) {
            this.initialize(this.type, this.arguments);
        }
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        return this.genericType().syntheticEnclosingInstanceTypes();
    }

    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return this.genericType().syntheticOuterLocalVariables();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.type instanceof UnresolvedReferenceBinding) {
            stringBuffer.append(this.debugName());
        } else {
            int n;
            int n2;
            if (this.isDeprecated()) {
                stringBuffer.append("deprecated ");
            }
            if (this.isPublic()) {
                stringBuffer.append("public ");
            }
            if (this.isProtected()) {
                stringBuffer.append("protected ");
            }
            if (this.isPrivate()) {
                stringBuffer.append("private ");
            }
            if (this.isAbstract() && this.isClass()) {
                stringBuffer.append("abstract ");
            }
            if (this.isStatic() && this.isNestedType()) {
                stringBuffer.append("static ");
            }
            if (this.isFinal()) {
                stringBuffer.append("final ");
            }
            if (this.isEnum()) {
                stringBuffer.append("enum ");
            } else if (this.isAnnotationType()) {
                stringBuffer.append("@interface ");
            } else if (this.isClass()) {
                stringBuffer.append("class ");
            } else {
                stringBuffer.append("interface ");
            }
            stringBuffer.append(this.debugName());
            stringBuffer.append("\n\textends ");
            stringBuffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
            if (this.superInterfaces != null) {
                if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                    stringBuffer.append("\n\timplements : ");
                    n2 = this.superInterfaces.length;
                    for (n = 0; n < n2; ++n) {
                        if (n > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(this.superInterfaces[n] != null ? this.superInterfaces[n].debugName() : "NULL TYPE");
                    }
                }
            } else {
                stringBuffer.append("NULL SUPERINTERFACES");
            }
            if (this.enclosingType() != null) {
                stringBuffer.append("\n\tenclosing type : ");
                stringBuffer.append(this.enclosingType().debugName());
            }
            if (this.fields != null) {
                if (this.fields != Binding.NO_FIELDS) {
                    stringBuffer.append("\n/*   fields   */");
                    n2 = this.fields.length;
                    for (n = 0; n < n2; ++n) {
                        stringBuffer.append('\n').append(this.fields[n] != null ? this.fields[n].toString() : "NULL FIELD");
                    }
                }
            } else {
                stringBuffer.append("NULL FIELDS");
            }
            if (this.methods != null) {
                if (this.methods != Binding.NO_METHODS) {
                    stringBuffer.append("\n/*   methods   */");
                    n2 = this.methods.length;
                    for (n = 0; n < n2; ++n) {
                        stringBuffer.append('\n').append(this.methods[n] != null ? this.methods[n].toString() : "NULL METHOD");
                    }
                }
            } else {
                stringBuffer.append("NULL METHODS");
            }
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    public TypeVariableBinding[] typeVariables() {
        if (this.arguments == null) {
            return this.type.typeVariables();
        }
        return Binding.NO_TYPE_VARIABLES;
    }

    public FieldBinding[] unResolvedFields() {
        return this.fields;
    }
}

