/*
 * The instrumentation of the COVALENT-INTRUSION-DETECTION-MIB module.
 * $Id: intrusion-mib.h 8676 2008-01-17 23:11:17Z ispringer $
 */
#ifndef __COVALENT_INTRUSION_DETECTION_MIB_H__
#define __COVALENT_INTRUSION_DETECTION_MIB_H__

typedef struct {
    time_t lastTime;
    char lastDoc[ MAX_WWWDOCNAME ];
    unsigned long lastCounter;
    time_t newTime;
    char newDoc[ MAX_WWWDOCNAME ];
    unsigned long newCounter;
} intrusion_entry_t;

void init_covalent_intrusion_detection_mib(server_rec *s, pool *p);
void invoke_intrusion_mib_update(request_rec *r, int last_or_new);

#ifdef INTRUSIONMIB_DEBUG
#define PRINT_INTRUSIONMIB(str) fprintf(stderr, str);
#else
#define PRINT_INTRUSIONMIB(str)
#endif

#endif /* __COVALENT_INTRUSION_DETECTION_MIB_H_ */
