/*
 * $Id: extensions.c 8676 2008-01-17 23:11:17Z ispringer $
 */
/* Apache includes */
#include <httpd.h>
#include <http_config.h>
#include <http_log.h>
#include <apr_optional.h>

/* UCD-SNMP includes */
#include <ucd-snmp-config.h>
#include <asn1.h>
#include <snmp_api.h>
#include <snmp_vars.h>
#include <agent_trap.h>

/* module includes */
#include "covalent-snmp-config.h"
#include "www-mib/www-mib.h"
#include "snmpagent/logging.h"
#include "external-mibs/extensions.h"

static snmpagent_log_type log_identifier = NEXT_LOG_TYPE;

apr_array_header_t *external_mib_portions;

int
init_register_external_mibtree(apr_pool_t *p)
{
    external_mib_portions = apr_array_make(p, 1, sizeof(external_mib_subtree_t *));
    return(external_mib_portions ? 1 : 0);
}


int 
covalent_snmp_register_mibtree(server_rec *s, apr_pool_t *p, external_mib_subtree_t *mibinfo)
{
    external_mib_subtree_t **subtree;

    subtree = (external_mib_subtree_t **)
                        apr_array_push(external_mib_portions);
    *subtree = mibinfo;
    //memcpy(subtree, mibinfo, sizeof(external_mib_subtree_t);
    return(++log_identifier);
}


void
covalent_snmp_notification(int specific, oid *enterprise,
                             int enterprise_length, struct variable_list *vars)
{
    send_enterprise_trap_vars(6, specific, enterprise, enterprise_length, vars);
}

int
external_mib_modules_init(server_rec *s, apr_pool_t *p)
{
external_mib_subtree_t *subtree;
int i;

    subtree = (external_mib_subtree_t *) external_mib_portions->elts;
    for (i = 0 ; i < external_mib_portions->nelts ; i++, subtree++) {
        if (register_mib("external subtree",
                        (struct variable *) subtree->variables,
                        subtree->variable_size, subtree->variables_amount,
                        subtree->base_oid, subtree->base_oid_length)
                                        != MIB_REGISTERED_OK ) {
            /* What will we do now?? */
        } else {
            if (subtree->init) {
                subtree->init(s, p);
            }
        }
    }
    return(0);
}

int
external_mib_modules_log_sinks(snmpagent_log_record_t *log_record)
{
external_mib_subtree_t *subtree;
int i;

    subtree = (external_mib_subtree_t *) external_mib_portions->elts;
    for (i = 0 ; i < external_mib_portions->nelts ; i++, subtree++) {
       if (subtree->logging_sink) {
            if (subtree->logging_sink(log_record)) {
                return(0);
            }
        }
    }
    return(0);
}

