/* Apache includes */
#include "httpd.h"
#include "http_config.h"

/* UCD_SNMP includes */
#include <ucd-snmp-config.h>
#include <asn1.h>
#include <snmp_api.h>
#include <snmp_vars.h>

/* Conductor includes */
#include "ietf-mibs/snmp-generic.h"
#include "covalent-snmp-config.h"
#include "covalent-snmp-logging.h"
#include "covalent-snmp.h"
#include "covalent-snmp-sconfig.h"

command_rec covalent_snmp_config_cmds[] = {
    { "SNMPconf", set_snmp_config_dir, NULL, RSRC_CONF, TAKE1, "Wrong configuration directory"},
    { "SNMPvar", set_snmp_persistent_dir, NULL, RSRC_CONF, TAKE1, "Wrong persistent directory"},
    { "SNMPuser", set_snmp_user, NULL, RSRC_CONF, TAKE1, "Wrong user for SNMP agent"},
    { "MaxClients", set_snmp_max_clients_limit, NULL, RSRC_CONF, TAKE1, "Maximum number of children alive at the same time" },
    { "SNMPResponseTypes", set_snmp_response_types, NULL, RSRC_CONF, RAW_ARGS,
      "List of response types to include in snmp output"},
    { "SNMPRequestTypes", set_snmp_request_types, NULL, RSRC_CONF, RAW_ARGS,
      "List of request types to include in snmp output"},
    { NULL }
};


module MODULE_VAR_EXPORT snmp_agt_module = {
    STANDARD_MODULE_STUFF,
    covalent_snmp_module_init,	/* initializer */
    NULL,			/* create per-directory config structure */
    NULL,			/* merge per-directory config structure */
    covalent_snmp_create_sconf,	/* create per-server config structure */
    NULL,			/* merge per-server config structure */
    covalent_snmp_config_cmds,	/* command table */
    NULL,			/* handlers */
    NULL,			/* translate handlers */
    NULL,			/* check_user_id */
    NULL,			/* check auth */
    NULL,			/* check access */
    NULL,			/* type_checker */
    NULL,			/* pre-run fixups */
    covalent_snmp_logger,	/* logger */
    NULL,			/* header parser */
    covalent_snmp_child_init,	/* child_init */
    NULL,			/* child_exit */
    NULL			/* post read-request */
};


