 
/* $Date: 2008-01-18 07:11:17 +0800 (Fri, 18 Jan 2008) $ $Id: covalent-snmp-v20.c 8676 2008-01-17 23:11:17Z ispringer $ harrie@covalent.net
 */
/* General includes */
#include <sys/types.h>
 
/* Apache includes */
#include "httpd.h"
#include "http_config.h"

#include "covalent-snmp-config.h"
#include "covalent-snmp.h"


static void snmp_register_hooks(void)
{
    ap_hook_post_config(snmp_post_config, NULL, NULL, AP_HOOK_MIDDLE);
    ap_hook_log_transaction(snmp_send_loginfo, NULL, NULL, AP_HOOK_MIDDLE);
}

command_rec covalent_snmp_config_cmds[] = {
    { "SNMPconf", set_snmp_config_dir, NULL, RSRC_CONF, TAKE1, "Wrong configuration directory"},
    { "SNMPvar", set_snmp_persistent_dir, NULL, RSRC_CONF, TAKE1, "Wrong persistent directory"},
    { NULL }
};


MODULE_VAR_EXPORT module snmp_agt_module = {
    STANDARD20_MODULE_STUFF,
    NULL,			/* dir config creater */
    NULL,			/* dir merger --- default is to override */
    NULL,			/* server config */
    NULL,			/* merge server config */
    covalent_snmp_config_cmds,	/* command ap_table_t */
    NULL,			/* handlers */
    covalent_snmp_register_hooks	/* register hooks */
};


