/*
 * $Id: restart-storage.c 8676 2008-01-17 23:11:17Z ispringer $
 * All functionality that handles temporary data storage
 * and functionality for restarts within Apache. DSO's
 * tend to loose the data. :-((
 */
/* Standard includes */
#include <stdio.h>
#include <fcntl.h>
#include <string.h>

/* SDBM includes */
#include <covalent_sdbm.h>

/* Covalent SNMP includes */
#include "covalent-snmp-config.h"
#include "restart-storage.h"


/*
 * Restart capability switch for disabling SNMP-SETs.
 */
static int restart_switch = ON;

/*
 * Function: set_restart_capability
 */
void
set_restart_capability(int set)
{
    restart_switch = set;
}

/*
 * Function: check_restart_capability
 */
int
check_restart_capability()
{
    return(restart_switch);
}

