# Copyright (c) 2000-2009, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define jspspec 2.1
%define major_version 6
%define minor_version 0
%define micro_version 41
%define packdname apache-tomcat-%{version}-src
%define servletspec 2.5
%define elspec 1.0
%define tcuid 91

%define with_signing 1
%define patchnumber 04
%define patchlevel -patch-%{patchnumber}
%define release_patchlevel _patch_%{patchnumber}

# Sync with the RHEL release version
%define brew_arch noarch
%define brew_release 15_patch_04.ep6.el6


Name: tomcat6
Epoch: 0
Version: %{major_version}.%{minor_version}.%{micro_version}
Release: 15%{release_patchlevel}%{?dist}
Summary: Apache Servlet/JSP Engine, RI for Servlet %{servletspec}/JSP %{jspspec} API
Group: Networking/Daemons
License: ASL 2.0
URL: http://tomcat.apache.org/
#http://apache.mirror.rafal.ca/tomcat/tomcat-6/v6.0.32/src/apache-tomcat-6.0.32-src.tar.gz
Source0: http://www.apache.org/dist/tomcat/tomcat-6/v%{version}/src/%{packdname}.tar.gz
Source1: %{name}-%{major_version}.%{minor_version}.conf
Source2: %{name}-%{major_version}.%{minor_version}.init
Source3: %{name}-%{major_version}.%{minor_version}.wrapper
Source4: %{name}-%{major_version}.%{minor_version}.logrotate
# The jsvc.tar.gz is only availble in the binary zip from apache.org
# wget http://www.apache.org/dist/tomcat/tomcat-6/v6.0.24/bin/apache-tomcat-6.0.24.zip
# unzip apache-tomcat-6.0.24.zip apache-tomcat-6.0.24/bin/jsvc.tar.gz
# mv apache-tomcat-6.0.24/bin/jsvc.tar.gz tomcat6-6.0.24-jsvc.tar.gz
Source5: %{name}-%{major_version}.%{minor_version}-log4j.properties
Source6: %{name}-component-info.xml
Source7: %{name}-6.0.policy
Source8: %{name}-6.0.JBossPublicKey.RSA

# EWS scripts
Source20: %{name}-6.0.catalina.script
Source21: %{name}-6.0.service
Source22: %{name}-6.0.winscripts.tar
Source99: sign-unsigned-jars

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildArch: noarch
BuildRequires: zip

#win-buildrequires: xbuild
#win-buildrequires: jakarta-commons-daemon
#rpm-buildrequires: tomcat6-zip
#rpm-buildrequires: tomcat6-docs-webapp
#rpm-buildrequires: tomcat6-javadoc
#rpm-buildrequires: tomcat6-src-zip

%description
Tomcat is the servlet container that is used in the official Reference
Implementation for the Java Servlet and JavaServer Pages technologies.
The Java Servlet and JavaServer Pages specifications are developed by
Sun under the Java Community Process.

Tomcat is developed in an open and participatory environment and
released under the Apache Software License version 2.0. Tomcat is intended
to be a collaboration of the best-of-breed developers from around the world.

%build

%install
rm -rf $RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc


%changelog
* Thu Jul 23 2015 Mladen Turk <mturk@redhat.com> 0:6.0.41-15_patch_04
- Sync with upstream build.

* Tue Aug  5 2014 Vaclav Tunka <vtunka@redhat.com> 0:6.0.41-5_patch_03
- Fix bz1126423

* Fri Jul 25 2014 Mladen Turk <mturk@redhat.com> 0:6.0.41-3_patch_02
- Sync with upstream build.

* Thu Jul 10 2014 Mladen Turk <mturk@redhat.com> 0:6.0.41-1_patch_02
- Fix bz1115525.

* Tue Jun  3 2014 Mladen Turk <mturk@redhat.com> 0:6.0.41-1_patch_01
- Sync with upstream build.

* Thu May 15 2014 Mladen Turk <mturk@redhat.com> 0:6.0.39-2_patch_01
- Fix bz1097179.

* Tue May  6 2014 Mladen Turk <mturk@redhat.com> 0:6.0.39-1_patch_01
- Sync with upstream build.

* Mon Mar 24 2014 Mladen Turk <mturk@redhat.com> 0:6.0.37-22_patch_03
- Sync with upstream build.

* Fri Jun 21 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-10_patch_01
- Sync with upstream build.

* Thu Jun 20 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-8_patch_01
- Sync with upstream build.

* Tue Jun 18 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-7_patch_01
- Sync with upstream build.

* Tue Jun 18 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-6_patch_01
- Sync with upstream build.

* Wed Jun  5 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-3_patch_01
- Sync with upstream build.

* Mon Jun  3 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-1_patch_01
- Sync with upstream build.

* Tue May 21 2013 Mladen Turk <mturk@redhat.com> 0:6.0.35-33_patch_07
- Sync with upstream build.

* Mon May  6 2013 Mladen Turk <mturk@redhat.com> 0:6.0.35-30_patch_08
- Fix BZ959871.
  Ensure commons-daemon.jar is correctly linked in postinstall.

* Thu May  2 2013 Mladen Turk <mturk@redhat.com> 0:6.0.35-30_patch_07
- Sync with upstream build.

* Thu May  2 2013 Mladen Turk <mturk@redhat.com> 0:6.0.35-30_patch_06
- Sync with upstream build.

* Thu Dec 13 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-25_patch_01
- Sync with upstream build.

* Wed Oct 24 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-24_patch_01
- Sync with upstream build.

* Mon Oct 15 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-23_patch_02
- Rebuild.

* Fri Oct 12 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-23_patch_01
- Sync with upstream build.

*  Tue Oct  9 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-22_patch_01
- Sync with upstream build.

*  Thu Oct  4 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-21_patch_02
- Fix JBPAPP-9733.
- Fix JBPAPP-10087.
- Fix JBPAPP-10012.

*  Wed Sep 26 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-21_patch_01
- Sync with upstream build.

*  Fri Sep 14 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-18_patch_05
- Fix typo in service.bat

*  Thu Sep  6 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-18_patch_04
- Rebuild

*  Tue Sep  4 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-18_patch_03
- Fix JBPAPP-9714

*  Mon Sep  3 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-18_patch_02
- Rebuild.

*  Mon Sep  3 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-18_patch_01
- Rebuild with modified source packages.
- Sync with upstream build.

*  Mon Aug 20 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-17_patch_01
- Fix JBPAPP-9714.
- Sync with upstream build.

*  Mon Aug 06 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-16_patch_02
- Fix service library path.

*  Mon Aug 06 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-16_patch_01
- Fix JBPAPP-9568.
- Sync with upstream build.

* Tue Jul 24 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-14_patch_01
- Sync with upstream build.

* Mon Jul 23 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-13_patch_01
- Rebuild with latest upstream.

* Wed Jun 27 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-11_patch_02
- Fix windows symbolic links.

* Wed Jun 27 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-11_patch_01
- Sync with upstream build.

* Tue Jun 26 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-10_patch_01
- Sync with upstream build.

* Thu Jun 21 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-8_patch_01
- Sync with upstream build.

* Tue Jun 19 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-6_patch_01
- Sync with upstream build.
- Use mod_cluster and jboss-logging as dependencies.

* Sat Apr 28 2012 David Knox <dknox@redhat.com> 0:6.0.35-3_patch_01
- Jar signing turned off. Remove RSA and JBoss policy file.

* Tue Feb 07 2012 David Knox <dknox@redhat.com> 0:6.0.35-2_patch_01
- Added jboss-parent package to BuildRequires. Required for ep-6 and 
- forward.
