<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision : 1395561 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="mpm.xml.meta">

  <title>Modules multi-processus (MPMs)</title>

<summary>
<p>Ce document d&eacute;crit ce qu'est un Module Multi-Processus, ainsi
que la mani&egrave;re dont ces modules sont utilis&eacute;s par le serveur HTTP Apache.</p>
</summary>

<section id="introduction"><title>Introduction</title>

    <p>La conception du serveur HTTP Apache en fait un serveur web puissant et
    flexible pouvant fonctionner sur une tr&egrave;s grande vari&eacute;t&eacute; de
    plateformes et toute une gamme d'environnements diff&eacute;rents. Plateformes
    diff&eacute;rentes et environnements diff&eacute;rents signifient souvent fonctionnalit&eacute;s
    diff&eacute;rentes, ou utilisation de diff&eacute;rentes m&eacute;thodes pour
    impl&eacute;menter la m&ecirc;me fonctionnalit&eacute; le plus efficacement possible.
    Apache httpd s'est toujours accomod&eacute; d'une grande vari&eacute;t&eacute; d'environnements
    gr&acirc;ce &agrave; sa conception modulaire. Cette conception autorise le webmaster
    &agrave; choisir quelles fonctionnalit&eacute;s seront incluses
    dans le serveur en s&eacute;lectionnant les modules &agrave; charger soit &agrave; la
    compilation, soit &agrave; l'ex&eacute;cution.</p>

    <p>Le serveur HTTP Apache 2.0 a &eacute;tendu cette conception modulaire aux
    fonctions les plus
    &eacute;l&eacute;mentaires d'un serveur web. Le serveur est fourni avec une vari&eacute;t&eacute; de
    Modules Multi-Processus (MPMs) qui
    sont responsables de l'association aux ports r&eacute;seau de la machine,
    acceptent les requ&ecirc;tes, et se chargent de r&eacute;partir ces derni&egrave;res
    entre les diff&eacute;rents processus enfants.</p>

    <p>L'extension de la conception modulaire &agrave; ce niveau du serveur
    comporte deux avantages importants :</p>

    <ul>
      <li>Apache httpd peut supporter plus proprement et efficacement une grande
      vari&eacute;t&eacute; de syst&egrave;mes d'exploitation. En particulier, la version Windows
      du serveur est maintenant beaucoup plus efficace, depuis que
      <module>mpm_winnt</module> peut utiliser les fonctionnalit&eacute;s r&eacute;seau
      natives &agrave; la place de la couche POSIX utilis&eacute;e par
      Apache httpd 1.3. Cet avantage s'&eacute;tend aussi aux syst&egrave;mes d'exploitation
      qui impl&eacute;mentent des MPMs sp&eacute;cialis&eacute;s.</li>

      <li>le serveur est plus &agrave; m&ecirc;me de r&eacute;pondre aux besoins d'un site
      particulier. Par exemple, les sites qui sont tr&egrave;s sollicit&eacute;s peuvent
      utiliser un MPM thread&eacute; comme
      <module>worker</module> ou <module>event</module>, tandis que les sites
      qui privil&eacute;gient la stabilit&eacute; ou la compatibilit&eacute; avec des logiciels
      plus anciens peuvent utiliser un module comme
      <module>prefork</module>.</li>
    </ul>

    <p>Du point de vue de l'utilisateur, les MPMs ne sont pas diff&eacute;rents des
    autres modules Apache httpd. La principale diff&eacute;rence r&eacute;side dans le fait qu'un
    et un seul MPM &agrave; la fois doit &ecirc;tre charg&eacute;
    lorsque le serveur s'ex&eacute;cute. La liste des
    MPMs disponibles est fournie dans <a href="mod/">l'index des
    modules</a>.</p>

</section>

<section id="defaults"><title>MPM par d&eacute;faut</title>

<p>La table suivante fournit la liste des MPMs par d&eacute;faut pour divers
syst&egrave;mes d'exploitation.  Il s'agit du MPM qui sera utilis&eacute; si
vous n'en sp&eacute;cifiez pas un autre &agrave; la compilation.</p>

<table border="1" style="zebra">
<columnspec><column width=".2"/><column width=".2"/></columnspec>
<tr><td>Netware</td><td><module>mpm_netware</module></td></tr>
<tr><td>OS/2</td><td><module>mpmt_os2</module></td></tr>
<tr><td>Unix</td><td><module>prefork</module>, <module>worker</module>,
ou <module>event</module>, selon les possibilit&eacute;s de la plate-forme</td></tr>
<tr><td>Windows</td><td><module>mpm_winnt</module></td></tr>
</table>

<note><p>Ici, 'Unix' sous-entend les syst&egrave;mes d'exploitation de type
Unix, comme Linux, BSD, Solaris, Mac OS X, etc...</p></note>

<p>Dans le cas des syst&egrave;mes d'exploitation de type Unix, le choix du MPM
&agrave; installer est orient&eacute; par deux questions :</p>
<p>1. Est-ce que le syst&egrave;me supporte les threads ?</p>
<p>2. Est-ce que le syst&egrave;me supporte le polling thread-safe (et en
particulier les fonctions kqueue et epoll) ?</p>

<p>Si la r&eacute;ponse aux deux questions est 'oui', le MPM par d&eacute;faut sera
<module>event</module>.</p>

<p>Si la r&eacute;ponse &agrave; la premi&egrave;re question est 'oui', et la r&eacute;ponse &agrave; la
deuxi&egrave;me 'non', le MPM par d&eacute;faut sera <module>worker</module>.</p>

<p>Si la r&eacute;ponse aux deux questions est 'non', le MPM par d&eacute;faut sera
<module>prefork</module>.</p>

<p>En pratique, cela signifie que le MPM par d&eacute;faut sera presque
toujours <module>event</module> car tous les syst&egrave;mes d'exploitation
modernes satisfont aux deux conditions.</p>

</section>

<section id="static"><title>Compiler un module MPM en tant que module
statique</title>

    <p>Les modules MPM peuvent &ecirc;tre compil&eacute;s en tant que modules
statiques sur toutes les plates-formes. A la compilation d'Apache, un
seul module MPM doit &ecirc;tre choisi pour &ecirc;tre compil&eacute; et li&eacute; avec le
serveur. La recompilation du serveur sera donc n&eacute;cessaire si vous
souhaitez changer de module MPM.</p>

    <p>Pour choisir un module MPM autre que le MPM par d&eacute;faut,
    utiliser l'argument
      <code>--with-mpm=<em>NOM</em></code> du script
      <program>configure</program>. <em>NOM</em> est le nom
      du MPM d&eacute;sir&eacute;.</p>

    <p>Une fois le serveur compil&eacute;, il est possible de savoir quel MPM
    a &eacute;t&eacute; choisi &agrave; l'aide de la commande <code>./httpd -l</code>.
    Cette commande fournit la liste de tous les modules compil&eacute;s
    avec le serveur, y compris le MPM.</p>

</section>

<section id="dynamic"><title>Compiler un module MPM en tant que module
DSO (Dynamic Shared Object)</title>

    <p>Sous Unix et les plates-formes similaires, les modules MPM
    peuvent &ecirc;tre compil&eacute;s en tant que modules DSO et charg&eacute;s
    dynamiquement dans le serveur comme tout module DSO. Compiler les
    modules MPM en tant que modules DSO permet de changer de MPM en
    modifiant la directive <directive
    module="mod_so">LoadModule</directive> concern&eacute;e, sans avoir &agrave;
    recompiler le serveur.</p>

    <p>Cette fonctionnalit&eacute; est activ&eacute;e via l'option
    <code>--enable-mpms-shared</code> du script
    <program>configure</program>. Si on ajoute l'argument
    <code><em>all</em></code>, tous les modules MPM disponibles sur la
    plate-forme consid&eacute;r&eacute;e seront install&eacute;s. Cet argument peut aussi
    contenir une liste de modules MPM &agrave; installer.</p>

    <p>Le module MPM par d&eacute;faut, s&eacute;lectionn&eacute; automatiquement ou sp&eacute;cifi&eacute;
    via l'option <code>--with-mpm</code> du script
    <program>configure</program>, sera charg&eacute; via une directive
    <directive module="mod_so">LoadModule</directive> du fichier de
    configuration du serveur g&eacute;n&eacute;r&eacute;. Pour choisir un autre module MPM,
    vous devrez donc modifier cette directive</p>

</section>

</manualpage>
