<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1338141 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="vhosts.xml.meta">
  <parentdocument href="./">Rewrite</parentdocument>

<title>H&eacute;bergement virtuel de masse avec mod_rewrite</title>

<summary>

<p>Ce document est un compl&eacute;ment &agrave; la <a
href="../mod/mod_rewrite.html">documentation de r&eacute;f&eacute;rence</a> du module
<module>mod_rewrite</module>. Il d&eacute;crit comment cr&eacute;er des serveurs
virtuels dynamiquement configur&eacute;s en utilisant
<module>mod_rewrite</module>.</p>

<note type="warning">L'utilisation de mod_rewrite n'est pas la meilleure
m&eacute;thode pour configurer des serveurs virtuels. Vous devez dans un
premier temps tenter de r&eacute;soudre votre probl&egrave;me via ces  <a
href="../vhosts/mass.html">d'autres m&eacute;thodes</a> avant d'avoir
recours &agrave; mod_rewrite. Voir aussi le document <a
href="avoid.html#vhosts">Comment &eacute;viter l'utilisation de
mod_rewrite</a>.</note>


</summary>
<seealso><a href="../mod/mod_rewrite.html">Documentation du module</a></seealso>
<seealso><a href="intro.html">Introduction &agrave; mod_rewrite</a></seealso>
<seealso><a href="remapping.html">Redirection et remise en
correspondance</a></seealso>
<seealso><a href="access.html">Contr&ocirc;le d'acc&egrave;s</a></seealso>
<!--<seealso><a href="vhosts.html">Serveurs virtuels</a></seealso>-->
<seealso><a href="proxy.html">Serveurs mandataires</a></seealso>
<seealso><a href="rewritemap.html">Utilisation de RewriteMap</a></seealso>
<seealso><a href="advanced.html">Techniques avanc&eacute;es</a></seealso>
<seealso><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></seealso>

<section id="per-hostname">

  <title>Serveurs virtuels pour des noms d'h&ocirc;tes arbitraires</title>

  <dl>
    <dt>Description :</dt>

    <dd>
    <p>Nous voulons cr&eacute;er automatiquement un serveur virtuel pour tout
    nom d'h&ocirc;te qui peut &ecirc;tre r&eacute;solu dans notre domaine, sans avoir &agrave;
    cr&eacute;er de nouvelle section VirtualHost.</p>

    <p>Dans cet exemple, nous supposons que nous utilisons le nom d'h&ocirc;te
    <code>www.<strong>SITE</strong>.example.com</code> pour chaque
    utilisateur, et que nous servons leur contenu depuis
    <code>/home/<strong>SITE</strong>/www</code>.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>

<highlight language="config">
RewriteEngine on

RewriteMap    lowercase int:tolower

RewriteCond   ${lowercase:%{<strong>HTTP_HOST</strong>}}   ^www\.<strong>([^.]+)</strong>\.example\.com$
RewriteRule   ^(.*) /home/<strong>%1</strong>/www$1
</highlight></dd>

<dt>Discussion</dt>
    <dd>

    <note type="warning">Vous devez v&eacute;rifier le bon fonctionnement de la
    r&eacute;solution DNS - Apache ne g&egrave;re pas la r&eacute;solution de nom. Vous
    devrez cr&eacute;er soit des enregistrements CNAME pour chaque nom d'h&ocirc;te,
    soit un enregistrement DNS avec caract&egrave;res g&eacute;n&eacute;riques. La cr&eacute;ation
    des enregistrements DNS est en dehors du sujet de ce document.</note>

<p>La directive RewriteMap interne <code>tolower</code> permet de
s'assurer que les noms d'h&ocirc;tes utilis&eacute;s seront tous en minuscules, de
fa&ccedil;on &agrave; &eacute;viter toute ambiguit&eacute; dans la structure des r&eacute;pertoires qui
doit &ecirc;tre cr&eacute;&eacute;e.</p>

<p>Les contenus des parenth&egrave;ses utilis&eacute;es dans une directive <directive
module="mod_rewrite">RewriteCond</directive> sont enregistr&eacute;s dans les
r&eacute;f&eacute;rences arri&egrave;res <code>%1</code>, <code>%2</code>, etc..., alors que
les contenus des parenth&egrave;ses utilis&eacute;es dans une directive <directive
module="mod_rewrite">RewriteRule</directive> le sont dans les
r&eacute;f&eacute;rences arri&egrave;res <code>$1</code>, <code>$2</code>, etc...</p>

<p>
Comme c'est le cas pour de nombreuses techniques discut&eacute;es dans ce
document, mod_rewrite n'est vraiment pas la meilleure m&eacute;thode pour
accomplir cette t&acirc;che. Vous devez plut&ocirc;t vous tourner vers
<module>mod_vhost_alias</module>, car ce dernier sera bien plus &agrave; m&ecirc;me
de g&eacute;rer tout ce qui est au del&agrave; du domaine des fichiers statiques,
comme les contenus dynamiques et la r&eacute;solution des alias.
</p>
    </dd>
  </dl>

</section>

<section id="simple.rewrite"><title>Configuration dynamique de serveurs
virtuels via <module>mod_rewrite</module></title>

    <p>Cet extrait du fichier <code>httpd.conf</code> permet d'obtenir
    le m&ecirc;me r&eacute;sultat que <a href="#per-hostname">le premier exemple</a>.
    La premi&egrave;re moiti&eacute; est tr&egrave;s similaire &agrave; la partie correspondante
    ci-dessus, except&eacute; quelques modifications requises &agrave; des fins de
    compatibilit&eacute; ascendante et pour faire en sorte que la partie
    <code>mod_rewrite</code> fonctionne correctement ; la seconde moiti&eacute;
    configure <code>mod_rewrite</code> pour effectuer le travail
    proprement dit.</p>

    <p>Comme <code>mod_rewrite</code> s'ex&eacute;cute avant tout autre module
    de traduction d'URI (comme <code>mod_alias</code>), il faut lui
    ordonner explicitement d'ignorer toute URL susceptible d'&ecirc;tre
    trait&eacute;e par ces autres modules. Et comme ces r&egrave;gles auraient sinon
    court-circuit&eacute; toute directive <code>ScriptAlias</code>, nous devons
    faire en sorte que <code>mod_rewrite</code> d&eacute;clare explicitement
    ces correspondances.</p>

<highlight language="config">
# extrait le nom de serveur de l'en-t&ecirc;te Host:
UseCanonicalName Off

# journaux dissociables
LogFormat "%{Host}i %h %l %u %t \"%r\" %s %b" vcommon
CustomLog logs/access_log vcommon

&lt;Directory /www/hosts&gt;
    # ExecCGI est n&eacute;cessaire ici car on ne peut pas forcer l'ex&eacute;cution
    # des CGI &agrave; la mani&egrave;re de ScriptAlias
    Options FollowSymLinks ExecCGI
&lt;/Directory&gt;

RewriteEngine On

# un nom de serveur extrait d'un en-t&ecirc;te Host: peut &ecirc;tre dans n'importe
# quelle casse

## on s'occupe tout d'abord des documents normaux :<br />
# permet &agrave; "Alias /icons/" de fonctionner - r&eacute;p&eacute;ter pour les autres
RewriteCond  %{REQUEST_URI}  !^/icons/
# permet aux CGIs de fonctionner
RewriteCond  %{REQUEST_URI}  !^/cgi-bin/
# le coeur du traitement
RewriteRule  ^/(.*)$  /www/hosts/${lowercase:%{SERVER_NAME}}/docs/$1

## on s'occupe maintenant des CGIs - on doit forcer l'utilisation d'un
# gestionnaire
RewriteCond  %{REQUEST_URI}  ^/cgi-bin/
RewriteRule  ^/(.*)$  /www/hosts/${lowercase:%{SERVER_NAME}}/cgi-bin/$1  [H=cgi-script]
</highlight>

</section>

<section id="xtra-conf"><title>Utilisation d'un fichier de configuration
du serveur virtuel s&eacute;par&eacute;</title>

    <p>Cette construction utilise des fonctionnalit&eacute;s plus avanc&eacute;es de
    <module>mod_rewrite</module> pour effectuer la traduction depuis le
    serveur virtuel vers la racine des documents, &agrave; partir d'un fichier
    de configuration s&eacute;par&eacute;. Elle est plus souple mais n&eacute;cessite une
    configuration plus compliqu&eacute;e.</p>

    <p>Le fichier <code>vhost.map</code> devrait ressembler &agrave; ceci :</p>

<example>
www.client-1.example.com  /www/clients/1<br />
www.client-2.example.com  /www/clients/2<br />
# ...<br />
www.client-N.example.com  /www/clients/N<br />
</example>

    <p>On doit ajouter &agrave; <code>httpd.conf</code> :</p>

<highlight language="config">
RewriteEngine on

RewriteMap   lowercase  int:tolower

# d&eacute;finit le fichier de correspondances
RewriteMap   vhost      txt:/www/conf/vhost.map

# on s'occupe des alias comme ci-dessus
RewriteCond  %{REQUEST_URI}               !^/icons/
RewriteCond  %{REQUEST_URI}               !^/cgi-bin/
RewriteCond  ${lowercase:%{SERVER_NAME}}  ^(.+)$
# on effectue ici la remise en correspondance &agrave; base de fichier
RewriteCond  ${vhost:%1}                  ^(/.*)$
RewriteRule  ^/(.*)$                      %1/docs/$1

RewriteCond  %{REQUEST_URI}               ^/cgi-bin/
RewriteCond  ${lowercase:%{SERVER_NAME}}  ^(.+)$
RewriteCond  ${vhost:%1}                  ^(/.*)$
RewriteRule  ^/(.*)$                      %1/cgi-bin/$1 [H=cgi-script]
</highlight>

</section>

</manualpage>
