<?xml version='1.0' encoding='ISO-8859-1' ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1344668 -->
<!-- French translation by Vincent Deffontaines, review by alain B -->
<!-- Updated by Lucien Gentis -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="details.xml.meta">
<parentdocument href="./">Serveurs virtuels</parentdocument>
   <title>Dtails sur le fonctionnement des serveurs virtuels</title>

<summary>

    <p>Ce document vise  expliquer dans le dtail comment le serveur
    HTTP Apache procde lors du choix de l'utilisation
    d'un serveur virtuel en fonction d'une requte reue.</p>

    <p>Il est recommand de lire la documentation<a href="name-based.html#namevip">
    Serveurs virtuels  base de nom et serveurs virtuels  base
    d'adresse IP</a> pour dterminer quel type de serveur virtuel nous
    convient le mieux, puis de lire les documentations <a
    href="name-based.html">serveurs virtuels  base de nom</a> ou <a
    href="ip-based.html">serveurs virtuels  base d'adresse IP</a>, et enfin
    d'tudier <a href="examples.html">quelques exemples</a>.</p>

    <p>Si vous voulez entrer dans les dtails, vous pouvez revenir vers
    cette page.</p>

</summary>

<seealso><a href="ip-based.html">Support des serveurs virtuels  base
d'adresse IP</a></seealso>
<seealso><a href="name-based.html">Support des serveurs virtuels  base
de nom</a></seealso>
<seealso><a href="examples.html">Exemples de serveurs virtuels pour une
configuration courante</a></seealso>
<seealso><a href="mass.html">Hbergement virtuel de masse configur
dynamiquement</a></seealso>


<section id="configparsing"><title>Fichier de configuration</title>

    <p>Un <em>serveur  principal (main_server)</em> contient toutes
    les dfinitions qui apparaissent en dehors des sections
    <code>&lt;VirtualHost&gt;</code>.</p>

    <p>Les serveurs virtuels, aussi
    appels <em>vhosts</em> (pour virtual hosts), sont dfinis par les
    sections <directive type="section" module="core">VirtualHost</directive>.</p>

    <p>Chaque directive <code>VirtualHost</code> comporte une ou
    plusieurs adresses et des ports optionnels.</p>

    <p>Il est possible d'utiliser des noms d'htes dans la dfinition
    d'un serveur virtuel, mais ils seront rsolus en adresses IP au
    dmarrage du serveur, et si une rsolution de nom choue, cette
    dfinition de serveur virtuel sera ignore. Cette mthode est par
    consquent dconseille.</p>

    <p>L'adresse peut
    tre spcifie sous la forme <code>*</code>, ce qui conviendra  la
    requte si aucun autre serveur virtuel ne possde l'adresse IP
    explicite correspondant  celle de la requte.</p>

    <p>L'adresse qui apparat dans la directive <code>VirtualHost</code>
    peut tre associe  un port optionnel. Si aucun port n'est
    spcifi, il s'agit d'un port gnrique qui peut aussi tre spcifi
    comme <code>*</code>. Le port gnrique correspond  toutes les
    valeurs de port.</p>

    <p>(Il ne faut pas confondre les numros de port sur lesquels Apache
    est en coute avec les numros de port spcifis dans la directive
    <code>VirtualHost</code> ; ces derniers ne servent qu' dfinir le
    <code>serveur virtuel</code> qui sera slectionn pour traiter la
    requte. Pour dfinir les ports sur lesquels Apache est en coute,
    utilisez la directive <directive module="mpm_common">Listen</directive>).
    </p>

    <p>L'ensemble des adresses (y compris les rsultats multiples
    <code>A</code> issus des requtes DNS) est appel <em>jeu
    d'adresses</em> du serveur virtuel.</p>

    <p>Apache fait automatiquement sa slection  partir de l'en-tte
    HTTP <code>Host</code> fourni par le client, lorsque la
    correspondance la plus exacte du point de vue adresse IP/port a lieu
    pour plusieurs serveurs virtuels.</p>

    <p>La directive <directive module="core">ServerName</directive> peut
    apparatre en quelque endroit de la dfinition d'un serveur.
    Cependant, chaque occurrence crase la prcdente (pour ce serveur).
    Si aucune directive <code>ServerName</code> n'est spcifie, le
    serveur tente de dterminer le nom du serveur  partir de l'adresse
    IP.</p>

    <p>Le premier serveur virtuel  base de nom apparaissant dans le
    fichier de configuration pour une paire IP:port donne est
    significatif car c'est lui qui sera utilis pour toutes les requtes
    reues sur cette adresse IP/port et pour laquelle aucun autre
    serveur virtuel ne possde un ServerName ou un ServerAlias
    correspondant. Il sera aussi utilis pour toutes les connexions SSL
    si le serveur ne supporte pas l'<glossary
    ref="servernameindication">Indication du nom du serveur</glossary>.</p>

    <p>Tous les noms spcifis au sein d'une section
    <code>VirtualHost</code> sont traits comme un
    <code>ServerAlias</code> (sans caractres gnriques), mais ne sont
    crass par aucune directive <code>ServerAlias</code>.</p>

    <p>Pour chaque serveur virtuel, diverses valeurs sont initialises
    par dfaut. En particulier&nbsp;:</p>

    <ol>
      <li>Dans le cas o un serveur virtuel ne contient pas de directives
      <directive module="core">ServerAdmin</directive>,
      <directive module="core">Timeout</directive>,
      <directive module="core">KeepAliveTimeout</directive>,
      <directive module="core">KeepAlive</directive>,
      <directive module="core">MaxKeepAliveRequests</directive>,
      <directive module="mpm_common">ReceiveBufferSize</directive>,
      ou <directive module="mpm_common">SendBufferSize</directive>,
      alors la valeur de chacun de ces paramtres est hrite de celle du
      serveur principal. (C'est  dire, hrite de la valeur finale aprs
      lecture de la configuration du serveur principal.)</li>

      <li>Les permissions par dfaut sur les rpertoires de chaque
      serveur virtuel sont assembles avec celles du serveur principal.
      Elles concernent galement toutes les informations de configuration
      par rpertoire pour tous les modules.</li>

      <li>Les configurations par serveur pour chaque module sont assembles
       partir de celles du serveur principal.</li>
    </ol>

    <p>L'essentiel des valeurs de configuration des serveurs virtuels
    provient de valeurs par dfaut issues du serveur principal.
    Mais la position dans le fichier de configuration des directives
    du serveur principal n'a pas d'importance -- l'ensemble de la
    configuration du serveur principal est lu avant que ces valeurs par
    dfaut soient appliques aux serveur virtuels. Ainsi, mme si la
    dfinition d'une valeur apparat aprs celle d'un serveur virtuel,
    cette valeur peut affecter la definition du serveur virtuel.</p>

    <p>Dans le cas o le serveur principal n'a pas de <code>ServerName</code>
     ce stade, le nom de la machine sur laquelle tourne le programme
    <program>httpd</program> est utilis  sa place. Nous appellerons
    <em>jeu d'adresses du serveur principal</em> les adresses IP
    renvoyes par une rsolution DNS sur le <code>ServerName</code>
    du serveur principal.</p>

    <p>Pour tous les champs <code>ServerName</code> non dfinis, dans
    le cas d'une configuration en serveur virtuel par nom, la valeur
    adopte par dfaut est la premire adresse donne dans la section
    <code>VirtualHost</code> qui dfinit le serveur virtuel.</p>

    <p>Si un serveur virtuel contient la valeur magique
    <code>_default_</code>, il fonctionne sur le mme <code>ServerName</code>
    que le serveur principal.</p>

</section>

<section id="hostmatching"><title>Choix du serveur virtuel</title>

    <p> la rception d'une requte, le serveur procde comme suit pour
    dterminer quel serveur virtuel utiliser&nbsp;:</p>

    <section id="hashtable"><title>Recherche de l'adresse IP</title>

    <p>Lors d'une premire connexion sur une adresse/port, le serveur
    recherche toutes les directives <code>VirtualHost</code> qui
    possdent la mme adresse IP/port.</p>

    <p>S'il n'y a aucune correspondance exacte pour cette adresse/port,
    la recherche s'effectue sur la valeur gnrique (<code>*</code>).</p>

    <p>Si aucune correspondance n'est enfin trouve, la requte sera
    servie par le serveur principal.</p>

    <p>S'il existe des dfinitions <code>VirtualHost</code> pour
    l'adresse IP, l'tape suivante consiste  dterminer si nous avons 
    faire  un serveur virtuel  base de nom ou d'adresse IP.</p>

    </section>

    <section id="ipbased"><title>Serveur virtuel par IP</title>

    <p>Si une seule section <code>VirtualHost</code> prsente la
    meilleure correspondance avec la paire adresse IP/port, aucune
    action n'est entreprise et la requte est
    traite par le serveur virtuel qui correspond.</p>

    </section>

    <section id="namebased"><title>Serveur virtuel par nom</title>

    <p>Si plusieurs sections <code>VirtualHost</code> prsentent la
    meilleure correspondance avec la paire adresse IP/port, le terme
    "liste" dans les tapes suivantes fait rfrence  la liste des
    serveurs virtuels qui correspondent, selon l'ordre dans lequel ils
    apparaissent dans le fichier de configuration.</p>

    <p>Si la connexion utilise SSL, si le serveur supporte l'<glossary
    ref="servernameindication">Indication de nom de serveur</glossary>,
    et si la ngociation du client SSL inclut l'extension TLS dans le
    nom d'hte requis, alors ce nom d'hte sera utilis par la suite, tout
    comme un en-tte <code>Host:</code> aurait t utilis dans le cas
    d'une connexion non-SSL. Si ces conditions ne sont pas runies, le
    premier serveur virtuel  base de nom dont l'adresse correspond sera
    utilis pour les connexions SSL. Ceci est important car c'est le
    serveur virtuel qui dtermine quel certificat le serveur va utiliser
    pour la connexion.</p>

    <p>Si la requte contient un en-tte <code>Host:</code>, on
    recherche dans la liste le premier serveur virtuel dont le
    <code>ServerName</code> ou le <code>ServerAlias</code> correspond,
    et c'est celui-ci qui va traiter la requte. Un en-tte
    <code>Host:</code> peut comporter un numro de port mais Apache
    l'ignore systmatiquement et utilise toujours le
    port sur lequel il a effectivement reu la requte.</p>

    <p>Le premier serveur virtuel du fichier de configuration qui
    possde l'adresse spcifie est prioritaire et intercepte toutes les
    requtes  destination d'un nom de serveur inconnu, ou toute requte
    sans en-tte <code>Host:</code> (comme les requtes HTTP/1.0).</p>

    </section>

    <section id="persistent"><title>Connexions persistantes</title>

    <p>La <em>recherche par adresse IP</em> dcrite ci-avant n'est faite
    qu'<em>une fois</em> pour chaque session TCP/IP, alors que la
    <em>recherche par nom</em> est ralise pour <em>chaque</em> requte au
    cours d'une connexion persistante (KeepAlive). En d'autres termes,
    il est possible pour un client de faire des requtes sur
    diffrents serveurs virtuels par nom, au cours d'une unique
    connexion persistante.</p>

    </section>

    <section id="absoluteURI"><title>URI absolu</title>

    <p>Au cas o l'URI de la requte est absolu, et que son nom de
    serveur et son port correspondent au serveur principal (ou l'un
    des serveurs virtuels configurs), <em>et</em> qu'ils correspondent
     l'adresse et au port de la requte, alors l'URI est amput
    de son prfixe protocole/nom de serveur/port et trait par le
    serveur correspondant (principal ou virtuel). Si cette correspondance
    n'existe pas, l'URI reste inchang et la requte est considre
    comme une requte d'un serveur mandataire (proxy).</p>
</section>

<section id="observations"><title>Observations</title>

    <ul>
      <li>La slection d'un serveur virtuel en fonction de son nom est
      un processus qui intervient aprs la slection par le serveur du
      serveur virtuel qui correspond le mieux du point de vue adresse
      IP/port.</li>

      <li>Si vous ne tenez pas compte de l'adresse IP  laquelle le
      client s'est connect, indiquez un caractre "*" comme adresse
      pour tous les serveurs virtuels, et la slection du serveur
      virtuel en fonction du nom s'appliquera alors  tous les serveurs
      virtuels dfinis.</li>

      <li>Les vrifications sur <code>ServerName</code> et
      <code>ServerAlias</code> ne sont jamais
      ralises pour les serveurs virtuels par IP.</li>

      <li>Seul l'ordre des serveurs virtuels par nom
      pour une adresse donne a une importance. Le serveur virtuel
      par nom qui est prsent en premier dans la configuration se
      voit attribu la priorit la plus haute pour les requtes
      arrivant sur son jeu d'adresses IP.</li>

      <li>Le numro de port contenu dans l'en-tte <code>Host:</code> n'est jamais utilis
      pour les tests de correspondances. Apache ne prend en compte
      que le numro de port sur lequel le client a envoy la requte.</li>

      <li>Si deux serveurs virtuels partagent la mme adresse, la
      slection se fera implicitement sur le nom. Il s'agit d'une
      nouvelle fonctionnalit de la version 2.3.11.</li>

      <li>Le serveur principal ne sert les requtes que
      lorsque l'adresse IP et le port demands par le client ne
      correspondent  aucun serveur virtuel (y compris un serveur
      virtuel <code>*</code>). En d'autres termes, le serveur
      principal n'est utile que pour les combinaisons adresse/port
      non spcifies (sauf quand un serveur virtuel <code>_default_</code>
      correspond au port).</li>

      <li>Il ne faut jamais employer de noms DNS dans des directives
      <code>VirtualHost</code>, car cela oblige le serveur a s'appuyer
      sur le DNS au moment du dmarrage. De plus, vous vous exposez
       des problmes de scurit si vous n'avez pas la matrise du
      DNS pour la totalit de vos domaines. Voir la documentation
      <a href="../dns-caveats.html">disponible ici</a>, ainsi que
      les deux points prciss ci-aprs.</li>

      <li>Un nom de serveur <code>ServerName</code> devrait toujours
      tre indiqu pour chaque serveur virtuel. Sans cela, une
      rsolution DNS est ncessaire pour chaque serveur virtuel.</li>
      </ul>
      </section>

</section>

<section id="tips"><title>Trucs et astuces</title>

    <p>En plus des points voqus sur la page des
    <a href="../dns-caveats.html#tips">problmes lis au DNS</a>,
    voici quelques points intressants&nbsp;:</p>

    <ul>
      <li>Toujours positionner les dfinitions relatives au serveur
      principal avant toute dfinition <code>VirtualHost</code>.
      (Ceci amliore grandement la lisibilit de la configuration
      -- la manire dont la configuration est interprte aprs la
      lecture des fichiers ne met pas en vidence le fait que les
      dfinitions positionnes avant et surtout aprs les serveurs
      virtuels peuvent impacter le fonctionnement de tous les
      serveurs virtuels.)</li>

   </ul>

</section>
</manualpage>

