<?xml version='1.0' encoding='ISO-8859-1' ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1334000 -->
<!-- French translation by Vincent Deffontaines, review by alain B -->
<!-- Updated by Lucien Gentis -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="fd-limits.xml.meta">
<parentdocument href="./">Serveurs Virtuels</parentdocument>
  <title>Limites des descripteurs de fichiers</title>

<summary>

    <p>Quand de nombreux serveurs virtuels sont crs, Apache peut
    dpasser les limites en descripteurs de fichiers ('file descriptors',
    galement appels <cite>gestionnaires de fichiers</cite>) si chacun
    des serveurs virtuels utilise ses propres fichiers journaux. Le
    nombre total de descripteurs de fichiers utiliss par Apache est
    d'un par fichier journal, un pour chacune des autres directives
    de fichiers journaux, plus un nombre constant compris entre 10 et 20
    pour son fonctionnement interne. Les systmes d'exploitation Unix
    limitent le nombre de descripteurs de fichiers utilisables par
    processus&nbsp;; une valeur courante pour cette limite est de 64, et
    cette valeur peut le plus souvent tre augmente.</p>

    <p>Apache tente d'accrotre cette valeur limite si ncessaire, mais
    sans y parvenir dans les cas suivants&nbsp;:</p>

    <ol>
      <li>Le systme d'exploitation ne permet pas l'utilisation d'appels
      systmes <code>setrlimit()</code>.</li>

      <li>L'appel <code>setrlimit(RLIMIT_NOFILE)</code> ne fonctionne pas
      sur votre systme d'exploitation (c'est le cas sous Solaris 2.3).</li>

      <li>Le nombre de descripteurs de fichiers ncessaires  Apache
      dpasse la limite physique du matriel.</li>

      <li>Le systme impose d'autres limites sur l'utilisation des
      descripteurs de fichiers, comme par exemple une limite sur les
      flux stdio, utilisables uniquement sur les descripteurs de
      fichiers infrieurs  256. (sous Solaris 2).</li>
    </ol>

    <p>En cas de problme, Vous pouvez&nbsp;:</p>

    <ul>
      <li>Rduire le nombre de fichiers journaux, en ne spcifiant
      aucun fichier journal dans les sections
      <directive type="section" module="core">VirtualHost</directive>,
      en donc en envoyant les informations aux fichiers journaux du
      serveur principal (Voir <a href="#splitlogs">clatement des
      fichiers journaux</a> ci-dessous pour plus d'informations sur
      cette possibilit).</li>

      <li>
        Dans les cas 1 ou 2 (voqus ci-dessus), augmentez la limite sur
        les descripteurs de fichiers avant le dmarrage d'Apache, au
        moyen d'un script comme

        <example>
          <code>#!/bin/sh<br />
           ulimit -S -n 100<br />
           exec httpd</code>
        </example>
      </li>
    </ul>

<!-- the document misc/descriptors.xml does not exist yet in 2.1
    <p>Veuillez noter que le document
    <a href="../misc/descriptors.html">Descripteurs et Apache</a>
    contient plus de dtails concernant les problmes de descripteurs
    de fichiers et comment les rsoudre en fonction de votre systme
    d'exploitation.</p>
-->

</summary>

<section id="splitlogs"><title>clatement des fichiers journaux</title>

<p>Lorsque vous choisissez d'enregistrer les informations manant de
plusieurs serveurs virtuels dans un mme fichier journal, vous voudrez
ensuite pouvoir scinder ces informations  des fins de statistiques, par
exemple, sur les diffrents serveurs virtuels. Il est possible de procder
de la manire suivante&nbsp;:</p>

<p>Tout d'abord, vous devez ajouter le nom du serveur virtuel  chaque
entre du journal. Ceci se paramtre au moyen de la directive
<directive module="mod_log_config"> LogFormat</directive> et de la
variable <code>%v</code>. Ajoutez cette variable au dbut de la chane
de dfinition du format de journalisations&nbsp;:</p>

<highlight language="config">
LogFormat "%v %h %l %u %t \"%r\" %&gt;s %b" vhost
CustomLog logs/multiple_vhost_log vhost
</highlight>

<p>Cette configuration va provoquer la cration d'un fichier de
journalisation au format standard (CLF&nbsp;: 'Common Log Format'), mais dont
chaque ligne dbutera par le nom canonique du serveur virtuel (spcifi
par la directive <directive module="core">ServerName</directive>).
(Voir <directive module="mod_log_config">Formats de journalisation
personnaliss</directive> pour d'autres informations sur la
personnalisation des fichiers journaux.)</p>

<p>Au moment de sparer les informations du fichier journal en un fichier
par serveur virtuel, le programme <code>
<a href="../programs/other.html">split-logfile</a></code> peut tre
utilis. Ce programme peut tre trouv dans le rpertoire
<code>support</code> de la distribution d'Apache.</p>

<p>Excutez ce programme au moyen de la commande&nbsp;:</p>

<example>
split-logfile &lt; /logs/multiple_vhost_log
</example>

<p>Une fois excut avec le nom du fichier contenant tous les journaux,
ce programme va gnrer un fichier pour chacun des serveurs virtuels
qui apparat dans le fichier d'entre. Chaque fichier en sortie est
nomm <code>nomduserveur.log</code>.</p>

</section>
</manualpage>

