/**
 * License Agreement.
 *
 *  JBoss RichFaces 3.0 - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html.iconimages;

import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;

/**
 * @author Maksim Kaszynski
 *
 */
public class DisabledCalendarIcon extends CalendarIcon {

	@Override
	protected BufferedImage createImage(int width, int height) {
		ColorSpace gsColorSpace = ColorSpace.getInstance(ColorSpace.CS_GRAY);

		ComponentColorModel ccm = new ComponentColorModel(gsColorSpace, true, false,
				Transparency.TRANSLUCENT, DataBuffer.TYPE_BYTE);

		WritableRaster raster = ccm.createCompatibleWritableRaster(width, height);

		return new BufferedImage(ccm, raster, ccm.isAlphaPremultiplied(), null);
	}

}
