/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.ajax4jsf.io.ByteBuffer;
import org.ajax4jsf.io.FastBufferInputStream;
import org.richfaces.request.FileUploadResource;

class FileUploadMemoryResource
extends FileUploadResource {
    private ByteBuffer buffer;

    public FileUploadMemoryResource(String name, String uploadLocation) {
        super(name, uploadLocation);
    }

    private void checkNotDeleted() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Resource has been deleted");
        }
    }

    public InputStream getInputStream() throws IOException {
        this.checkNotDeleted();
        return new FastBufferInputStream(this.buffer);
    }

    public long getSize() {
        return this.buffer.getLast().getTotalSize();
    }

    public void write(String fileName) throws IOException {
        this.checkNotDeleted();
        InputSupplier<InputStream> inputSupplier = new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return FileUploadMemoryResource.this.getInputStream();
            }
        };
        Files.copy((InputSupplier)inputSupplier, (File)this.getOutputFile(fileName));
    }

    public void delete() throws IOException {
        this.buffer = null;
    }

    public void handle(byte[] bytes, int length) throws IOException {
        this.buffer.append(bytes, 0, length);
    }

    public void create() {
        this.buffer = new ByteBuffer(128);
    }

    public void complete() {
        this.buffer.compact();
    }
}

