/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.ListType;
import org.richfaces.component.UISequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractList
extends UISequence {
    public static final String TERM = "term";
    private static final Predicate<String> TERM_PREDICATE = new Predicate<String>(){

        public boolean apply(String input) {
            return AbstractList.TERM.equals(input);
        }
    };
    private static final Predicate<String> NON_TERM_PREDICATE = Predicates.not(TERM_PREDICATE);

    private Iterator<UIComponent> getFacetsIterator(Predicate<? super String> namePredicate) {
        if (this.getFacetCount() > 0) {
            return Maps.filterKeys((Map)this.getFacets(), namePredicate).values().iterator();
        }
        return Iterators.emptyIterator();
    }

    protected Iterator<UIComponent> dataChildren() {
        return Iterators.concat(this.getChildren().iterator(), this.getFacetsIterator(TERM_PREDICATE));
    }

    protected Iterator<UIComponent> fixedChildren() {
        return this.getFacetsIterator(NON_TERM_PREDICATE);
    }

    @Attribute(defaultValue="ListType.unordered")
    public abstract ListType getType();

    public UIComponent getTerm() {
        return this.getFacet(TERM);
    }

    @Attribute(events={@EventName(value="click")})
    public abstract String getOnclick();

    @Attribute(events={@EventName(value="dblclick")})
    public abstract String getOndblclick();

    @Attribute(events={@EventName(value="mousedown")})
    public abstract String getOnmousedown();

    @Attribute(events={@EventName(value="mouseup")})
    public abstract String getOnmouseup();

    @Attribute(events={@EventName(value="mouseover")})
    public abstract String getOnmouseover();

    @Attribute(events={@EventName(value="mousemove")})
    public abstract String getOnmousemove();

    @Attribute(events={@EventName(value="mouseout")})
    public abstract String getOnmouseout();

    @Attribute(events={@EventName(value="keypress")})
    public abstract String getOnkeypress();

    @Attribute(events={@EventName(value="keydown")})
    public abstract String getOnkeydown();

    @Attribute(events={@EventName(value="keyup")})
    public abstract String getOnkeyup();

    @Attribute(events={@EventName(value="rowclick")})
    public abstract String getOnrowclick();

    @Attribute(events={@EventName(value="rowdblclick")})
    public abstract String getOnrowdblclick();

    @Attribute(events={@EventName(value="rowmousedown")})
    public abstract String getOnrowmousedown();

    @Attribute(events={@EventName(value="rowmouseup")})
    public abstract String getOnrowmouseup();

    @Attribute(events={@EventName(value="rowmouseover")})
    public abstract String getOnrowmouseover();

    @Attribute(events={@EventName(value="rowmousemove")})
    public abstract String getOnrowmousemove();

    @Attribute(events={@EventName(value="rowmouseout")})
    public abstract String getOnrowmouseout();

    @Attribute(events={@EventName(value="rowkeypress")})
    public abstract String getOnrowkeypress();

    @Attribute(events={@EventName(value="rowkeydown")})
    public abstract String getOnrowkeydown();

    @Attribute(events={@EventName(value="rowkeyup")})
    public abstract String getOnrowkeyup();

    @Attribute
    public abstract String getStyle();

    @Attribute
    public abstract String getStyleClass();

    @Attribute
    public abstract String getTitle();

    @Attribute
    public abstract String getDir();

    @Attribute
    public abstract String getLang();

    @Attribute
    public abstract String getRowClasses();

    @Attribute
    public abstract String getRowClass();
}

