/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import org.richfaces.component.util.HtmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TreeNodeState {
    expanded("rf-tr-nd-exp", "rf-trn-hnd-exp", "rf-trn-ico-exp"){

        public boolean isLeaf() {
            return false;
        }

        public boolean isDifferentThan(TreeNodeState anotherState) {
            return anotherState != expandedNoChildren && super.isDifferentThan(anotherState);
        }
    }
    ,
    expandedNoChildren("rf-tr-nd-exp rf-tr-nd-exp-nc", "rf-trn-hnd-lf", "rf-trn-ico-exp"){

        public boolean isLeaf() {
            return false;
        }

        public boolean isDifferentThan(TreeNodeState anotherState) {
            return anotherState != expanded && super.isDifferentThan(anotherState);
        }
    }
    ,
    collapsed("rf-tr-nd-colps", "rf-trn-hnd-colps", "rf-trn-ico-colps"){

        public boolean isLeaf() {
            return false;
        }
    }
    ,
    leaf("rf-tr-nd-lf", "rf-trn-hnd-lf", "rf-trn-ico-lf"){

        public boolean isLeaf() {
            return true;
        }
    };

    private String nodeClass;
    private String handleClass;
    private String iconClass;
    private String customIconClass;

    private TreeNodeState(String nodeClass, String defaultHandleClass, String iconClass) {
        this.nodeClass = nodeClass;
        this.handleClass = HtmlUtil.concatClasses((Object[])new Object[]{defaultHandleClass, "rf-trn-hnd"});
        this.iconClass = HtmlUtil.concatClasses((Object[])new Object[]{iconClass, "rf-trn-ico"});
        this.customIconClass = HtmlUtil.concatClasses((Object[])new Object[]{this.iconClass, "rf-trn-ico-cst"});
    }

    public abstract boolean isLeaf();

    public boolean isDifferentThan(TreeNodeState anotherState) {
        return anotherState != this;
    }

    public String getNodeClass() {
        return this.nodeClass;
    }

    public String getHandleClass() {
        return this.handleClass;
    }

    public String getIconClass() {
        return this.iconClass;
    }

    public String getCustomIconClass() {
        return this.customIconClass;
    }
}

