    // ----------------------------------------------------- StateHolder Methods
    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!initialStateMarked()) {
            Object values[] = new Object[1];
            <#list generatedAttributes as attribute>
            values[${attribute_index}] = this.${attribute.getterName}();
            </#list>

            return values;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }

        Object values[] = (Object[]) state;
        <#list generatedAttributes as attribute>
        ${attribute.setterName}((${attribute.typeForCasting}) values[${attribute_index}]);
        </#list>
    }

    private boolean transientValue = false;

    @Override
    public boolean isTransient() {
        return this.transientValue;
    }

    @Override
    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }


    private boolean initialState;

    @Override
    public void markInitialState() {
        initialState = true;
    }

    @Override
    public boolean initialStateMarked() {
        return initialState;
    }

    @Override
    public void clearInitialState() {
        initialState = false;
    }
