/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.ListenersFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.render.Renderer;
import org.ajax4jsf.context.ContextInitParameters;
import org.richfaces.component.QueueRegistry;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js")})
@ListenersFor(value={@ListenerFor(systemEventClass=PostAddToViewEvent.class), @ListenerFor(systemEventClass=PreRemoveFromViewEvent.class)})
public abstract class QueueRendererBase
extends Renderer
implements ComponentSystemEventListener {
    protected static final String QUEUE_ID_ATTRIBBUTE = "queueId";
    protected static final String NAME_ATTRIBBUTE = "name";
    protected static final Logger LOGGER = RichfacesLogger.COMPONENTS.getLogger();

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!ContextInitParameters.isQueueEnabled((FacesContext)context)) {
            return;
        }
        UIComponent comp = event.getComponent();
        String queueName = this.getQueueName(context, comp);
        QueueRegistry queueRegistry = QueueRegistry.getInstance(context);
        if (event instanceof PostAddToViewEvent) {
            queueRegistry.addQueue(queueName, comp);
        } else if (event instanceof PreRemoveFromViewEvent) {
            queueRegistry.removeQueue(queueName);
        }
    }

    protected abstract String getQueueName(FacesContext var1, UIComponent var2);
}

