/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client;

import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.sonatype.aether.ant.com.ning.http.client.AsyncHttpProviderConfig;
import org.sonatype.aether.ant.com.ning.http.client.ConnectionsPool;
import org.sonatype.aether.ant.com.ning.http.client.ProxyServer;
import org.sonatype.aether.ant.com.ning.http.client.Realm;
import org.sonatype.aether.ant.com.ning.http.client.SSLEngineFactory;
import org.sonatype.aether.ant.com.ning.http.client.filter.IOExceptionFilter;
import org.sonatype.aether.ant.com.ning.http.client.filter.RequestFilter;
import org.sonatype.aether.ant.com.ning.http.client.filter.ResponseFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHttpClientConfig {
    private static final String ASYNC_CLIENT = AsyncHttpClientConfig.class.getName() + ".";
    private final int maxTotalConnections;
    private final int maxConnectionPerHost;
    private final int connectionTimeOutInMs;
    private final int idleConnectionInPoolTimeoutInMs;
    private final int requestTimeoutInMs;
    private final boolean redirectEnabled;
    private final int maxDefaultRedirects;
    private final boolean compressionEnabled;
    private final String userAgent;
    private final boolean allowPoolingConnection;
    private final ScheduledExecutorService reaper;
    private final ExecutorService applicationThreadPool;
    private final ProxyServer proxyServer;
    private final SSLContext sslContext;
    private final SSLEngineFactory sslEngineFactory;
    private final AsyncHttpProviderConfig<?, ?> providerConfig;
    private final ConnectionsPool<?, ?> connectionsPool;
    private final Realm realm;
    private final List<RequestFilter> requestFilters;
    private final List<ResponseFilter> responseFilters;
    private final List<IOExceptionFilter> ioExceptionFilters;
    private final int requestCompressionLevel;
    private final int maxRequestRetry;
    private final boolean allowSslConnectionPool;
    private final boolean useRawUrl;

    private AsyncHttpClientConfig(int maxTotalConnections, int maxConnectionPerHost, int connectionTimeOutInMs, int idleConnectionInPoolTimeoutInMs, int requestTimeoutInMs, boolean redirectEnabled, int maxDefaultRedirects, boolean compressionEnabled, String userAgent, boolean keepAlive, ScheduledExecutorService reaper, ExecutorService applicationThreadPool, ProxyServer proxyServer, SSLContext sslContext, SSLEngineFactory sslEngineFactory, AsyncHttpProviderConfig<?, ?> providerConfig, ConnectionsPool<?, ?> connectionsPool, Realm realm, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, List<IOExceptionFilter> ioExceptionFilters, int requestCompressionLevel, int maxRequestRetry, boolean allowSslConnectionCaching, boolean useRawUrl) {
        this.maxTotalConnections = maxTotalConnections;
        this.maxConnectionPerHost = maxConnectionPerHost;
        this.connectionTimeOutInMs = connectionTimeOutInMs;
        this.idleConnectionInPoolTimeoutInMs = idleConnectionInPoolTimeoutInMs;
        this.requestTimeoutInMs = requestTimeoutInMs;
        this.redirectEnabled = redirectEnabled;
        this.maxDefaultRedirects = maxDefaultRedirects;
        this.compressionEnabled = compressionEnabled;
        this.userAgent = userAgent;
        this.allowPoolingConnection = keepAlive;
        this.sslContext = sslContext;
        this.sslEngineFactory = sslEngineFactory;
        this.providerConfig = providerConfig;
        this.connectionsPool = connectionsPool;
        this.realm = realm;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.ioExceptionFilters = ioExceptionFilters;
        this.requestCompressionLevel = requestCompressionLevel;
        this.maxRequestRetry = maxRequestRetry;
        this.reaper = reaper;
        this.allowSslConnectionPool = allowSslConnectionCaching;
        this.applicationThreadPool = applicationThreadPool == null ? Executors.newCachedThreadPool() : applicationThreadPool;
        this.proxyServer = proxyServer;
        this.useRawUrl = useRawUrl;
    }

    public ScheduledExecutorService reaper() {
        return this.reaper;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int getMaxConnectionPerHost() {
        return this.maxConnectionPerHost;
    }

    public int getConnectionTimeoutInMs() {
        return this.connectionTimeOutInMs;
    }

    public int getIdleConnectionTimeoutInMs() {
        return this.idleConnectionInPoolTimeoutInMs;
    }

    public int getIdleConnectionInPoolTimeoutInMs() {
        return this.idleConnectionInPoolTimeoutInMs;
    }

    public int getRequestTimeoutInMs() {
        return this.requestTimeoutInMs;
    }

    public boolean isRedirectEnabled() {
        return this.redirectEnabled;
    }

    public int getMaxRedirects() {
        return this.maxDefaultRedirects;
    }

    public boolean getAllowPoolingConnection() {
        return this.allowPoolingConnection;
    }

    public boolean getKeepAlive() {
        return this.allowPoolingConnection;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public ExecutorService executorService() {
        return this.applicationThreadPool;
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public ConnectionsPool<?, ?> getConnectionsPool() {
        return this.connectionsPool;
    }

    public SSLEngineFactory getSSLEngineFactory() {
        if (this.sslEngineFactory == null) {
            return new SSLEngineFactory(){

                public SSLEngine newSSLEngine() {
                    if (AsyncHttpClientConfig.this.sslContext != null) {
                        SSLEngine sslEngine = AsyncHttpClientConfig.this.sslContext.createSSLEngine();
                        sslEngine.setUseClientMode(true);
                        return sslEngine;
                    }
                    return null;
                }
            };
        }
        return this.sslEngineFactory;
    }

    public AsyncHttpProviderConfig<?, ?> getAsyncHttpProviderConfig() {
        return this.providerConfig;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public List<RequestFilter> getRequestFilters() {
        return Collections.unmodifiableList(this.requestFilters);
    }

    public List<ResponseFilter> getResponseFilters() {
        return Collections.unmodifiableList(this.responseFilters);
    }

    public List<IOExceptionFilter> getIOExceptionFilters() {
        return Collections.unmodifiableList(this.ioExceptionFilters);
    }

    public int getRequestCompressionLevel() {
        return this.requestCompressionLevel;
    }

    public int getMaxRequestRetry() {
        return this.maxRequestRetry;
    }

    public boolean isSslConnectionPoolEnabled() {
        return this.allowSslConnectionPool;
    }

    public boolean isUseRawUrl() {
        return this.useRawUrl;
    }

    static /* synthetic */ String access$100() {
        return ASYNC_CLIENT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private int defaultMaxTotalConnections = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultMaxTotalConnections", -1);
        private int defaultMaxConnectionPerHost = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultMaxConnectionsPerHost", -1);
        private int defaultConnectionTimeOutInMs = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultConnectionTimeoutInMS", 60000);
        private int defaultIdleConnectionInPoolTimeoutInMs = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultIdleConnectionInPoolTimeoutInMS", 60000);
        private int defaultRequestTimeoutInMs = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultRequestTimeoutInMS", 60000);
        private boolean redirectEnabled = Boolean.getBoolean(AsyncHttpClientConfig.access$100() + "defaultRedirectsEnabled");
        private int maxDefaultRedirects = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultMaxRedirects", 5);
        private boolean compressionEnabled = Boolean.getBoolean(AsyncHttpClientConfig.access$100() + "compressionEnabled");
        private String userAgent = System.getProperty(AsyncHttpClientConfig.access$100() + "userAgent", "NING/1.0");
        private boolean allowPoolingConnection = true;
        private ScheduledExecutorService reaper = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "AsyncHttpClient-Reaper");
                t.setDaemon(true);
                return t;
            }
        });
        private ExecutorService applicationThreadPool = Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "AsyncHttpClient-Callback");
                t.setDaemon(true);
                return t;
            }
        });
        private ProxyServer proxyServer = null;
        private SSLContext sslContext;
        private SSLEngineFactory sslEngineFactory;
        private AsyncHttpProviderConfig<?, ?> providerConfig;
        private ConnectionsPool<?, ?> connectionsPool;
        private Realm realm;
        private int requestCompressionLevel = -1;
        private int maxRequestRetry = 5;
        private final List<RequestFilter> requestFilters = new LinkedList<RequestFilter>();
        private final List<ResponseFilter> responseFilters = new LinkedList<ResponseFilter>();
        private final List<IOExceptionFilter> ioExceptionFilters = new LinkedList<IOExceptionFilter>();
        private boolean allowSslConnectionPool = true;
        private boolean useRawUrl = false;

        public Builder() {
        }

        public Builder setMaximumConnectionsTotal(int defaultMaxTotalConnections) {
            this.defaultMaxTotalConnections = defaultMaxTotalConnections;
            return this;
        }

        public Builder setMaximumConnectionsPerHost(int defaultMaxConnectionPerHost) {
            this.defaultMaxConnectionPerHost = defaultMaxConnectionPerHost;
            return this;
        }

        public Builder setConnectionTimeoutInMs(int defaultConnectionTimeOutInMs) {
            this.defaultConnectionTimeOutInMs = defaultConnectionTimeOutInMs;
            return this;
        }

        public Builder setIdleConnectionTimeoutInMs(int defaultIdleConnectionTimeoutInMs) {
            this.defaultIdleConnectionInPoolTimeoutInMs = defaultIdleConnectionTimeoutInMs;
            return this;
        }

        public Builder setIdleConnectionInPoolTimeoutInMs(int defaultIdleConnectionInPoolTimeoutInMs) {
            this.defaultIdleConnectionInPoolTimeoutInMs = defaultIdleConnectionInPoolTimeoutInMs;
            return this;
        }

        public Builder setRequestTimeoutInMs(int defaultRequestTimeoutInMs) {
            this.defaultRequestTimeoutInMs = defaultRequestTimeoutInMs;
            return this;
        }

        public Builder setFollowRedirects(boolean redirectEnabled) {
            this.redirectEnabled = redirectEnabled;
            return this;
        }

        public Builder setMaximumNumberOfRedirects(int maxDefaultRedirects) {
            this.maxDefaultRedirects = maxDefaultRedirects;
            return this;
        }

        public Builder setCompressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder setAllowPoolingConnection(boolean allowPoolingConnection) {
            this.allowPoolingConnection = allowPoolingConnection;
            return this;
        }

        public Builder setKeepAlive(boolean allowPoolingConnection) {
            this.allowPoolingConnection = allowPoolingConnection;
            return this;
        }

        public Builder setScheduledExecutorService(ScheduledExecutorService reaper) {
            if (this.reaper != null) {
                this.reaper.shutdown();
            }
            this.reaper = reaper;
            return this;
        }

        public Builder setExecutorService(ExecutorService applicationThreadPool) {
            if (this.applicationThreadPool != null) {
                this.applicationThreadPool.shutdown();
            }
            this.applicationThreadPool = applicationThreadPool;
            return this;
        }

        public Builder setProxyServer(ProxyServer proxyServer) {
            this.proxyServer = proxyServer;
            return this;
        }

        public Builder setSSLEngineFactory(SSLEngineFactory sslEngineFactory) {
            this.sslEngineFactory = sslEngineFactory;
            return this;
        }

        public Builder setSSLContext(final SSLContext sslContext) {
            this.sslEngineFactory = new SSLEngineFactory(){

                public SSLEngine newSSLEngine() throws GeneralSecurityException {
                    SSLEngine sslEngine = sslContext.createSSLEngine();
                    sslEngine.setUseClientMode(true);
                    return sslEngine;
                }
            };
            this.sslContext = sslContext;
            return this;
        }

        public Builder setAsyncHttpClientProviderConfig(AsyncHttpProviderConfig<?, ?> providerConfig) {
            this.providerConfig = providerConfig;
            return this;
        }

        public Builder setConnectionsPool(ConnectionsPool<?, ?> connectionsPool) {
            this.connectionsPool = connectionsPool;
            return this;
        }

        public Builder setRealm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public Builder addRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.add(requestFilter);
            return this;
        }

        public Builder removeRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.remove(requestFilter);
            return this;
        }

        public Builder addResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.add(responseFilter);
            return this;
        }

        public Builder removeResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.remove(responseFilter);
            return this;
        }

        public Builder addIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.add(ioExceptionFilter);
            return this;
        }

        public Builder removeIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.remove(ioExceptionFilter);
            return this;
        }

        public int getRequestCompressionLevel() {
            return this.requestCompressionLevel;
        }

        public Builder setRequestCompressionLevel(int requestCompressionLevel) {
            this.requestCompressionLevel = requestCompressionLevel;
            return this;
        }

        public Builder setMaxRequestRetry(int maxRequestRetry) {
            this.maxRequestRetry = maxRequestRetry;
            return this;
        }

        public Builder setAllowSslConnectionPool(boolean allowSslConnectionPool) {
            this.allowSslConnectionPool = allowSslConnectionPool;
            return this;
        }

        public Builder setUseRawUrl(boolean useRawUrl) {
            this.useRawUrl = useRawUrl;
            return this;
        }

        public Builder(AsyncHttpClientConfig prototype) {
            this.allowPoolingConnection = prototype.getAllowPoolingConnection();
            this.providerConfig = prototype.getAsyncHttpProviderConfig();
            this.connectionsPool = prototype.getConnectionsPool();
            this.defaultConnectionTimeOutInMs = prototype.getConnectionTimeoutInMs();
            this.defaultIdleConnectionInPoolTimeoutInMs = prototype.getIdleConnectionInPoolTimeoutInMs();
            this.allowPoolingConnection = prototype.getKeepAlive();
            this.defaultMaxConnectionPerHost = prototype.getMaxConnectionPerHost();
            this.maxDefaultRedirects = prototype.getMaxRedirects();
            this.defaultMaxTotalConnections = prototype.getMaxTotalConnections();
            this.proxyServer = prototype.getProxyServer();
            this.realm = prototype.getRealm();
            this.defaultRequestTimeoutInMs = prototype.getRequestTimeoutInMs();
            this.sslContext = prototype.getSSLContext();
            this.sslEngineFactory = prototype.getSSLEngineFactory();
            this.userAgent = prototype.getUserAgent();
            this.requestFilters.clear();
            this.responseFilters.clear();
            this.requestFilters.addAll(prototype.getRequestFilters());
            this.responseFilters.addAll(prototype.getResponseFilters());
            this.useRawUrl = prototype.isUseRawUrl();
        }

        public AsyncHttpClientConfig build() {
            return new AsyncHttpClientConfig(this.defaultMaxTotalConnections, this.defaultMaxConnectionPerHost, this.defaultConnectionTimeOutInMs, this.defaultIdleConnectionInPoolTimeoutInMs, this.defaultRequestTimeoutInMs, this.redirectEnabled, this.maxDefaultRedirects, this.compressionEnabled, this.userAgent, this.allowPoolingConnection, this.reaper, this.applicationThreadPool, this.proxyServer, this.sslContext, this.sslEngineFactory, this.providerConfig, this.connectionsPool, this.realm, this.requestFilters, this.responseFilters, this.ioExceptionFilters, this.requestCompressionLevel, this.maxRequestRetry, this.allowSslConnectionPool, this.useRawUrl);
        }
    }
}

