/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.analysis;

import java.io.Serializable;
import java.util.Comparator;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.NodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CounterComparator
implements Comparator<ICounter>,
Serializable {
    private static final long serialVersionUID = -3777463066252746748L;
    public static final CounterComparator TOTALITEMS = new CounterComparator(){
        private static final long serialVersionUID = 8824120489765405662L;

        public int compare(ICounter c1, ICounter c2) {
            return c1.getTotalCount() - c2.getTotalCount();
        }
    };
    public static final CounterComparator COVEREDITEMS = new CounterComparator(){
        private static final long serialVersionUID = 1L;

        public int compare(ICounter c1, ICounter c2) {
            return c1.getCoveredCount() - c2.getCoveredCount();
        }
    };
    public static final CounterComparator MISSEDITEMS = new CounterComparator(){
        private static final long serialVersionUID = -2991039557556551206L;

        public int compare(ICounter c1, ICounter c2) {
            return c1.getMissedCount() - c2.getMissedCount();
        }
    };
    public static final CounterComparator COVEREDRATIO = new CounterComparator(){
        private static final long serialVersionUID = 7897690710299613918L;

        public int compare(ICounter c1, ICounter c2) {
            return Double.compare(c1.getCoveredRatio(), c2.getCoveredRatio());
        }
    };
    public static final CounterComparator MISSEDRATIO = new CounterComparator(){
        private static final long serialVersionUID = -5014193668057469357L;

        public int compare(ICounter c1, ICounter c2) {
            return Double.compare(c1.getMissedRatio(), c2.getMissedRatio());
        }
    };

    public CounterComparator reverse() {
        final CounterComparator original = this;
        return new CounterComparator(){
            private static final long serialVersionUID = 7703349549732801967L;

            public int compare(ICounter o1, ICounter o2) {
                return original.compare(o2, o1);
            }
        };
    }

    public NodeComparator on(ICoverageNode.CounterEntity entity) {
        return new NodeComparator(this, entity);
    }
}

