/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client.providers.netty;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sonatype.aether.ant.com.ning.http.client.AsyncHandler;
import org.sonatype.aether.ant.com.ning.http.client.AsyncHttpClientConfig;
import org.sonatype.aether.ant.com.ning.http.client.Request;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.NettyResponseFuture;
import org.sonatype.aether.ant.org.jboss.netty.buffer.ChannelBuffer;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelFuture;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelFutureListener;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.HttpRequest;
import org.sonatype.aether.ant.org.jboss.netty.handler.ssl.SslHandler;
import org.sonatype.aether.ant.org.slf4j.Logger;
import org.sonatype.aether.ant.org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NettyConnectListener<T>
implements ChannelFutureListener {
    private static final Logger logger = LoggerFactory.getLogger(NettyConnectListener.class);
    private final AsyncHttpClientConfig config;
    private final NettyResponseFuture<T> future;
    private final HttpRequest nettyRequest;
    private final AtomicBoolean handshakeDone = new AtomicBoolean(false);

    private NettyConnectListener(AsyncHttpClientConfig config, NettyResponseFuture<T> future, HttpRequest nettyRequest) {
        this.config = config;
        this.future = future;
        this.nettyRequest = nettyRequest;
    }

    public NettyResponseFuture<T> future() {
        return this.future;
    }

    @Override
    public final void operationComplete(ChannelFuture f) throws Exception {
        if (f.isSuccess()) {
            f.getChannel().getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(this.future);
            if (!this.handshakeDone.getAndSet(true) && f.getChannel().getPipeline().get("sslHandler") != null) {
                ((SslHandler)f.getChannel().getPipeline().get("sslHandler")).handshake().addListener(this);
                return;
            }
            this.future.provider().writeRequest(f.getChannel(), this.config, this.future, this.nettyRequest);
        } else {
            Throwable cause = f.getCause();
            logger.debug("Trying to recover a dead cached channel {} with a retry value of {} ", f.getChannel(), (Object)this.future.canRetry());
            if (this.future.canRetry() && cause != null && (NettyAsyncHttpProvider.abortOnDisconnectException(cause) || ClosedChannelException.class.isAssignableFrom(cause.getClass()) || this.future.getState() != NettyResponseFuture.STATE.NEW)) {
                logger.debug("Retrying {} ", this.nettyRequest);
                if (this.future.provider().remotelyClosed(f.getChannel(), this.future)) {
                    return;
                }
            }
            logger.debug("Failed to recover from exception: {} with channel {}", cause, (Object)f.getChannel());
            ConnectException e = new ConnectException(f.getCause() != null ? cause.getMessage() + " to " + this.future.getURI().toString() : this.future.getURI().toString());
            if (cause != null) {
                e.initCause(cause);
            }
            this.future.abort(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private final AsyncHttpClientConfig config;
        private final Request request;
        private final AsyncHandler<T> asyncHandler;
        private NettyResponseFuture<T> future;
        private final NettyAsyncHttpProvider provider;
        private final ChannelBuffer buffer;

        public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler, NettyAsyncHttpProvider provider, ChannelBuffer buffer) {
            this.config = config;
            this.request = request;
            this.asyncHandler = asyncHandler;
            this.future = null;
            this.provider = provider;
            this.buffer = buffer;
        }

        public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, NettyAsyncHttpProvider provider, ChannelBuffer buffer) {
            this.config = config;
            this.request = request;
            this.asyncHandler = asyncHandler;
            this.future = future;
            this.provider = provider;
            this.buffer = buffer;
        }

        public NettyConnectListener<T> build(URI uri) throws IOException {
            HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, this.request, uri, true, this.buffer);
            if (this.future == null) {
                this.future = NettyAsyncHttpProvider.newFuture(uri, this.request, this.asyncHandler, nettyRequest, this.config, this.provider);
            } else {
                this.future.setNettyRequest(nettyRequest);
                this.future.setRequest(this.request);
            }
            return new NettyConnectListener(this.config, this.future, nettyRequest);
        }
    }
}

