/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.codehaus.plexus.util.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.sonatype.aether.ant.org.codehaus.plexus.util.Os;
import org.sonatype.aether.ant.org.codehaus.plexus.util.StringUtils;
import org.sonatype.aether.ant.org.codehaus.plexus.util.cli.CommandLineException;
import org.sonatype.aether.ant.org.codehaus.plexus.util.cli.CommandLineTimeOutException;
import org.sonatype.aether.ant.org.codehaus.plexus.util.cli.Commandline;
import org.sonatype.aether.ant.org.codehaus.plexus.util.cli.StreamConsumer;
import org.sonatype.aether.ant.org.codehaus.plexus.util.cli.StreamFeeder;
import org.sonatype.aether.ant.org.codehaus.plexus.util.cli.StreamPumper;

public abstract class CommandLineUtils {
    private static Map processes = Collections.synchronizedMap(new HashMap());
    private static Thread shutdownHook = new Thread("CommandlineUtil shutdown"){

        public void run() {
            if (processes != null && processes.size() > 0) {
                System.err.println("Destroying " + processes.size() + " processes");
                Iterator it = processes.values().iterator();
                while (it.hasNext()) {
                    System.err.println("Destroying process..");
                    ((Process)it.next()).destroy();
                }
                System.err.println("Destroyed " + processes.size() + " processes");
            }
        }
    };

    public static void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static void removeShutdownHook(boolean execute) {
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
        if (execute) {
            shutdownHook.run();
        }
    }

    public static int executeCommandLine(Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr, 0);
    }

    public static int executeCommandLine(Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr, int timeoutInSeconds) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr, timeoutInSeconds);
    }

    public static int executeCommandLine(Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, systemIn, systemOut, systemErr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCommandLine(Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr, int timeoutInSeconds) throws CommandLineException {
        if (cl == null) {
            throw new IllegalArgumentException("cl cannot be null.");
        }
        Process p = cl.execute();
        processes.put(new Long(cl.getPid()), p);
        StreamFeeder inputFeeder = null;
        if (systemIn != null) {
            inputFeeder = new StreamFeeder(systemIn, p.getOutputStream());
        }
        StreamPumper outputPumper = new StreamPumper(p.getInputStream(), systemOut);
        StreamPumper errorPumper = new StreamPumper(p.getErrorStream(), systemErr);
        if (inputFeeder != null) {
            inputFeeder.start();
        }
        outputPumper.start();
        errorPumper.start();
        try {
            Thread thread;
            int returnValue;
            if (timeoutInSeconds <= 0) {
                returnValue = p.waitFor();
            } else {
                long now = System.currentTimeMillis();
                long timeoutInMillis = 1000L * (long)timeoutInSeconds;
                long finish = now + timeoutInMillis;
                while (CommandLineUtils.isAlive(p) && System.currentTimeMillis() < finish) {
                    Thread.sleep(10L);
                }
                if (CommandLineUtils.isAlive(p)) {
                    throw new InterruptedException("Process timeout out after " + timeoutInSeconds + " seconds");
                }
                returnValue = p.exitValue();
            }
            if (inputFeeder != null) {
                thread = inputFeeder;
                synchronized (thread) {
                    while (!inputFeeder.isDone()) {
                        inputFeeder.wait();
                    }
                }
            }
            thread = outputPumper;
            synchronized (thread) {
                while (!outputPumper.isDone()) {
                    outputPumper.wait();
                }
            }
            thread = errorPumper;
            synchronized (thread) {
                while (!errorPumper.isDone()) {
                    errorPumper.wait();
                }
            }
            processes.remove(new Long(cl.getPid()));
            if (outputPumper.getException() != null) {
                throw new CommandLineException("Error inside systemOut parser", outputPumper.getException());
            }
            if (errorPumper.getException() != null) {
                throw new CommandLineException("Error inside systemErr parser", errorPumper.getException());
            }
            int n = returnValue;
            return n;
        }
        catch (InterruptedException ex) {
            CommandLineUtils.killProcess(cl.getPid());
            throw new CommandLineTimeOutException("Error while executing external command, process killed.", ex);
        }
        finally {
            if (inputFeeder != null) {
                inputFeeder.close();
            }
            outputPumper.close();
            errorPumper.close();
            p.destroy();
            if (processes.get(new Long(cl.getPid())) != null) {
                processes.remove(new Long(cl.getPid()));
            }
        }
    }

    public static Properties getSystemEnvVars() throws IOException {
        return CommandLineUtils.getSystemEnvVars(!Os.isFamily("windows"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getSystemEnvVars(boolean caseSensitive) throws IOException {
        Method getenvMethod = CommandLineUtils.getEnvMethod();
        if (getenvMethod != null) {
            try {
                return CommandLineUtils.getEnvFromSystem(getenvMethod, caseSensitive);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new IOException(e.getMessage());
            }
        }
        Process p = null;
        try {
            String line;
            Properties envVars = new Properties();
            Runtime r = Runtime.getRuntime();
            boolean overriddenEncoding = false;
            if (Os.isFamily("windows")) {
                if (Os.isFamily("win9x")) {
                    p = r.exec("command.com /c set");
                } else {
                    overriddenEncoding = true;
                    p = r.exec("cmd.exe /U /c set");
                }
            } else {
                p = r.exec("env");
            }
            InputStreamReader reader = overriddenEncoding ? new InputStreamReader(p.getInputStream(), "UTF-16LE") : new InputStreamReader(p.getInputStream());
            BufferedReader br = new BufferedReader(reader);
            String lastKey = null;
            String lastVal = null;
            while ((line = br.readLine()) != null) {
                int idx = line.indexOf(61);
                if (idx > 0) {
                    lastKey = line.substring(0, idx);
                    if (!caseSensitive) {
                        lastKey = lastKey.toUpperCase(Locale.ENGLISH);
                    }
                    lastVal = line.substring(idx + 1);
                    envVars.setProperty(lastKey, lastVal);
                    continue;
                }
                if (lastKey == null) continue;
                lastVal = lastVal + "\n" + line;
                envVars.setProperty(lastKey, lastVal);
            }
            Properties properties = envVars;
            return properties;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    public static void killProcess(long pid) {
        Process p = (Process)processes.get(new Long(pid));
        if (p != null) {
            p.destroy();
            System.out.println("Process " + pid + " is killed.");
            processes.remove(new Long(pid));
        } else {
            System.out.println("don't exist.");
        }
    }

    public static boolean isAlive(long pid) {
        return processes.get(new Long(pid)) != null;
    }

    public static boolean isAlive(Process p) {
        if (p == null) {
            return false;
        }
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public static String[] translateCommandline(String toProcess) throws Exception {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        Vector<String> v = new Vector<String>();
        StringBuffer current = new StringBuffer();
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
                continue;
            }
            if ("\"".equals(nextTok)) {
                state = 2;
                continue;
            }
            if (" ".equals(nextTok)) {
                if (current.length() == 0) continue;
                v.addElement(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(nextTok);
        }
        if (current.length() != 0) {
            v.addElement(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new CommandLineException("unbalanced quotes in " + toProcess);
        }
        Object[] args = new String[v.size()];
        v.copyInto(args);
        return args;
    }

    public static String quote(String argument) throws CommandLineException {
        return CommandLineUtils.quote(argument, false, false, true);
    }

    public static String quote(String argument, boolean wrapExistingQuotes) throws CommandLineException {
        return CommandLineUtils.quote(argument, false, false, wrapExistingQuotes);
    }

    public static String quote(String argument, boolean escapeSingleQuotes, boolean escapeDoubleQuotes, boolean wrapExistingQuotes) throws CommandLineException {
        if (argument.indexOf("\"") > -1) {
            if (argument.indexOf("'") > -1) {
                throw new CommandLineException("Can't handle single and double quotes in same argument");
            }
            if (escapeSingleQuotes) {
                return "\\'" + argument + "\\'";
            }
            if (wrapExistingQuotes) {
                return '\'' + argument + '\'';
            }
        } else if (argument.indexOf("'") > -1) {
            if (escapeDoubleQuotes) {
                return "\\\"" + argument + "\\\"";
            }
            if (wrapExistingQuotes) {
                return '\"' + argument + '\"';
            }
        } else if (argument.indexOf(" ") > -1) {
            if (escapeDoubleQuotes) {
                return "\\\"" + argument + "\\\"";
            }
            return '\"' + argument + '\"';
        }
        return argument;
    }

    public static String toString(String[] line) {
        if (line == null || line.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < line.length; ++i) {
            if (i > 0) {
                result.append(' ');
            }
            try {
                result.append(StringUtils.quoteAndEscape(line[i], '\"'));
                continue;
            }
            catch (Exception e) {
                System.err.println("Error quoting argument: " + e.getMessage());
            }
        }
        return result.toString();
    }

    private static Method getEnvMethod() {
        try {
            return System.class.getMethod("getenv", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static Properties getEnvFromSystem(Method method, boolean caseSensitive) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Properties envVars = new Properties();
        Map envs = (Map)method.invoke(null, null);
        Iterator iterator = envs.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)envs.get(key);
            if (!caseSensitive) {
                key = key.toUpperCase(Locale.ENGLISH);
            }
            envVars.put(key, value);
        }
        return envVars;
    }

    static {
        shutdownHook.setContextClassLoader(null);
        CommandLineUtils.addShutdownHook();
    }

    public static class StringStreamConsumer
    implements StreamConsumer {
        private StringBuffer string = new StringBuffer();
        private String ls = System.getProperty("line.separator");

        public void consumeLine(String line) {
            this.string.append(line).append(this.ls);
        }

        public String getOutput() {
            return this.string.toString();
        }
    }
}

