/*
 * JBoss, Home of Professional Open Source
 * Copyright 2014, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.richfaces.JsfVersion.JSF_2_0;
import static org.richfaces.JsfVersion.JSF_2_1;
import static org.richfaces.JsfVersion.JSF_2_2;

import org.junit.Test;
import org.junit.Ignore;

public class TestJsfVersion {

    @Test
    public void testCompliancy() {
        assertTrue(JSF_2_2.isCompliantWith(JSF_2_2));
        assertTrue(JSF_2_2.isCompliantWith(JSF_2_1));
        assertTrue(JSF_2_2.isCompliantWith(JSF_2_0));

        assertFalse(JSF_2_1.isCompliantWith(JSF_2_2));
        assertTrue(JSF_2_1.isCompliantWith(JSF_2_1));
        assertTrue(JSF_2_1.isCompliantWith(JSF_2_0));

        assertFalse(JSF_2_0.isCompliantWith(JSF_2_2));
        assertFalse(JSF_2_0.isCompliantWith(JSF_2_1));
        assertTrue(JSF_2_0.isCompliantWith(JSF_2_0));
    }

    @Ignore
    @Test
    public void testCurrentVersion() {
        assertTrue(JsfVersion.getCurrent().isCompliantWith(JSF_2_2));
    }
}
