/**
 * Copyright 2016-2019 The OpenTracing Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package io.opentracing.contrib.spring.web.starter;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Configuration for tracing of HTTP clients.
 * Supports RestTemplate, AsyncRestTemplate, and WebClient beans.
 *
 * @author Michal Dvorak
 * @see RestTemplateTracingAutoConfiguration,
 * @see WebClientTracingAutoConfiguration
 * @since 4/5/18
 */
@ConfigurationProperties(WebClientTracingProperties.CONFIGURATION_PREFIX)
public class WebClientTracingProperties {

    public static final String CONFIGURATION_PREFIX = WebTracingProperties.CONFIGURATION_PREFIX + ".client";

    /**
     * When set to true (default), it enables automatic tracing of RestTemplate, AsyncRestTemplate, and WebClient beans,
     * as well as instances created using default RestTemplateBuilder and WebClient.Builder beans.
     * Does not affect instances created manually.
     */
    private boolean enabled = true;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}
