/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.BasicMultiPropertiesConfig;
import com.mchange.v2.cfg.CombinedMultiPropertiesConfig;
import com.mchange.v2.cfg.DelayedLogItem;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

final class ConfigUtils {
    private static final String[] DFLT_VM_RSRC_PATHFILES = new String[]{"/com/mchange/v2/cfg/vmConfigResourcePaths.txt", "/mchange-config-resource-paths.txt"};
    private static final String[] HARDCODED_DFLT_RSRC_PATHS = new String[]{"/mchange-commons.properties", "hocon:/reference,/application,/", "/"};
    static final String[] NO_PATHS = new String[0];
    static MultiPropertiesConfig vmConfig = null;

    static MultiPropertiesConfig read(String[] resourcePath, List delayedLogItems) {
        return new BasicMultiPropertiesConfig(resourcePath, delayedLogItems);
    }

    public static MultiPropertiesConfig read(String[] resourcePath) {
        return new BasicMultiPropertiesConfig(resourcePath);
    }

    public static MultiPropertiesConfig combine(MultiPropertiesConfig[] configs) {
        return new CombinedMultiPropertiesConfig(configs).toBasic();
    }

    public static MultiPropertiesConfig readVmConfig(String[] defaultResources, String[] preemptingResources) {
        return ConfigUtils.readVmConfig(defaultResources, preemptingResources, null);
    }

    static List vmCondensedPaths(String[] defaultResources, String[] preemptingResources, List delayedLogItemsOut) {
        return ConfigUtils.condensePaths(new String[][]{defaultResources, ConfigUtils.vmResourcePaths(delayedLogItemsOut), preemptingResources});
    }

    static String stringFromPathsList(List pathsList) {
        StringBuffer sb = new StringBuffer(2048);
        int len = pathsList.size();
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(pathsList.get(i));
        }
        return sb.toString();
    }

    public static MultiPropertiesConfig readVmConfig(String[] defaultResources, String[] preemptingResources, List delayedLogItemsOut) {
        defaultResources = defaultResources == null ? NO_PATHS : defaultResources;
        preemptingResources = preemptingResources == null ? NO_PATHS : preemptingResources;
        List pathsList = ConfigUtils.vmCondensedPaths(defaultResources, preemptingResources, delayedLogItemsOut);
        if (delayedLogItemsOut != null) {
            delayedLogItemsOut.add(new DelayedLogItem(DelayedLogItem.Level.FINER, "Reading VM config for path list " + ConfigUtils.stringFromPathsList(pathsList)));
        }
        return ConfigUtils.read(pathsList.toArray(new String[pathsList.size()]), delayedLogItemsOut);
    }

    private static List condensePaths(String[][] pathLists) {
        HashSet<String> pathSet = new HashSet<String>();
        ArrayList<String> reverseMe = new ArrayList<String>();
        int i = pathLists.length;
        while (--i >= 0) {
            int j = pathLists[i].length;
            while (--j >= 0) {
                String path = pathLists[i][j];
                if (pathSet.contains(path)) continue;
                pathSet.add(path);
                reverseMe.add(path);
            }
        }
        Collections.reverse(reverseMe);
        return reverseMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List readResourcePathsFromResourcePathsTextFile(String resourcePathsTextFileResourcePath, List delayedLogItemsOut) {
        ArrayList<String> rps = new ArrayList<String>();
        BufferedReader br = null;
        try {
            InputStream is = MultiPropertiesConfig.class.getResourceAsStream(resourcePathsTextFileResourcePath);
            if (is != null) {
                String rp;
                br = new BufferedReader(new InputStreamReader(is, "8859_1"));
                while ((rp = br.readLine()) != null) {
                    if ("".equals(rp = rp.trim()) || rp.startsWith("#")) continue;
                    rps.add(rp);
                }
                if (delayedLogItemsOut != null) {
                    delayedLogItemsOut.add(new DelayedLogItem(DelayedLogItem.Level.FINEST, String.format("Added paths from resource path text file at '%s'", resourcePathsTextFileResourcePath)));
                }
            } else if (delayedLogItemsOut != null) {
                delayedLogItemsOut.add(new DelayedLogItem(DelayedLogItem.Level.FINEST, String.format("Could not find resource path text file for path '%s'. Skipping.", resourcePathsTextFileResourcePath)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rps;
    }

    private static List readResourcePathsFromResourcePathsTextFiles(String[] resourcePathsTextFileResourcePaths, List delayedLogItemsOut) {
        ArrayList out = new ArrayList();
        int len = resourcePathsTextFileResourcePaths.length;
        for (int i = 0; i < len; ++i) {
            out.addAll(ConfigUtils.readResourcePathsFromResourcePathsTextFile(resourcePathsTextFileResourcePaths[i], delayedLogItemsOut));
        }
        return out;
    }

    private static String[] vmResourcePaths(List delayedLogItemsOut) {
        List paths = ConfigUtils.vmResourcePathList(delayedLogItemsOut);
        return paths.toArray(new String[paths.size()]);
    }

    private static List vmResourcePathList(List delayedLogItemsOut) {
        List<String> pathsFromFiles = ConfigUtils.readResourcePathsFromResourcePathsTextFiles(DFLT_VM_RSRC_PATHFILES, delayedLogItemsOut);
        List<String> rps = pathsFromFiles.size() > 0 ? pathsFromFiles : Arrays.asList(HARDCODED_DFLT_RSRC_PATHS);
        return rps;
    }

    public static synchronized MultiPropertiesConfig readVmConfig() {
        return ConfigUtils.readVmConfig(null);
    }

    public static synchronized MultiPropertiesConfig readVmConfig(List delayedLogItemsOut) {
        if (vmConfig == null) {
            List rps = ConfigUtils.vmResourcePathList(delayedLogItemsOut);
            vmConfig = new BasicMultiPropertiesConfig(rps.toArray(new String[rps.size()]));
        }
        return vmConfig;
    }

    public static synchronized boolean foundVmConfig() {
        return vmConfig != null;
    }

    public static void dumpByPrefix(MultiPropertiesConfig mpc, String pfx) {
        Properties props = mpc.getPropertiesByPrefix(pfx);
        TreeMap<Object, Object> m = new TreeMap<Object, Object>();
        m.putAll(props);
        for (Map.Entry entry : m.entrySet()) {
            System.err.println(entry.getKey() + " --> " + entry.getValue());
        }
    }

    private ConfigUtils() {
    }
}

