/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.v2.cfg.DelayedLogItem;
import com.mchange.v2.cfg.MConfig;
import com.mchange.v2.cfg.MLogConfigSource;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLogger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class MLogConfig {
    private static MultiPropertiesConfig CONFIG = null;
    private static List BOOTSTRAP_LOG_ITEMS = null;
    private static Method delayedDumpToLogger = null;

    public static synchronized void refresh(MultiPropertiesConfig[] overrides, String overridesDescription) {
        boolean firstLoad;
        String[] defaults = new String[]{"/com/mchange/v2/log/default-mchange-log.properties"};
        String[] preempts = new String[]{"/mchange-log.properties", "/"};
        ArrayList<DelayedLogItem> bli = new ArrayList<DelayedLogItem>();
        MultiPropertiesConfig tmpCONFIG = MLogConfigSource.readVmConfig(defaults, preempts, bli);
        boolean bl = firstLoad = CONFIG == null;
        if (overrides != null) {
            int olen = overrides.length;
            MultiPropertiesConfig[] combineMe = new MultiPropertiesConfig[olen + 1];
            combineMe[0] = tmpCONFIG;
            for (int i = 0; i < olen; ++i) {
                combineMe[i + 1] = overrides[i];
            }
            bli.add(new DelayedLogItem(DelayedLogItem.Level.INFO, (firstLoad ? "Loaded" : "Refreshed") + " MLog library log configuration, with overrides" + (overridesDescription == null ? "." : ": " + overridesDescription)));
            CONFIG = MConfig.combine(combineMe);
        } else {
            if (!firstLoad) {
                bli.add(new DelayedLogItem(DelayedLogItem.Level.INFO, "Refreshed MLog library log configuration, without overrides."));
            }
            CONFIG = tmpCONFIG;
        }
        BOOTSTRAP_LOG_ITEMS = bli;
    }

    private static void ensureLoad() {
        if (CONFIG == null) {
            MLogConfig.refresh(null, null);
        }
    }

    private static void ensureDelayedDumpToLogger() {
        try {
            if (delayedDumpToLogger == null) {
                Class<?> mConfigClass = Class.forName("com.mchange.v2.cfg.MConfig");
                Class<?> delayedLogItemClass = Class.forName("com.mchange.v2.cfg.DelayedLogItem");
                delayedDumpToLogger = mConfigClass.getMethod("dumpToLogger", delayedLogItemClass, MLogger.class);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static synchronized String getProperty(String key) {
        MLogConfig.ensureLoad();
        return CONFIG.getProperty(key);
    }

    public static synchronized void logDelayedItems(MLogger logger) {
        MLogConfig.ensureLoad();
        MLogConfig.ensureDelayedDumpToLogger();
        ArrayList items = new ArrayList();
        items.addAll(BOOTSTRAP_LOG_ITEMS);
        items.addAll(CONFIG.getDelayedLogItems());
        HashSet uniquerizer = new HashSet();
        uniquerizer.addAll(items);
        for (Object item : items) {
            if (!uniquerizer.contains(item)) continue;
            uniquerizer.remove(item);
            try {
                delayedDumpToLogger.invoke(null, item, logger);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Error(e);
            }
        }
    }

    public static synchronized String dump() {
        return CONFIG.toString();
    }

    private MLogConfig() {
    }
}

