#! /bin/bash
#	$Id: probemodem.sh.in,v 1.35 1996/06/24 02:59:37 sam Rel $
#
# Warning, this file was automatically created by the HylaFAX configure script
#
# HylaFAX Facsimile Software
#
# Copyright (c) 1993-1996 Sam Leffler
# Copyright (c) 1993-1996 Silicon Graphics, Inc.
# HylaFAX is a trademark of Silicon Graphics
# 
# Permission to use, copy, modify, distribute, and sell this software and 
# its documentation for any purpose is hereby granted without fee, provided
# that (i) the above copyright notices and this permission notice appear in
# all copies of the software and related documentation, and (ii) the names of
# Sam Leffler and Silicon Graphics may not be used in any advertising or
# publicity relating to the software without the specific, prior written
# permission of Sam Leffler and Silicon Graphics.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
#

#
# VERSION:	v4.0pl1
# DATE:		Fri Aug 15 16:03:03 MEST 1997
# TARGET:	i586-unknown-linux
#

#
# probemodem [tty]
#
# This script probes a modem attached to a serial line and
# reports the results of certain commands.
#
SPOOL=/var/spool/fax
SBIN=/usr/sbin

SPEED=
while [ x"$1" != x"" ] ; do
    case $1 in
    -os)    OS=$2; shift;;
    -s)	    SPEED=$2; shift;;
    -*)	    echo "Usage: $0 [-os OS] [-s SPEED] [ttyname]"; exit 1;;
    *)	    TTY=$1;;
    esac
    shift
done

#
# Run faxsetup to setup & verify the target machine if
# never done before.  We then source the output that has
# all the target-specific configuration information.
#
test -f $SPOOL/etc/setup.cache || {
    echo ""
    echo "Running faxsetup to setup your system for fax service.  This will"
    echo "only happen once; though you may also run faxsetup independently."
    echo ""

    $SBIN/faxsetup -server
}
. $SPOOL/etc/setup.cache	# common configuration stuff
. $SPOOL/etc/setup.modem	# modem-specific stuff

SH=$SCRIPT_SH			# shell for use below
OUT=/tmp/probemodem$$		# temp file in which modem output is recorded
SVR4UULCKN=$LIBEXEC/lockname	# SVR4 UUCP lock name construction program
ONDELAY=$LIBEXEC/ondelay	# prgm to open devices blocking on carrier
CAT="$CAT -u"			# something to do unbuffered reads and writes

while [ -z "$TTY" -o ! -c /dev/$TTY ]; do
    if [ "$TTY" != "" ]; then
	echo "/dev/$TTY is not a terminal device."
    fi
    prompt "Serial port that modem is connected to [$TTY]?"; read TTY
done

if [ ! -d $UUCP_LOCKDIR ]; then
    cat<<EOF

The UUCP lock file directory, $UUCP_LOCKDIR, does not appear
to exist or be a directory.  This must be corrected before you
can use this script to setup a modem for use.  Rerun the faxsetup
command to correct this problem.

EOF
    exit 1
fi

LOCKX=`ttyLocks $TTY`			# UUCP lock file names
DEVS=`ttyAliases $TTY`			# all TTY aliases
tdev=`ttyDev $TTY`			# TTY device to use for communication

#
# Check that device is not currently being used.
#
for x in $LOCKX; do
    if [ -f $x ]; then
	echo "Sorry, the device is currently in use by another program."
	exit 1
    fi
done

#
# Lock the device for later use when deducing the modem type.
#
JUNK="$LOCKX $OUT"
trap "rm -f $JUNK; exit 1" 0 1 2 15

LOCKSTR=`expr "         $$" : '.*\(..........\)'`
# lock the device by all of its names
for x in $LOCKX; do
    echo "$LOCKSTR" > $x
done
# zap any gettys or other users
fuser -k $DEVS >/dev/null 2>&1 || {
    cat<<EOF
Hmm, there does not appear to be an fuser command on your machine.
This means that I am unable to insure that all processes using the
modem have been killed.  I will keep going, but beware that you may
have competition for the modem.
EOF
}

cat<<EOF

Now we are going to probe the tty port.  This takes a few seconds,
so be patient.  Note that if you do not have the modem cabled to
the port, or the modem is turned off, this may hang (just go and
cable up the modem or turn it on, or whatever).
EOF

case $TARGET in
*-sunos*)
    #
    # Sun systems have a command for manipulating software
    # carrier on a terminal line.  Set or reset carrier
    # according to the type of tty device being used.
    #
    case $TTY in
    tty*) ttysoftcar -y $TTY >/dev/null 2>&1;;
    cua*) ttysoftcar -n $TTY >/dev/null 2>&1;;
    esac
esac

if [ -x ${ONDELAY} ]; then
    onDev() {
	if [ "$1" = "-c" ]; then
	    shift; catpid=`${ONDELAY} $tdev $SH -c "$* >$OUT" & echo $!`
	else
	    ${ONDELAY} $tdev $SH -c "$*"
	fi
    }
else
cat<<'EOF'

The "ondelay" program to open the device without blocking is not
present.  We're going to try to continue without it; let's hope that
the serial port won't block waiting for carrier...
EOF
    onDev() {
	if [ "$1" = "-c" ]; then
	    shift; catpid=`$SH <$tdev >$tdev -c "$* >$OUT" & echo $!`
	else
	    $SH <$tdev >$tdev -c "$*"
	fi
    }
fi

STTY=`ttyStty $tdev`				# appropriate stty cmd

#
# Send each command in SendString to the modem and collect
# the result in $OUT.  Read this very carefully.  It's got
# a lot of magic in it!
#
SendToModem()
{
    COMMAND=$*
    sleep 1					# wait for previous kill
    onDev $STTY 0; sleep 1			# reset the modem (hopefully)
						# start listening for output
    onDev -c "$STTY clocal && exec $CAT $tdev"; sleep 2
    #
    # NB: eof is set to ^A so that only 1 character is needed
    #     for a pending read on HPUX systems
    #
    onDev $STTY -echo -icrnl -ixon -ixoff -isig eof '"^A"' clocal $SPEED;
	sleep 1
    # NB: merging \r & ATQ0 causes some modems problems
    printf "\r" >$tdev; sleep 1;		# force consistent state
    printf "ATQ0V1E1\r" >$tdev; sleep 1;	# enable echo and result codes
    for i in $COMMAND; do
	printf "$i\r" >$tdev; sleep 1;
    done
    kill -9 $catpid; catpid=
    # NB: [*&\\\\$] must have the "$" last for AIX (yech)
    pat=`echo "$i"|$SED -e 's/[*&\\\\$]/\\\\&/g'` # escape regex metacharacters
    RESPONSE=`tr -ds '\015' '\012' < $OUT | \
	$SED -n "/$pat/{n;s/ *$//;p;q;}" | $SED 's/+F.*=//'`
}

echo ""
if [ -z "$SPEED" ]; then
    #
    # Probe for the highest speed at which the modem
    # responds to "AT" with "OK".
    #
    printf "Probing for best speed to talk to modem:"
    SPEEDS=`ttySpeeds $tdev`			# set of speeds for auto-bauding
    for SPEED in $SPEEDS
    do
	printf " $SPEED"
	SendToModem AT >/dev/null 2>&1
	sleep 1
	RESULT=`tr -ds '\015' '\012' < $OUT | tail -1`
	test "$RESULT" = OK && break;
    done
    if [ "$RESULT" != OK ]; then
	echo ""
	echo "Unable to deduce DTE-DCE speed; check that you are using the"
	echo "correct device and/or that your modem is setup properly.  If"
	echo "all else fails, try the -s option to lock the speed."
	exit 1
    fi
    echo " OK."
else
    echo "Using user-specified $SPEED to talk to modem."
fi
RESULT="";
while [ -z "$RESULT" ]; do
    #
    # This goes in the background while we try to
    # reset the modem.  If something goes wrong, it'll
    # nag the user to check on the problem.
    #
    (trap 0 1 2 15;
     while true; do
	sleep 10;
	echo ""
	echo "Hmm, something seems to be hung, check your modem eh?"
     done)& nagpid=$!
    trap "rm -f \$JUNK; kill $nagpid \$catpid; exit 1" 0 1 2 15

    SendToModem "AT+FCLASS=?" 			# ask for class support

    kill $nagpid
    trap "rm -f \$JUNK; test \"\$catpid\" && kill \$catpid; exit 1" 0 1 2 15
    sleep 1

    RESULT=`tr -ds '\015' '\012' < $OUT | tail -1`
    if [ -z "$RESPONSE" ]; then
	echo ""
	echo "There was no response from the modem.  Perhaps the modem is"
	echo "turned off or the cable between the modem and host is not"
	echo "connected.  Please check the modem and hit a carriage return"
	prompt "when you are ready to try again:"
	read x
    fi
done

Try()
{
    TRYCOMMAND=$*
    sleep 1					# wait for previous kill
    onDev $STTY 0				# reset the modem (hopefully)
    sleep 1
    onDev -c "$STTY clocal && exec $CAT $tdev"	# start listening for output
    sleep 1
    onDev $STTY -echo -icrnl -ixon -ixoff -isig eof '"^A"' clocal $SPEED
    sleep 1
    for i in $TRYCOMMAND; do
	printf "$i\r\r" >$tdev; sleep 1;
    done
    kill -9 $catpid; catpid=
    sleep 1
    # NB: [*&\\$] must have the "$" last for AIX (yech)
    pat=`echo "$i"|$SED -e 's/[*&\\$]/\\\\&/g'`	# escape regex metacharacters
    RESPONSE=`tr -ds '\015' '\012' < $OUT | $SED -n "/$pat/{n;s/ *$//;p;q;}"`
    RESULT=`tr -ds '\015' '\012' < $OUT | tail -1`

    printf "$*	RESULT = \"$RESULT\"	RESPONSE = \"$RESPONSE\"\n"
}

TryClass2dot0Commands()
{
    Try "AT+FCLASS=?";	Try "AT+FCLASS?"
    Try "AT+FCLASS=0";	Try "AT+FCLASS=1";	Try "AT+FCLASS=2.0"
    Try "AT+FCLASS?"

    Try "AT+FJU=?";	Try "AT+FJU?"

    Try "AT+FDR=?"
    Try "AT+FDT=?"
    Try "AT+FIP=?"

    Try "AT+FAA=?";	Try "AT+FAA?"
			Try "AT+FBS?"	# NB: +FBS is a read-only parameter
    Try "AT+FBO=?";	Try "AT+FBO?"
    Try "AT+FBU=?";	Try "AT+FBU?"
    Try "AT+FCC=?";	Try "AT+FCC?"
    Try "AT+FCQ=?";	Try "AT+FCQ?"
    Try "AT+FCR=?";	Try "AT+FCR?"
    Try "AT+FCS=?";	Try "AT+FCS?"
    Try "AT+FCT=?";	Try "AT+FCT?"
    Try "AT+FEA=?";	Try "AT+FEA?"
    Try "AT+FFC=?";	Try "AT+FFC?"
    Try "AT+FHS=?";	Try "AT+FHS?"
    Try "AT+FIE=?";	Try "AT+FIE?"
    Try "AT+FIS=?";	Try "AT+FIS?"
    Try "AT+FLI=?";	Try "AT+FLI?"
    Try "AT+FLO=?";	Try "AT+FLO?"
    Try "AT+FLP=?";	Try "AT+FLP?"
			Try "AT+FMI?"
			Try "AT+FMM?"
			Try "AT+FMR?"
    Try "AT+FMS=?";	Try "AT+FMS?"
    Try "AT+FNR=?";	Try "AT+FNR?"
    Try "AT+FNS=?";	Try "AT+FNS?"
    Try "AT+FPI=?";	Try "AT+FPI?"
    Try "AT+FPP=?";	Try "AT+FPP?"
    Try "AT+FPR=?";	Try "AT+FPR?"
    Try "AT+FPS=?";	Try "AT+FPS?"
    Try "AT+FRQ=?";	Try "AT+FRQ?"
    Try "AT+FRY=?";	Try "AT+FRY?"
    Try "AT+FSP=?";	Try "AT+FSP?"

    # NB: put this last since it resets to Class 0 on some modems
    Try "AT+FKS=?"
}

TryClass2Commands()
{
    Try "AT+FCLASS=?";	Try "AT+FCLASS?"
    Try "AT+FCLASS=0";	Try "AT+FCLASS=1";	Try "AT+FCLASS=2"
    Try "AT+FCLASS?"
    Try "AT+FJUNK=?";	Try "AT+FJUNK?"
    Try "AT+FAA=?";	Try "AT+FAA?"
    Try "AT+FAXERR=?";	Try "AT+FAXERR?"
    Try "AT+FBADLIN=?";	Try "AT+FBADLIN?"
    Try "AT+FBADMUL=?";	Try "AT+FBADMUL?"
    Try "AT+FBOR=?";	Try "AT+FBOR?"
    Try "AT+FBUF=?";	Try "AT+FBUF?"
    Try "AT+FBUG=?";	Try "AT+FBUG?"
    Try "AT+FCIG=?";	Try "AT+FCIG?"
    Try "AT+FCQ=?";	Try "AT+FCQ?"
    Try "AT+FCR=?";	Try "AT+FCR?"
    Try "AT+FTBC=?";	Try "AT+FTBC?"
    Try "AT+FDCC=?";	Try "AT+FDCC?"
    Try "AT+FDCS=?";	Try "AT+FDCS?"
    Try "AT+FDIS=?";	Try "AT+FDIS?"
    Try "AT+FDT=?";	Try "AT+FDT?"
    Try "AT+FECM=?";	Try "AT+FECM?"
    Try "AT+FET=?";	Try "AT+FET?"
    Try "AT+FLID=?";	Try "AT+FLID?"
    Try "AT+FLNFC=?";	Try "AT+FLNFC?"
    Try "AT+FLPL=?";	Try "AT+FLPL?"
    Try "AT+FMDL?";	Try "AT+FMFR?"
    Try "AT+FMINSP=?";	Try "AT+FMINSP?"
    Try "AT+FPHCTO=?";	Try "AT+FPHCTO?"
    Try "AT+FPTS=?";	Try "AT+FPTS?"
    Try "AT+FRBC=?";	Try "AT+FRBC?"
    Try "AT+FREL=?";	Try "AT+FREL?"
    Try "AT+FREV?";
    Try "AT+FSPL=?";	Try "AT+FSPL?"
    Try "AT+FTBC=?";	Try "AT+FTBC?"
    Try "AT+FVRFC=?";	Try "AT+FVRFC?"
    Try "AT+FWDFC=?";	Try "AT+FWDFC?"

    # NB: put this last since it resets to Class 0 on some modems
    Try "AT+FK=?"
}

TryClass1Commands()
{
    Try "AT+FCLASS=?";	Try "AT+FCLASS?"
    Try "AT+FCLASS=0";	Try "AT+FCLASS=1"
    Try "AT+FCLASS?"
    Try "AT+FJUNK=?";	Try "AT+FJUNK?"
    Try "AT+FAA=?";	Try "AT+FAA?"
    Try "AT+FAE=?";	Try "AT+FAE?"
    Try "AT+FTH=?"
    Try "AT+FRH=?"
    Try "AT+FTM=?"
    Try "AT+FRM=?"
    Try "AT+FTS=?"
    Try "AT+FRS=?"
}

TryCommonCommands()
{
    for i in 0 1 2 3; do
	Try "ATI$i"
    done
}

common()
{
    echo "This looks like a Class $1 modem."
    echo ""
    TryCommonCommands
}

class1()
{
    echo ""; echo "Class 1 stuff..."; echo ""
    TryClass1Commands
}

class2()
{
    echo ""; echo "Class 2 stuff..."; echo ""
    TryClass2Commands
}

class2dot0()
{
    echo ""; echo "Class 2.0 stuff..."; echo ""
    TryClass2dot0Commands
}

echo ""
if [ "$RESULT" = "OK" ]; then
    # Looks like a Class 1 or 2 modem, get more information
    case "`echo $RESPONSE | sed -e 's/[()]//g'`" in
    1)			common "1"; class1;;
    2)			common "2"; class2;;
    2.0)		common "2.0"; class2dot0;;
    0,1)		common "1"; class1;;
    0,2)		common "2"; class2;;
    0,2.0)		common "2.0"; class2dot0;;
    1,2)		common "1+2"; class1; class2;;
    1,2.0)		common "1+2.0"; class1; class2dot0;;
    2,2.0)		common "2+2.0"; class2; class2dot0;;
    0,1,2)		common "1+2"; class1; class2;;
    0,1,2.0)		common "1+2.0"; class1; class2dot0;;
    0,2,2.0)		common "2+2.0"; class2; class2dot0;;
    1,2,2.0)		common "1+2+2.0"; class1; class2; class2dot0;;
    0,1,2,2.0)		common "1+2+2.0"; class1; class2; class2dot0;;
    0,1,2,2.0,*)	common "1+2+2.0"; class1; class2; class2dot0;;
    1,2,2.0,*)		common "1+2+2.0"; class1; class2; class2dot0;;
    0,2,2.0,*)		common "2+2.0"; class2; class2dot0;;
    0,1,2.0,*)		common "1+2.0"; class1; class2dot0;;
    0,1,2,*)		common "1+2"; class1; class2;;
    2,2.0,*)		common "2+2.0"; class2; class2dot0;;
    1,2.0,*)		common "2+2.0"; class1; class2dot0;;
    1,2,*)		common "1+2"; class1; class2;;
    0,2.0,*)		common "2.0"; class2dot0;;
    0,2,*)		common "2"; class2;;
    0,1,*)		common "1"; class1;;
    2.0,*)		common "2.0"; class2dot0;;
    2,*)		common "2"; class2;;
    1,*)		common "1"; class1;;
    *)	echo "The result of the AT+FCLASS=? command was:"
	echo ""
	cat $OUT
	echo ""
	echo "I don't figure that it's worthwhile to continue..."
	exit
	;;
    esac
else
    echo "This not a Class 1, 2, or 2.0 modem,"
    exit
fi
