/*	$Id: d1SendApp.c++,v 1.43 1996/08/21 21:02:47 sam Rel $ */
/*
 * Copyright (c) 1994-1996 Sam Leffler
 * Copyright (c) 1994-1996 Silicon Graphics, Inc.
 * HylaFAX is a trademark of Silicon Graphics
 * d1SendApp.c++ by Roby Villwock 
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/file.h>
#include <signal.h>
#include <ctype.h>

#include "FaxMachineInfo.h"
#include "FaxAcctInfo.h"
#include "UUCPLock.h"
#include "d1SendApp.h"
#include "FaxRequest.h"
#include "Dispatcher.h"
#include "StackBuffer.h"
#include "Sys.h"
#include "ixo.h"

#include "config.h"

extern char *sys_errlist[];

static sms_typ SMS_STRUCTURE;

/*
 * Send messages with IXO/TAP protocol.
 */

#include "lms.h"

extern "C" int lms_create_msgq();
extern "C" int lms_request(int, char *, char *, char *);

static void t_error (char *txt)
{
}

static int fp_write_nr=0;
static FILE * fp_write_file= NULL;
static void write_log_protokoll(const char *s)
{

return;

fp_write_nr++;
if( fp_write_file == NULL)
{
fp_write_file= ::fopen("/tmp/d1.log","a+");
if(fp_write_file == NULL) return;
}

::fprintf(fp_write_file,"\n%d %s",fp_write_nr, s);
::fflush(fp_write_file);
}



d1SendApp* d1SendApp::_instance = NULL;

d1SendApp::d1SendApp(const fxStr& devName, const fxStr& devID)
    : ModemServer(devName, devID)
{
    ready = FALSE;
    modemLock = NULL;
    setupConfig();

    fxAssert(_instance == NULL, "Cannot create multiple d1SendApp instances");
    _instance = this;
}

d1SendApp::~d1SendApp()
{
    delete modemLock;
}

d1SendApp& d1SendApp::instance() { return *_instance; }

void
d1SendApp::initialize(int argc, char** argv)
{
    ModemServer::initialize(argc, argv);
    faxApp::initialize(argc, argv);

    // NB: must do last to override config file information
    for (GetoptIter iter(argc, argv, getOpts()); iter.notDone(); iter++)
	switch (iter.option()) {
	case 'l':			// do uucp locking
	    modemLock = getUUCPLock(getModemDevice());
	    break;
	case 'c':			// set configuration parameter
	    readConfigItem(iter.optArg());
	    break;
	}
}

void
d1SendApp::open()
{
    ModemServer::open();
    faxApp::open();
}

void
d1SendApp::close()
{
    if (isRunning()) {
	if (state == ModemServer::SENDING) {
	    /*
	     * Terminate the active job and let the send
	     * operation complete so that the transfer is
	     * logged and the appropriate exit status is
	     * returned to the caller.
	     */
	    ModemServer::abortSession();
	} else {
	    ModemServer::close();
	    faxApp::close();
	}
    }
}

FaxSendStatus
d1SendApp::send(const char* filename)
{
    int found_request;


	write_log_protokoll("send:");
	write_log_protokoll(filename);

    int fd = Sys::open(filename, O_RDWR);
    if (fd >= 0) {
	if (flock(fd, LOCK_EX) >= 0) {
	    FaxRequest* req = new FaxRequest(filename, fd);
	    fxBool reject;
	    if (req->readQFile(reject) && !reject) {
		found_request=req->findRequest(FaxRequest::send_page);

		if (found_request != fx_invalidArrayIndex) {
		    FaxMachineInfo info;


		    info.updateConfig(canonicalizePhoneNumber(req->number));
		    FaxAcctInfo ai;

		    ai.start = Sys::now();

		    sendPage(*req, info);

		    ai.jobid = req->jobid;
		    ai.jobtag = req->jobtag;
		    ai.user = req->mailaddr;
		    ai.duration = Sys::now() - ai.start;
		    ai.conntime = getConnectTime();
		    ai.commid = req->commid;
		    ai.device = getModemDeviceID();
		    ai.dest = req->external;
		    ai.csi = "";
		    ai.params = 0;
		    if (req->status == send_done)
			ai.status = "";
		    else
			ai.status = req->notice;
		    if (!ai.record("PAGE"))
			logError("Error writing %s accounting record, dest=%s",
			    "PAGE", (const char*) ai.dest);
		} else
		    sendFailed(*req, send_failed, "Job has no PIN to send to");
		    req->writeQFile(); 		// update on-disk copy
		return (req->status);		// return status for exit
	    } else
		delete req;
	    logError("Could not read request file");
	} else
	    logError("Could not lock request file: %m");
	Sys::close(fd);
    } else
	logError("Could not open request file: %m");
    return (send_failed);
}

void
d1SendApp::sendPage(FaxRequest& req, FaxMachineInfo& info)
{
    if (lockModem()) {
	beginSession(req.number);
	req.commid = getCommID();
	traceServer("SEND PAGE: JOB %s DEST %s COMMID %s"
	    , (const char*) req.jobid
	    , (const char*) req.external
	    , (const char*) req.commid
	);
	/*
	 * Setup tty parity; per-destination information takes
	 * precedence over command-line arguments/config params;
	 * otherwise the IXO/TAP spec is used (set below).
	 */
	if (info.getPagerTTYParity() != "")
	    pagerTTYParity = info.getPagerTTYParity();
	// NB: may need to set tty baud rate here XXX
	if (setupModem()) {
	    changeState(SENDING);
	    fxStr emsg;
	    setServerStatus("Sending page " | req.jobid);
	    /*
	     * Construct the phone number to dial by applying the
	     * dialing rules to the user-specified dialing string.
	     */
	    fxStr msg;
	    if (prepareMsg(req, info, msg))
		sendPage(req, info, prepareDialString(req.number), msg);
	    changeState(MODEMWAIT);		// ...sort of...
	} else
	    sendFailed(req, send_retry, "Can not setup modem", 4*pollModemWait);
	discardModem(TRUE);
	endSession();
	unlockModem();
    } else {
	sendFailed(req, send_retry, "Can not lock modem device",2*pollLockWait);
    }
}

fxBool
d1SendApp::prepareMsg(FaxRequest& req, FaxMachineInfo& info, fxStr& msg)
{
    u_int i = req.findRequest(FaxRequest::send_data);
    if (i == fx_invalidArrayIndex)		// page w/o text
	return (TRUE);
    int fd = Sys::open(req.requests[i].item, O_RDONLY);
    if (fd < 0) {
	sendFailed(req, send_failed,
	    "Internal error: unable to open text message file");
	return (FALSE);
    }
    struct stat sb;
    (void) Sys::fstat(fd, sb);
    msg.resize((u_int) sb.st_size);
    if (Sys::read(fd, &msg[0], (u_int) sb.st_size) != sb.st_size) {
	sendFailed(req, send_failed,
	    "Internal error: unable to read text message file");
	return (FALSE);
    }
    Sys::close(fd);

    u_int maxMsgLen = info.getPagerMaxMsgLength();
    if (maxMsgLen == (u_int) -1)		// not set, use default
	maxMsgLen = pagerMaxMsgLength;
    if (msg.length() > maxMsgLen) {
	traceServer("Pager message length %u too large; truncated to %u",
	    msg.length(), maxMsgLen);
	msg.resize(maxMsgLen);
    }

    msg.append('\n');
    return (TRUE);
}

void
d1SendApp::sendFailed(FaxRequest& req, FaxSendStatus stat, const char* notice, u_int tts)
{
    req.status = stat;
    req.notice = notice;
    /*
     * When requeued for the default interval (requeueOther),
     * don't adjust the time-to-send field so that the spooler
     * will set it according to the default algorithm that 
     * uses the command-line parameter and a random jitter.
     */
    if (tts != requeueOther)
	req.tts = Sys::now() + tts;
    traceServer("PAGE FAILED: %s", notice);
}

void
d1SendApp::sendPage(FaxRequest& req, FaxMachineInfo& info, const fxStr& number, const fxStr& msg)
{
int lms_status;


    connTime = 0;				// indicate no connection
    if (!getModem()->dataService()) {
	sendFailed(req, send_failed, "Unable to configure modem for data use");
	return;
    }
    req.notice = "";
    fxStr notice;
    time_t pageStart = Sys::now();


    if (pagerSetupCmds != "")
	{
	write_log_protokoll("pagerSetupCmds");
	(void) getModem()->atCmd(pagerSetupCmds);
	}


/* Original Stand */
/*
    CallStatus callstat = getModem()->dial(number, notice);
	write_log_protokoll(notice);
*/

/* +++ Neu +++ */
    strcpy(SMS_STRUCTURE.smsc, number);
    CallStatus callstat;
    callstat= ClassModem::OK;



lms_status= anforderung_channeld(SMS_STRUCTURE.smsc);

if(lms_status == 2)
	{
    write_log_protokoll("channeld: Anforderung wurde negativ quittiert");
    notice = "channeld: alle b kanaele sind besetzt";
    req.status = send_retry;
	}

/* +++ Ende Neu ++++ */


if(lms_status != 2)
    callstat = open_smsc(&SMS_STRUCTURE);

    if (lms_status != 2 && callstat != ClassModem::OK)
	{
    notice = "no connect smsc";
	}

    if (callstat == ClassModem::OK)
	connTime = Sys::now();			// connection start time
    (void) abortRequested();			// check for user abort
	
    if (callstat == ClassModem::OK && !abortCall) {
	req.ndials = 0;				// consec. failed dial attempts
	req.tottries++;				// total answered calls
	req.totdials++;				// total attempted calls
	info.setCalledBefore(TRUE);
	info.setDialFailures(0);

	req.status = send_ok;			// be optimistic



	    while (req.requests.length() > 0) {	// messages
		u_int i = req.findRequest(FaxRequest::send_page);
		if (i == fx_invalidArrayIndex)
		    break;
		if (req.requests[i].item.length() == 0) {
		    sendFailed(req, send_failed, "No PIN specified");
		    break;
		}

if(lms_status != 2)
{

        flushModemInput();

	strcpy(SMS_STRUCTURE.smsc, number);
	SMS_STRUCTURE.conn_mode=0;
	SMS_STRUCTURE.wait_note=0;
	SMS_STRUCTURE.save_time=0;
	strcpy(SMS_STRUCTURE.message,msg);
	SMS_STRUCTURE.orig[0]=0;
    	strcpy( SMS_STRUCTURE.dest, req.requests[i].item);
	SMS_STRUCTURE.messid[0]=0;
	SMS_STRUCTURE.send_lim=0;
	SMS_STRUCTURE.quer_lim=0;
	SMS_STRUCTURE.dele_lim=0;
	SMS_STRUCTURE.result=0;
	SMS_STRUCTURE.retry=0;
	SMS_STRUCTURE.cause=0;
	SMS_STRUCTURE.t_errno=0;
	SMS_STRUCTURE.errno=0;
	SMS_STRUCTURE.ec=0;
	SMS_STRUCTURE.duration=0;
	SMS_STRUCTURE.trn=0;
	SMS_STRUCTURE.more_to_send=0;
	SMS_STRUCTURE.ackflag=0;
	SMS_STRUCTURE.result_str[0]=0;
	SMS_STRUCTURE.sendezeit[0]=0;
	SMS_STRUCTURE.gebuehr=0;

	send_d1_message(&SMS_STRUCTURE);

	freigabe_channeld(SMS_STRUCTURE.smsc);

	req.gebuehr= SMS_STRUCTURE.gebuehr;
    if(SMS_STRUCTURE.result == 0)
    {
    write_log_protokoll("send_d1_message ist OK");
    req.status = send_ok;
    }
    else
    {
    req.status = send_failed;
    if(SMS_STRUCTURE.retry) req.status = send_retry;
    sendFailed(req, req.status, SMS_STRUCTURE.result_str);
    notice = SMS_STRUCTURE.result_str;


    if(req.status == send_failed) write_log_protokoll("send_failed");
    if(req.status == send_retry) write_log_protokoll("send_retry");
    if(req.status == send_ok) write_log_protokoll("send_ok");
    }

}


if(lms_status == 2)
{
if(req.tottries) req.tottries--;
if(req.totdials) req.totdials--;
callstat= ClassModem::BUSY;
notice = "channeld: alle b kanaele sind besetzt";
req.status = send_retry;
req.tts = time(0) + requeueProto;
break;
}





		    if (req.status == send_retry) {
			req.tts = time(0) + requeueProto;
			break;
		    }
		
		req.requests.remove(i);
		break;
	    }




	if (req.status == send_ok) {
	    time_t now = Sys::now();
	    traceServer("SEND PAGE: FROM " | req.mailaddr
		| " TO " | req.external | " (sent in %s)",
		fmtTime(now - pageStart));
	    info.setSendFailures(0);
	} else {

	    sendFailed(req, req.status, notice);
    	    write_log_protokoll("Es trat ein Fehler auf!");
    	    write_log_protokoll(req.notice);

	    info.setSendFailures(info.getSendFailures()+1);
	    info.setLastSendFailure(req.notice);


	}
    } else if (!abortCall) {
	sendFailed(req, send_failed, "Connect Error");
	
	/*
	 * Analyze the call status codes and selectively decide if the
	 * job should be retried.  We try to avoid the situations where
	 * we might be calling the wrong number so that we don't end up
	 * harrassing someone w/ repeated calls.
	 */
	req.ndials++;
	req.totdials++;			// total attempted calls
	switch (callstat) {
	case ClassModem::NOCARRIER:	// no carrier detected on remote side
	    /*
	     * Since some modems can not distinguish between ``No Carrier''
	     * and ``No Answer'' we offer this configurable hack whereby
	     * we'll retry the job <n> times in the face of ``No Carrier''
	     * dialing errors; if we've never previously reached a modem
	     * at that number.  This should not be used except if
	     * the modem is incapable of distinguishing between
	     * ``No Carrier'' and ``No Answer''.
	     */
	    if (!info.getCalledBefore() && req.ndials > noCarrierRetrys) {
		sendFailed(req, send_failed, notice);
		break;
	    }
	    /* fall thru... */
	case ClassModem::NODIALTONE:	// no local dialtone, possibly unplugged
	case ClassModem::ERROR:		// modem might just need to be reset
	case ClassModem::FAILURE:	// modem returned something unexpected
	case ClassModem::BUSY:		// busy signal
	case ClassModem::NOANSWER:	// no answer or ring back
	    sendFailed(req, send_retry, notice, requeueTTS[callstat]);
	    /* fall thru... */
	case ClassModem::OK:		// call was aborted by user
	    break;
	}
	if (callstat != ClassModem::OK) {
	    info.setDialFailures(info.getDialFailures()+1);
	    info.setLastDialFailure(req.notice);
	}
    }
    if (abortCall)
	sendFailed(req, send_failed, "Job aborted by user");
    else if (req.status == send_retry) {
	if (req.totdials == req.maxdials) {
	    notice = req.notice | "; too many attempts to dial";
    	    write_log_protokoll("send_failed (maxdials): too many attempts to dial");
	    sendFailed(req, send_failed, notice);
	} else if (req.tottries == req.maxtries) {
	    notice = req.notice | "; too many attempts to send";
    	    write_log_protokoll("send_failed (maxtries): too many attempts to send");
	    sendFailed(req, send_failed, notice);
	}
    }
    /*
     * Cleanup after the call.  If we have new information on
     * the client's remote capabilities, the machine info
     * database will be updated when the instance is destroyed.
     */
    getModem()->hangup();
    /*
     * This may not be exact--the line may already have been
     * dropped--but it should be close enough unless the modem
     * gets wedged and the hangup work times out.  Also be
     * sure to register a non-zero amount of connect time so
     * that folks doing accounting can adjust charge-back costs
     * to reflect any minimum connect time tarrifs imposted by
     * their PTT (e.g. calls < 1 minute are rounded up to 1 min.)
     */
    if (connTime) {
	connTime = Sys::now() - connTime;
	if (connTime == 0)
	    connTime++;
    }
}

u_int
d1SendApp::getResponse(fxStackBuffer& buf, long secs)
{
    return (0);
}

/*
 * Scan through a buffer looking for a potential
 * code byte return in a protocol response.
 * This is needed because some pager services such
 * as PageNet intersperse protocol messages and
 * verbose text messages.
 */
static fxBool
scanForCode(const u_char*& cp, u_int& len)
{
    return (TRUE);
}

fxBool
d1SendApp::pagePrologue(FaxRequest& req, const FaxMachineInfo& info, fxStr& emsg)
{
     return (TRUE);
}

fxBool
d1SendApp::pageGoAhead(FaxRequest& req, const FaxMachineInfo&, fxStr& emsg)
{
     return (TRUE);
}

/*
 * Calculate packet checksum and append to buffer.
 */
static void
addChecksum(fxStackBuffer& buf)
{
}

fxBool
d1SendApp::sendPagerMsg(FaxRequest& req, faxRequest& preq, const fxStr& msg, fxStr& emsg)
{
	return (TRUE);
}

fxBool
d1SendApp::pageEpilogue(FaxRequest& req, const FaxMachineInfo&, fxStr& emsg)
{
    return (TRUE);
}

void
d1SendApp::traceResponse(const fxStackBuffer& buf)
{
}

void
d1SendApp::traceIXOCom(const char* dir, const u_char* data, u_int cc)
{
    if (log) {
	if ((logTracingLevel& FAXTRACE_IXO) == 0)
	    return;
    } else if ((tracingLevel & FAXTRACE_IXO) == 0)
	return;

    fxStackBuffer buf;
    for (u_int i = 0; i < cc; i++) {
	u_char b = data[i];
	if (!isprint(b)) {
	    const char* octdigits = "01234567";
	    char s[4];
	    s[0] = '\\';
	    s[1] = octdigits[b>>6];
	    s[2] = octdigits[(b>>3)&07];
	    s[3] = octdigits[b&07];
	    buf.put(s, 4);
	} else
	    buf.put(b);
    }
    traceStatus(FAXTRACE_IXO, "%s <%u:%.*s>",
	dir, cc, buf.getLength(), (const char*) buf);
}

void
d1SendApp::traceIXO(const char* fmt ...)
{
    va_list ap;
    va_start(ap, fmt);
    vtraceStatus(FAXTRACE_PROTOCOL, fmt, ap);
    va_end(ap);
}

fxBool
d1SendApp::putModem(const void* data, int n, long ms)
{
    traceIXOCom("<--",  (const u_char*) data, n);
    return (putModem1(data, n, ms));
}

time_t d1SendApp::getConnectTime() const	{ return (connTime); }

/*
 * Configuration support.
 */

void
d1SendApp::resetConfig()
{
    ModemServer::resetConfig();
    setupConfig();
}

#define	N(a)	(sizeof (a) / sizeof (a[0]))

const d1SendApp::stringtag d1SendApp::strings[] = {
{ "ixoservice",		&d1SendApp::ixoService,	IXO_SERVICE },
{ "ixodeviceid",	&d1SendApp::ixoDeviceID,	IXO_DEVICEID },
{ "pagerttyparity",	&d1SendApp::pagerTTYParity,	"even" },
};
const d1SendApp::stringtag d1SendApp::atcmds[] = {
{ "pagersetupcmds",	&d1SendApp::pagerSetupCmds },
};
const d1SendApp::numbertag d1SendApp::numbers[] = {
{ "pagermaxmsglength",	&d1SendApp::pagerMaxMsgLength,128 },
{ "ixomaxunknown",	&d1SendApp::ixoMaxUnknown,	IXO_MAXUNKNOWN },
{ "ixoidprobe",		&d1SendApp::ixoIDProbe,	IXO_IDPROBE },
{ "ixoidtimeout",	&d1SendApp::ixoIDTimeout,	IXO_IDTIMEOUT },
{ "ixologinretries",	&d1SendApp::ixoLoginRetries,	IXO_LOGINRETRIES },
{ "ixologintimeout",	&d1SendApp::ixoLoginTimeout,	IXO_LOGINTIMEOUT },
{ "ixogatimeout",	&d1SendApp::ixoGATimeout,	IXO_GATIMEOUT },
{ "ixoxmitretries",	&d1SendApp::ixoXmitRetries,	IXO_XMITRETRIES },
{ "ixoxmittimeout",	&d1SendApp::ixoXmitTimeout,	IXO_XMITTIMEOUT },
{ "ixoacktimeout",	&d1SendApp::ixoAckTimeout,	IXO_ACKTIMEOUT },
};

void
d1SendApp::setupConfig()
{
    int i;
    for (i = N(strings)-1; i >= 0; i--)
	(*this).*strings[i].p = (strings[i].def ? strings[i].def : "");
    for (i = N(atcmds)-1; i >= 0; i--)
	(*this).*atcmds[i].p = (atcmds[i].def ? atcmds[i].def : "");
    for (i = N(numbers)-1; i >= 0; i--)
	(*this).*numbers[i].p = numbers[i].def;
}

fxBool
d1SendApp::setConfigItem(const char* tag, const char* value)
{
    u_int ix;
    if (findTag(tag, (const tags*)atcmds, N(atcmds), ix)) {
	(*this).*atcmds[ix].p = parseATCmd(value);
    } else if (findTag(tag, (const tags*) strings, N(strings), ix)) {
	(*this).*strings[ix].p = value;
    } else if (findTag(tag, (const tags*)numbers, N(numbers), ix)) {
	(*this).*numbers[ix].p = getNumber(value);
    } else
	return (ModemServer::setConfigItem(tag, value));
    return (TRUE);
}
#undef	N

u_int
d1SendApp::getConfigParity(const char* value) const
{
char tbuf[400];

	write_log_protokoll("d1SendApp::getConfigParity:");
	write_log_protokoll(value);

    if (streq(value, "even"))
	return (EVEN);
    else if (streq(value, "odd"))
	return (ODD);
    else if (streq(value, "none"))
	return (NONE);
    else {
	sprintf(tbuf,"Unknown pager tty parity %s ignored; using EVEN", value);
	logError(tbuf);
	return (EVEN);				// per IXO/TAP spec
    }
}

/*
 * Modem and TTY setup
 */
fxBool 
d1SendApp::setupModem()
{
    return (ModemServer::setupModem() &&
	setParity((Parity) getConfigParity(pagerTTYParity)));
}

/*
 * Modem locking support.
 */

fxBool
d1SendApp::lockModem()
{
    return (modemLock ? modemLock->lock() : TRUE);
}

void
d1SendApp::unlockModem()
{
    if (modemLock)
	modemLock->unlock();
}

/*
 * Notification handlers.
 */

/*
 * Handle notification that the modem device has become
 * available again after a period of being unavailable.
 */
void
d1SendApp::notifyModemReady()
{
    ready = TRUE;
}

/*
 * Handle notification that the modem device looks to
 * be in a state that requires operator intervention.
 */
void
d1SendApp::notifyModemWedged()
{
    if (!sendModemStatus(getModemDeviceID(), "W"))
	logError("MODEM %s appears to be wedged",
	    (const char*) getModemDevice());
    close();
}

/*
 * Miscellaneous stuff.
 */

static void
usage(const char* appName)
{
    faxApp::fatal("usage: %s -m deviceID [-t tracelevel] [-l] qfile ...",
	appName);
}

static void
sigCleanup(int s)
{
    signal(s, fxSIGHANDLER(sigCleanup));
    logError("CAUGHT SIGNAL %d", s);
    d1SendApp::instance().close();
    if (!d1SendApp::instance().isRunning())
	_exit(send_failed);
}

int
main(int argc, char** argv)
{
write_log_protokoll("d1send Programm gestartet");

    faxApp::setupLogging("D1Send");

    fxStr appName = argv[0];
    u_int l = appName.length();
    appName = appName.tokenR(l, '/');

    faxApp::setOpts("c:m:l");

    fxStr devID;
    for (GetoptIter iter(argc, argv, faxApp::getOpts()); iter.notDone(); iter++)
	switch (iter.option()) {
	case 'm': devID = iter.optArg(); break;
	case '?': usage(appName);
	}
    if (devID == "")
	usage(appName);

    d1SendApp* app = new d1SendApp(faxApp::idToDev(devID), devID);

    signal(SIGTERM, fxSIGHANDLER(sigCleanup));
    signal(SIGINT, fxSIGHANDLER(sigCleanup));

    app->initialize(argc, argv);
    app->open();
    while (app->isRunning() && !app->isReady())
	Dispatcher::instance().dispatch();
    FaxSendStatus status;
    if (app->isReady())
	status = app->send(argv[optind]);
    else
	status = send_retry;
    app->close();
    return (status);
}



#define MODEMSERVICE  "smsc_a_d1"
#define ISDNSERVICE   "smsc_d_d1"

#define MAXMSGLEN     4000
#define MAXRETRY      3        /* also max 3 sende versuche */
#define MAXMSG        4        /* max anzahl kurzmitt. je session */
#define MAXCR         8        /* max anzahl CR, bevor aufgelegt wird */

#define A_START          0
#define A_SEND_REQ       1
#define A_SEND_ACK       2
#define A_RCV_ANSW       3
#define A_END            4
#define A_SEND_ALERT     5
#define A_SEND_CR        6
#define A_SEND_ID        7
#define A_RCV_ID         8
#define A_RCV_LOGINRES   9
#define A_SEND_QUERY    10
#define A_PAR_QUERY     11

#define TOUT_CR       1
#define TOUT_ACK      10
#define TOUT_ID       2
#define TOUT_NOTE     17
#define TOUT_TOTAL    60
#define TOUT_CONNECT  40

#define SMSC_MODEM1        "01712092522"
#define SMSC_MODEM2        "0911663070"
#define SMSC_MODEM3        "0911663071"
#define SMSC_ISDN1         ""
#define SMSC_ISDN2         ""
#define SMSC_ISDN3         ""

/*--------------------------------------------------------------------*/

#ifdef TEST_MAIN
static int    debug = 1;
#else
static int    debug = 0;
#endif

static int    prev_action;
static int    connect_timeout=0;
static time_t starttime;
static time_t querystart;


/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
int d1SendApp::send_d1_message(sms_typ *sms)
{
 int  fd,res,action,rcv_timeout=10;
 char buf[MAXMSGLEN];
 char *p1;
 int  cr_sent=0;
 int  parquerycnt = 0;
 time_t t=time(0);

write_log_protokoll("Aufruf SEND_D1_MESSAGE");

 sms->result  = -5;
 sms->retry   = 0;
 sms->t_errno = 0;
 sms->errno   = 0;
 sms->cause   = 0;
 sms->duration= 0;
 sms->ec      = 0;   /* error code vom smsc, nur bei d2 */
 sms->gebuehr = 0;
 sms->trn     = 0;
 sms->result_str[0] = 0;
 sms->sendezeit[0]  = 0;

 starttime    = time(0);
 prev_action  = A_START;
 action       = A_SEND_CR;
 while (1)
 {
    if ((time(0) - starttime) > TOUT_TOTAL)
       action = A_END;

    switch (action)
    {
       case A_SEND_CR:
          cr_sent++;
          if (send_cr(sms))
             action = A_END;
          else
             action = A_RCV_ID;

          prev_action = A_SEND_CR;
          break;

       case A_RCV_ID:
          res = rcv_packet(buf,"ID=",sms,TOUT_CR);
          if (res == 0)
             action = A_SEND_ID;

          if (res < 0)
             action = A_END;    /* fehler beim lesen */

          if (res > 0)
          {  /* timeout */
             if (cr_sent >= MAXCR)
             {
                sms->result = -6;
                sms->retry = 1;   /* vielleicht klappt es beim n{chsten mal */
                p1 = strchr (buf,'\r');
                if (p1) *p1=0;
                sprintf (sms->result_str,"200 Kein Login-Prompt vom D1-SMS-Center erhalten. %s%s",
                         *buf?"Meldung: ":"",buf);
                action = A_END;
             }
             else
             {
                action = A_SEND_CR;
             }
          }
          prev_action = A_RCV_ID;
          break;

       case A_SEND_ID:
          if (send_id(sms))
             action = A_END;
          else
             action = A_RCV_LOGINRES;
          prev_action = A_SEND_ID;
          break;

       case A_RCV_LOGINRES:
          res = rcv_packet(buf,"\033[p\r",sms,8);
          if (res == 0)
          {
             if (debug)
                fprintf (stderr, "Login erfolgreich\n");
             action = A_PAR_QUERY;
          }

          if (res <  0)
             action = A_END;    /* fehler beim lesen oder ende der conn*/

          if (res > 0)          /* timeout */
             action = A_SEND_ID;
          prev_action = A_RCV_LOGINRES;
          break;

       case A_PAR_QUERY:
          parquerycnt++;
          rcv_timeout = 3;
          if (parameter_query(sms))
             action = A_END;
          else
             action = A_RCV_ANSW;
          prev_action = A_PAR_QUERY;
          break;

       case A_SEND_REQ:
          sms->trn++;
          if (sms->trn > MAXRETRY)
          {
             sms->result = -5;
             sms->retry  = 1;
             if (!(sms->result_str[0]))
                sprintf (sms->result_str,"201 Keine positive Antwort vom D1-SMS-Center.");
             return (A_END);
          }

          rcv_timeout = 10;
          if (send_transfer_req(sms))
             action = A_END;
          else
             action = A_RCV_ANSW;
          prev_action = A_SEND_REQ;
          break;

       case A_RCV_ANSW:
          res = rcv_answer(buf,sms,rcv_timeout);
          if (res < 0) /* fehler beim lesen oder conn-ende*/
             action = A_END;

          if (res > 0) /* timeout */
          {
             if (prev_action == A_PAR_QUERY)
             {
               if (parquerycnt >= MAXRETRY)
               {
                  sms->result = -5;
                  sms->retry = 1;
                  sprintf (sms->result_str,"202 Ermittlung der Systemparamter des D1-SMS-Centers fehlgeschlagen.");
                  action = A_END;
               }
               else
                  action = A_PAR_QUERY;
             }
          }
          else
          {  /* ab hier liegt ein paket vor */
             action = check_answer(buf,sms);
          }
          prev_action = A_RCV_ANSW;
          break;

       case A_SEND_QUERY:
          if ((time(0) - querystart) > TOUT_NOTE)
          {
             action = A_END;
          }
          else
          {
             if (send_query(sms))
                action = A_END;
             else
                action = A_RCV_ANSW;
          }
          prev_action = A_SEND_QUERY;
          break;

       default:

          sms->result = -5;
          sms->retry  = 1;
          sprintf (sms->result_str,"203 Interner Ablauffehler.");
          action = A_END;
          break;
    }

    if (action == A_END)
       break;
 }

 close_smsc(sms);
 sms->duration = time(0) - t;
 return (0);
}

/*--------------------------------------------------------------------*/
int d1SendApp::send_cr(sms_typ *sms)
{

if(putModem("\r", 1) != TRUE)
{

    if (debug)
       t_error ("send_cr() ");

    sprintf (sms->result_str,"204 Fehler beim Senden zum D1-SMS-Center. (CR)");
    sms->result = -2;
    sms->t_errno = -1;
    return (-1);
 }

 if (debug)
    fprintf (stderr,"<CR> gesendet\n");
 return (0);
}

/*--------------------------------------------------------------------*/
int d1SendApp::anforderung_channeld(char *nr)
{

if(lms_create_msgq()) return(1);


write_log_protokoll("\nDer Channeld wurde kontaktiert!");

if(lms_request(MSG_ANFORDERUNG, LMS_SMS_SERVICE, nr, "..."))
{
write_log_protokoll("\nAnforderung wurde negativ quittiert!");
return(2);
}



return(0);
}
/*--------------------------------------------------------------------*/
void d1SendApp::freigabe_channeld(char *nr)
{
lms_request(MSG_FREIGABE, LMS_SMS_SERVICE, nr, "...");
}
/*--------------------------------------------------------------------*/
CallStatus d1SendApp::open_smsc(sms_typ *sms)
{
char nebenstelle[200];
char dialog_format[200];
char dialog_text[200];
int rc;
char buf[1024];

strcpy(dialog_format,ModemServer::dialCmd);
sprintf(dialog_text,dialog_format,sms->smsc);
strcat(dialog_text,"\r");


write_log_protokoll("dialog_text-->");
write_log_protokoll(dialog_text);
if(putModem("at&F\r", 5) != TRUE)
{
	write_log_protokoll("Ausgabe at&f fehlerhaft");
}

rc=rcv_packet(buf,"OK",sms, 10);

if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}


if(putModem("at&x1\r", 6) != TRUE)
{
	write_log_protokoll("Ausgabe at&x1 fehlerhaft");
}

rc=rcv_packet(buf,"OK",sms, 10);

if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}



if(putModem("atS13.5=1\r", 10) != TRUE)
{
	write_log_protokoll("Ausgabe atS13.5=1 fehlerhaft");
}

rc=rcv_packet(buf,"OK",sms, 10);
if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}


strcpy(nebenstelle,"at&e");
ModemServer::getNebenstelle(&nebenstelle[4]);
strcat(nebenstelle,"\r");

if(putModem(nebenstelle, strlen(nebenstelle)) != TRUE)
{
	write_log_protokoll("Ausgabe at&e... fehlerhaft");
}

rc=rcv_packet(buf,"OK",sms, 10);
if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}




if(putModem(dialog_text, strlen(dialog_text)) != TRUE)
{
	write_log_protokoll("Ausgabe atd fehlerhaft");
}


/* rc=rcv_packet(buf,"CONNECT",sms,TOUT_CR);  */
rc=rcv_packet(buf,"CONNECT",sms, 10);

if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}

return(ClassModem::OK);

}
/*--------------------------------------------------------------------*/
int d1SendApp::rcv_string_packet(char *packet, char pattern ,sms_typ *sms, 
	int timeout, int maxlen)
{
 fxBool wasTimeout;
 int fehler_code;
 int c;
 int            flags,rec,rcode,event,offset;
 char           buf [MAXMSGLEN];
 char           buf1[MAXMSGLEN];
 char           *p,*p1;
 
*packet = 0;

 while (1)
 {
	c = isdn_getModemChar(timeout * 1000, fehler_code, wasTimeout);

	if(wasTimeout)
	{
	write_log_protokoll("rcv_packet: timeout");

     /* normaler Timeout */
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
             sprintf (sms->result_str,"321 Keine Antwort vom SMS empfangen.");
             sms->result  = -5;
             sms->retry   = 1;
             sms->errno   = -1;
	return(1);
	}

	if(fehler_code)
	{
	switch(fehler_code)		{
	case EAGAIN:
	case EINTR:
			continue;
	default:
	write_log_protokoll("rcv_packet: error");
             sprintf (sms->result_str,"322 Kommunikationsfehler (Read): %s", sys_errlist[fehler_code]);
             sms->result  = -5;
             sms->retry   = 1;
             sms->errno   = fehler_code;
	     return (-1);
					}
	}

    if(c == pattern) return(0);

    if(c == EOF)
    { /* normaler Timeout */
	write_log_protokoll("rcv_packet: timeout");
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
       return (1);
    }
	rec=1;
	buf[0]=c;

    /* jetzt ist mal wieder ein Zeichen da */

    
    if (rec > 0)
    {
       buf[rec] = 0;
       /* jetzt mu xon xoff raus */
       for (p=buf,p1=buf1,*p1=0;*p;p++)
       {
          if ((*p != 17) && (*p != 19))
          {
             *p1 = *p;
             p1++;
             *p1 = 0;
          }
       }
       strcat (packet,buf1);
	if(strlen(packet) >= maxlen) return(0);

	write_log_protokoll("rcv_packet: ");
	write_log_protokoll(packet);

	if(strcmp(packet,"NO ANSWER") == 0)
	{
	return(-3);
	}

	if(strcmp(packet,"BUSY") == 0)
	{
	return(-2);
	}

       continue;
    }
 }
}
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
int d1SendApp::rcv_packet(char *packet, char *pattern,sms_typ *sms, int timeout)
{
 fxBool wasTimeout;
 int fehler_code;
 int c;
 int            flags,rec,rcode,event,offset;
 char           buf [MAXMSGLEN];
 char           buf1[MAXMSGLEN];
 char           *p,*p1;
 
*packet = 0;

 while (1)
 {
	c = isdn_getModemChar(timeout * 1000, fehler_code, wasTimeout);

	if(wasTimeout)
	{
	write_log_protokoll("rcv_packet: timeout");

     /* normaler Timeout */
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
	return(1);
	}

	if(fehler_code)
	{
	switch(fehler_code)		{
	case EAGAIN:
	case EINTR:
			continue;
	default:
	write_log_protokoll("rcv_packet: error");
             sprintf (sms->result_str,"205 Kommunikationsfehler beim Lesen: %s",
                      sys_errlist[fehler_code]);
             sms->result  = -5;
             sms->retry   = 1;
             sms->errno   = fehler_code;
	     return (-1);
					}
	}

    if(c == EOF)
    { /* normaler Timeout */
	write_log_protokoll("rcv_packet: timeout");
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
       return (1);
    }
	rec=1;
	buf[0]=c;

    /* jetzt ist mal wieder ein Zeichen da */

    
    if (rec > 0)
    {
       buf[rec] = 0;
       /* jetzt mu xon xoff raus */
       for (p=buf,p1=buf1,*p1=0;*p;p++)
       {
          if ((*p != 17) && (*p != 19))
          {
             *p1 = *p;
             p1++;
             *p1 = 0;
          }
       }
       strcat (packet,buf1);

	write_log_protokoll("rcv_packet: ");
	write_log_protokoll(packet);

	if(strcmp(packet,"NO ANSWER") == 0)
	{
	return(-3);
	}

	if(strcmp(packet,"BUSY") == 0)
	{
	return(-2);
	}

       if (*pattern)
       {
          offset = strlen(packet) - strlen(pattern);
          if (offset >= 0)
          {
             if (!strcmp(&packet[offset],pattern))
             {
                if (debug)
                {
                   strcpy (buf,packet);
                   for (p=buf;*p;p++)
                      if (*p=='\r')
                         *p='!';
                   fprintf (stderr,"\nEmpfangen %s\n",buf);
                }
                return (0);
             }
          }
       }
       continue;
    }
 }
}
/*--------------------------------------------------------------------*/
int d1SendApp::close_smsc(sms_typ *sms)
{
int rc;
char buf[80];

  isdn_sleep(2);
  putModem("+++", 3);
  isdn_sleep(3);

 putModem("\004\r",2); /* EOT */
 /* sms->gebuehr = isi_getcharge(fd); */
 sms->gebuehr = 0;


  putModem("ath\r", 4);
  rc=rcv_packet(buf,"OK",sms, 10);

if(rc) return(0);

  putModem("ati3\r", 5);
  rc=rcv_packet(buf,"Linux ISDN\r\n",sms, 4);
  if(rc) return(0);

  /* maximal 20 Zeichen einlesen (bis CR) */ 
  rc=rcv_string_packet(buf,'\r', sms, 1, 4);
  if(rc) return(0);

 
 sscanf(buf, "%d",&sms->gebuehr);

 {
 char tbuf[40];

 sprintf(tbuf,"Gebuehr: %d",sms->gebuehr);
 write_log_protokoll(tbuf);

 }

 return (0);
}
/*--------------------------------------------------------------------*/
int d1SendApp::send_id(sms_typ *sms)
{
 char buf[20];

 *buf=0x1b;
 sprintf(&buf[1],"PG1\r");

if(putModem(buf, strlen(buf)) != TRUE)
 {
    if (debug)
       t_error ("send_id() ");

    sprintf (sms->result_str,"206 Fehler beim Senden zum D1-SMS-Center. (PG1)");
    sms->result = -2;
    sms->retry  = 1;
    sms->t_errno = -1;
    return (-1);
 }
 if (debug)
    fprintf (stderr,"gesendet : %s\n",buf);
 return (0);
}
/*--------------------------------------------------------------------*/
int d1SendApp::parameter_query(sms_typ *sms)
{
 int  res;
 char buf[MAXMSGLEN];
 char buf2[MAXMSGLEN];
 char *p;

 sprintf (buf,"\002%s\r%s\r\003",sms->dest,")#*&(P");
 sprintf (buf2,"%s%s\r",buf,checksum(buf));

if(putModem(buf2, strlen(buf2)) != TRUE)
 {
    if (debug)
       t_error ("parameter_query() ");

    sprintf (sms->result_str,"207 Fehler beim Senden zum D1-SMS-Center. (Destination)");
    sms->result = -2;
    sms->retry  = 1;
    sms->t_errno = -1;
    return (-1);
 }
 if (debug)
 {
    strcpy (buf,buf2);
    for (p=buf;*p;p++)
       if (*p=='\r')
          *p='!';
    fprintf (stderr,"Parameter-Query gesendet: %s",buf);
 }
 return (0);
}
/*--------------------------------------------------------------------*/
int d1SendApp::send_transfer_req(sms_typ *sms)
{
 int  res;
 char buf[MAXMSGLEN];
 char buf2[MAXMSGLEN];
 char *p;
 static int packs,actpack,firsttime=1;
 static int offset[MAXMSG],len[MAXMSG];
 char tmpdest[40];

 if (firsttime)
 {
    if (sms->dest[0] == '0')
    {
       strcpy (tmpdest,"49");
       strcat (tmpdest,&(sms->dest[1]));
       strcpy (sms->dest,tmpdest);
    }

    packs = get_offsets(sms->message,offset,len);
    actpack   = 0;
    firsttime = 0;
    sms->ackflag = 0;
 }

 if (sms->ackflag)
 {
    actpack++;
    sms->trn = 0;
 }

 strncpy (buf2,&(sms->message[offset[actpack]]),len[actpack]);
 buf2[len[actpack]] = 0;
 sprintf (buf,"\002%s\r%s%s\r\003",sms->dest,buf2,")#*&(C");
 sprintf (buf2,"%s%s\r",buf,checksum(buf));

if(putModem(buf2, strlen(buf2)) != TRUE)
 {
    if (debug)
       t_error ("t_snd() ");
    sprintf (sms->result_str,"208 Fehler beim Senden zum D1-SMS-Center. (Uebermittlung der Nachricht)");
    sms->result = -2;
    sms->t_errno = -1;
    return (-1);
 }
 if (debug)
 {
    strcpy (buf,buf2);
    for (p=buf;*p;p++)
       if (*p=='\r')
          *p='!';
    fprintf (stderr,"gesendet %s\n",buf);
 }

 if (packs > (actpack + 1))
    sms->more_to_send = 1;
 else
    sms->more_to_send = 0;
 return (0);
}
/*--------------------------------------------------------------------*/
int d1SendApp::get_offsets (char *mess, int  *off, int  *len)
{
 int   i,pnr;
 char *ptr;

 off[0] = 0;
 mess[MAXMSG*160] = 0;
 for (pnr=0;pnr<MAXMSG;pnr++)
 {
    ptr = &mess[off[pnr]];
    len[pnr] = strlen(ptr);
    if (len[pnr] <= 160)
    {
       if (pnr<(MAXMSG-1))
          len[pnr+1] = 0;
       return (pnr+1);
    }

    /* jetzt von 160 rckwrts nach dem ersten leerzeichen suchen */
    for (i=159;i>145;i--)
    {
       if ((ptr[i] == ' ') || (ptr[i] == '\n'))
       {
          i++; /* i1 ist jetzt der offset des 2. packs */
          if (pnr < (MAXMSG - 1))
             off[pnr+1] = off[pnr] + i;
          len[pnr]   = i - 1;
          break;
       }
    }

    if (i==145)
    {
       if (pnr < (MAXMSG-1))
          off[pnr+1] = off[pnr] + 160;
       len[pnr] = 160;
    }
 }

 return (pnr);
}

/*--------------------------------------------------------------------*/
int d1SendApp::send_query(sms_typ *sms)
{
 int  res;
 char buf[MAXMSGLEN];
 char buf2[MAXMSGLEN];
 char *p;

 sprintf (buf,"\002%s\r%s%s\r\003",sms->dest,")#*&(Q",sms->messid);
 sprintf (buf2,"%s%s\r",buf,checksum(buf));

if(putModem(buf2, strlen(buf2)) != TRUE)
 {
    if (debug)
       t_error ("t_snd() ");

    sprintf (sms->result_str,"209 Fehler beim Senden zum D1-SMS-Center. (ebermittlung der Message ID)");
    sms->result = -2;
    sms->t_errno = -1;
    return (-1);
 }

 if (debug)
 {
    strcpy (buf,buf2);
    for (p=buf;*p;p++)
       if (*p=='\r')
          *p='!';
    fprintf (stderr,"Status-Query gesendet: %s\n",buf);
 }
 return (0);
}
/*--------------------------------------------------------------------*/
int d1SendApp::rcv_answer(char *packet, sms_typ *sms, int timeout)

{
 fxBool wasTimeout;
 int fehler_code;
 int c;
 int         flags,rec,rcode,event;
 char        buf [MAXMSGLEN];
 char        buf1[MAXMSGLEN];
 char        *p,*p1;

 *packet = 0;

 while (1)
 {

	c = isdn_getModemChar(timeout * 1000, fehler_code, wasTimeout);


	if(wasTimeout)
	{
     /* normaler Timeout */
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
	return(1);
	}

	if(fehler_code)
	{
	switch(fehler_code)		{
	case EAGAIN:
	case EINTR:
			continue;
	default:
             sprintf (sms->result_str,"205 Kommunikationsfehler beim Lesen: %s",
                      sys_errlist[fehler_code]);
             sms->result  = -5;
             sms->retry   = 1;
             sms->errno   = fehler_code;
	     return (-1);
					}
	}



	buf[0]=c; 
	rec=1;
    
    if (c == EOF)
    {
                sprintf (sms->result_str,"210 Verbindung unerwartet vom D1-SMS-Center abgebaut.");
                sms->retry   = 1;
                sms->result  = -6;
                return (-1);

    }

    if (rec > 0)
    {
       buf[rec] = 0;
       /* jetzt mu xon xoff raus */
       for (p=buf,p1=buf1,*p1=0;*p;p++)
       {
          if ((*p != 17) && (*p != 19))
          {
             *p1 = *p;
             p1++;
             *p1 = 0;
          }
       }
       strcat (packet,buf1);
       /* jetzt erst mal schauen ob das Packet komplett ist */
       if (isinstr (packet,"\r\006\r") ||  /* ACK */
           isinstr (packet,"\004\r")   ||  /* EOT */
           isinstr (packet,"\r\017\r") ||  /* NAK */
           isinstr (packet,"\r\036\r"))    /* RS */
       {
          if (debug)
          {
             strcpy (buf,packet);
             for (p=buf;*p;p++)
                if (*p=='\r')
                   *p='!';
             fprintf (stderr,"\nEmpfangen %s\n",buf);
          }
          return (0);
       }
       continue;
    }
 }
}
/*--------------------------------------------------------------------*/
int d1SendApp::check_answer(char *buf, sms_typ *sms)
{
 char        *p1,*p2;
 static int   firstmessid = 1;

 sms->ackflag = 0;

 if (prev_action == A_PAR_QUERY)
 {
    sms->send_lim = 0;
    sms->quer_lim = 0;
    sms->dele_lim = 0;

    if (isinstr (buf,"\r\006\r"))
    {
       p2 = buf;
       p1 = strchr(p2,',');
       if (p1)
       {
          *p1 = 0;
          sms->send_lim = atoi(p2);
          if (debug)
             fprintf(stderr,"Sendlimit = %d\n",sms->send_lim);
          p2 = p1+1;
       }
       else
          return (A_SEND_REQ);

       p1 = strchr(p2,',');
       if (p1)
       {
          *p1 = 0;
          sms->quer_lim = atoi(p2);
          if (debug)
             fprintf(stderr,"Querylimit = %d\n",sms->quer_lim);
          p2 = p1+1;
       }
       else
          return (A_SEND_REQ);
       /* hier mu ich nach , oder CR suchen, da nicht 3 sondern mgl. 4
          parameter gesendet werden */
       p1 = strchr(p2,',');
       if (!p1)
          p1 = strchr(p2,'\r');

       if (p1)
       {
          *p1 = 0;
          sms->dele_lim = atoi(p2);
          if (debug)
             fprintf(stderr,"Deletelimit = %d\n",sms->dele_lim);
       }
    }
    return (A_SEND_REQ);
 }

 if (prev_action == A_SEND_REQ)
 {
    if (isinstr(buf,"Operation failed"))
    {
       sms->result = -5;
       sms->retry  = 1;
       p1 = strchr (buf,'\r');
       if (p1) *p1=0;
       sprintf (sms->result_str,"211 Meldung: %-70s",
                buf);
       return (A_SEND_REQ);
    }

    if (isinstr(buf,"confirm failed"))
    {
       if (isinstr(buf,"subscriber not allowed to receive messages"))
       {
          sms->result = -5;
          sms->retry  = 0;
          sprintf (sms->result_str,"212 Teilnehmer hat keine Berechtigung zum Empfang von Kurzmitteilungen.");
          return (A_END);
       }
       if (isinstr(buf,"subscriber not on database"))
       {
          sms->result = -5;
          sms->retry  = 0;
          sprintf (sms->result_str,"213 Teilnehmer ist nicht in der Datenbank des D1-SMS-Centers.");
          return (A_END);
       }
       if (isinstr(buf,"no message text provided"))
       {
          sms->result = -5;
          sms->retry  = 0;
          sprintf (sms->result_str,"214 Kein Mitteilungstext uebergeben.");
          return (A_END);
       }

       if (isinstr(buf,"system problem"))
       {
          sms->result = -5;
          sms->retry  = 1;
          sprintf (sms->result_str,"215 System-Problem im D1-SMS-Center.");
          return (A_END);
       }
       else
       {
          sms->result = -5;
          sms->retry  = 0;
          p1 = strchr (buf,'\r');
          if (p1) *p1=0;
          sprintf (sms->result_str,"211 Meldung: %-70s",
                   buf);
          return (A_END);
       }
    }

    if (isinstr (buf,"successful"))
    {
       sms->ackflag = 1;
       if (sms->wait_note)
       {
          if (firstmessid)
          {  /* damit beim langen Messages nur die Besttigung fr den ersten
                teil berprft wird */
             firstmessid = 0;
             p1=strpos(buf,"Message");
             if (p1)
             {
                strncpy (sms->messid,&p1[8],15);
                sms->messid[15]=0;
                p1 = strchr(sms->messid,' ');
             }
             if (p1)
                *p1 = 0;
             else
             {
                sprintf (sms->result_str,"216 Fehler beim Bestimmen der Message-ID.");
                sms->result = 0;
                sms->retry  = 0;
                return (A_END);
             }
          }
       }
       if (sms->more_to_send)
          return (A_SEND_REQ);

       if (prev_action == A_SEND_REQ)
          querystart = time(0);

       if (isinstr (buf,"message has been delivered"))
       {
          sms->result = 1;
          sms->retry  = 0;
          sprintf (sms->result_str,"217 Kurzmitteilung erfolgreich an das D1-Handy ausgeliefert.");
          return (A_END);
       }
       else
       {
          sprintf (sms->result_str,"218 Die Auslieferung an das D1-Handy wurde nicht bestaetigt.");
          sms->result = 0;
          sms->retry  = 0;

          if (sms->wait_note)
          {
             if (isinstr (buf,"limit reached"))
                return (A_END);

             if (sms->quer_lim)
                isdn_sleep(8); /* jetzt lieber langsamer fragen */
             else
                isdn_sleep(1);

             return (A_SEND_QUERY);
          }
          else
             return (A_END);
       }
    }

    sms->result = -5;
    sms->retry  = 1;
    p1 = strchr (buf,'\r');
    if (p1) *p1=0;
    sprintf (sms->result_str,"211 Meldung: %-70s",
             buf);
    return (A_END);
 }

 if (prev_action == A_SEND_QUERY)
 {
    if (isinstr (buf,"successful"))
    {
       sms->ackflag = 1;

       if (sms->more_to_send)
          return (A_SEND_REQ);

       if (prev_action == A_SEND_REQ)
          querystart = time(0);

       if (isinstr (buf,"message has been delivered"))
       {
          sms->result = 1;
          sms->retry  = 0;
          sprintf (sms->result_str,"217 Kurzmitteilung erfolgreich an das D1-Handy ausgeliefert.");
          return (A_END);
       }
       else
       {
          sprintf (sms->result_str,"218 Die Auslieferung an das D1-Handy wurde nicht bestaetigt.");
          sms->result = 0;
          sms->retry  = 0;

          if (sms->wait_note)
          {
             if (isinstr (buf,"limit reached"))
                return (A_END);

             if (sms->quer_lim)
                isdn_sleep(8); /* jetzt lieber langsamer fragen */
             else
                isdn_sleep(1);

             return (A_SEND_QUERY);
          }
          else
             return (A_END);
       }
    }

    if (isinstr(buf,"query failed"))
    {
       if (isinstr(buf,"message not available") ||
           isinstr(buf,"subscriber id mismatch"))
       {
          sms->result = -3;
          sms->retry  = 0;
          sprintf (sms->result_str,"219 Das D1-SMS-Center konnte die Kurzmitteilung nicht ausliefern.");
       }
       else
       {
          sms->result = -3;
          sms->retry  = 0;
          sprintf (sms->result_str,"211 Meldung: %s",buf);
       }
    }
    return (A_END);
 }

 if (isinstr (buf,"\004\r")) /* EOT */
 {
    sms->result = -5;
    sms->retry  = 1;
    p1 = strchr (buf,'\r');
    if (p1) *p1=0;
    sprintf (sms->result_str,"211 Meldung: %-70s",
             buf);
    return (A_END);
 }

 if (isinstr (buf,"\r\017\r")) /* NAK */
 {
    if ((prev_action == A_SEND_REQ) || (prev_action == A_SEND_QUERY))
    {
       sms->result = -5;
       sms->retry  = 0;
       p1 = strchr (buf,'\r');
       if (p1) *p1=0;
       sprintf (sms->result_str,"211 Meldung: %-70s",
                buf);
       return (prev_action);
    }
 }

 sms->result = -5;
 sms->retry  = 0;
 p1 = strchr (buf,'\r');
 if (p1) *p1=0;
 sprintf (sms->result_str,"211 Meldung: %-70s",
          buf);
 return (A_END);
}

/*--------------------------------------------------------------------*/
char *d1SendApp::checksum(char *buf)
{
 int         sum=0;
 char        *p;
 static char chksum[4];

 for (p=buf;*p != 0;p++)
    sum += (*p & 0x7f);

 sum &= 0xfff;
 sprintf (chksum,"%c%c%c",(((sum & 0xf00)>>8)+ 0x30),
                          (((sum & 0xf0) >>4)+ 0x30),
                          (((sum & 0xf)  >>0)+ 0x30));
 return (chksum);
}

/*--------------------------------------------------------------------*/
int d1SendApp::isinstr(char *s1, char *s2)
{
 int len1,len2,i;

 if ((!s1) || !(s2))
    return (0);

 len1=strlen(s1),
 len2=strlen(s2);
 if (len1 < len2)
    return(0);
 for (i=0;i<=len1-len2;i++)
 {
    if (!strncmp(&s1[i],s2,len2))
       return (1);
 }

 return (0);
}

/*--------------------------------------------------------------------*/
/* Sucht nach 'muster' in 'str' und gibt Pointer auf Anfang zurueck
*/
char *d1SendApp::strpos( char *str, char *muster)
{
char *hilf;
uint lenmuster = strlen (muster);

   do {
        hilf = strchr(str,*muster);
        if (hilf != (char *) NULL)
        {
           if (strlen (hilf) < lenmuster)  break;       /* BS */
           if (strncmp(hilf,muster, lenmuster) == 0)
              return(hilf);
           else str = ++hilf;
        }
   }
   while(hilf != (char *) NULL );
   return ((char *) NULL);
}

/*-----------------------------------------------------------------------------
** isdn_sleep()
**-----------------------------------------------------------------------------
** Interner Sleep-Befehl. Wenn die Shellvariable Debug gesetzt ist
** wird eine debuggergerechte aber rechenintensive Funktion benutzt
**
** Uebergabe:   int   sec     Sekunden
**
** Return   :   Keiner
*/


void d1SendApp::isdn_sleep(int sec)
{
      sleep(sec);
}
/*--------------------------------------------------------------------*/


