/*	$Id: d2SendApp.c++,v 1.43 1996/08/21 21:02:47 sam Rel $ */
/*
 * Copyright (c) 1994-1996 Sam Leffler
 * Copyright (c) 1994-1996 Silicon Graphics, Inc.
 * HylaFAX is a trademark of Silicon Graphics
 * d2SendApp.c++ by Roby Villwock 
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/file.h>
#include <signal.h>
#include <ctype.h>

#include "FaxMachineInfo.h"
#include "FaxAcctInfo.h"
#include "UUCPLock.h"
#include "d2SendApp.h"
#include "FaxRequest.h"
#include "Dispatcher.h"
#include "StackBuffer.h"
#include "Sys.h"
#include "ixo.h"

#include "config.h"

extern char *sys_errlist[];

static sms_typ SMS_STRUCTURE;

/*
 * Send messages with IXO/TAP protocol.
 */

#include "lms.h"

extern "C" int lms_create_msgq();
extern "C" int lms_request(int, char *, char *, char *);

static void t_error (char *txt)
{
}

static int fp_write_nr=0;
static FILE * fp_write_file= NULL;
static void write_log_protokoll(const char *s)
{



fp_write_nr++;
if( fp_write_file == NULL)
{
fp_write_file= ::fopen("/tmp/d2.log","a+");
if(fp_write_file == NULL) return;
}

::fprintf(fp_write_file,"\n%d %s",fp_write_nr, s);
::fflush(fp_write_file);
}



d2SendApp* d2SendApp::_instance = NULL;

d2SendApp::d2SendApp(const fxStr& devName, const fxStr& devID)
    : ModemServer(devName, devID)
{
    ready = FALSE;
    modemLock = NULL;
    setupConfig();

    fxAssert(_instance == NULL, "Cannot create multiple d2SendApp instances");
    _instance = this;
}

d2SendApp::~d2SendApp()
{
    delete modemLock;
}

d2SendApp& d2SendApp::instance() { return *_instance; }

void
d2SendApp::initialize(int argc, char** argv)
{
    ModemServer::initialize(argc, argv);
    faxApp::initialize(argc, argv);

    // NB: must do last to override config file information
    for (GetoptIter iter(argc, argv, getOpts()); iter.notDone(); iter++)
	switch (iter.option()) {
	case 'l':			// do uucp locking
	    modemLock = getUUCPLock(getModemDevice());
	    break;
	case 'c':			// set configuration parameter
	    readConfigItem(iter.optArg());
	    break;
	}
}

void
d2SendApp::open()
{
    ModemServer::open();
    faxApp::open();
}

void
d2SendApp::close()
{
    if (isRunning()) {
	if (state == ModemServer::SENDING) {
	    /*
	     * Terminate the active job and let the send
	     * operation complete so that the transfer is
	     * logged and the appropriate exit status is
	     * returned to the caller.
	     */
	    ModemServer::abortSession();
	} else {
	    ModemServer::close();
	    faxApp::close();
	}
    }
}

FaxSendStatus
d2SendApp::send(const char* filename)
{
    int found_request;


	write_log_protokoll("send:");
	write_log_protokoll(filename);

    int fd = Sys::open(filename, O_RDWR);
    if (fd >= 0) {
	if (flock(fd, LOCK_EX) >= 0) {
	    FaxRequest* req = new FaxRequest(filename, fd);
	    fxBool reject;
	    if (req->readQFile(reject) && !reject) {
		found_request=req->findRequest(FaxRequest::send_page);

		if (found_request != fx_invalidArrayIndex) {
		    FaxMachineInfo info;


		    info.updateConfig(canonicalizePhoneNumber(req->number));
		    FaxAcctInfo ai;

		    ai.start = Sys::now();

		    sendPage(*req, info);

		    ai.jobid = req->jobid;
		    ai.jobtag = req->jobtag;
		    ai.user = req->mailaddr;
		    ai.duration = Sys::now() - ai.start;
		    ai.conntime = getConnectTime();
		    ai.commid = req->commid;
		    ai.device = getModemDeviceID();
		    ai.dest = req->external;
		    ai.csi = "";
		    ai.params = 0;
		    if (req->status == send_done)
			ai.status = "";
		    else
			ai.status = req->notice;
		    if (!ai.record("PAGE"))
			logError("Error writing %s accounting record, dest=%s",
			    "PAGE", (const char*) ai.dest);
		} else
		    sendFailed(*req, send_failed, "Job has no PIN to send to");
		    req->writeQFile(); 		// update on-disk copy
		return (req->status);		// return status for exit
	    } else
		delete req;
	    logError("Could not read request file");
	} else
	    logError("Could not lock request file: %m");
	Sys::close(fd);
    } else
	logError("Could not open request file: %m");
    return (send_failed);
}

void
d2SendApp::sendPage(FaxRequest& req, FaxMachineInfo& info)
{
    if (lockModem()) {
	beginSession(req.number);
	req.commid = getCommID();
	traceServer("SEND PAGE: JOB %s DEST %s COMMID %s"
	    , (const char*) req.jobid
	    , (const char*) req.external
	    , (const char*) req.commid
	);
	/*
	 * Setup tty parity; per-destination information takes
	 * precedence over command-line arguments/config params;
	 * otherwise the IXO/TAP spec is used (set below).
	 */
	if (info.getPagerTTYParity() != "")
	    pagerTTYParity = info.getPagerTTYParity();
	// NB: may need to set tty baud rate here XXX
	if (setupModem()) {
	    changeState(SENDING);
	    fxStr emsg;
	    setServerStatus("Sending page " | req.jobid);
	    /*
	     * Construct the phone number to dial by applying the
	     * dialing rules to the user-specified dialing string.
	     */
	    fxStr msg;
	    if (prepareMsg(req, info, msg))
		sendPage(req, info, prepareDialString(req.number), msg);
	    changeState(MODEMWAIT);		// ...sort of...
	} else
	    sendFailed(req, send_retry, "Can not setup modem", 4*pollModemWait);
	discardModem(TRUE);
	endSession();
	unlockModem();
    } else {
	sendFailed(req, send_retry, "Can not lock modem device",2*pollLockWait);
    }
}

fxBool
d2SendApp::prepareMsg(FaxRequest& req, FaxMachineInfo& info, fxStr& msg)
{
    u_int i = req.findRequest(FaxRequest::send_data);
    if (i == fx_invalidArrayIndex)		// page w/o text
	return (TRUE);
    int fd = Sys::open(req.requests[i].item, O_RDONLY);
    if (fd < 0) {
	sendFailed(req, send_failed,
	    "Internal error: unable to open text message file");
	return (FALSE);
    }
    struct stat sb;
    (void) Sys::fstat(fd, sb);
    msg.resize((u_int) sb.st_size);
    if (Sys::read(fd, &msg[0], (u_int) sb.st_size) != sb.st_size) {
	sendFailed(req, send_failed,
	    "Internal error: unable to read text message file");
	return (FALSE);
    }
    Sys::close(fd);

    u_int maxMsgLen = info.getPagerMaxMsgLength();
    if (maxMsgLen == (u_int) -1)		// not set, use default
	maxMsgLen = pagerMaxMsgLength;
    if (msg.length() > maxMsgLen) {
	traceServer("Pager message length %u too large; truncated to %u",
	    msg.length(), maxMsgLen);
	msg.resize(maxMsgLen);
    }

    msg.append('\n');
    return (TRUE);
}

void
d2SendApp::sendFailed(FaxRequest& req, FaxSendStatus stat, const char* notice, u_int tts)
{
    req.status = stat;
    req.notice = notice;
    /*
     * When requeued for the default interval (requeueOther),
     * don't adjust the time-to-send field so that the spooler
     * will set it according to the default algorithm that 
     * uses the command-line parameter and a random jitter.
     */
    if (tts != requeueOther)
	req.tts = Sys::now() + tts;
    traceServer("PAGE FAILED: %s", notice);
}

void
d2SendApp::sendPage(FaxRequest& req, FaxMachineInfo& info, const fxStr& number, const fxStr& msg)
{
int lms_status;


    connTime = 0;				// indicate no connection
    if (!getModem()->dataService()) {
	sendFailed(req, send_failed, "Unable to configure modem for data use");
	return;
    }
    req.notice = "";
    fxStr notice;
    time_t pageStart = Sys::now();


    if (pagerSetupCmds != "")
	{
	write_log_protokoll("pagerSetupCmds");
	(void) getModem()->atCmd(pagerSetupCmds);
	}


/* Original Stand */
/*
    CallStatus callstat = getModem()->dial(number, notice);
	write_log_protokoll(notice);
*/

/* +++ Neu +++ */
    strcpy(SMS_STRUCTURE.smsc, number);
    CallStatus callstat;
    callstat= ClassModem::OK;



lms_status= anforderung_channeld(SMS_STRUCTURE.smsc);

if(lms_status == 2)
	{
    write_log_protokoll("channeld: Anforderung wurde negativ quittiert");
    notice = "channeld: alle b kanaele sind besetzt";
    req.status = send_retry;
	}

/* +++ Ende Neu ++++ */


if(lms_status != 2)
    callstat = open_smsc(&SMS_STRUCTURE);

    if (lms_status != 2 && callstat != ClassModem::OK)
	{
    notice = "no connect smsc";
	}

    if (callstat == ClassModem::OK)
	connTime = Sys::now();			// connection start time
    (void) abortRequested();			// check for user abort
	
    if (callstat == ClassModem::OK && !abortCall) {
	req.ndials = 0;				// consec. failed dial attempts
	req.tottries++;				// total answered calls
	req.totdials++;				// total attempted calls
	info.setCalledBefore(TRUE);
	info.setDialFailures(0);

	req.status = send_ok;			// be optimistic



	    while (req.requests.length() > 0) {	// messages
		u_int i = req.findRequest(FaxRequest::send_page);
		if (i == fx_invalidArrayIndex)
		    break;
		if (req.requests[i].item.length() == 0) {
		    sendFailed(req, send_failed, "No PIN specified");
		    break;
		}

if(lms_status != 2)
{

        flushModemInput();

	SMS_STRUCTURE.smsc[0]=0;
	SMS_STRUCTURE.conn_mode=0;
	SMS_STRUCTURE.wait_note=0;
	SMS_STRUCTURE.save_time=0;
	strcpy(SMS_STRUCTURE.message,msg);


	{
	int i;
	int points;
	char tbuf[20];
	char telno[20];

	telno[0]=0;

	write_log_protokoll("ModemNumber:" );
	write_log_protokoll(getModemNumber());

	strcpy(tbuf,getModemNumber());
	/* Uwandlung in andrese Format */
	points=0;

	for(i=0; i<strlen(tbuf); i++)	{

	if(tbuf[i] == '.') 
	{
	points++;
	if(points == 1) { strcat(telno,"0"); continue; }
	continue;
	}
	else
	{
	char tbuf1[2];

	if(points == 0) continue;

	tbuf1[0]= tbuf[i];
	tbuf1[1]= 0;

	strcat(telno,tbuf1);
	}

					}

	write_log_protokoll("telno");
	write_log_protokoll(telno);

	strcpy(SMS_STRUCTURE.orig ,  telno); 
	}


    	strcpy( SMS_STRUCTURE.dest, req.requests[i].item);
	SMS_STRUCTURE.messid[0]=0;
	SMS_STRUCTURE.send_lim=0;
	SMS_STRUCTURE.quer_lim=0;
	SMS_STRUCTURE.dele_lim=0;
	SMS_STRUCTURE.result=0;
	SMS_STRUCTURE.retry=0;
	SMS_STRUCTURE.cause=0;
	SMS_STRUCTURE.t_errno=0;
	SMS_STRUCTURE.errno=0;
	SMS_STRUCTURE.ec=0;
	SMS_STRUCTURE.duration=0;
	SMS_STRUCTURE.trn=0;
	SMS_STRUCTURE.more_to_send=0;
	SMS_STRUCTURE.ackflag=0;
	SMS_STRUCTURE.result_str[0]=0;
	SMS_STRUCTURE.sendezeit[0]=0;
	SMS_STRUCTURE.gebuehr=0;

        ModemServer::setRawModeOn();
	send_d2_message(&SMS_STRUCTURE);
        ModemServer::setRawModeOff();


	freigabe_channeld(SMS_STRUCTURE.smsc);

	req.gebuehr= SMS_STRUCTURE.gebuehr;
    if(SMS_STRUCTURE.result == 0)
    {
    write_log_protokoll("send_d2_message ist OK");
    req.status = send_ok;
    }
    else
    {
    req.status = send_failed;
    if(SMS_STRUCTURE.retry) req.status = send_retry;
    sendFailed(req, req.status, SMS_STRUCTURE.result_str);
    notice = SMS_STRUCTURE.result_str;


    if(req.status == send_failed) write_log_protokoll("send_failed");
    if(req.status == send_retry) write_log_protokoll("send_retry");
    if(req.status == send_ok) write_log_protokoll("send_ok");
    }

}


if(lms_status == 2)
{
if(req.tottries) req.tottries--;
if(req.totdials) req.totdials--;
callstat= ClassModem::BUSY;
notice = "channeld: alle b kanaele sind besetzt";
req.status = send_retry;
req.tts = time(0) + requeueProto;
break;
}





		    if (req.status == send_retry) {
			req.tts = time(0) + requeueProto;
			break;
		    }
		
		req.requests.remove(i);
		break;
	    }




	if (req.status == send_ok) {
	    time_t now = Sys::now();
	    traceServer("SEND PAGE: FROM " | req.mailaddr
		| " TO " | req.external | " (sent in %s)",
		fmtTime(now - pageStart));
	    info.setSendFailures(0);
	} else {

	    sendFailed(req, req.status, notice);
    	    write_log_protokoll("Es trat ein Fehler auf!");
    	    write_log_protokoll(req.notice);

	    info.setSendFailures(info.getSendFailures()+1);
	    info.setLastSendFailure(req.notice);


	}
    } else if (!abortCall) {
	sendFailed(req, send_failed, "Connect Error");
	
	/*
	 * Analyze the call status codes and selectively decide if the
	 * job should be retried.  We try to avoid the situations where
	 * we might be calling the wrong number so that we don't end up
	 * harrassing someone w/ repeated calls.
	 */
	req.ndials++;
	req.totdials++;			// total attempted calls
	switch (callstat) {
	case ClassModem::NOCARRIER:	// no carrier detected on remote side
	    /*
	     * Since some modems can not distinguish between ``No Carrier''
	     * and ``No Answer'' we offer this configurable hack whereby
	     * we'll retry the job <n> times in the face of ``No Carrier''
	     * dialing errors; if we've never previously reached a modem
	     * at that number.  This should not be used except if
	     * the modem is incapable of distinguishing between
	     * ``No Carrier'' and ``No Answer''.
	     */
	    if (!info.getCalledBefore() && req.ndials > noCarrierRetrys) {
		sendFailed(req, send_failed, notice);
		break;
	    }
	    /* fall thru... */
	case ClassModem::NODIALTONE:	// no local dialtone, possibly unplugged
	case ClassModem::ERROR:		// modem might just need to be reset
	case ClassModem::FAILURE:	// modem returned something unexpected
	case ClassModem::BUSY:		// busy signal
	case ClassModem::NOANSWER:	// no answer or ring back
	    sendFailed(req, send_retry, notice, requeueTTS[callstat]);
	    /* fall thru... */
	case ClassModem::OK:		// call was aborted by user
	    break;
	}
	if (callstat != ClassModem::OK) {
	    info.setDialFailures(info.getDialFailures()+1);
	    info.setLastDialFailure(req.notice);
	}
    }
    if (abortCall)
	sendFailed(req, send_failed, "Job aborted by user");
    else if (req.status == send_retry) {
	if (req.totdials == req.maxdials) {
	    notice = req.notice | "; too many attempts to dial";
    	    write_log_protokoll("send_failed (maxdials): too many attempts to dial");
	    sendFailed(req, send_failed, notice);
	} else if (req.tottries == req.maxtries) {
	    notice = req.notice | "; too many attempts to send";
    	    write_log_protokoll("send_failed (maxtries): too many attempts to send");
	    sendFailed(req, send_failed, notice);
	}
    }
    /*
     * Cleanup after the call.  If we have new information on
     * the client's remote capabilities, the machine info
     * database will be updated when the instance is destroyed.
     */
    getModem()->hangup();
    /*
     * This may not be exact--the line may already have been
     * dropped--but it should be close enough unless the modem
     * gets wedged and the hangup work times out.  Also be
     * sure to register a non-zero amount of connect time so
     * that folks doing accounting can adjust charge-back costs
     * to reflect any minimum connect time tarrifs imposted by
     * their PTT (e.g. calls < 1 minute are rounded up to 1 min.)
     */
    if (connTime) {
	connTime = Sys::now() - connTime;
	if (connTime == 0)
	    connTime++;
    }
}

u_int
d2SendApp::getResponse(fxStackBuffer& buf, long secs)
{
    return (0);
}

/*
 * Scan through a buffer looking for a potential
 * code byte return in a protocol response.
 * This is needed because some pager services such
 * as PageNet intersperse protocol messages and
 * verbose text messages.
 */
static fxBool
scanForCode(const u_char*& cp, u_int& len)
{
    return (TRUE);
}

fxBool
d2SendApp::pagePrologue(FaxRequest& req, const FaxMachineInfo& info, fxStr& emsg)
{
     return (TRUE);
}

fxBool
d2SendApp::pageGoAhead(FaxRequest& req, const FaxMachineInfo&, fxStr& emsg)
{
     return (TRUE);
}

/*
 * Calculate packet checksum and append to buffer.
 */
static void
addChecksum(fxStackBuffer& buf)
{
}

fxBool
d2SendApp::sendPagerMsg(FaxRequest& req, faxRequest& preq, const fxStr& msg, fxStr& emsg)
{
	return (TRUE);
}

fxBool
d2SendApp::pageEpilogue(FaxRequest& req, const FaxMachineInfo&, fxStr& emsg)
{
    return (TRUE);
}

void
d2SendApp::traceResponse(const fxStackBuffer& buf)
{
}

void
d2SendApp::traceIXOCom(const char* dir, const u_char* data, u_int cc)
{
    if (log) {
	if ((logTracingLevel& FAXTRACE_IXO) == 0)
	    return;
    } else if ((tracingLevel & FAXTRACE_IXO) == 0)
	return;

    fxStackBuffer buf;
    for (u_int i = 0; i < cc; i++) {
	u_char b = data[i];
	if (!isprint(b)) {
	    const char* octdigits = "01234567";
	    char s[4];
	    s[0] = '\\';
	    s[1] = octdigits[b>>6];
	    s[2] = octdigits[(b>>3)&07];
	    s[3] = octdigits[b&07];
	    buf.put(s, 4);
	} else
	    buf.put(b);
    }
    traceStatus(FAXTRACE_IXO, "%s <%u:%.*s>",
	dir, cc, buf.getLength(), (const char*) buf);
}

void
d2SendApp::traceIXO(const char* fmt ...)
{
    va_list ap;
    va_start(ap, fmt);
    vtraceStatus(FAXTRACE_PROTOCOL, fmt, ap);
    va_end(ap);
}

fxBool
d2SendApp::putModem(const void* data, int n, long ms)
{
    traceIXOCom("<--",  (const u_char*) data, n);
    return (putModem1(data, n, ms));
}

time_t d2SendApp::getConnectTime() const	{ return (connTime); }

/*
 * Configuration support.
 */

void
d2SendApp::resetConfig()
{
    ModemServer::resetConfig();
    setupConfig();
}

#define	N(a)	(sizeof (a) / sizeof (a[0]))

const d2SendApp::stringtag d2SendApp::strings[] = {
{ "ixoservice",		&d2SendApp::ixoService,	IXO_SERVICE },
{ "ixodeviceid",	&d2SendApp::ixoDeviceID,	IXO_DEVICEID },
{ "pagerttyparity",	&d2SendApp::pagerTTYParity,	"even" },
};
const d2SendApp::stringtag d2SendApp::atcmds[] = {
{ "pagersetupcmds",	&d2SendApp::pagerSetupCmds },
};
const d2SendApp::numbertag d2SendApp::numbers[] = {
{ "pagermaxmsglength",	&d2SendApp::pagerMaxMsgLength,128 },
{ "ixomaxunknown",	&d2SendApp::ixoMaxUnknown,	IXO_MAXUNKNOWN },
{ "ixoidprobe",		&d2SendApp::ixoIDProbe,	IXO_IDPROBE },
{ "ixoidtimeout",	&d2SendApp::ixoIDTimeout,	IXO_IDTIMEOUT },
{ "ixologinretries",	&d2SendApp::ixoLoginRetries,	IXO_LOGINRETRIES },
{ "ixologintimeout",	&d2SendApp::ixoLoginTimeout,	IXO_LOGINTIMEOUT },
{ "ixogatimeout",	&d2SendApp::ixoGATimeout,	IXO_GATIMEOUT },
{ "ixoxmitretries",	&d2SendApp::ixoXmitRetries,	IXO_XMITRETRIES },
{ "ixoxmittimeout",	&d2SendApp::ixoXmitTimeout,	IXO_XMITTIMEOUT },
{ "ixoacktimeout",	&d2SendApp::ixoAckTimeout,	IXO_ACKTIMEOUT },
};

void
d2SendApp::setupConfig()
{
    int i;
    for (i = N(strings)-1; i >= 0; i--)
	(*this).*strings[i].p = (strings[i].def ? strings[i].def : "");
    for (i = N(atcmds)-1; i >= 0; i--)
	(*this).*atcmds[i].p = (atcmds[i].def ? atcmds[i].def : "");
    for (i = N(numbers)-1; i >= 0; i--)
	(*this).*numbers[i].p = numbers[i].def;
}

fxBool
d2SendApp::setConfigItem(const char* tag, const char* value)
{
    u_int ix;
    if (findTag(tag, (const tags*)atcmds, N(atcmds), ix)) {
	(*this).*atcmds[ix].p = parseATCmd(value);
    } else if (findTag(tag, (const tags*) strings, N(strings), ix)) {
	(*this).*strings[ix].p = value;
    } else if (findTag(tag, (const tags*)numbers, N(numbers), ix)) {
	(*this).*numbers[ix].p = getNumber(value);
    } else
	return (ModemServer::setConfigItem(tag, value));
    return (TRUE);
}
#undef	N

u_int
d2SendApp::getConfigParity(const char* value) const
{
char tbuf[400];

	write_log_protokoll("d2SendApp::getConfigParity:");
	write_log_protokoll(value);

    if (streq(value, "even"))
	return (EVEN);
    else if (streq(value, "odd"))
	return (ODD);
    else if (streq(value, "none"))
	return (NONE);
    else {
	sprintf(tbuf,"Unknown pager tty parity %s ignored; using EVEN", value);
	logError(tbuf);
	return (EVEN);				// per IXO/TAP spec
    }
}

/*
 * Modem and TTY setup
 */
fxBool 
d2SendApp::setupModem()
{
    return (ModemServer::setupModem() &&
	setParity((Parity) getConfigParity(pagerTTYParity)));
}

/*
 * Modem locking support.
 */

fxBool
d2SendApp::lockModem()
{
    return (modemLock ? modemLock->lock() : TRUE);
}

void
d2SendApp::unlockModem()
{
    if (modemLock)
	modemLock->unlock();
}

/*
 * Notification handlers.
 */

/*
 * Handle notification that the modem device has become
 * available again after a period of being unavailable.
 */
void
d2SendApp::notifyModemReady()
{
    ready = TRUE;
}

/*
 * Handle notification that the modem device looks to
 * be in a state that requires operator intervention.
 */
void
d2SendApp::notifyModemWedged()
{
    if (!sendModemStatus(getModemDeviceID(), "W"))
	logError("MODEM %s appears to be wedged",
	    (const char*) getModemDevice());
    close();
}

/*
 * Miscellaneous stuff.
 */

static void
usage(const char* appName)
{
    faxApp::fatal("usage: %s -m deviceID [-t tracelevel] [-l] qfile ...",
	appName);
}

static void
sigCleanup(int s)
{
    signal(s, fxSIGHANDLER(sigCleanup));
    logError("CAUGHT SIGNAL %d", s);
    d2SendApp::instance().close();
    if (!d2SendApp::instance().isRunning())
	_exit(send_failed);
}

int
main(int argc, char** argv)
{
write_log_protokoll("d2send Programm gestartet");

    faxApp::setupLogging("D2Send");

    fxStr appName = argv[0];
    u_int l = appName.length();
    appName = appName.tokenR(l, '/');

    faxApp::setOpts("c:m:l");

    fxStr devID;
    for (GetoptIter iter(argc, argv, faxApp::getOpts()); iter.notDone(); iter++)
	switch (iter.option()) {
	case 'm': devID = iter.optArg(); break;
	case '?': usage(appName);
	}
    if (devID == "")
	usage(appName);

    d2SendApp* app = new d2SendApp(faxApp::idToDev(devID), devID);

    signal(SIGTERM, fxSIGHANDLER(sigCleanup));
    signal(SIGINT, fxSIGHANDLER(sigCleanup));

    app->initialize(argc, argv);
    app->open();
    while (app->isRunning() && !app->isReady())
	Dispatcher::instance().dispatch();
    FaxSendStatus status;
    if (app->isReady())
	status = app->send(argv[optind]);
    else
	status = send_retry;
    app->close();
    return (status);
}
/*--------------------------------------------------------------------*/
int d2SendApp::anforderung_channeld(char *nr)
{

if(lms_create_msgq()) return(1);


write_log_protokoll("\nDer Channeld wurde kontaktiert!");

if(lms_request(MSG_ANFORDERUNG, LMS_SMS_SERVICE, nr, "..."))
{
write_log_protokoll("\nAnforderung wurde negativ quittiert!");
return(2);
}



return(0);
}
/*--------------------------------------------------------------------*/
void d2SendApp::freigabe_channeld(char *nr)
{
lms_request(MSG_FREIGABE, LMS_SMS_SERVICE, nr, "...");
}
/*--------------------------------------------------------------------*/
#ifdef TEST_MAIN
static int    debug = 1;
#else
static int    debug = 0;
#endif

static int    prev_action;
static int    connect_timeout=0;
static time_t starttime;
static time_t querystart;


/*--------------------------------------------------------------------*/
#define MAXMSGLEN     4000
#define MAXRETRY      2        /* also max 3 sende versuche */

#define A_SEND_REQ    1
#define A_SEND_ACK    2
#define A_RCV_ANSW    3
#define A_END         4
#define A_SEND_ALERT  5

#define TOUT_ACK      30
#define TOUT_NOTE     30

#define OT_CALL_INPUT      1
#define OT_SMS_TRANSFER   30
#define OT_SMT_ALERT      31

#define MT_TONE            1
#define MT_NUMERIC         2
#define MT_ALPHANUM        3
#define MT_TRANSPARENT     4

#define SMSC_MODEM1        "01722278020"
#define SMSC_ISDN1         "01722278000"
#define SMSC_ISDN2         "01722278010"
#define SMSC_ISDN3         "02111733214"

static char *ErrorIntern =
"Die Kurzmitteilung wurde nicht versendet. Der Grund ist ein interner Fehler in den Kommunikationsanwendung. Wenden Sie sich zu Kl{rung mit folgender Fehlermeldung an die PDS-Hotline:\n\n";

/*--------------------------------------------------------------------*/
int d2SendApp::send_d2_message(sms_typ *sms)
{
 int  fd,res,action,rcv_timeout=0;
 char buf[MAXMSGLEN];
 pack_typ pack;
 time_t t=time(0);

 sms->result  = -5;
 sms->retry   = 0;
 sms->t_errno = 0;
 sms->errno   = 0;
 sms->cause   = 0;
 sms->duration= 0;
 sms->ec      = 0;   /* error code vom smsc */
 sms->gebuehr = 0;
 sms->trn     = 0;
 sms->result_str[0] = 0;
 sms->sendezeit[0]  = 0;
 action       = A_SEND_REQ;


 while (1)
 {
    switch (action)
    {
       case A_SEND_ALERT:
          if (send_alert(sms))
          {
             action = A_END;
          }
          else
          {
             rcv_timeout = TOUT_NOTE;
             action = A_RCV_ANSW;
          }
          break;

       case A_SEND_REQ:
          if (send_transfer_req(sms))
          {
             action = A_END;
          }
          else
          {
             rcv_timeout = TOUT_ACK;
             action = A_RCV_ANSW;
          }
          break;

       case A_SEND_ACK:
          /*
          send_acknowledge(sms);
          */
          action = A_END;
          break;

       case A_RCV_ANSW:
          res = rcv_packet(buf,sms,rcv_timeout);
	{
	char tbuf[80];

	  sprintf(tbuf,"RCV_PACKET: %d",res);
	  write_log_protokoll(tbuf);
	}



          if (res == -1) /* fehler beim lesen */
          {
             action = A_END;
             break;
          }

          if (res == -2) /* timeout (keine antwort) */
          {
             if (pack.ack.ack == 'A')
             {
                action = A_END;
                break;
             }

             if (sms->trn >= MAXRETRY)
             {
                sms->result = -4; /* nach retry versuchen immer noch fehlerhaft */
                sms->retry = 1;   /* bei isdn-verbindung will er machmal nicht */
                sprintf (sms->result_str,"Die Kurzmitteilung konnte nach %d Versuchen nicht an das D2-SMS-Center }bergeben werden!",
                         1 + sms->trn);
                action = A_END;
             }
             else
             {
                sms->trn++;
                action = A_SEND_REQ;
             }
             break;
          }
          /* ab hier liegt ein paket vor */
          res = decode_packet(buf,&pack);
	{
	char tbuf[80];

	  sprintf(tbuf,"DECODE_PACKET: %d",res);
	  write_log_protokoll(tbuf);
	}

          if (res)
          {
             if (debug)
                fprintf (stderr,"decode_packet() = %d\n",res);

             if (res == -1) /* bad checksum in der Antwort*/
             {
                if (pack.ack.ack == 'A')
                {  /* bad checksum bei der notification */
                   action = A_END;
                   break;
                }
                else
                {
                   if (sms->trn >= MAXRETRY)
                   {
                      sms->result = -4; /* nach retry versuchen immer noch fehlerhaft */
                      sms->retry = 1;
                      sprintf (sms->result_str,"Die Kurzmitteilung konnte nach %d Versuchen nicht an das D2-SMS-Center }bergeben werden!",
                               1 + sms->trn);
                      action = A_END;
                   }
                   else
                   {
                      sms->trn++;
                      action = A_SEND_REQ;
                   }
                }
             }
             else
             { /* res muss jetzt < -1 sein */
                if (pack.ack.ack == 'A')
                {  /* anderes nach dem ACK */
                   action = A_END;
                   break;
                }
                else
                {
                   action = A_RCV_ANSW;
                   break;
                }
             }
             action = A_END;
             break;
          }
          else
          { /* jetzt ist ein ordentliches Paket gekommen */
	  write_log_protokoll("jetzt ist ein ordentliches Paket gekommen!");

             if ((pack.op == 'R') && (pack.ot == OT_SMS_TRANSFER))
             { /* reply auf die sms-transfer-message */
                if (pack.ack.ack == 'A')
                {
	  	   write_log_protokoll("Die Kurzmitteiling wurde erfolgreich gesendet!");
                   strcpy (sms->sendezeit,timestamp_to_timestr(pack.ack.empf_zeit));
                   sprintf (sms->result_str,"Die Kurzmitteilung wurde erfolgreich an das D2-SMS-Center }bergeben. Auf eine Best{tigung f}r die Auslieferung an das Mobiltelefon wurde nicht gewartet.");
                   rcv_timeout = TOUT_NOTE;
                   sms->result = 0;
                   if (sms->wait_note)
                      action = A_RCV_ANSW;
                   else
                      action = A_END;
                   break;
                }
                else
                { /* ab hier muss pack.ack.ack != 'A' sein */
                   if (pack.ack.ec == 1) /* checksum error */
                   {
	  	   write_log_protokoll("checksum error");

                      sms->ec = pack.ack.ec;
                      if (sms->trn >= MAXRETRY)
                      {
                         sms->result = -4; /* nach retry versuchen immer noch fehlerhaft */
                         sprintf (sms->result_str,"Kurzmitteilung konnte nach %d Versuchen nicht an das D2-SMS-Center }bergeben werden!",
                                  1 + sms->trn);
                         action = A_END;
                      }
                      else
                      {
                         sms->trn++;
                         action = A_SEND_REQ;
                      }
                      break;
                   }
                   else
                   {
	  	      write_log_protokoll("Die Kurzmitteldung wurde unterbrochen");
                      sms->result = -3;
                      sms->ec = pack.ack.ec;
                      sprintf (sms->result_str,"Die Kurzmitteilung ist nicht versendet worden, weil die Annahme vom D2-SMS-Center abgelehnt oder die ]bermittlung unterbrochen wurde.\n\nUrsache: %s ",
                               decode_ec(sms->ec));
                      action = A_END;
                      break;
                   }
                }
             }
             else
             {  /* jetzt muss es der Call-input-info sein */
	  	      write_log_protokoll("jetzt muss es der CALL-input-info sein");
                strcpy (sms->result_str,pack.cin.message);
                if (isinstr(pack.cin.message,"Code 107"))
                {
                   if (pack.ack.mvp[0])
                   {
	  	      write_log_protokoll("Der Call wurde im SMS Center gespeichert");
                      sprintf (buf,"\nDie Kurzmitteilung wird bis %s im SMS-Center gespeichert.",
                               decode_mvp(pack.ack.mvp));
                      strcat (sms->result_str,buf);
                   }
                }
	  	write_log_protokoll("alles paletti");
                sms->result = 1; /* alles paletti */
                action = A_END;
                break;
             }
          }
          break;
    }

    if (action == A_END)
       break;
 }

 close_smsc(sms);
 sms->duration = time(0) - t;
 return (0);
}
/*--------------------------------------------------------------------*/
CallStatus d2SendApp::open_smsc(sms_typ *sms)
{
char nebenstelle[200];
char dialog_format[200];
char dialog_text[200];
int rc;
char buf[1024];

strcpy(dialog_format,ModemServer::dialCmd);
sprintf(dialog_text,dialog_format,sms->smsc);
strcat(dialog_text,"\r");


write_log_protokoll("dialog_text-->");
write_log_protokoll(dialog_text);

if(putModem("at&F\r", 5) != TRUE)
{
	write_log_protokoll("Ausgabe at&f fehlerhaft");
}

rc=rcv_packet(buf,"OK",sms, 10);

if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}

if(putModem("atE0\r", 5) != TRUE)
{
	write_log_protokoll("Ausgabe atE0 fehlerhaft");
}

rc=rcv_packet(buf,"OK",sms, 10);

if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}


if(putModem("at&x1\r", 6) != TRUE)
{
	write_log_protokoll("Ausgabe at&x1 fehlerhaft");
}

rc=rcv_packet(buf,"OK",sms, 10);

if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}



if(putModem("atS13.1=0\r", 10) != TRUE)
{
	write_log_protokoll("Ausgabe atS13.1=1 fehlerhaft");
}

rc=rcv_packet(buf,"OK",sms, 10);
if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}


strcpy(nebenstelle,"at&e");
ModemServer::getNebenstelle(&nebenstelle[4]);
strcat(nebenstelle,"\r");

if(putModem(nebenstelle, strlen(nebenstelle)) != TRUE)
{
	write_log_protokoll("Ausgabe at&e... fehlerhaft");
}

rc=rcv_packet(buf,"OK",sms, 10);
if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}





if(putModem(dialog_text, strlen(dialog_text)) != TRUE)
{
	write_log_protokoll("Ausgabe atd fehlerhaft");
}


/* rc=rcv_packet(buf,"CONNECT",sms,TOUT_CR);  */
rc=rcv_packet(buf,"CONNECT",sms, 10);

if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}

return(ClassModem::OK);

}
/*--------------------------------------------------------------------*/
int d2SendApp::rcv_packet(char *packet, sms_typ *sms, int timeout)
{
 int flag;
 fxBool wasTimeout;
 int fehler_code;
 int c;
 int         flags,rec,rcode,event;
 static int  firsttime = 1;
 static char buf [MAXMSGLEN];
 char        buf2[MAXMSGLEN];
 char        *p,*p1;
 time_t      starttime;



 flag=0;
 *packet = 0;
 *buf2 = 0;
 if (firsttime)
 {
    *buf=0;
    firsttime = 0;
 }
 starttime = time(0);

 while (time(0) < (starttime + timeout))
 {


	c = isdn_getModemChar(timeout*1000, fehler_code, wasTimeout);

	if(c > 0 && wasTimeout == 0 && fehler_code == 0)
	{
	char tbuf[2];

	if(c == 0x02) flag= flag| 1;
	if(c == 0x03) flag= flag| 2;
	if(flag == 3) return(0);

	if(c == 0x02) continue;
	if(c == 0x03) continue;


	tbuf[0] = c;
	tbuf[1]=0;
	strcat (packet,tbuf);
	continue;
	}


	if(wasTimeout)
	{
     /* normaler Timeout */
	continue;
	}

	if(fehler_code)
	{
       switch (fehler_code)
       {
          case EAGAIN:
          case EINTR:   /* signal eingefangen, message da */
  	     continue;
          default:
             sprintf (sms->result_str,"%s poll() : %s",
                      ErrorIntern,
                      sys_errlist[fehler_code]);
             sms->errno   = fehler_code;
	     continue;
       }

	}
	/* Ende der Fehlerbehandlung */


       if (c == EOF)
       {
                sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nVerbindung unerwartet vom D2-SMS-Center abgebaut.");
                sms->result  = -6;
                return (-1);
       }

 }
 return (-2); /* time out */
}
/*--------------------------------------------------------------------*/
int d2SendApp::close_smsc(sms_typ *sms)
{
int rc;
char buf[80];

  isdn_sleep(2);
  putModem("+++", 3);
  isdn_sleep(3);

 putModem("\004\r",2); /* EOT */
 /* sms->gebuehr = isi_getcharge(fd); */
 sms->gebuehr = 0;


  putModem("ath\r", 4);
  rc=rcv_packet(buf,"OK",sms, 10);

if(rc) return(0);

  putModem("ati3\r", 5);
  rc=rcv_packet(buf,"Linux ISDN\r\n",sms, 4);
  if(rc) return(0);

  /* maximal 20 Zeichen einlesen (bis CR) */ 
  rc=rcv_string_packet(buf,'\r', sms, 1, 4);
  if(rc) return(0);

 
 sscanf(buf, "%d",&sms->gebuehr);

 {
 char tbuf[40];

 sprintf(tbuf,"Gebuehr: %d",sms->gebuehr);
 write_log_protokoll(tbuf);

 }

 return (0);
}
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
int d2SendApp::send_transfer_req(sms_typ *sms)
{
 int  res;
 char buf[MAXMSGLEN];
 char buf2[MAXMSGLEN];

/*
 sprintf (buf2,"/O/%2.2d/%s/%s//1/////%s/%s/",OT_SMS_TRANSFER,
          sms->dest,sms->orig,prep_save_time(sms->save_time),
          ascii_to_ia5 (sms->message));
 sprintf (buf,"%-2.2d/%-5.5d%s",sms->trn,strlen(buf2) + 10,buf2);
 sprintf (buf2,"\002%s%-2.2x\003",buf,checksum(buf));
*/

 sprintf (buf2,"/O/%2.2d/%s/%s//1/////%s/%s/",
	  OT_SMS_TRANSFER,
          sms->dest,
	  sms->orig,
	  "",
          ascii_to_ia5 (sms->message)
        	);
 sprintf (buf,"%-2.2d/%-5.5d%s",sms->trn,strlen(buf2) + 10,buf2);
 sprintf (buf2,"\002%s%-2.2x\003",buf,checksum(buf));





if(putModem(buf2, strlen(buf2)) != TRUE)
 {
    if (debug)
       t_error ("t_snd() ");
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nFehler beim Senden zum D2-SMS-Center.\nt_snd()");
    sms->result = -2;
    sms->t_errno = -1;
    return (-1);
 }
 if (debug)
    fprintf (stderr,"gesendet %s\n",buf2);
 return (0);
}
/*--------------------------------------------------------------------*/
int d2SendApp::checksum(char *buf)
{
 int   sum=0;
 char *p;

 for (p=buf;*p != 0;p++)
    sum += *p;

 sum &= 0xff;
 return (sum);
}
/*--------------------------------------------------------------------*/
int d2SendApp::isinstr(char *s1, char *s2)
{
 int len1,len2,i;

 if ((!s1) || !(s2))
    return (0);

 len1=strlen(s1),
 len2=strlen(s2);
 if (len1 < len2)
    return(0);
 for (i=0;i<=len1-len2;i++)
 {
    if (!strncmp(&s1[i],s2,len2))
       return (1);
 }

 return (0);
}

/*--------------------------------------------------------------------*/
void d2SendApp::isdn_sleep(int sec)
{
      sleep(sec);
}
/*--------------------------------------------------------------------*/
int d2SendApp::send_alert(sms_typ *sms)
{
 int  res;
 char buf[MAXMSGLEN];
 char buf2[MAXMSGLEN];

 sprintf (buf2,"/O/31/%s/0139/",
          sms->orig);
 sprintf (buf,"%-2.2d/%-5.5d%s",sms->trn,strlen(buf2) + 10,buf2);
 sprintf (buf2,"\002%s%-2.2x\003",buf,checksum(buf));

 if (debug)
    fprintf (stderr,"gesendet %s\n",buf2);
 
if(putModem(buf2, strlen(buf2)) != TRUE)
 {
    if (debug)
       t_error ("t_snd() ");
    return (-1);
 }
 return (0);
}

/*--------------------------------------------------------------------*/
char *d2SendApp::prep_save_time(int st)
{
 time_t      t;
 struct tm  *tt;
 static char buf[20];

 if (st <= 0)
 {
    *buf = 0;
 }
 else
 {
    t = time(0) + (st * 3600);
    tt = localtime (&t);
    sprintf (buf,"%2.2d%2.2d%2.2d%2.2d%2.2d",
                  tt->tm_mday,1 + tt->tm_mon,tt->tm_year,tt->tm_hour,tt->tm_min);
 }
 return (buf);
}
/*--------------------------------------------------------------------*/
char *d2SendApp::ascii_to_ia5(char *message)
{
 int i,len;
 char *p;
 static char ia5[2001];

 if (strlen (message) > 1000)
    message[1000] = 0;

 len = strlen (message);
 for (i=0;i<len;i++)
 {
    switch (message[i] & 0x7f)
    {  /* die folgenden zeichen werden leider falsch dargestellt */
       /* sie werden auf leerzeichen gemappt */
       case 0x5F: /* '_' */
       case 0x5E: /* '^' */
       case 0x78: /* '' */
          message[i] = 0x20; /* ' ' */
    }
    sprintf (&ia5[i*2],"%-2.2x",message[i] & 0x7f);
 }

 for (p=ia5;*p!=0;p++)
    *p = (char) toupper(*p);

 return (ia5);
}
/*--------------------------------------------------------------------*/
int d2SendApp::decode_packet (char     *packet, pack_typ *pkt)
{
 int  chksum;
 char buf[1000];
 char *p,*p1;

{
char tbuf[200];

sprintf(tbuf,"decode_packet %x %x %x %c %c %c %c %c %c %c",
	*(packet+0),
	*(packet+1),
	*(packet+2),
	*(packet+3),
	*(packet+4),
	*(packet+5),
	*(packet+6),
	*(packet+7),
	*(packet+8),
	*(packet+9)
	);

write_log_protokoll(tbuf);
}

 sscanf (&packet[strlen(packet) - 2],"%x",&chksum);
 packet[strlen(packet) - 2] = 0;
 if (chksum != checksum (packet))
    return (-1); /* ungueltige checksum */

 strncpy (buf,packet,2);
 buf[2] = 0;
 pkt->trn = atoi(buf);

 pkt->op = packet[9];
 if ((pkt->op != 'O') && (pkt->op != 'R'))
    return (-2);  /* ungueltige operation */

 strncpy (buf,&packet[11],2);
 buf[2] = 0;
 pkt->ot = atoi (buf);
 if ((pkt->ot != OT_SMS_TRANSFER) && (pkt->ot != OT_CALL_INPUT))
    return (-3);  /* unbekannter (nicht erwarteter) operation type */

 if (pkt->ot == OT_SMS_TRANSFER)
 {
    if (pkt->op == 'O') /* response */
       return (-4);  /* nicht verwertbar */

    pkt->ack.ack = packet[14];
    if ((pkt->ack.ack != 'A') && (pkt->ack.ack != 'N'))
       return (-5);  /* unerwarteter Wert */

    if (pkt->ack.ack == 'A')
    {
       if (packet[16] != '/')
       {  /* dann muss hier die mvp stehen */
          strncpy (pkt->ack.mvp,&packet[16],10);
          pkt->ack.mvp[10]=0;
          p = &packet[27];
       }
       else
       {
          p = &packet[17];
       }
       /* p zeigt auf die system-message */
       if (*p == '/')
          pkt->ack.sm[0] = 0;
       else
       {
          strncpy (pkt->ack.sm,p,29);
          pkt->ack.sm[29]=0;
          p1 = strchr(pkt->ack.sm,'/');
          if (p1)
             *p1 = 0;
          strncpy (pkt->ack.empf_nr,p,16);
          pkt->ack.empf_nr[16] = 0;
          p1 = strchr(pkt->ack.empf_nr,':');
          if (p1)
             *p1 = 0;
          p1 = strchr(pkt->ack.sm,':');
          if (p1)
             *p1 = 0;
          p1++;
          /* p1 zeigt jetzt auf die empf_zeit */
          strncpy (pkt->ack.empf_zeit,p1,12);
          pkt->ack.empf_zeit[12] = 0;
       }
       return (0);
    }
    if (pkt->ack.ack == 'N')
    {
       strncpy (buf,&packet[16],2);
       buf[2]=0;
       pkt->ack.ec = atoi(buf);
       strncpy (pkt->ack.sm,&packet[19],200);
       p = strchr (pkt->ack.sm,'/');
       if (p)
          *p = 0;
    }
    return (0);
 }
 if (pkt->ot == OT_CALL_INPUT)
 {
    if (pkt->op == 'R') /* response */
       return (-7);  /* nicht verwertbar */

    /* jetzt muss es ein CALL-INPUT fuer uns sein */
    strncpy (pkt->cin.empf,&packet[14],16);
    pkt->cin.empf[16]=0;
    p = strchr (pkt->cin.empf,'/');
    if (p)
       *p = 0;

    p = strchr (&packet[14],'/');
    if (p)
       p++; /* p zeigt jetzt auf den absender */

    strncpy (pkt->cin.abs,p,16);
    pkt->cin.abs[16]=0;
    p1 = strchr (pkt->cin.abs,'/');
    if (p1)
       *p1 = 0;

    p1 = strchr (p,'/');
    if (p1)
       p1++; /* p1 zeigt jetzt auf den auth-code */

    strncpy (pkt->cin.auth,p1,200);
    pkt->cin.auth[200]=0;
    p = strchr (pkt->cin.auth,'/');
    if (p)
       *p = 0;

    p = strchr (p1,'/');
    if (p)
       p++; /* p zeigt jetzt auf den message-type */

    strncpy (buf,p,1);
    buf[1]=0;
    pkt->cin.mess_type = atoi(buf);
    p1 = p + 2; /* p1 zeigt jetzt auf die message */

    switch (pkt->cin.mess_type)
    {
       case MT_NUMERIC:
          strncpy (pkt->cin.message,p1,300);
          pkt->cin.message[300]=0;
          p = strchr (pkt->cin.message,'/');
          if (p)
             *p = 0;
          return (0);
       case MT_ALPHANUM:
          strncpy (buf,p1,300);
          buf[300] = 0;
          p = strchr (buf,'/');
          if (p)
             *p = 0;
          strcpy (pkt->cin.message,ia5_to_ascii(buf));
          return (0);
       default:
          return (-8);
    }
 }
 return (-6);
}
/*--------------------------------------------------------------------*/
char *d2SendApp::decode_ec (int ec)
{
 static char buf[100];

 switch (ec)
 {
    case 1:
       return ("Fehler in der Checksumme der Sendeanfrage");
    case 2:
       return ("Syntaxfehler in der Sendeanfrage");
    case 4:
       return ("Operation zu diesem Zeitpunkt nicht erlaubt");
    case 5:
       return ("Rufsperre zu diesem Teilnehmer aktiviert");
    case 6:
       return ("Ung}ltige Zielrufnummer");
    case 7:
       return ("Fehler bei der Authentisierung");
    case 8:
       return ("Legitimierungscode fehlerhaft");
    case 22:
       return ("Ung}ltige Zeitperiode");
    case 24:
       return ("Message ist zu lang");
    case 26:
       return ("Messageart ist f}r dieses Endger{t nicht erlaubt");
    default:
       sprintf (buf,"Unbekannter Fehlercode %d",ec);
       return (buf);
 }
}
/*--------------------------------------------------------------------*/
char *d2SendApp::timestamp_to_timestr(char *ts)
{
 static char string[30];
 char buf[3];
 int  i;

 string[0] = 0;
 for (i=3;i<6;i++)
 {
    strncpy (buf,&ts[2*i],2);
    buf[2]=0;
    strcat (string,buf);
    if (i<5)
       strcat (string,":");
    else
       strcat (string," am ");
 }

 for (i=0;i<3;i++)
 {
    strncpy (buf,&ts[2*i],2);
    buf[2]=0;
    strcat (string,buf);
    if (i<2)
       strcat (string,".");
 }

 return (string);
}

/*--------------------------------------------------------------------*/
char *d2SendApp::decode_mvp(char *mvp)
{
 static char string[30];
 char buf[3];
 int  i;

 string[0] = 0;
 for (i=0;i<3;i++)
 {
    strncpy (buf,&mvp[2*i],2);
    buf[2]=0;
    strcat (string,buf);
    if (i<2)
       strcat (string,".");
    else
       strcat (string," um ");
 }

 for (i=3;i<5;i++)
 {
    strncpy (buf,&mvp[2*i],2);
    buf[2]=0;
    strcat (string,buf);
    if (i<4)
       strcat (string,":");
 }
 return (string);
}
/*--------------------------------------------------------------------*/
char *d2SendApp::ia5_to_ascii(char *ia5)
{
 static char string[1000];
 char buf[3];
 int i,len;
 unsigned int value;

 len = strlen(ia5)/2;
 for (i=0;i<len;i++)
 {
    memset (buf,0,3);
    strncpy(buf,&ia5[2*i],2);
    if (sscanf (buf,"%x",&value) != 1)
       break;
    else
       string[i] = (char) value;
 }

 string[i] = 0;
 return (string);
}
/*--------------------------------------------------------------------*/
int d2SendApp::rcv_packet(char *packet, char *pattern,sms_typ *sms, int timeout)
{
 fxBool wasTimeout;
 int fehler_code;
 int c;
 int            flags,rec,rcode,event,offset;
 char           buf [MAXMSGLEN];
 char           buf1[MAXMSGLEN];
 char           *p,*p1;
 
*packet = 0;

 while (1)
 {
	c = isdn_getModemChar(timeout * 1000, fehler_code, wasTimeout);

	if(wasTimeout)
	{
	write_log_protokoll("rcv_packet: timeout");

     /* normaler Timeout */
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
	return(1);
	}

	if(fehler_code)
	{
	switch(fehler_code)		{
	case EAGAIN:
	case EINTR:
			continue;
	default:
	write_log_protokoll("rcv_packet: error");
             sprintf (sms->result_str,"205 Kommunikationsfehler beim Lesen: %s",
                      sys_errlist[fehler_code]);
             sms->result  = -5;
             sms->retry   = 1;
             sms->errno   = fehler_code;
	     return (-1);
					}
	}

    if(c == EOF)
    { /* normaler Timeout */
	write_log_protokoll("rcv_packet: timeout");
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
       return (1);
    }
	rec=1;
	buf[0]=c;

    /* jetzt ist mal wieder ein Zeichen da */

    
    if (rec > 0)
    {
       buf[rec] = 0;
       /* jetzt mu xon xoff raus */
       for (p=buf,p1=buf1,*p1=0;*p;p++)
       {
          if ((*p != 17) && (*p != 19))
          {
             *p1 = *p;
             p1++;
             *p1 = 0;
          }
       }
       strcat (packet,buf1);

	write_log_protokoll("rcv_packet: ");
	write_log_protokoll(packet);

	if(strcmp(packet,"NO ANSWER") == 0)
	{
	return(-3);
	}

	if(strcmp(packet,"BUSY") == 0)
	{
	return(-2);
	}

       if (*pattern)
       {
          offset = strlen(packet) - strlen(pattern);
          if (offset >= 0)
          {
             if (!strcmp(&packet[offset],pattern))
             {
                if (debug)
                {
                   strcpy (buf,packet);
                   for (p=buf;*p;p++)
                      if (*p=='\r')
                         *p='!';
                   fprintf (stderr,"\nEmpfangen %s\n",buf);
                }
                return (0);
             }
          }
       }
       continue;
    }
 }
}
/*--------------------------------------------------------------------*/
int d2SendApp::rcv_string_packet(char *packet, char pattern ,sms_typ *sms, 
	int timeout, int maxlen)
{
 fxBool wasTimeout;
 int fehler_code;
 int c;
 int            flags,rec,rcode,event,offset;
 char           buf [MAXMSGLEN];
 char           buf1[MAXMSGLEN];
 char           *p,*p1;
 
*packet = 0;

 while (1)
 {
	c = isdn_getModemChar(timeout * 1000, fehler_code, wasTimeout);

	if(wasTimeout)
	{
	write_log_protokoll("rcv_packet: timeout");

     /* normaler Timeout */
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
             sprintf (sms->result_str,"321 Keine Antwort vom SMS empfangen.");
             sms->result  = -5;
             sms->retry   = 1;
             sms->errno   = -1;
	return(1);
	}

	if(fehler_code)
	{
	switch(fehler_code)		{
	case EAGAIN:
	case EINTR:
			continue;
	default:
	write_log_protokoll("rcv_packet: error");
             sprintf (sms->result_str,"322 Kommunikationsfehler (Read): %s", sys_errlist[fehler_code]);
             sms->result  = -5;
             sms->retry   = 1;
             sms->errno   = fehler_code;
	     return (-1);
					}
	}

    if(c == pattern) return(0);

    if(c == EOF)
    { /* normaler Timeout */
	write_log_protokoll("rcv_packet: timeout");
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
       return (1);
    }
	rec=1;
	buf[0]=c;

    /* jetzt ist mal wieder ein Zeichen da */

    
    if (rec > 0)
    {
       buf[rec] = 0;
       /* jetzt mu xon xoff raus */
       for (p=buf,p1=buf1,*p1=0;*p;p++)
       {
          if ((*p != 17) && (*p != 19))
          {
             *p1 = *p;
             p1++;
             *p1 = 0;
          }
       }
       strcat (packet,buf1);
	if(strlen(packet) >= maxlen) return(0);

	write_log_protokoll("rcv_packet: ");
	write_log_protokoll(packet);

	if(strcmp(packet,"NO ANSWER") == 0)
	{
	return(-3);
	}

	if(strcmp(packet,"BUSY") == 0)
	{
	return(-2);
	}

       continue;
    }
 }
}
/*--------------------------------------------------------------------*/

