/*	$Id: ftpSendApp.c++,v 1.43 1996/08/21 21:02:47 sam Rel $ */
/*
 * Copyright (c) 1994-1996 Sam Leffler
 * Copyright (c) 1994-1996 Silicon Graphics, Inc.
 * HylaFAX is a trademark of Silicon Graphics
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/file.h>
#include <signal.h>
#include <ctype.h>

#include "FaxMachineInfo.h"
#include "FaxAcctInfo.h"
#include "UUCPLock.h"
#include "ftpSendApp.h"
#include "FaxRequest.h"
#include "Dispatcher.h"
#include "StackBuffer.h"
#include "Sys.h"
#include "ixo.h"

#include "config.h"

#define MAX_RETRY        4        /* also max 4 sende versuche */

static char *ErrorIntern =
"Die Datei wurde nicht bertragen. Der Grund ist ein interner Fehler in den Kommunikationsanwendung. Wenden Sie sich zu Klaerung mit folgender Fehlermeldung an die PDS-Hotline:";

extern char *sys_errlist[];

static xmt_typ XMT_STRUCTURE;

#include "lms.h"

extern "C" int lms_create_msgq();
extern "C" int lms_request(int, char *, char *, char *);

/*
 * Send messages with IXO/TAP protocol.
 */

static void t_error (char *txt)
{
}

static int fp_write_nr=0;
static FILE * fp_write_file= NULL;
static void write_log_protokoll(const char *s)
{

return;

fp_write_nr++;
if( fp_write_file == NULL)
{
fp_write_file= ::fopen("/tmp/ftp.log","a+");
if(fp_write_file == NULL) return;
}

::fprintf(fp_write_file,"\n%d %s",fp_write_nr, s);
::fflush(fp_write_file);
}



ftpSendApp* ftpSendApp::_instance = NULL;

ftpSendApp::ftpSendApp(const fxStr& devName, const fxStr& devID)
    : ModemServer(devName, devID)
{
    ready = FALSE;
    modemLock = NULL;
    setupConfig();

    fxAssert(_instance == NULL, "Cannot create multiple ftpSendApp instances");
    _instance = this;
}

ftpSendApp::~ftpSendApp()
{
    delete modemLock;
}

ftpSendApp& ftpSendApp::instance() { return *_instance; }

void
ftpSendApp::initialize(int argc, char** argv)
{
    ModemServer::initialize(argc, argv);
    faxApp::initialize(argc, argv);

    // NB: must do last to override config file information
    for (GetoptIter iter(argc, argv, getOpts()); iter.notDone(); iter++)
	switch (iter.option()) {
	case 'l':			// do uucp locking
	    modemLock = getUUCPLock(getModemDevice());
	    break;
	case 'c':			// set configuration parameter
	    readConfigItem(iter.optArg());
	    break;
	}
}

void
ftpSendApp::open()
{
    ModemServer::open();
    faxApp::open();
}

void
ftpSendApp::close()
{
    if (isRunning()) {
	if (state == ModemServer::SENDING) {
	    /*
	     * Terminate the active job and let the send
	     * operation complete so that the transfer is
	     * logged and the appropriate exit status is
	     * returned to the caller.
	     */
	    ModemServer::abortSession();
	} else {
	    ModemServer::close();
	    faxApp::close();
	}
    }
}

FaxSendStatus
ftpSendApp::send(const char* filename)
{
	write_log_protokoll("send:");
	write_log_protokoll(filename);
        

    int fd = Sys::open(filename, O_RDWR);
    if (fd >= 0) {
	if (flock(fd, LOCK_EX) >= 0) {
	    FaxRequest* req = new FaxRequest(filename, fd);
	    fxBool reject;
	    if (req->readQFile(reject) && !reject) {

		if (1==1) {
		    FaxMachineInfo info;


		    info.updateConfig(canonicalizePhoneNumber(req->number));
		    FaxAcctInfo ai;

		    ai.start = Sys::now();

		    sendFtp(*req, info);

		    ai.jobid = req->jobid;
		    ai.jobtag = req->jobtag;
		    ai.user = req->mailaddr;
		    ai.duration = Sys::now() - ai.start;
		    ai.conntime = getConnectTime();
		    ai.commid = req->commid;
		    ai.device = getModemDeviceID();
		    ai.dest = req->external;
		    ai.csi = "";
		    ai.params = 0;
		    if (req->status == send_done)
			ai.status = "";
		    else
			ai.status = req->notice;
		    if (!ai.record("PAGE"))
			logError("Error writing %s accounting record, dest=%s",
			    "PAGE", (const char*) ai.dest);
		} 
		    req->writeQFile(); 		// update on-disk copy
		return (req->status);		// return status for exit
	    } else
		delete req;
	    logError("Could not read request file");
	} else
	    logError("Could not lock request file: %m");
	Sys::close(fd);
    } else
	logError("Could not open request file: %m");
    return (send_failed);
}

void
ftpSendApp::sendFtp(FaxRequest& req, FaxMachineInfo& info)
{
    if (lockModem()) {
	beginSession(req.number);
	req.commid = getCommID();
	traceServer("SEND PAGE: JOB %s DEST %s COMMID %s"
	    , (const char*) req.jobid
	    , (const char*) req.external
	    , (const char*) req.commid
	);
	/*
	 * Setup tty parity; per-destination information takes
	 * precedence over command-line arguments/config params;
	 * otherwise the IXO/TAP spec is used (set below).
	 */
	if (info.getPagerTTYParity() != "")
	    pagerTTYParity = info.getPagerTTYParity();
	// NB: may need to set tty baud rate here XXX
	if (setupModem()) {
	    changeState(SENDING);
	    fxStr emsg;
	    setServerStatus("Sending Ftp " | req.jobid);
	    /*
	     * Construct the phone number to dial by applying the
	     * dialing rules to the user-specified dialing string.
	     */
	    fxStr msg;
	    msg="";

		sendFtp(req, info, prepareDialString(req.number), msg);
	    changeState(MODEMWAIT);		// ...sort of...
	} else
	    sendFailed(req, send_retry, "Can not setup modem", 4*pollModemWait);
	discardModem(TRUE);
	endSession();
	unlockModem();
    } else {
	sendFailed(req, send_retry, "Can not lock modem device",2*pollLockWait);
    }
}

fxBool
ftpSendApp::prepareMsg(FaxRequest& req, FaxMachineInfo& info, fxStr& msg)
{
    return (TRUE);
}

void
ftpSendApp::sendFailed(FaxRequest& req, FaxSendStatus stat, const char* notice, u_int tts)
{
    req.status = stat;
    req.notice = notice;
    /*
     * When requeued for the default interval (requeueOther),
     * don't adjust the time-to-send field so that the spooler
     * will set it according to the default algorithm that 
     * uses the command-line parameter and a random jitter.
     */
    if (tts != requeueOther)
	req.tts = Sys::now() + tts;
    traceServer("PDSFTP FAILED: %s", notice);
}

void
ftpSendApp::sendFtp(FaxRequest& req, FaxMachineInfo& info, const fxStr& number, const fxStr& msg)
{
int lms_status;


    connTime = 0;				// indicate no connection
    if (!getModem()->dataService()) {
	sendFailed(req, send_failed, "Unable to configure modem for data use");
	return;
    }
    req.notice = "";
    fxStr notice;
    time_t pageStart = Sys::now();



/* Original Stand */
/*
    CallStatus callstat = getModem()->dial(number, notice);
	write_log_protokoll(notice);
*/

/* +++ Neu +++ */

    strcpy(XMT_STRUCTURE.telno, number);
    CallStatus callstat;

    callstat= ClassModem::OK;

lms_status= anforderung_channeld(XMT_STRUCTURE.telno);

if(lms_status == 2)
	{
    write_log_protokoll("channeld: Anforderung wurde negativ quittiert");
    notice = "channeld: alle b kanaele sind besetzt";
    req.status = send_retry;
	}



if(lms_status != 2)
    callstat = open_xmt(&XMT_STRUCTURE);

/* +++ Ende Neu ++++ */


    if (lms_status != 2 && callstat != ClassModem::OK)
	{
    notice = "289 no connect bmft server";
	}

    if (callstat == ClassModem::OK)
	connTime = Sys::now();			// connection start time
    (void) abortRequested();			// check for user abort
	
    if (callstat == ClassModem::OK && !abortCall) {

    	write_log_protokoll("Connect ist OK");

	req.ndials = 0;				// consec. failed dial attempts
	req.tottries++;				// total answered calls
	req.totdials++;				// total attempted calls
	info.setCalledBefore(TRUE);
	info.setDialFailures(0);

	req.status = send_ok;			// be optimistic



	    while (req.requests.length() > 0) {	// messages


		u_int i = req.findRequest(FaxRequest::send_data);
		if (i == fx_invalidArrayIndex)
		    break;

		strcpy(XMT_STRUCTURE.sourcepath, req.requests[i].item);
		strcpy(XMT_STRUCTURE.telno, number);

    		write_log_protokoll("Data File:");
    		write_log_protokoll(XMT_STRUCTURE.sourcepath);
    		write_log_protokoll("Number:");
    		write_log_protokoll(number);


if(lms_status != 2)
{

	XMT_STRUCTURE.result=0;
	XMT_STRUCTURE.errno=0;
	XMT_STRUCTURE.duration=0;
	XMT_STRUCTURE.diagnostic=0;
	XMT_STRUCTURE.cause=0;
	XMT_STRUCTURE.charge=0;
	XMT_STRUCTURE.result_str[0]=0;
    	XMT_STRUCTURE.gebuehr=0;

        ModemServer::setRawModeOn();
    	ftp_dialog(&XMT_STRUCTURE);
	freigabe_channeld(XMT_STRUCTURE.telno);
        ModemServer::setRawModeOff();

    req.gebuehr= XMT_STRUCTURE.gebuehr;

    if(XMT_STRUCTURE.result == 0)
    {
    write_log_protokoll("ftp_dialog ist OK");
    req.status = send_ok;
    }
    else
    {
    req.status = send_failed;
    if(XMT_STRUCTURE.retry) req.status = send_retry;
    sendFailed(req, req.status, XMT_STRUCTURE.result_str);
    notice = XMT_STRUCTURE.result_str;


    if(req.status == send_failed) write_log_protokoll("send_failed");
    if(req.status == send_retry) write_log_protokoll("send_retry");
    if(req.status == send_ok) write_log_protokoll("send_ok");
    }

}



if(lms_status == 2)
{
if(req.tottries) req.tottries--;
if(req.totdials) req.totdials--;
callstat= ClassModem::BUSY;
notice = "channeld: alle b kanaele sind besetzt";
req.status = send_retry;
req.tts = time(0) + requeueProto;
break;
}





		    if (req.status == send_retry) {
			req.tts = time(0) + requeueProto;
			break;
		    }
		
		req.requests.remove(i);
		break;
	    }




	if (req.status == send_ok) {
	    time_t now = Sys::now();
	    traceServer("SEND FTP: FROM " | req.mailaddr
		| " TO " | req.external | " (sent in %s)",
		fmtTime(now - pageStart));
	    info.setSendFailures(0);
	} else {

	    sendFailed(req, req.status, notice);
    	    write_log_protokoll("Es trat ein Fehler auf!");
    	    write_log_protokoll(req.notice);

	    info.setSendFailures(info.getSendFailures()+1);
	    info.setLastSendFailure(req.notice);


	}
    } else if (!abortCall) {
	sendFailed(req, send_failed, "Connect Error");
	
	/*
	 * Analyze the call status codes and selectively decide if the
	 * job should be retried.  We try to avoid the situations where
	 * we might be calling the wrong number so that we don't end up
	 * harrassing someone w/ repeated calls.
	 */
	req.ndials++;
	req.totdials++;			// total attempted calls
	switch (callstat) {
	case ClassModem::NOCARRIER:	// no carrier detected on remote side
	    /*
	     * Since some modems can not distinguish between ``No Carrier''
	     * and ``No Answer'' we offer this configurable hack whereby
	     * we'll retry the job <n> times in the face of ``No Carrier''
	     * dialing errors; if we've never previously reached a modem
	     * at that number.  This should not be used except if
	     * the modem is incapable of distinguishing between
	     * ``No Carrier'' and ``No Answer''.
	     */
	    if (!info.getCalledBefore() && req.ndials > noCarrierRetrys) {
		sendFailed(req, send_failed, notice);
		break;
	    }
	    /* fall thru... */
	case ClassModem::NODIALTONE:	// no local dialtone, possibly unplugged
	case ClassModem::ERROR:		// modem might just need to be reset
	case ClassModem::FAILURE:	// modem returned something unexpected
	case ClassModem::BUSY:		// busy signal
	case ClassModem::NOANSWER:	// no answer or ring back
	    sendFailed(req, send_retry, notice, requeueTTS[callstat]);
	    /* fall thru... */
	case ClassModem::OK:		// call was aborted by user
	    break;
	}
	if (callstat != ClassModem::OK) {
	    info.setDialFailures(info.getDialFailures()+1);
	    info.setLastDialFailure(req.notice);
	}
    }
    if (abortCall)
	sendFailed(req, send_failed, "Job aborted by user");
    else if (req.status == send_retry) {
	if (req.totdials == req.maxdials) {
	    notice = req.notice | "; too many attempts to dial";
    	    write_log_protokoll("send_failed (maxdials): too many attempts to dial");
	    sendFailed(req, send_failed, notice);
	} else if (req.tottries == req.maxtries) {
	    notice = req.notice | "; too many attempts to send";
    	    write_log_protokoll("send_failed (maxtries): too many attempts to send");
	    sendFailed(req, send_failed, notice);
	}
    }
    /*
     * Cleanup after the call.  If we have new information on
     * the client's remote capabilities, the machine info
     * database will be updated when the instance is destroyed.
     */
    getModem()->hangup();
    /*
     * This may not be exact--the line may already have been
     * dropped--but it should be close enough unless the modem
     * gets wedged and the hangup work times out.  Also be
     * sure to register a non-zero amount of connect time so
     * that folks doing accounting can adjust charge-back costs
     * to reflect any minimum connect time tarrifs imposted by
     * their PTT (e.g. calls < 1 minute are rounded up to 1 min.)
     */
    if (connTime) {
	connTime = Sys::now() - connTime;
	if (connTime == 0)
	    connTime++;
    }
}

u_int
ftpSendApp::getResponse(fxStackBuffer& buf, long secs)
{
    return (0);
}

/*
 * Scan through a buffer looking for a potential
 * code byte return in a protocol response.
 * This is needed because some pager services such
 * as PageNet intersperse protocol messages and
 * verbose text messages.
 */
static fxBool
scanForCode(const u_char*& cp, u_int& len)
{
    return (TRUE);
}

fxBool
ftpSendApp::pagePrologue(FaxRequest& req, const FaxMachineInfo& info, fxStr& emsg)
{
     return (TRUE);
}

fxBool
ftpSendApp::pageGoAhead(FaxRequest& req, const FaxMachineInfo&, fxStr& emsg)
{
     return (TRUE);
}

/*
 * Calculate packet checksum and append to buffer.
 */
static void
addChecksum(fxStackBuffer& buf)
{
}

fxBool
ftpSendApp::sendPagerMsg(FaxRequest& req, faxRequest& preq, const fxStr& msg, fxStr& emsg)
{
	return (TRUE);
}

fxBool
ftpSendApp::pageEpilogue(FaxRequest& req, const FaxMachineInfo&, fxStr& emsg)
{
    return (TRUE);
}

void
ftpSendApp::traceResponse(const fxStackBuffer& buf)
{
}

void
ftpSendApp::traceIXOCom(const char* dir, const u_char* data, u_int cc)
{
    if (log) {
	if ((logTracingLevel& FAXTRACE_IXO) == 0)
	    return;
    } else if ((tracingLevel & FAXTRACE_IXO) == 0)
	return;

    fxStackBuffer buf;
    for (u_int i = 0; i < cc; i++) {
	u_char b = data[i];
	if (!isprint(b)) {
	    const char* octdigits = "01234567";
	    char s[4];
	    s[0] = '\\';
	    s[1] = octdigits[b>>6];
	    s[2] = octdigits[(b>>3)&07];
	    s[3] = octdigits[b&07];
	    buf.put(s, 4);
	} else
	    buf.put(b);
    }
    traceStatus(FAXTRACE_IXO, "%s <%u:%.*s>",
	dir, cc, buf.getLength(), (const char*) buf);
}

void
ftpSendApp::traceIXO(const char* fmt ...)
{
    va_list ap;
    va_start(ap, fmt);
    vtraceStatus(FAXTRACE_PROTOCOL, fmt, ap);
    va_end(ap);
}

fxBool
ftpSendApp::putModem(const void* data, int n, long ms)
{
    traceIXOCom("<--",  (const u_char*) data, n);
    return (putModem1(data, n, ms));
}

time_t ftpSendApp::getConnectTime() const	{ return (connTime); }

/*
 * Configuration support.
 */

void
ftpSendApp::resetConfig()
{
    ModemServer::resetConfig();
    setupConfig();
}

#define	N(a)	(sizeof (a) / sizeof (a[0]))

const ftpSendApp::stringtag ftpSendApp::strings[] = {
{ "ixoservice",		&ftpSendApp::ixoService,	IXO_SERVICE },
{ "ixodeviceid",	&ftpSendApp::ixoDeviceID,	IXO_DEVICEID },
{ "pagerttyparity",	&ftpSendApp::pagerTTYParity,	"even" },
};
const ftpSendApp::stringtag ftpSendApp::atcmds[] = {
{ "pagersetupcmds",	&ftpSendApp::pagerSetupCmds },
};
const ftpSendApp::numbertag ftpSendApp::numbers[] = {
{ "pagermaxmsglength",	&ftpSendApp::pagerMaxMsgLength,128 },
{ "ixomaxunknown",	&ftpSendApp::ixoMaxUnknown,	IXO_MAXUNKNOWN },
{ "ixoidprobe",		&ftpSendApp::ixoIDProbe,	IXO_IDPROBE },
{ "ixoidtimeout",	&ftpSendApp::ixoIDTimeout,	IXO_IDTIMEOUT },
{ "ixologinretries",	&ftpSendApp::ixoLoginRetries,	IXO_LOGINRETRIES },
{ "ixologintimeout",	&ftpSendApp::ixoLoginTimeout,	IXO_LOGINTIMEOUT },
{ "ixogatimeout",	&ftpSendApp::ixoGATimeout,	IXO_GATIMEOUT },
{ "ixoxmitretries",	&ftpSendApp::ixoXmitRetries,	IXO_XMITRETRIES },
{ "ixoxmittimeout",	&ftpSendApp::ixoXmitTimeout,	IXO_XMITTIMEOUT },
{ "ixoacktimeout",	&ftpSendApp::ixoAckTimeout,	IXO_ACKTIMEOUT },
};

void
ftpSendApp::setupConfig()
{
    int i;
    for (i = N(strings)-1; i >= 0; i--)
	(*this).*strings[i].p = (strings[i].def ? strings[i].def : "");
    for (i = N(atcmds)-1; i >= 0; i--)
	(*this).*atcmds[i].p = (atcmds[i].def ? atcmds[i].def : "");
    for (i = N(numbers)-1; i >= 0; i--)
	(*this).*numbers[i].p = numbers[i].def;
}

fxBool
ftpSendApp::setConfigItem(const char* tag, const char* value)
{
    u_int ix;
    if (findTag(tag, (const tags*)atcmds, N(atcmds), ix)) {
	(*this).*atcmds[ix].p = parseATCmd(value);
    } else if (findTag(tag, (const tags*) strings, N(strings), ix)) {
	(*this).*strings[ix].p = value;
    } else if (findTag(tag, (const tags*)numbers, N(numbers), ix)) {
	(*this).*numbers[ix].p = getNumber(value);
    } else
	return (ModemServer::setConfigItem(tag, value));
    return (TRUE);
}
#undef	N

u_int
ftpSendApp::getConfigParity(const char* value) const
{
char tbuf[400];

	write_log_protokoll("ftpSendApp::getConfigParity:");
	write_log_protokoll(value);

    if (streq(value, "even"))
	return (EVEN);
    else if (streq(value, "odd"))
	return (ODD);
    else if (streq(value, "none"))
	return (NONE);
    else {
	sprintf(tbuf,"Unknown pager tty parity %s ignored; using EVEN", value);
	logError(tbuf);
	return (EVEN);				// per IXO/TAP spec
    }
}

/*
 * Modem and TTY setup
 */
fxBool 
ftpSendApp::setupModem()
{
    return (ModemServer::setupModem() &&
	setParity((Parity) getConfigParity(pagerTTYParity)));
}

/*
 * Modem locking support.
 */

fxBool
ftpSendApp::lockModem()
{
    return (modemLock ? modemLock->lock() : TRUE);
}

void
ftpSendApp::unlockModem()
{
    if (modemLock)
	modemLock->unlock();
}

/*
 * Notification handlers.
 */

/*
 * Handle notification that the modem device has become
 * available again after a period of being unavailable.
 */
void
ftpSendApp::notifyModemReady()
{
    ready = TRUE;
}

/*
 * Handle notification that the modem device looks to
 * be in a state that requires operator intervention.
 */
void
ftpSendApp::notifyModemWedged()
{
    if (!sendModemStatus(getModemDeviceID(), "W"))
	logError("MODEM %s appears to be wedged",
	    (const char*) getModemDevice());
    close();
}

/*
 * Miscellaneous stuff.
 */

static void
usage(const char* appName)
{
    faxApp::fatal("usage: %s -m deviceID [-t tracelevel] [-l] qfile ...",
	appName);
}

static void
sigCleanup(int s)
{
    signal(s, fxSIGHANDLER(sigCleanup));
    logError("CAUGHT SIGNAL %d", s);
    ftpSendApp::instance().close();
    if (!ftpSendApp::instance().isRunning())
	_exit(send_failed);
}

int
main(int argc, char** argv)
{
write_log_protokoll("ftpsend Programm gestartet");

    faxApp::setupLogging("ftpSend");


    fxStr appName = argv[0];
    u_int l = appName.length();
    appName = appName.tokenR(l, '/');

    faxApp::setOpts("c:m:l");

    fxStr devID;
    for (GetoptIter iter(argc, argv, faxApp::getOpts()); iter.notDone(); iter++)
	switch (iter.option()) {
	case 'm': devID = iter.optArg(); break;
	case '?': usage(appName);
	}
    if (devID == "")
	usage(appName);

    ftpSendApp* app = new ftpSendApp(faxApp::idToDev(devID), devID);

    signal(SIGTERM, fxSIGHANDLER(sigCleanup));
    signal(SIGINT, fxSIGHANDLER(sigCleanup));

    app->initialize(argc, argv);
    app->open();
    while (app->isRunning() && !app->isReady())
	Dispatcher::instance().dispatch();
    FaxSendStatus status;
    if (app->isReady())
	status = app->send(argv[optind]);
    else
	status = send_retry;
    app->close();
    return (status);
}



#define MODEMSERVICE  "smsc_a_ftp"
#define ISDNSERVICE   "smsc_d_ftp"

#define MAXMSGLEN     4000
#define MAXRETRY      3        /* also max 3 sende versuche */
#define MAXMSG        4        /* max anzahl kurzmitt. je session */
#define MAXCR         8        /* max anzahl CR, bevor aufgelegt wird */

#define A_START          0
#define A_SEND_REQ       1
#define A_SEND_ACK       2
#define A_RCV_ANSW       3
#define A_END            4
#define A_SEND_ALERT     5
#define A_SEND_CR        6
#define A_SEND_ID        7
#define A_RCV_ID         8
#define A_RCV_LOGINRES   9
#define A_SEND_QUERY    10
#define A_PAR_QUERY     11

#define TOUT_CR       1
#define TOUT_ACK      10
#define TOUT_ID       2
#define TOUT_NOTE     17
#define TOUT_TOTAL    60
#define TOUT_CONNECT  40

#define SMSC_MODEM1        "01712092522"
#define SMSC_MODEM2        "0911663070"
#define SMSC_MODEM3        "0911663071"
#define SMSC_ISDN1         ""
#define SMSC_ISDN2         ""
#define SMSC_ISDN3         ""

/*--------------------------------------------------------------------*/

#ifdef TEST_MAIN
static int    debug = 1;
#else
static int    debug = 0;
#endif



/*--------------------------------------------------------------------*/
int ftpSendApp::isinstr(char *s1, char *s2)
{
 int len1,len2,i;

 if ((!s1) || !(s2))
    return (0);

 len1=strlen(s1),
 len2=strlen(s2);
 if (len1 < len2)
    return(0);
 for (i=0;i<=len1-len2;i++)
 {
    if (!strncmp(&s1[i],s2,len2))
       return (1);
 }

 return (0);
}

/*--------------------------------------------------------------------*/
/* Sucht nach 'muster' in 'str' und gibt Pointer auf Anfang zurueck
*/
char *ftpSendApp::strpos( char *str, char *muster)
{
char *hilf;
uint lenmuster = strlen (muster);

   do {
        hilf = strchr(str,*muster);
        if (hilf != (char *) NULL)
        {
           if (strlen (hilf) < lenmuster)  break;       /* BS */
           if (strncmp(hilf,muster, lenmuster) == 0)
              return(hilf);
           else str = ++hilf;
        }
   }
   while(hilf != (char *) NULL );
   return ((char *) NULL);
}

/*-----------------------------------------------------------------------------
** isdn_sleep()
**-----------------------------------------------------------------------------
** Interner Sleep-Befehl. Wenn die Shellvariable Debug gesetzt ist
** wird eine debuggergerechte aber rechenintensive Funktion benutzt
**
** Uebergabe:   int   sec     Sekunden
**
** Return   :   Keiner
*/


void ftpSendApp::isdn_sleep(int sec)
{
      sleep(sec);
}
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
int ftpSendApp::anforderung_channeld(char *nr)
{

if(lms_create_msgq()) return(1);


write_log_protokoll("\nDer Channeld wurde kontaktiert!");

if(lms_request(MSG_ANFORDERUNG, LMS_BMFT_SERVICE, nr, "..."))
{
write_log_protokoll("\nAnforderung wurde negativ quittiert!");
return(2);
}



return(0);
}
/*--------------------------------------------------------------------*/
void ftpSendApp::freigabe_channeld(char *nr)
{
lms_request(MSG_FREIGABE, LMS_BMFT_SERVICE, nr, "...");
}
/*--------------------------------------------------------------------*/
CallStatus ftpSendApp::open_xmt(xmt_typ *xmt)
{
char nebenstelle[200];
char dialog_format[200];
char dialog_text[200];
int rc;
char buf[1024];

strcpy(dialog_format,ModemServer::dialCmd);
sprintf(dialog_text,dialog_format,xmt->telno);
strcat(dialog_text,"\r");


write_log_protokoll("dialog_text-->");
write_log_protokoll(dialog_text);

rc=rcv_packet(buf,"....",xmt, 2);
flushModemInput();

sprintf(buf,"at&F\r");
if(putModem(buf, strlen(buf)) != TRUE)
{
	write_log_protokoll("Ausgabe at&F fehlerhaft");
}

rc=rcv_packet(buf,"OK",xmt, 10);
if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}

sprintf(buf,"atE0\r");
if(putModem(buf, strlen(buf)) != TRUE)
{
	write_log_protokoll("Ausgabe atE0 fehlerhaft");
}

rc=rcv_packet(buf,"OK",xmt, 10);
if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}

sprintf(buf,"at&x0\r");
if(putModem(buf, strlen(buf)) != TRUE)
{
	write_log_protokoll("Ausgabe at&x0 fehlerhaft");
}


rc=rcv_packet(buf,"OK",xmt, 10);
if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}



sprintf(buf,"ats14=3\r");
if(putModem(buf, strlen(buf)) != TRUE)
{
write_log_protokoll("Ausgabe ats14=3 fehlerhaft");
}

rc=rcv_packet(buf,"OK",xmt, 10);
if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}



sprintf(buf,"ats19=160\r");
if(putModem(buf, strlen(buf)) != TRUE)
{
write_log_protokoll("Ausgabe ats19=160 fehlerhaft");
}

rc=rcv_packet(buf,"OK",xmt, 10);
if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}









    strcpy(nebenstelle,"at&e");
    ModemServer::getNebenstelle(&nebenstelle[4]);
    strcat(nebenstelle,"\r");


if(putModem(nebenstelle, strlen(nebenstelle)) != TRUE)
{
	write_log_protokoll("Ausgabe at&e2 fehlerhaft");
}

rc=rcv_packet(buf,"OK",xmt, 10);
if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}





/* sprintf(buf,"atd%s\r",xmt->telno); */

if(putModem(dialog_text, strlen(dialog_text)) != TRUE)
{
	write_log_protokoll("Ausgabe atd fehlerhaft");
}


rc=rcv_packet(buf,"CONNECT",xmt, 10);

if(rc)
{
switch(rc)	{
case -3:
	return(ClassModem::NOANSWER);
	break;
case -2:
	return(ClassModem::BUSY);
	break;
default:
	return(ClassModem::NOANSWER);
	break;
		}
}

flushModemInput();
return(ClassModem::OK);
}
/*--------------------------------------------------------------------*/
int ftpSendApp::ftp_dialog(xmt_typ *xmt)
{
 job_typ job;

 job.starttime= time(0);

 xmt->diagnostic = 0;
 xmt->result     = 0;
 xmt->retry      = 0;
 xmt->charge     = 0;
 xmt->duration   = 0;
 xmt->result_str[0] = 0;

 if (open_file(xmt,&job))
    return (-1);

 write_log_protokoll("Die Datei wurde geoeffnet.");
 xmit_file(xmt,&job);
 close_con(xmt,&job);
 fclose(job.fptr);
 return (xmt->result);
}
/*--------------------------------------------------------------------*/
int ftpSendApp::cause_diag(int cause)
{
 switch (cause)
 {
    case 0x01: /* no channel avail */
    case 0x8a: /* no channel avail */
       return (D_NOCHAN);
    case 0x08: /* cannot activate L1 */
    case 0xb9: /* out of order */
       return (D_NOLAY1);
    case 0x02:
    case 0x0a:
    case 0x39:
    case 0x09:
    case 0x81: /* invalid call reference value */
       return (D_PROTO);
    case 0x03:
       return (D_INTERNAL);
    case 0x80:
       return (D_DISCONNECT);
    case 0xa1: /* busy */
    case 0xbb: /* user access busy */
       return (D_OCCUPIED);
    case 0xbd: /* incoming calls barred */
    case 0xbe: /* call rejected */
       return (D_DISCHAR);
    case 0xd9: /* network congestion */
       return (D_NETLOAD);
    case 0xb5:
       return (D_NOPARTN);
    case 0xba:
       return (D_NOANSWE);
    default :
       return (D_UNKNOWN);
 }
}
/*--------------------------------------------------------------------*/
char *ftpSendApp::cause_text(int cause)
{
char errbuf[101];

 switch (cause)
 {
    case 0x01: /* no channel avail */
    case 0x8a: /* no channel avail */
       return ("Kein B-Kanal verf}gbar");
    case 0x08: /* cannot activate L1 */
       return ("Kann nicht auf den ISDN-Anschluss zugreifen");
    case 0x02:
       return ("Ung}ltige Protokoll-Optionen");
    case 0x03:
       return ("Ung}ltige ISDN-Adresse");
    case 0x0a:
       return ("Protokoll-Verletztung auf Schicht 2");
    case 0x39:
       return ("Interner Protokoll-Fehler");
    case 0x09: /* cannot get TEI */
       return ("Kann kein TEI holen");
    case 0x80:
       return ("Verbindung vom Gegenseite unterbrochen");
    case 0x81: /* invalid call reference value */
       return ("Ung}ltiger Ruf-Referenzwert");
    case 0xa1: /* busy */
    case 0xbb: /* user access busy */
       return ("Anschluss ist besetzt");
    case 0xb9: /* out of order */
       return ("Anschluss ist ausser Betreib");
    case 0xbd: /* incoming calls barred */
       return ("Eingehende Rufe werden abgelehnt");
    case 0xbe: /* call rejected */
       return ("Ruf wurde abgewiesen");
    case 0xd9: /* network congestion */
       return ("Vor}bergehende ISDN-Netzwerk}berlastung");
    case 0xb5:
       return ("Kein Anschluss unter dieser Nummer");
    case 0xba:
       return ("Gegenstelle hebt nicht ab");
    default :
       sprintf(errbuf, "Fehler %x", cause);
       return(errbuf);
 }
}
/*--------------------------------------------------------------------*/
int ftpSendApp::do_retry(int cause)
{
 switch (cause)
 {
    case 0x01: /* no channel avail */
    case 0x08: /* cannot activate L1 */
    case 0x09: /* cannot get TEI */
    case 0x81: /* invalid call reference value */
    case 0x8a: /* no channel avail */
    case 0xa1: /* busy */
    case 0xb9: /* out of order */
    case 0xbb: /* user access busy */
    case 0xbd: /* incoming calls barred */
    case 0xbe: /* call rejected */
    case 0xd9: /* network congestion */
    case 0xda: /* remote user initiated */
    case 0xf0: /* local procedure error */
    case 0xf1:
    case 0xf2:
    case 0xf3:
    case 0xf4:
       return (1);
    default :
       return (0); /* es macht keine sinn es nochmal zu versuchen */
 }
}

/*--------------------------------------------------------------------*/
int ftpSendApp::close_con(xmt_typ *xmt, job_typ *job)
{
int rc;
char buf[80];

  isdn_sleep(2);
  putModem("+++", 3);
  isdn_sleep(5);

/*  xmt->charge = isi_getcharge(job->confd); */
 xmt->duration = time(0) - job->starttime;

  putModem("ath\r", 4);
  rc=rcv_packet(buf,"OK",xmt, 10);

if(rc) return(0);

  putModem("ati3\r", 5);
  rc=rcv_packet(buf,"Linux ISDN\r\n",xmt, 4);
  if(rc) return(0);

  /* maximal 20 Zeichen einlesen (bis CR) */ 
  rc=rcv_string_packet(buf,'\r', xmt, 1, 4);
  if(rc) return(0);

 
 sscanf(buf, "%d",&xmt->gebuehr);

 {
 char tbuf[40];

 sprintf(tbuf,"Gebuehr: %d",xmt->gebuehr);
 write_log_protokoll(tbuf);

 }


 return (0);
}

/*--------------------------------------------------------------------*/
int ftpSendApp::rcv_string_packet(char *packet, char pattern ,xmt_typ *xmt, 
	int timeout, int maxlen)
{
 fxBool wasTimeout;
 int fehler_code;
 int c;
 int            flags,rec,rcode,event,offset;
 char           buf [MAXMSGLEN];
 char           buf1[MAXMSGLEN];
 char           *p,*p1;
 
*packet = 0;

 while (1)
 {
	c = isdn_getModemChar(timeout * 1000, fehler_code, wasTimeout);

	if(wasTimeout)
	{
	write_log_protokoll("rcv_packet: timeout");

     /* normaler Timeout */
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
             sprintf (xmt->result_str,"321 Keine Antwort vom SMS empfangen.");
             xmt->result  = -5;
             xmt->retry   = 1;
             xmt->errno   = -1;
	return(1);
	}

	if(fehler_code)
	{
	switch(fehler_code)		{
	case EAGAIN:
	case EINTR:
			continue;
	default:
	write_log_protokoll("rcv_packet: error");
             sprintf (xmt->result_str,"322 Kommunikationsfehler (Read): %s", sys_errlist[fehler_code]);
             xmt->result  = -5;
             xmt->retry   = 1;
             xmt->errno   = fehler_code;
	     return (-1);
					}
	}

    if(c == pattern) return(0);

    if(c == EOF)
    { /* normaler Timeout */
	write_log_protokoll("rcv_packet: timeout");
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
       return (1);
    }
	rec=1;
	buf[0]=c;

    /* jetzt ist mal wieder ein Zeichen da */

    
    if (rec > 0)
    {
       buf[rec] = 0;
       /* jetzt mu xon xoff raus */
       for (p=buf,p1=buf1,*p1=0;*p;p++)
       {
          if ((*p != 17) && (*p != 19))
          {
             *p1 = *p;
             p1++;
             *p1 = 0;
          }
       }
       strcat (packet,buf1);
	if(strlen(packet) >= maxlen) return(0);

	write_log_protokoll("rcv_packet: ");
	write_log_protokoll(packet);

	if(strcmp(packet,"NO ANSWER") == 0)
	{
	return(-3);
	}

	if(strcmp(packet,"BUSY") == 0)
	{
	return(-2);
	}

       continue;
    }
 }
}
/*--------------------------------------------------------------------*/
int ftpSendApp::checksum( char *p, int len)
{
 int   sum,i;

 for (i=0,sum=0;i<len;i++)
    sum += p[i];

 return (sum);
}

/*--------------------------------------------------------------------*/
int ftpSendApp::open_file( xmt_typ *xmt, job_typ *job)

{
 struct stat statbuf;

 if (stat (xmt->sourcepath,&statbuf))
 {
    sprintf (xmt->result_str,"280 Zu sendende Datei %s nicht gefunden",
             xmt->sourcepath);
    xmt->diagnostic = D_OPNFIL;
    xmt->result = -4;
    return (-1);
 }
 if (!(statbuf.st_mode & S_IFREG))
 {
    sprintf (xmt->result_str,"281 Zu sendende Datei %s ist nicht regulaer",
             xmt->sourcepath);
    xmt->diagnostic = D_OPNFIL;
    xmt->result = -4;
    return (-1);
 }

 if (!(statbuf.st_mode & S_IREAD))
 {
    sprintf (xmt->result_str,"282 Keine Leseberechtigung fr Datei %s",
             xmt->sourcepath);
    xmt->diagnostic = D_OPNFIL;
    xmt->result = -4;
    return (-1);
 }

 job->fptr = fopen (xmt->sourcepath,"rb");
 if (!job->fptr)
 {
    sprintf (xmt->result_str,"283 Fehler beim fopen() der Datei %s", xmt->sourcepath);
    xmt->diagnostic = D_OPNFIL;
    xmt->result = -4;
    return (-1);
 }
 return (0);
}

/*--------------------------------------------------------------------*/
int ftpSendApp::check_answer( xmt_typ  *xmt, job_typ  *job, pack_typ *rbuf)
{
 int offs;

 if ((rbuf->head.packlen < sizeof(header_typ)) ||
     (rbuf->head.packlen > (FT_DATALEN + sizeof(header_typ))))
    return (0);

 if (checksum ((char *)&(rbuf->head.packlen),rbuf->head.packlen - 4) != rbuf->head.chksum)
    return (0);

 /* ab hier liegt ein ordentliches Paket vor */
 switch (rbuf->head.opcode)
 {
    case FTOP_ACK: /* ok, naechstes paket senden */
        job->tries=1;
        job->sendblock = rbuf->head.packnr + 1;
        if (job->lastblock)
           return (1); /* ok, alles paletti, transfer ist fertig */
    case FTOP_ERROR:
        if (rbuf->head.packlen > sizeof(header_typ)) /* jetzt ist es eine Fehlermeldung */
        {
           strcpy (xmt->result_str,"284 PROBLEM AUF GEGENSEITE: ");
           offs = strlen (xmt->result_str);
           memcpy (&(xmt->result_str[offs]),rbuf->data,rbuf->head.packlen - sizeof(header_typ));
           xmt->diagnostic = D_BADKOMM;
           xmt->result = -3;
           xmt->retry  = 1;
           return (-1);
        }
        break;
    default:
        break;
 }
 return (0);
}


/*--------------------------------------------------------------------*/
int ftpSendApp::rcv_answer( xmt_typ  *xmt, job_typ  *job, pack_typ *rbuf)
{
 int state;
 int datalen;
 int offset;
 char *ptr;
 fxBool wasTimeout;
 int fehler_code;
 int c;
 int rcode,rec,flags=0,event;


 write_log_protokoll("start rcv_answer.");
 ptr= (char *)&(rbuf->head.chksum);
 offset=0;
 state=0;

 while (1)
 {
	c = isdn_getModemChar(TOUT_ACK * 1000, fehler_code, wasTimeout);

	if(wasTimeout)
	{
	write_log_protokoll("rcv_answer: timeout");
       return (1);
	}

    if (fehler_code)
    {
	write_log_protokoll("rcv_answer: Error");
       switch (fehler_code)
       {
          case EAGAIN:
  	     continue;
          case EINTR:
             sprintf (xmt->result_str,"285 Abbruch durch ein Signal.");
             xmt->errno  = fehler_code;
             xmt->diagnostic = D_TX_ABORTED;
             xmt->retry  = 1;
             xmt->result = -3;
             return (-1);
          default:
             sprintf (xmt->result_str,"286 Lesefehler: %s", sys_errlist[fehler_code]);
             xmt->errno   = fehler_code;
             xmt->diagnostic = D_INTERNAL;
             xmt->retry   = 1;
             xmt->result  = -3;
	     return (-1);
       }
	/* End OF Switch */
    }
    /* End OF IF(FEHLER_CODE) */

    if(c == EOF) {
	continue;
    }

    *(ptr+offset)= c;
    offset++;

    switch(state)	{
    case 0:
	if(offset < sizeof(header_typ)) break;
	state=1;
	datalen= rbuf->head.packlen;
	break;
    }

   if(state && offset == datalen) break;
 }
 /* END OF WHILE */
 write_log_protokoll("rcv_answert ist zu ende.");
}

/*--------------------------------------------------------------------*/
int ftpSendApp::send_ftp_data( xmt_typ  *xmt, job_typ  *job, pack_typ *wbuf)
{

write_log_protokoll("Start send_ftp_data.");
{
char tbuf[40];
sprintf(tbuf,"Ant: %d", wbuf->head.packlen);
write_log_protokoll(tbuf);
}

  if(putModem((char *)&(wbuf->head.chksum), wbuf->head.packlen) != TRUE)
 {
 write_log_protokoll("send_ftp_data lieferte einen Fehler.");
    sprintf (xmt->result_str,"287 Kommunikationsfehler: Senden",
             ErrorIntern);
    xmt->diagnostic = D_SMS_TLIERR;
    xmt->result = -3;
    xmt->t_errno = -1;
    return (-1);
 }
 write_log_protokoll("send_ftp_data ist OK.");
 return (0);
}

/*--------------------------------------------------------------------*/
int ftpSendApp::read_data( xmt_typ  *xmt, job_typ  *job, pack_typ *wbuf)
{
 static int lastblock=0;
 int        len;

 if (lastblock != (job->sendblock -1))
 {
    if (job->sendblock == lastblock)
    {
       if (debug)
          fprintf (stderr,"sendblock = lastblock = %d\n",job->sendblock);
       return (0);
    }
    else
    {
       fseek (job->fptr,(job->sendblock-1)*FT_DATALEN,SEEK_SET);
       if (debug)
          fprintf (stderr,"backward: sendblock = %d\n",job->sendblock);
    }
 }

 len = fread(wbuf->data, 1, FT_DATALEN, job->fptr);
 if (len < FT_DATALEN)
    job->lastblock = 1;
 lastblock    = job->sendblock;
 wbuf->head.opcode  = FTOP_DATA;
 wbuf->head.packnr  = job->sendblock;
 wbuf->head.packlen = len + sizeof(header_typ);
 wbuf->head.chksum  = checksum ((char *)(&(wbuf->head.packlen)),len + sizeof(header_typ) - 4);
 return (0);
}


/*--------------------------------------------------------------------*/
int ftpSendApp::xmit_file( xmt_typ *xmt, job_typ *job)
{
 pack_typ  wbuf,rbuf;
 int       res;

 job->sendblock = 1;
 job->tries     = 1;
 job->lastblock = 0;
 while (1)
 {

flushModemInput();


 write_log_protokoll("Aufruf read_data.");
    read_data  (xmt,job,&wbuf);
 write_log_protokoll("Ende read_data.");
    if (send_ftp_data  (xmt,job,&wbuf))
	{
       break;
	}


    if (debug)
       fprintf (stderr,"Block %d gesendet\n",job->sendblock);

    res = rcv_answer (xmt,job,&rbuf);
    switch (res)
    {
       case -1: /* Fehler beim Lesen, bzw. disconnect */
          return (-1);
       case  0:
          res = check_answer (xmt,job,&rbuf);
          if (res == 1)   /* letztes packet */
          {
             xmt->result = 0;
             xmt->retry  = 0;
             return (0);
          }
          if (debug)
             fprintf (stderr,"ACK %d emfangen\n",rbuf.head.packnr);
          break;
       case  1: /* timeout */
       default:
          job->tries++;
          break;
    }

    if (job->tries > MAX_RETRY)
    {
       sprintf (xmt->result_str,"288 Kommunikation zur Gegenstelle gestoert.");
       xmt->diagnostic = D_BADKOMM;
       xmt->result = -3;
       xmt->retry  = 1;
       return (-1);
    }

    if (xmt->result < 0)
       break;
 }
 return (0);
}


/*--------------------------------------------------------------------*/
int ftpSendApp::rcv_packet(char *packet, char *pattern,xmt_typ *xmt, int timeout)
{
 fxBool wasTimeout;
 int fehler_code;
 int c;
 int            flags,rec,rcode,event,offset;
 char           buf [MAXMSGLEN];
 char           buf1[MAXMSGLEN];
 char           *p,*p1;
 
*packet = 0;

 while (1)
 {
	c = isdn_getModemChar(timeout * 1000, fehler_code, wasTimeout);

	if(wasTimeout)
	{
	write_log_protokoll("rcv_packet: timeout");

     /* normaler Timeout */
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
	return(1);
	}

	if(fehler_code)
	{
	switch(fehler_code)		{
	case EAGAIN:
	case EINTR:
			continue;
	default:
	write_log_protokoll("rcv_packet: error");
             sprintf (xmt->result_str,"286 Lesefehler: %s", sys_errlist[fehler_code]);
             xmt->result  = -5;
             xmt->retry   = 1;
             xmt->errno   = fehler_code;
	     return (-1);
					}
	}

    if(c == EOF)
    { /* normaler Timeout */
	write_log_protokoll("rcv_packet: timeout");
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
       return (1);
    }
	rec=1;
	buf[0]=c;

    /* jetzt ist mal wieder ein Zeichen da */

    
    if (rec > 0)
    {
       buf[rec] = 0;
       /* jetzt mu xon xoff raus */
       for (p=buf,p1=buf1,*p1=0;*p;p++)
       {
          if ((*p != 17) && (*p != 19))
          {
             *p1 = *p;
             p1++;
             *p1 = 0;
          }
       }
       strcat (packet,buf1);

	write_log_protokoll("rcv_packet: ");
	write_log_protokoll(packet);

	if(strcmp(packet,"NO ANSWER") == 0)
	{
	return(-3);
	}

	if(strcmp(packet,"BUSY") == 0)
	{
	return(-2);
	}

       if (*pattern)
       {
          offset = strlen(packet) - strlen(pattern);
          if (offset >= 0)
          {
             if (!strcmp(&packet[offset],pattern))
             {
                if (debug)
                {
                   strcpy (buf,packet);
                   for (p=buf;*p;p++)
                      if (*p=='\r')
                         *p='!';
                   fprintf (stderr,"\nEmpfangen %s\n",buf);
                }
                return (0);
             }
          }
       }
       continue;
    }
 }
}
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/


