/*	$Id: deSendApp.h,v 1.14 1996/06/24 03:00:53 sam Rel $ */
/*
 * Copyright (c) 1994-1996 Sam Leffler
 * Copyright (c) 1994-1996 Silicon Graphics, Inc.
 * HylaFAX is a trademark of Silicon Graphics
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#ifndef _ftpSendApp_
#define	_ftpSendApp_
/*
 * IXO Send FTP App.
 */
#include "faxApp.h"
#include "ModemServer.h"
#include "FaxTrace.h"
#include "pdsisdn.h"

class UUCPLock;
class fxStackBuffer;

typedef struct
{
/* interne Variable */
 FILE   *fptr;
 int     confd;
 int     sendblock;
 int     tries;
 int     lastblock;
 time_t  starttime;
} job_typ;

typedef struct
{
 int   chksum;
 int   packlen;
 int   opcode;
 int   packnr;
} header_typ;

typedef struct
{
 header_typ head;
 char       data[FT_DATALEN];
} pack_typ;




class ftpSendApp : public ModemServer, public faxApp {
public:
    struct stringtag {
	const char*	 name;
	fxStr ftpSendApp::* p;
	const char*	 def;		// NULL is shorthand for ""
    };
    struct numbertag {
	const char*	 name;
	u_int ftpSendApp::*p;
	u_int		 def;
    };
private:
// runtime state
    fxBool	ready;			// modem ready for use
    UUCPLock*	modemLock;		// uucp lockfile handle
    time_t	connTime;		// time connected to peer

    fxStr	pagerSetupCmds;		// pager-specific modem setup commands
    fxStr	pagerTTYParity;		// parity setting for tty
    u_int	pagerMaxMsgLength;	// default max message text length

    fxStr	ixoService;		// IXO protocol service string
    fxStr	ixoDeviceID;		// IXO protocol device id string
    u_int	ixoMaxUnknown;		// max unknown responses to permit
    u_int	ixoIDProbe;		// time between probes for ID= string
    u_int	ixoIDTimeout;		// timeout waiting for initial ID=
    u_int	ixoLoginRetries;	// # times to retry login procedure
    u_int	ixoLoginTimeout;	// timeout on login procedure
    u_int	ixoGATimeout;		// timeout waiting for go-ahead message
    u_int	ixoXmitRetries;		// # times to retry sending msg block
    u_int	ixoXmitTimeout;		// timeout waiting for xmit response
    u_int	ixoAckTimeout;		// timeout waiting ro final ack/nak

    static ftpSendApp* _instance;

    static const stringtag strings[];
    static const stringtag atcmds[];
    static const numbertag numbers[];

// configuration support
    void	setupConfig();
    void	resetConfig();
    fxBool	setConfigItem(const char* tag, const char* value);
    u_int	getConfigParity(const char* value) const;
// IXO transmission support
    int isinstr(char *s1, char *s2);
    char *strpos( char *str, char *muster);
    void isdn_sleep(int sec);
    void	sendFtp(FaxRequest&, FaxMachineInfo&);
    void	sendFtp(FaxRequest&, FaxMachineInfo&, const fxStr&,
		    const fxStr&);
    fxBool	sendPagerMsg(FaxRequest&, faxRequest&, const fxStr&, fxStr&);
    u_int	getResponse(fxStackBuffer& buf, long secs);
    fxBool	prepareMsg(FaxRequest&, FaxMachineInfo&, fxStr&);
    fxBool	pagePrologue(FaxRequest&, const FaxMachineInfo&, fxStr&);
    fxBool	pageGoAhead(FaxRequest&, const FaxMachineInfo&, fxStr&);
    fxBool	pageEpilogue(FaxRequest&, const FaxMachineInfo&, fxStr&);
    void	sendFailed(FaxRequest&, FaxSendStatus, const char*, u_int = 0);
    void	notifyPageSent(FaxRequest& req, u_int fi);
    time_t	getConnectTime() const;
    CallStatus  open_xmt(xmt_typ *xmt);
    int anforderung_channeld(char *);
    void freigabe_channeld(char *);
    int 	ftp_dialog(xmt_typ *sms);
    int 	cause_diag(int cause);
    char 	*cause_text(int cause);
    int 	close_con(xmt_typ *xmt, job_typ *job);
    int 	do_retry(int cause);
    int		xmit_file( xmt_typ *xmt, job_typ *job);
    int		read_data( xmt_typ  *xmt, job_typ  *job, pack_typ *wbuf);
    int		send_ftp_data( xmt_typ  *xmt, job_typ  *job, pack_typ *wbuf);
    int		rcv_answer( xmt_typ  *xmt, job_typ  *job, pack_typ *rbuf);
    int rcv_string_packet(char *packet, char pattern ,xmt_typ *xmt, int timeout, int maxlen);
    int		check_answer( xmt_typ  *xmt, job_typ  *job, pack_typ *rbuf);
    int		open_file( xmt_typ *xmt, job_typ *job);
    int 	checksum( char *p, int len);
    int         rcv_packet(char *packet, char *pattern,xmt_typ *xmt, int timeout);

// modem handling
    fxBool	lockModem();
    void	unlockModem();
    fxBool	setupModem();
// notification interfaces used by ModemServer
    void	notifyModemReady();
    void	notifyModemWedged();
// miscellaneous
    fxBool	putModem(const void* data, int n, long ms = 0);
    void	traceResponse(const fxStackBuffer& buf);
    void	traceIXO(const char* fmt ...);
    void	traceIXOCom(const char* dir, const u_char* data, u_int cc);
public:
    ftpSendApp(const fxStr& device, const fxStr& devID);
    ~ftpSendApp();

    static ftpSendApp& instance();

    void	initialize(int argc, char** argv);
    void	open();
    void	close();

    FaxSendStatus send(const char* filename);

    fxBool	isReady() const;
};
inline fxBool ftpSendApp::isReady() const 	{ return ready; }
#endif
