/*******************************************************************************
** 
**
**
** PDS/villwock            11.97
**
** Parameter:     -d    Debugging on, es wird die Datei /tmp/filercv.debug
                        angelegt
*******************************************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <termios.h>
#include "Sys.h"
#include"../config.h"
#include "isdn_bftrcv.h"


#define MAXSEQNUM 99999999

/* ++++ state: Feld ++++ */
#define JOB_STATE_UNDEFINED "0"
#define JOB_STATE_SUSPENDED "1"
#define JOB_STATE_PENDING "2"
#define JOB_STATE_SLEEPING "3"
#define JOB_STATE_BLOCKED "4"
#define JOB_STATE_READY "5"
#define JOB_STATE_ACTIVE "6"
#define JOB_STATE_DONE "7"


#define FIFOSELECTBUG  1


extern char *sys_errlist[];
static int   debug = 1;

extern	char* fmtTime(time_t);

#define	FAX_RECVSEQF	FAX_SPOOLDIR "/" FAX_RECVDIR "/" FAX_SEQF
#define	FAX_JOBDIR	FAX_SPOOLDIR "/" FAX_RECVDIR
#define	FAX_DOCSEQF	FAX_SPOOLDIR "/" FAX_DOCDIR "/" FAX_SEQF
#define	FAX_DOCS	FAX_SPOOLDIR "/" FAX_DOCDIR 

/*--------------------------------------------------------------------*/
FTPServer::FTPServer()
{
timer = Timeout();
}
/* ****************************************************************************** */
/*
 * Ablage von Information in die Datei /var/spool/fax/etc/xferlog
 */
void FTPServer::write_xferlog_info(
char *path,	/* Path der Log Datei */
char *start, 	/* zB. 10/10/1997 15:19 */
char *cmd, 	/* zB.: "SEND" */
char *commid, 	/* zB.: "00000002" */
char *device, 	/* zB.: "cui2" */
char *jobid, 	/* zB.: "108" */
char *jobtag, 	/* zB.: "" */
char *user, 	/* zB.: "root at Jimlinux.pds.de" */
char *dest, 	/* zB.: "855675" */
char *csi, 	/* zB.: "" */
unsigned int params, 	/* zB.: 65535 */
int npages, 	/* zB.: 0 */
char *duration, /* zB.: "0:33" */
char *conntime, /* zB.: "0:00" */
char *status 	/* zB.: "Unknown Problem (Check Modem Power)" */
)
{
int fd;
char record[600];
char buf[200];
int i;
char c;
char* cp;

record[0]=0;

    fd = ::open("/var/spool/fax/etc/xferlog", O_RDWR|O_CREAT|O_APPEND, 0644);

    if (fd < 0) return;

	strcat(record,start);			// $ 1 = time

	sprintf(buf,"\t%s", cmd);		// $ 2 = SEND|RECV|POLL|PAGE
	strcat(record,buf);

	sprintf(buf,"\t%s", commid);		// $ 3 = commid
	strcat(record,buf);

	sprintf(buf,"\t%s", device);		// $ 4 = device
	strcat(record,buf);

	sprintf(buf,"\t%s", jobid);		// $ 5 = jobid
	strcat(record,buf);

	i = 0;
	for (cp = jobtag; c = *cp; cp++) {
	    if (i == sizeof (buf)-2)		// truncate string
		break;
	    if (c == '\t')			// tabs are field delimiters
		c = ' ';
	    else if (c == '"')			// escape quote marks
		buf[i++] = '\\';
	    buf[i++] = c;
	}
	buf[i] = '\0';

	strcat(record,"\t\"");	
	strcat(record,buf);			// $ 6 = jobtag	
	strcat(record,"\"");	

	sprintf(buf,"\t%s", user);		// $ 7 = sender
	strcat(record,buf);

	sprintf(buf,"\t\"%s\"", dest);		// $ 8 = dest
	strcat(record,buf);

	sprintf(buf,"\t\"%s\"", csi);		// $ 9 = csi
	strcat(record,buf);

	sprintf(buf,"\t%u", params);		// $10 = encoded params
	strcat(record,buf);

	sprintf(buf,"\t%d", npages);		// $11 = npages
	strcat(record,buf);

	sprintf(buf,"\t%s", duration);		// $12 = duration
	strcat(record,buf);

	sprintf(buf,"\t%s", conntime);		// $13 = conntime
	strcat(record,buf);

	sprintf(buf,"\t\"%s\"", status);	// $14 = status
	strcat(record,buf);

	strcat(record,"\n");

	::flock(fd, LOCK_EX);
	::write(fd, record, strlen(record));
	::close(fd);				// implicit unlock

}
/* ****************************************************************************** */
void FTPServer::insert_char( char *ptr, int offset )
{
int i;
int n;

n=strlen(ptr);

for(i=strlen(ptr) -1; i>= offset; i--)	{
*(ptr+i+1) = *(ptr+i);
					}
*(ptr+n+1)=0;
}
/* ****************************************************************************** */
/* fuer folgende Token gedacht:     state:    npages: 				  */
void FTPServer::setJobToken( char *path, char *token, char *state )
{
int i,j,k,l;
char buffer[2048];
int offset;
int cc;
FILE *JobFile;

    JobFile = fopen(path, "r+");

    if (JobFile == NULL) return;

	
    flock(fileno(JobFile), LOCK_EX);

   
	offset=0;
 
    while ((cc = fread(&buffer[offset], 1, sizeof (buffer), JobFile)) > 0)
	{
	offset+=cc;
	}

    buffer[offset]=0;


    for(i=0;i<strlen(buffer);i++)		{

    if(memcmp(&buffer[i],token,strlen(token)) == 0) {

    /* auffuellen mit Blanks */
    j=0;
    while(1)		{
	if(buffer[i+strlen(token)+j] == '\n') break;
	if(buffer[i+strlen(token)+j] == 0) break;
	buffer[i+strlen(token)+j] = ' ';
	j++;
     }

    for(k=0; k< strlen(state); k++)
	if(buffer[i+strlen(token)+k] == '\n') break;

    for(l=0; l< strlen(state) -k; l++) 
	insert_char(buffer,i+strlen(token));


    memcpy(&buffer[i+strlen(token)],state,strlen(state));
	break;
    }
    }


    rewind(JobFile);
    fprintf(JobFile, "%s",buffer);
    fflush(JobFile);
    ftruncate(fileno(JobFile), ftell(JobFile));


    flock(fileno(JobFile), LOCK_UN);
    fclose(JobFile);
}
/*--------------------------------------------------------------------*/
void FTPServer::write_jobfile(int docid)
{
time_t now;
char tbuf[200];
FILE *fp;
int nr;

nr=getRecvId();
now= Sys::now();

zeitstempel=now;
sprintf(tbuf,"%s/q%d",FAX_JOBDIR,nr);

if(debug)
{
printf("\nWrite Jobfile: %s",tbuf); fflush(stdout);
}

fp = fopen (tbuf,"w+b");
if(fp == NULL) return;

fprintf(fp,"%s%d\n","tts:",now);
fprintf(fp,"%s\n","killtime:0");
fprintf(fp,"%s\n","retrytime:60");
fprintf(fp,"%s\n","state:5");
fprintf(fp,"%s\n","npages:0");
fprintf(fp,"%s\n","totpages:0");
fprintf(fp,"%s\n","ntries:0");
fprintf(fp,"%s\n","ndials:0");
fprintf(fp,"%s\n","totdials:0");
fprintf(fp,"%s\n","maxdials:12");
fprintf(fp,"%s\n","tottries:0");
fprintf(fp,"%s\n","maxtries:3");
fprintf(fp,"%s\n","pagewidth:0");
fprintf(fp,"%s\n","resolution:98");
fprintf(fp,"%s\n","pagelength:0");
fprintf(fp,"%s\n","priority:127");
fprintf(fp,"%s\n","schedpri:127");
fprintf(fp,"%s\n","minsp:0");
fprintf(fp,"%s\n","desiredbr:5");
fprintf(fp,"%s\n","desiredst:0");
fprintf(fp,"%s\n","desiredec:1");
fprintf(fp,"%s\n","desireddf:3");
fprintf(fp,"%s\n","desiredtl:0");
fprintf(fp,"%s\n","useccover:1");
fprintf(fp,"%s%s\n","external:", fsrv.partner_telno);
fprintf(fp,"%s%s\n","number:", fsrv.partner_telno);
fprintf(fp,"%s\n","mailaddr:");
fprintf(fp,"%s\n","sender:");
fprintf(fp,"%s%d\n","jobid:", nr);
fprintf(fp,"%s\n","jobtag:");
fprintf(fp,"%s\n","pagehandling:");
fprintf(fp,"%s\n","modem:any");
fprintf(fp,"%s\n","receiver:");
fprintf(fp,"%s\n","company:");
fprintf(fp,"%s\n","location:");
fprintf(fp,"%s\n","cover:");
fprintf(fp,"%s\n","client:localhost");
fprintf(fp,"%s\n","owner:root");
fprintf(fp,"%s\n","groupid:196");
fprintf(fp,"%s\n","signalrate:");
fprintf(fp,"%s\n","dataformat:");
fprintf(fp,"%s\n","jobtype:pdsftp");
fprintf(fp,"%s\n","tagline:");
fprintf(fp,"%s\n","subaddr:");
fprintf(fp,"%s\n","passwd:");
fprintf(fp,"%s\n","doneop:default");
fprintf(fp,"%s\n","commid:");
fprintf(fp,"%s\n","status:");
fprintf(fp,"%s\n","notify:none");
fprintf(fp,"%s\n","pagechop:default");
fprintf(fp,"%s\n","chopthreshold:3");
fprintf(fp,"%s\n","page:0::88906916");
fprintf(fp,"%s\n","!page:0::88906916");
fprintf(fp,"%s%d\n","data:0::docq/doc_ftp.",docid);

fclose(fp);

}
/*--------------------------------------------------------------------*/
int FTPServer::getDocId()
{
char line[1024];
u_int seqnum = 1;
int fseqf = ::open(FAX_DOCSEQF, O_CREAT|O_RDWR, 0644);

if(debug)
{
printf("\nRead DOC SEQF: %s",FAX_DOCSEQF); fflush(stdout);
}

if (fseqf < 0) return(0);

flock(fseqf, LOCK_EX);
int n = read(fseqf, line, sizeof (line));
line[n < 0 ? 0 : n] = '\0';

if (n > 0)
	    seqnum = atoi(line);

seqnum++;

if (seqnum < 1 || seqnum >= MAXSEQNUM) {
seqnum = 1;
}

sprintf(line, "%u", seqnum);
(void) lseek(fseqf, 0, SEEK_SET);
if (::write(fseqf, line, strlen(line)) != strlen(line))
	seqnum= 0;

close(fseqf);	
return(seqnum);	
}
/*--------------------------------------------------------------------*/
int FTPServer::getRecvId()
{
char line[1024];
u_int seqnum = 1;
int fseqf = ::open(FAX_RECVSEQF, O_CREAT|O_RDWR, 0644);

if(debug)
{
printf("\nRead RECV SEQF: %s",FAX_RECVSEQF); fflush(stdout);
}

if (fseqf < 0) return(0);

flock(fseqf, LOCK_EX);
int n = read(fseqf, line, sizeof (line));
line[n < 0 ? 0 : n] = '\0';

if (n > 0)
	    seqnum = atoi(line);

seqnum++;

if (seqnum < 1 || seqnum >= MAXSEQNUM) {
seqnum = 1;
}

sprintf(line, "%u", seqnum);
(void) lseek(fseqf, 0, SEEK_SET);
if (::write(fseqf, line, strlen(line)) != strlen(line))
	seqnum= 0;

close(fseqf);	
return(seqnum);	
}
/*--------------------------------------------------------------------*/
void FTPServer::atMode()
{
sleep(3);
if(modemFd < 0) return;
::write ( modemFd, "+++", 3);
sleep(3);
}
/*--------------------------------------------------------------------*/
int FTPServer::setRawModeOn()
{
int status;
struct termios term;

status=::tcgetattr(modemFd, &term);

if(status)
{
return(1);
}

term.c_iflag &= ~( IXON );

::tcsetattr(modemFd,TCSAFLUSH, &term);

return (0);
}
/*--------------------------------------------------------------------*/
int FTPServer::setRawModeOff()
{
int status;
struct termios term;

status=::tcgetattr(modemFd, &term);

if(status)
{
return(1);
}

term.c_iflag |= ( IXON );

::tcsetattr(modemFd,TCSAFLUSH, &term);

return (0);
}

/*--------------------------------------------------------------------*/
void FTPServer::spezial_modem_init()
{
int status;
struct termios term;

status=::tcgetattr(modemFd, &term);

if(status)
{
return;
}

term.c_iflag &= ~( ICRNL );
term.c_cflag &= ~( CLOCAL );
term.c_cflag |=  ( CRTSCTS);
term.c_oflag &=  ~( OPOST);
term.c_lflag &=  ~( ISIG ); 
term.c_lflag &=  ~( ICANON ); 
term.c_lflag &=  ~( ECHO ); 
term.c_lflag &=  ~( ECHOE ); 
term.c_lflag &=  ~( ECHOK ); 
term.c_lflag &=  ~( IEXTEN ); 


term.c_cc[5]=1;

::tcsetattr(modemFd,TCSAFLUSH, &term);

}

/*--------------------------------------------------------------------*/
int FTPServer::rcv_packet(char *pattern, int sec)
{
int offset;
int len;
int rc;
int k;
char buffer[1024];


if (debug)
{
printf("\nRECEIVE Pattern %s",pattern); fflush(stdout);
}

len=strlen(pattern);
offset=0;

while(1)					{

if (sec) timer.startTimeout(sec * 1000);
rc= ::read(modemFd,(char *)&buffer[offset],1);
buffer[offset+1]=0;


if (sec) timer.stopTimeout();

if(rc != 1) return(1);

if (debug)
{
printf("\nzeichen: %c %d", buffer[offset], buffer[offset]); fflush(stdout);
}

offset++;
if(offset == 1000) break;

if(offset < len) continue;

for(k=0; k< offset; k++)	{
if(memcmp(&buffer[k], pattern, len) == 0) 
{
return(0);
}
				}
						}



return(1);
}
/*--------------------------------------------------------------------*/
int FTPServer::rcv_caller(int sec)
{
int offset;
int len;
int rc;
int k;
char buffer[400];

if (debug)
{
printf("\nRECEIVE CALLER NUMBER verarbeiten.");
fflush(stdout);
}


offset=0;

while(1)					{

if (sec) timer.startTimeout(sec * 1000);
rc= ::read(modemFd,(char *)&buffer[offset],1);
buffer[offset+1]=0;

if (sec) timer.stopTimeout();

if(rc != 1) return(1);

if (debug)
{
printf("\nzeichen: %c %d", buffer[offset], buffer[offset]); fflush(stdout);
}


if(buffer[offset] == 0x0d)
{
buffer[offset] = 0;

if (debug)
{
printf("\nNumber empfangen: <%s>",buffer); fflush(stdout);
}

strcpy(fsrv.partner_telno,buffer);
return(0);
}

offset++;
if(offset == 39) break;
						}



return(1);
}
/*--------------------------------------------------------------------*/
int FTPServer::atCmd(char *text)
{
int rcode;

if (debug)
{
printf("\n---><%s>",text); fflush(stdout);
}

rcode = ::write ( modemFd, text, strlen(text));
}
/*--------------------------------------------------------------------*/
int FTPServer::open(char *DeviceName)
{
int rcode;
char at_commando[200];

fsrv.fptr=NULL;
fsrv.result=0;
fsrv.filepath[0]=0;
fsrv.writepack=0;
fsrv.lastpack=0;
fsrv.ackno=0;
fsrv.errno=0;
fsrv.t_errno=0;
fsrv.cause=0;
fsrv.basis[0]=0;
fsrv.tmp_name[0]=0;
fsrv.tries=0;
fsrv.goodblocks=0;

modemFd= ::open(DeviceName,O_RDWR);
if(modemFd < 0) return(1);

spezial_modem_init();

sprintf(at_commando,"at&F\r");
rcode = atCmd(at_commando);
if(rcv_packet("OK", 2)) return(1);

sprintf(at_commando,"atE0\r");
rcode = atCmd( at_commando);
if(rcv_packet("OK", 2)) return(1);

sprintf(at_commando,"at&X0\r");
rcode = atCmd( at_commando);
if(rcv_packet("OK", 2)) return(1);

/* Hier muss die Nebenstellennummer ermittelt werden */
sprintf(at_commando,"at&E%s\r",nebenstelle);
rcode = atCmd( at_commando);
if(rcv_packet("OK", 2)) return(1);

sprintf(at_commando,"ats14=3\r");
rcode = atCmd( at_commando);
if(rcv_packet("OK", 2)) return(1);

sprintf(at_commando,"ats19=%s\r",service);
rcode = atCmd( at_commando);
if(rcv_packet("OK", 2)) return(1);

sprintf(at_commando,"ats0=1\r");
rcode = atCmd( at_commando);
if(rcv_packet("OK", 2)) return(1);


return(0);
}
/*--------------------------------------------------------------------*/
FTPServer::~FTPServer()
{
}
/*--------------------------------------------------------------------*/
void FTPServer::startTimeout(long ms)
{
}
/*--------------------------------------------------------------------*/
int FTPServer::checksum(char *p,int len)
{
 char * ptr;
 char c;
 int   sum,i;

 ptr = (char *) p;

 for (i=0,sum=0;i<len;i++)	{
    sum += *(ptr+i);
				}

 return (sum);
}

/*--------------------------------------------------------------------*/
int FTPServer::write_pack(pack_typ *rbuf)
{
 static int good_written=0;

 if (!fsrv.fptr)
 {  /* datei beim ersten paket anlegen */
    if (create_file())
       return (-1);
 }

 if (fsrv.ackno != (good_written + 1))
    return (0);

 if (rbuf->head.packlen > sizeof(header_typ))
 { /* letztes Paket mit mehr als 0 Bytes daten */
    if (!fwrite(rbuf->data, rbuf->head.packlen - sizeof(header_typ), 1, fsrv.fptr))
    {
       if (!fsrv.result)
       {
          sprintf (fsrv.result_str,"250 Fehler beim Schreiben der Datei.");
          fsrv.result  = -2;
       }
       return (-1);
    }
 }

 good_written = fsrv.ackno;

 if (fsrv.lastpack)
    fclose (fsrv.fptr);

 return (0);
}


/*************************************************************/
int FTPServer::send_ack()
{
 pack_typ wbuf;
 int rcode;

if (debug)
{
printf("\nsend_ack()"); fflush(stdout);
}

 wbuf.head.packlen = sizeof(header_typ);
 wbuf.head.opcode  = FTOP_ACK;
 wbuf.head.packnr  = fsrv.ackno;
 wbuf.head.chksum  = checksum ((char *)&(wbuf.head.packlen),sizeof(header_typ) - 4);

 rcode = ::write ( modemFd, (char *)&(wbuf.head.chksum), wbuf.head.packlen);

 if (rcode < 0)
 {
    sprintf (fsrv.result_str,"251 Fehler beim Senden des Acknowledge.");
    fsrv.result = -2;
    fsrv.t_errno = errno;
    return (-1);
 }

 return (0);
}

/*************************************************************/
int FTPServer::send_err()
{
 pack_typ wbuf;
 int rcode;


if (debug)
{
printf("\nsend_err()"); fflush(stdout);
}

 strcpy (wbuf.data,fsrv.result_str);
 wbuf.head.packlen = sizeof(header_typ) + strlen (wbuf.data);
 wbuf.head.opcode  = FTOP_ERROR;
 wbuf.head.packnr  = fsrv.ackno;
 wbuf.head.chksum  = checksum ((char *)&(wbuf.head.packlen),wbuf.head.packlen - 4);

 rcode = ::write (modemFd, (char *)&(wbuf.head.chksum), wbuf.head.packlen);
 if (rcode < 0)
 {
    sprintf (fsrv.result_str,"Fehler beim Senden der Fehlermeldung.\n");
    fsrv.result = -2;
    fsrv.t_errno = errno;
    return (-1);
 }

 return (0);
}

/*************************************************************
ergebnis: -1 Fehler oder Emfangsende, Disconnect
           0 Packet empfangen, kann auch defekt sein
*************************************************************/
int FTPServer::rcv_pack(pack_typ  *rbuf)
{
 int offset;
 int rec,i;
 unsigned char *ptr;

if (debug)
{
printf("\nRCV_PACK\n"); fflush(stdout);
}

    ptr=(unsigned char *) &(rbuf->head.chksum);
    offset=0;

 /* blockierend lesen */
    while(1)
    {

    rec = ::read (modemFd,ptr+offset,(sizeof (pack_typ))-offset);

if (debug)
{
    printf("\nREC: %d\n",rec); fflush(stdout);
}

    if(rec == 0) 
    {
    sprintf (fsrv.result_str,"252 Disconnect.");
    fsrv.result  = 0;
    fsrv.t_errno = 0;
    return (-1);
    }

 
    if(rec < 0)
    {

if (debug)
{
    printf("\nErrno: %d\n",errno); fflush(stdout); 
}

    break;
    }

    offset+=rec;
    if(offset == rbuf->head.packlen) break;

if (debug)
{
    printf("\nOPCODE: %d OFFSET: %d LEN: %d\n",
	rbuf->head.opcode, 
	offset, 
	rbuf->head.packlen); 
	fflush(stdout);
}


    }




    if (rec > 0)
       return (0); /* ok, danke */
    
       sprintf (fsrv.result_str,"253 Fehler beim Transfer.");
       fsrv.result  = -2;
       fsrv.t_errno = errno;
       return (-1);
}

/*************************************************************/
int FTPServer::check_pack(pack_typ *rbuf)
{

 if ((rbuf->head.packlen < sizeof(header_typ)) || (rbuf->head.packlen > (FT_DATALEN + sizeof(header_typ))))
{
    return (0);
}


 if (debug)
 {
    printf ("Packet Nr.: %d, Laenge %d Bytes empfangen\n",
             rbuf->head.packnr, rbuf->head.packlen);
    fflush (stdout);
 }

 if (checksum ((char *)&(rbuf->head.packlen),rbuf->head.packlen - 4) != rbuf->head.chksum)
	{
    return (0);
	}

 if (debug)
 {
printf("\nCHECK_PACK: Checksum ist OK!\n"); fflush(stdout);
 }


 /* ab hier liegt ein ordentliches Paket vor */
 switch (rbuf->head.opcode)
 {
    case FTOP_DATA: /* ok, naechstes paket senden */
        if (rbuf->head.packnr == (fsrv.ackno + 1))
           fsrv.writepack = 1;
        else
           fsrv.writepack = 0;

        fsrv.ackno = rbuf->head.packnr;

        if (rbuf->head.packlen < sizeof (pack_typ))
           fsrv.lastpack = 1;

        if (debug)
        {
           if (fsrv.writepack)
              printf ("Datenpacket kann geschrieben werden\n");
           fflush (stdout);
        }
        break;

    default:
        if (debug)
        {
           printf ("Ungueltiger OP-Code %d\n",rbuf->head.opcode);
           fflush (stdout);
        }
        break;
 }
 return (0);
}


/*************************************************************/
int FTPServer::create_file()

{
int docid;

 docid=getDocId();
 strcpy (fsrv.basis,FAX_DOCS);
 sprintf (fsrv.tmp_name,"doc_ftp%c%d",'.',docid);

if (debug)
{
printf("\nCreate File %s\n",fsrv.tmp_name); fflush(stdout);
}

 sprintf (fsrv.filepath,"%s/%s",
          fsrv.basis,fsrv.tmp_name);

 if (debug)
 {
    printf ("Empfangsdatei %s soll angelegt werden\n",fsrv.filepath);
    fflush (stdout);
 }

 fsrv.fptr = fopen (fsrv.filepath,"w+b");
 if (!fsrv.fptr)
 {
    sprintf (fsrv.result_str,"254 Fehler beim fopen() der Datei %s",fsrv.filepath);
    fsrv.result = -2;
    return (-1);
 }

 write_jobfile(docid);
 return (0);
}

/*************************************************************/
int FTPServer::accept_con()
{

 strcpy (fsrv.partner_name,"UNBEKANNT");
 strcpy (fsrv.partner_telno,"");

if(rcv_packet("CALLER NUMBER: ", 0)) return(1);
if(rcv_caller(2)) return(1);
if(rcv_packet("RING", 0)) return(1);
if(rcv_packet("CONNECT", 0)) return(1);

if (debug)
{
printf("\nConnected!"); fflush(stdout);
}

 fsrv.starttime = time(0);
 return(0);
}

/*--------------------------------------------------------------------*/
int FTPServer::serve_it()
{
 pack_typ  rbuf;

if (debug)
{
printf("\nsave_it()"); fflush(stdout);
}

 fsrv.lastpack  = 0;
 fsrv.result    = 0;
 fsrv.ackno     = 0;
 fsrv.fptr      = 0;
 fsrv.writepack = 0;

 while (1)
 {
    if (!rcv_pack (&rbuf))
    {  /* ok, packet gekommen, gut oder schlecht */
       check_pack (&rbuf);

if (debug)
{
	printf("\nsave_it() lastpack: %d",fsrv.lastpack); fflush(stdout);
	printf("\nsave_it() writepack: %d",fsrv.writepack); fflush(stdout);
}

       if (fsrv.lastpack)
       { /* beim letzen ack muss man sicher sein */
          if (fsrv.writepack)
          {
             write_pack(&rbuf);
             if (fsrv.result)
                send_err();
             else
                send_ack ();
          }
       }
       else
       { /* sonst die schnellere Variante */
          send_ack();
          if (fsrv.writepack)
          {
             write_pack(&rbuf);
             if (fsrv.result)
                send_err();
          }
       }
    }
    else
    { /* Fehler beim Lesen, bzw. disconnect */
       return (-1);
    }
 }
}


/*--------------------------------------------------------------------*/
int FTPServer::close_fds()
{
 fsrv.duration = time(0) - fsrv.starttime;
 if (fsrv.fptr > 0)
    fclose(fsrv.fptr);

 if (fsrv.result) /* liegt ein fehler vor? */
{
    if(fsrv.filepath[0] != 0) unlink (fsrv.filepath);
}


if(modemFd >= 0) 
{
close(modemFd);
}

modemFd = -1;
 return(0);
}

/*--------------------------------------------------------------------*/
int FTPServer::create_tdd()
{
 FILE *tddfptr;
 char  tddfname[256];


 sprintf (tddfname,"%s/TSK_%s",
                   fsrv.basis,&fsrv.tmp_name[4]);

 tddfptr = fopen (tddfname,"w+");
 if (!tddfptr)
 {
    sprintf (fsrv.result_str,"255 TDD-Datei %s kann nicht angelegt werden.",
	     tddfname);
    fsrv.result = -1;
    return (-1);
 }

 fprintf (tddfptr,"function=RECEIVE_BFT\n");
 fprintf (tddfptr,"address=!%s\n",fsrv.partner_telno);
 fprintf (tddfptr,"status=%d\n",(-1) * fsrv.result);
 fprintf (tddfptr,"error=%d\n",fsrv.result);
 if (fsrv.result)
    fprintf (tddfptr,"errmsg=%s\n",fsrv.result_str);
 fprintf (tddfptr,"filename=%s\n",fsrv.filepath);
 fprintf (tddfptr,"time=%ld\n",time(0));
 fclose  (tddfptr);
 return  (0);
}

/*--------------------------------------------------------------------*/
void FTPServer::trace()
{



    printf ("---------------------------------------------------------\n");
    printf ("Ergebnis     : %d\n",fsrv.result);
    if (fsrv.result)
       printf ("Fehlertxt    : %s\n",fsrv.result_str);
    printf ("Gegenstelle  : %s\n",fsrv.partner_telno);
    printf ("Gegenstelle  : %s\n",fsrv.partner_name);
    printf ("Dauer        : %d Sekunden\n",fsrv.duration);
}
/*--------------------------------------------------------------------*/
int main(int argc, char* argv[])
{
char buf[200];
char buf1[200];

 if (argc != 4)
 {
 exit(1);
 }

 if(debug == 0)
 {
 ::signal(SIGTERM, SIG_IGN);
 ::signal(SIGINT, SIG_IGN);
 }

 FTPServer* app = new FTPServer();

 strcpy(app->devicename,argv[1]);
 strcpy(app->nebenstelle,argv[2]);
 strcpy(app->service,argv[3]);
 if (app->open(app->devicename))
{

if (debug)
{
printf("\nModem Open error detect!"); fflush(stdout);
}

exit(-1);
}

 if (!app->accept_con())
{
    app->setRawModeOn();
    app->serve_it();
    app->setRawModeOff(); 
    app->atMode();
}

 app->close_fds();

 strftime(buf, sizeof (buf), "%D %H:%M", localtime(&app->zeitstempel));

 if(memcmp(app->devicename,"/dev/",5) == 0)
 {
 strcpy(buf1,&app->devicename[5]);
 }
 else
 {
 strcpy(buf1,app->devicename);
 }




  if (app->fsrv.result == 0) {

	app->write_xferlog_info(
 	"/var/spool/fax/etc/xferlog",
	buf,
	"BMFT",
	"00000000",
	buf1,
	"108",
	"",
	"   ",
    	app->fsrv.partner_telno,
	"",
	0,
	10,
	fmtTime(app->fsrv.duration),
	"0:00",
	"Filetransfer OSI COM is OK"	
	);
	}
	else
	{
	app->write_xferlog_info(
 	"/var/spool/fax/etc/xferlog",
	buf,
	"BMFT",
	"00000000",
	buf1,
	"108",
	"",
	"   ",
    	app->fsrv.partner_telno,
	"",
	0,
	10,
	fmtTime(app->fsrv.duration),
	"0:00",
        app->fsrv.result_str
	);
	}

 if (debug)
 {
    app->trace();
 }
 return (0);
}

