/*	$Id: deSendApp.h,v 1.14 1996/06/24 03:00:53 sam Rel $ */
/*
 * Copyright (c) 1994-1996 Sam Leffler
 * Copyright (c) 1994-1996 Silicon Graphics, Inc.
 * HylaFAX is a trademark of Silicon Graphics
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#ifndef _FTPServerApp_
#define	_FTPServer_

#include "pdsisdn.h"
#include "Timeout.h"

typedef struct
{
 char filepath[512];
 char partner_telno[40];
 char partner_name[40];
 int  result;
 char result_str[200];
 int  errno;
 int  t_errno;
 int  cause;
 int  duration;

/* interne Variable */
 FILE *fptr;
 int   goodblocks;
 int   tries;
 int   lastpack;
 int   writepack;
 int   starttime;
 int   ackno;
 char  tmp_name[80];
 char  basis[80];
} fsrv_typ;

typedef struct
{
 int   chksum;
 int   packlen;
 int   opcode;
 int   packnr;
} header_typ;

typedef struct
{
 header_typ head;
 char       data[FT_DATALEN];
} pack_typ;


class FTPServer  {
public:

private:
char CallerNumber[80];
int modemFd;

Timeout	timer;

public:

 fsrv_typ fsrv;
 char devicename[80];
 char nebenstelle[80];
 char service[80];
 time_t zeitstempel;

    FTPServer();
    ~FTPServer();
    void startTimeout(long ms);
    int open(char *Devicename);
    int rcv_packet(char *pattern, int sec);
    int rcv_caller(int sec);
    int checksum(char *p,int len);
    int write_pack(pack_typ *rbuf);
    int send_ack();
    int send_err();
    int rcv_pack(pack_typ  *rbuf);
    int check_pack(pack_typ *rbuf);
    int create_file();
    int accept_con();
    int serve_it();
    int close_fds();
    int create_tdd();
    void trace();
    void spezial_modem_init();
    int atCmd(char *text);
    int setRawModeOn();
    int setRawModeOff();
    void atMode();
    int getDocId();
    int getRecvId();
    void write_jobfile(int docid);

    void write_xferlog_info(
	char *path,	/* Path der Log Datei */
	char *start, 	/* zB. 10/10/1997 15:19 */
	char *cmd, 	/* zB.: "SEND" */
	char *commid, 	/* zB.: "00000002" */
	char *device, 	/* zB.: "cui2" */
	char *jobid, 	/* zB.: "108" */
	char *jobtag, 	/* zB.: "" */
	char *user, 	/* zB.: "root at Jimlinux.pds.de" */
	char *dest, 	/* zB.: "855675" */
	char *csi, 	/* zB.: "" */
	unsigned int params, 	/* zB.: 65535 */
	int npages, 	/* zB.: 0 */
	char *duration, /* zB.: "0:33" */
	char *conntime, /* zB.: "0:00" */
	char *status 	/* zB.: "Unknown Problem (Check Modem Power)" */
	);


    void insert_char( char *ptr, int offset );
    void setJobToken( char *path, char *token, char *state );


};


#endif
