/*******************************************************************************
** $BASIS/pds/isdn/lprg/isdn_bftsend.c
**
*******************************************************************************/
/*
#define TEST_MAIN
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <fcntl.h>
#include <varargs.h>
#include <stdlib.h>
#include <unistd.h>
#include <isdn/l_lib.h>
#include "pds/pdsisdn.h"

#define MAX_RETRY        4        /* also max 4 sende versuche */
#define TOUT_ACK         4

/*--------------------------------------------------------------------*/
typedef struct
{
/* interne Variable */
 FILE   *fptr;
 int     confd;
 int     sendblock;
 int     tries;
 int     lastblock;
 time_t  starttime;
} job_typ;

typedef struct
{
 int   chksum;
 int   packlen;
 int   opcode;
 int   packnr;
} header_typ;

typedef struct
{
 header_typ head;
 char       data[FT_DATALEN];
} pack_typ;

static char *ErrorIntern =
"Die Datei wurde nicht bertragen. Der Grund ist ein interner Fehler in den Kommunikationsanwendung. Wenden Sie sich zu Klaerung mit folgender Fehlermeldung an die PDS-Hotline:\n\n";


static int checksum	TB_PROTO(( char *, int ));
static int close_con	TB_PROTO(( xmt_typ *,job_typ * ));
static int open_con	TB_PROTO(( xmt_typ *,job_typ * ));
static int open_file    TB_PROTO(( xmt_typ *,job_typ * ));
static int xmit_file	TB_PROTO(( xmt_typ *,job_typ * ));
static int read_data	TB_PROTO(( xmt_typ *,job_typ *,pack_typ * ));
static int send_data	TB_PROTO(( xmt_typ *,job_typ *,pack_typ * ));
static int rcv_answer   TB_PROTO(( xmt_typ *,job_typ *,pack_typ * ));
static int check_answer TB_PROTO(( xmt_typ *,job_typ *,pack_typ * ));
static int do_retry	TB_PROTO(( int ));
static int cause_diag	TB_PROTO(( int ));
static char *cause_text	TB_PROTO(( int ));

/*--------------------------------------------------------------------*/
extern char *sys_errlist[];
extern char *t_errlist[];

#ifndef R_UNIXWARE
extern int   t_errno;
#endif

#ifdef TEST_MAIN
static int    debug = 1;
#else
static int    debug = 0;
#endif

/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
int isdn_send_bft(xmt)
xmt_typ *xmt;
{
 job_typ job;

 xmt->diagnostic = 0;
 xmt->result     = 0;
 xmt->retry      = 0;
 xmt->charge     = 0;
 xmt->duration   = 0;
 xmt->result_str[0] = 0;

 if (open_file(xmt,&job))
    return (-1);

 if (open_con(xmt,&job))
 {
    fclose(job.fptr);
    return (-1);
 }

 xmit_file(xmt,&job);
 close_con(xmt,&job);
 fclose(job.fptr);
 return (xmt->result);
}

/*************************************************************/
static int xmit_file(xmt,job)
xmt_typ *xmt;
job_typ *job;
{
 pack_typ  wbuf,rbuf;
 int       res;

 job->sendblock = 1;
 job->tries     = 1;
 job->lastblock = 0;
 while (1)
 {
    read_data  (xmt,job,&wbuf);
    if (send_data  (xmt,job,&wbuf))
       break;

    if (debug)
       fprintf (stderr,"Block %d gesendet\n",job->sendblock);

    res = rcv_answer (xmt,job,&rbuf);
    switch (res)
    {
       case -1: /* Fehler beim Lesen, bzw. disconnect */
          return (-1);
       case  0:
          res = check_answer (xmt,job,&rbuf);
          if (res == 1)   /* letztes packet */
          {
             xmt->result = 0;
             xmt->retry  = 0;
             return (0);
          }
          if (debug)
             fprintf (stderr,"ACK %d emfangen\n",rbuf.head.packnr);
          break;
       case  1: /* timeout */
       default:
          job->tries++;
          break;
    }

    if (job->tries > MAX_RETRY)
    {
       sprintf (xmt->result_str,"Kommunikation zur Gegenstelle gestoert.");
       xmt->diagnostic = D_BADKOMM;
       xmt->result = -3;
       xmt->retry  = 1;
       return (-1);
    }

    if (xmt->result < 0)
       break;
 }
 return (0);
}



/*************************************************************/
static int read_data(xmt,job,wbuf)
xmt_typ  *xmt;
job_typ  *job;
pack_typ *wbuf;
{
 static int lastblock=0;
 int        len;

 if (lastblock != (job->sendblock -1))
 {
    if (job->sendblock == lastblock)
    {
       if (debug)
          fprintf (stderr,"sendblock = lastblock = %d\n",job->sendblock);
       return (0);
    }
    else
    {
       fseek (job->fptr,(job->sendblock-1)*FT_DATALEN,SEEK_SET);
       if (debug)
          fprintf (stderr,"backward: sendblock = %d\n",job->sendblock);
    }
 }

 len = fread(wbuf->data, 1, FT_DATALEN, job->fptr);
 if (len < FT_DATALEN)
    job->lastblock = 1;
 lastblock    = job->sendblock;
 wbuf->head.opcode  = FTOP_DATA;
 wbuf->head.packnr  = job->sendblock;
 wbuf->head.packlen = len + sizeof(header_typ);
 wbuf->head.chksum  = checksum ((char *)(&(wbuf->head.packlen)),len + sizeof(header_typ) - 4);
 return (0);
}


/*************************************************************/
static int send_data(xmt,job,wbuf)
xmt_typ  *xmt;
job_typ  *job;
pack_typ *wbuf;
{
 int rcode;

 rcode = t_snd (job->confd, (char *)&(wbuf->head.chksum), wbuf->head.packlen,0);
 if (rcode < 0)
 {
    sprintf (xmt->result_str,"%s t_snd() (%s)",
             ErrorIntern, t_errlist[t_errno]);
    xmt->diagnostic = D_SMS_TLIERR;
    xmt->result = -3;
    xmt->t_errno = t_errno;
    return (-1);
 }
 return (0);
}

/*************************************************************
ergebnis: -1 Fehler
           1 Timeout (kein Packet)
           0 normales Packet
*************************************************************/
static int rcv_answer(xmt,job,rbuf)
xmt_typ  *xmt;
job_typ  *job;
pack_typ *rbuf;
{
 int rcode,rec,flags=0,event;
 struct pollfd  fds[1];

 fds[0].fd      = job->confd;
 fds[0].events  = POLLIN;

 while (1)
 {
    rcode = poll (fds,1,TOUT_ACK * 1000);
    if (rcode == 0)
    { /* normaler Timeout */
       return (1);
    }
    if (rcode < 0)
    {
       switch (errno)
       {
          case EAGAIN:
  	     continue;
          case EINTR:
             sprintf (xmt->result_str,"Abbruch durch ein Signal.");
             xmt->errno  = errno;
             xmt->diagnostic = D_TX_ABORTED;
             xmt->retry  = 1;
             xmt->result = -3;
             return (-1);
          default:
             sprintf (xmt->result_str,"%s poll() : %s",ErrorIntern,
                      sys_errlist[errno]);
             xmt->errno   = errno;
             xmt->diagnostic = D_INTERNAL;
             xmt->retry   = 1;
             xmt->result  = -3;
	     return (-1);
       }
    }
    /* jetzt ist mal wieder ein paket da */

    rec = t_rcv (job->confd,(char *)&(rbuf->head.chksum),FT_DATALEN,&flags);
    if (rec < 0)
    {
       if (t_errno == TLOOK)
       {
          event = t_look(job->confd);
          switch (event)
          {
             case T_DISCONNECT:
                sprintf (xmt->result_str,"Verbindung unerwartet von Gegenstelle abgebaut.");
                xmt->diagnostic = D_DISCONNECT;
                xmt->retry   = 1;
                xmt->result  = -3;
                return (-1);

             default:
                continue;
          }
       }

       if (t_errno != TNODATA)
       {
          xmt->t_errno = t_errno;
          sprintf (xmt->result_str,"Systemfehler: t_rcv() (%s)",
                   t_errlist[t_errno]);
          xmt->diagnostic = D_SMS_TLIERR;
          xmt->result  = -2;
          xmt->retry   = 1;
          return (-1);
       }
    }
    if (rec > 0)
    {
       return (0);
    }
 }
}

/*************************************************************/
static int check_answer(xmt,job,rbuf)
xmt_typ  *xmt;
job_typ  *job;
pack_typ *rbuf;
{
 int offs;

 if ((rbuf->head.packlen < sizeof(header_typ)) ||
     (rbuf->head.packlen > (FT_DATALEN + sizeof(header_typ))))
    return (0);

 if (checksum ((char *)&(rbuf->head.packlen),rbuf->head.packlen - 4) != rbuf->head.chksum)
    return (0);

 /* ab hier liegt ein ordentliches Paket vor */
 switch (rbuf->head.opcode)
 {
    case FTOP_ACK: /* ok, naechstes paket senden */
        job->tries=1;
        job->sendblock = rbuf->head.packnr + 1;
        if (job->lastblock)
           return (1); /* ok, alles paletti, transfer ist fertig */
    case FTOP_ERROR:
        if (rbuf->head.packlen > sizeof(header_typ)) /* jetzt ist es eine Fehlermeldung */
        {
           strcpy (xmt->result_str,"PROBLEM AUF GEGENSEITE: ");
           offs = strlen (xmt->result_str);
           memcpy (&(xmt->result_str[offs]),rbuf->data,rbuf->head.packlen - sizeof(header_typ));
           xmt->diagnostic = D_BADKOMM;
           xmt->result = -3;
           xmt->retry  = 1;
           return (-1);
        }
        break;
    default:
        break;
 }
 return (0);
}


/*************************************************************/
static int open_file(xmt,job)
xmt_typ *xmt;
job_typ *job;

{
 struct stat statbuf;

 if (stat (xmt->sourcepath,&statbuf))
 {
    sprintf (xmt->result_str,"Zu sendende Datei %s nicht gefunden",
             xmt->sourcepath);
    xmt->diagnostic = D_OPNFIL;
    xmt->result = -4;
    return (-1);
 }
 if (!(statbuf.st_mode & S_IFREG))
 {
    sprintf (xmt->result_str,"Zu sendende Datei %s ist nicht regulaer",
             xmt->sourcepath);
    xmt->diagnostic = D_OPNFIL;
    xmt->result = -4;
    return (-1);
 }

 if (!(statbuf.st_mode & S_IREAD))
 {
    sprintf (xmt->result_str,"Keine Leseberechtigung fr Datei %s",
             xmt->sourcepath);
    xmt->diagnostic = D_OPNFIL;
    xmt->result = -4;
    return (-1);
 }

 job->fptr = fopen (xmt->sourcepath,"rb");
 if (!job->fptr)
 {
    sprintf (xmt->result_str,"Fehler beim fopen() der Datei %s",
             xmt->sourcepath);
    xmt->diagnostic = D_OPNFIL;
    xmt->result = -4;
    return (-1);
 }
 return (0);
}

/*************************************************************/
static int open_con(xmt,job)
xmt_typ *xmt;
job_typ *job;
{
 struct t_call  *callp;
 struct t_bind  *bindp;
 struct t_discon disc;
 int             event;
 char           *escape,*isdndev;
 char            restelno[80];

 isdndev = isi_default("BASE_isdndev",NULL);
 if (!isdndev)
 {
    sprintf (xmt->result_str,"%s. Kann isdndev nicht bestimmen!",
             ErrorIntern);
    xmt->diagnostic = D_INTERNAL;
    xmt->result = -1;
    xmt->retry  = 1;
    return(-1);
 }

 job->confd = t_open(isdndev,O_RDWR,NULL);
 if (job->confd < 0)
 {
    xmt->result  = -1;
    xmt->diagnostic = D_INTERNAL;
    xmt->t_errno = t_errno;
    sprintf (xmt->result_str,"Datei nicht versendet. Systemfehler: t_open() (%s)",
             t_errlist[t_errno]);
    return(-1);
 }

 bindp=(struct t_bind*)isi_bindaddr(FTXFER_SERVICE,0);
 if (t_bind(job->confd,bindp,NULL) < 0)
 {
    xmt->result  = -1;
    xmt->diagnostic = D_INTERNAL;
    xmt->t_errno = t_errno;
    sprintf (xmt->result_str,"Datei nicht bertragen.\n Systemfehler: t_bind() (%s)",
             t_errlist[t_errno]);
    t_close(job->confd);
    return(-1);
 }

 escape = isi_default("BASE_escape",NULL);
 if (!*escape)
    sprintf (restelno,"=%s",xmt->telno);
 else
    sprintf (restelno,"=%s%s",escape,xmt->telno);

 callp = isi_getaddr(restelno,FTXFER_SERVICE);
 if (!callp)
 {
    xmt->result  = -4;
    xmt->diagnostic = D_INTERNAL;
    xmt->t_errno = t_errno;
    sprintf (xmt->result_str,"Datei nicht bertragen.\nisi_getaddr() fehlgeschlagen\n");
    t_close(job->confd);
    return(-1);
 }

 if (t_connect(job->confd, callp,callp) == -1)
 {
    memset (&disc,0,sizeof (disc));
    t_rcvdis (job->confd,&disc);

    if (disc.reason)
    {
       sprintf (xmt->result_str,"Datei nicht versendet, da die Verbindung zum Gegenstelle (Rufnummer %s) nicht hergestellt werden konnte.\n\nUrsache : %s ",
                xmt->telno,
                cause_text (disc.reason));
       xmt->cause  = disc.reason;
       xmt->retry  = do_retry(xmt->cause);
       xmt->diagnostic = cause_diag(disc.reason);
       xmt->result = -1;  /* keine Verbindung */
    }
    else
    {
       if (t_errno == TLOOK)
       {
          event = t_look(job->confd);
          switch (event)
          {
             case T_DISCONNECT:
                sprintf (xmt->result_str,"Datei nicht bertragen, Verbindung zur Gegenstelle abgebrochen.");
                xmt->diagnostic = D_BADKOMM;
                xmt->result  = -3;
                break;
             default:
                sprintf (xmt->result_str,"Die Verbindung zur Gegenstelle (Rufnummer %s) konnte nicht hergestellt werden!", xmt->telno);
                xmt->diagnostic = D_BADKOMM;
                xmt->result  = -1;
                break;
          }
       }
       else
       {
          sprintf (xmt->result_str,"%s TLI-Fehler %s (t_errno %d)",
                   ErrorIntern,
                   t_errlist[t_errno],
                   t_errno);
          xmt->t_errno = t_errno;
          xmt->diagnostic = D_SMS_TLIERR;
          xmt->result  = -1;  /* keine Verbindung */
       }
    }

    xmt->charge = isi_getcharge(job->confd);
    t_close (job->confd);
    return (-1);
 }

 if (fcntl (job->confd,F_SETFL,O_NONBLOCK) < 0)
 {
    sprintf (xmt->result_str,"%s fcntl() : %s",
             ErrorIntern,
             sys_errlist[errno]);
    xmt->errno   = errno;
    xmt->diagnostic = D_INTERNAL;
    xmt->result  = -4;
    xmt->charge = isi_getcharge(job->confd);
    t_close (job->confd);
    return (-1);
 }
 job->starttime = time(0);
 return(0);
}

/*--------------------------------------------------------------------*/
static int checksum(p,len)
char *p;
int len;
{
 int   sum,i;

 for (i=0,sum=0;i<len;i++)
    sum += p[i];

 return (sum);
}

/*--------------------------------------------------------------------*/
static int close_con(xmt,job)
xmt_typ *xmt;
job_typ *job;
{
 xmt->charge = isi_getcharge(job->confd);
 xmt->duration = time(0) - job->starttime;
 t_close(job->confd);
 return (0);
}

/*--------------------------------------------------------------------*/
static int do_retry(cause)
int cause;
{
 switch (cause)
 {
    case 0x01: /* no channel avail */
    case 0x08: /* cannot activate L1 */
    case 0x09: /* cannot get TEI */
    case 0x81: /* invalid call reference value */
    case 0x8a: /* no channel avail */
    case 0xa1: /* busy */
    case 0xb9: /* out of order */
    case 0xbb: /* user access busy */
    case 0xbd: /* incoming calls barred */
    case 0xbe: /* call rejected */
    case 0xd9: /* network congestion */
    case 0xda: /* remote user initiated */
    case 0xf0: /* local procedure error */
    case 0xf1:
    case 0xf2:
    case 0xf3:
    case 0xf4:
       return (1);
    default :
       return (0); /* es macht keine sinn es nochmal zu versuchen */
 }
}

/*--------------------------------------------------------------------*/
static char *cause_text(cause)
int cause;
{
static char errbuf[101];

 switch (cause)
 {
    case 0x01: /* no channel avail */
    case 0x8a: /* no channel avail */
       return ("Kein B-Kanal verf}gbar");
    case 0x08: /* cannot activate L1 */
       return ("Kann nicht auf den ISDN-Anschluss zugreifen");
    case 0x02:
       return ("Ung}ltige Protokoll-Optionen");
    case 0x03:
       return ("Ung}ltige ISDN-Adresse");
    case 0x0a:
       return ("Protokoll-Verletztung auf Schicht 2");
    case 0x39:
       return ("Interner Protokoll-Fehler");
    case 0x09: /* cannot get TEI */
       return ("Kann kein TEI holen");
    case 0x80:
       return ("Verbindung vom Gegenseite unterbrochen");
    case 0x81: /* invalid call reference value */
       return ("Ung}ltiger Ruf-Referenzwert");
    case 0xa1: /* busy */
    case 0xbb: /* user access busy */
       return ("Anschluss ist besetzt");
    case 0xb9: /* out of order */
       return ("Anschluss ist ausser Betreib");
    case 0xbd: /* incoming calls barred */
       return ("Eingehende Rufe werden abgelehnt");
    case 0xbe: /* call rejected */
       return ("Ruf wurde abgewiesen");
    case 0xd9: /* network congestion */
       return ("Vor}bergehende ISDN-Netzwerk}berlastung");
    case 0xb5:
       return ("Kein Anschluss unter dieser Nummer");
    case 0xba:
       return ("Gegenstelle hebt nicht ab");
    default :
       sprintf(errbuf, "Fehler %x", cause);
       return(errbuf);
 }
}

/*--------------------------------------------------------------------*/
static int cause_diag(cause)
int cause;
{
 switch (cause)
 {
    case 0x01: /* no channel avail */
    case 0x8a: /* no channel avail */
       return (D_NOCHAN);
    case 0x08: /* cannot activate L1 */
    case 0xb9: /* out of order */
       return (D_NOLAY1);
    case 0x02:
    case 0x0a:
    case 0x39:
    case 0x09:
    case 0x81: /* invalid call reference value */
       return (D_PROTO);
    case 0x03:
       return (D_INTERNAL);
    case 0x80:
       return (D_DISCONNECT);
    case 0xa1: /* busy */
    case 0xbb: /* user access busy */
       return (D_OCCUPIED);
    case 0xbd: /* incoming calls barred */
    case 0xbe: /* call rejected */
       return (D_DISCHAR);
    case 0xd9: /* network congestion */
       return (D_NETLOAD);
    case 0xb5:
       return (D_NOPARTN);
    case 0xba:
       return (D_NOANSWE);
    default :
       return (D_UNKNOWN);
 }
}

#ifdef TEST_MAIN
/*--------------------------------------------------------------------*/
int main(argc,argv)
int argc;
char *argv[];

{
 xmt_typ xmt;

 strcpy (xmt.telno,"042619749111");
 strcpy (xmt.sourcepath,"/tmp/ttt");

 if (argc > 1)
    strcpy (xmt.telno,argv[1]);

 if (argc > 2)
    strcpy (xmt.sourcepath,argv[2]);

 isdn_send_bft(&xmt);

 fprintf (stderr,"---------------------------------------------------------\n");
 fprintf (stderr,"Ergebnis  : %d\n",xmt.result);
 fprintf (stderr,"Nochmal   : %s\n",xmt.retry?"JA":"NEIN");
 fprintf (stderr,"Fehlertxt : %s\n",xmt.result_str);
 fprintf (stderr,"Gebuehren : DM %3.2f\n",(float)((xmt.charge * 12.)/100.));
 fprintf (stderr,"Dauer     : %d Sekunden\n",xmt.duration);
 return (0);
}

#endif
