/*******************************************************************************
** $BASIS/pds/isdn/lprg/isdn_d1.c
**
** ge{ndert
** 29.04.97	Hinrichs/PDS	Stringparsing fehlertoleranter gestaltet
*******************************************************************************/
/*
#define TEST_MAIN
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include <isdn/l_lib.h>
#include <pds/pdsisdn.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#define MODEMSERVICE  "smsc_a_d1"
#define ISDNSERVICE   "smsc_d_d1"

#define MAXMSGLEN     4000
#define MAXRETRY      3        /* also max 3 sende versuche */
#define MAXMSG        4        /* max anzahl kurzmitt. je session */
#define MAXCR         8        /* max anzahl CR, bevor aufgelegt wird */

#define A_START          0
#define A_SEND_REQ       1
#define A_SEND_ACK       2
#define A_RCV_ANSW       3
#define A_END            4
#define A_SEND_ALERT     5
#define A_SEND_CR        6
#define A_SEND_ID        7
#define A_RCV_ID         8
#define A_RCV_LOGINRES   9
#define A_SEND_QUERY    10
#define A_PAR_QUERY     11

#define TOUT_CR       1
#define TOUT_ACK      10
#define TOUT_ID       2
#define TOUT_NOTE     17
#define TOUT_TOTAL    60
#define TOUT_CONNECT  40

#define SMSC_MODEM1        "01712092522"
#define SMSC_MODEM2        "0911663070"
#define SMSC_MODEM3        "0911663071"
#define SMSC_ISDN1         ""
#define SMSC_ISDN2         ""
#define SMSC_ISDN3         ""

#ifndef R_UNIXWARE
extern int _xti_error        TB_PROTO (( char * ));
#endif
/*--------------------------------------------------------------------*/
static int   check_answer    TB_PROTO (( char *, sms_typ * ));
static char *checksum        TB_PROTO (( char * ));
static int   do_retry        TB_PROTO (( int ));
static char *cause_text      TB_PROTO (( int ));
static char *strpos          TB_PROTO (( char *, char * ));
static int   send_transfer_req TB_PROTO (( sms_typ *, int ));
static int   get_offsets     TB_PROTO (( char *, int *, int * ));
static int   send_query      TB_PROTO (( sms_typ *, int ));
static int   send_cr         TB_PROTO (( sms_typ *, int ));
static int   send_id         TB_PROTO (( sms_typ *, int ));
static int   parameter_query TB_PROTO (( sms_typ *, int ));
static int   open_smsc       TB_PROTO (( sms_typ * ));
static int   close_smsc      TB_PROTO (( int , sms_typ * ));
static int   rcv_packet      TB_PROTO (( int, char *, char *, sms_typ *, int ));
static int   rcv_answer      TB_PROTO (( int, char *, sms_typ *, int ));
static void  catch_alarm     TB_PROTO (( int ));
/*--------------------------------------------------------------------*/
extern char *sys_errlist[];
extern char *t_errlist[];

#ifndef R_UNIXWARE
extern int   t_errno;
#endif

#ifdef TEST_MAIN
static int    debug = 1;
#else
static int    debug = 0;
#endif

static int    prev_action;
static int    connect_timeout=0;
static time_t starttime;
static time_t querystart;


/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
int send_d1_message(sms)
sms_typ *sms;
{
 int  fd,res,action,rcv_timeout=10;
 char buf[MAXMSGLEN];
 char *p1;
 int  cr_sent=0;
 int  parquerycnt = 0;
 time_t t=time(0);

 sms->result  = -5;
 sms->retry   = 0;
 sms->t_errno = 0;
 sms->errno   = 0;
 sms->cause   = 0;
 sms->duration= 0;
 sms->ec      = 0;   /* error code vom smsc, nur bei d2 */
 sms->gebuehr = 0;
 sms->trn     = 0;
 sms->result_str[0] = 0;
 sms->sendezeit[0]  = 0;
 fd = open_smsc(sms);
 if (fd < 0)
    return (-1);

 starttime    = time(0);
 prev_action  = A_START;
 action       = A_SEND_CR;
 while (1)
 {
    if ((time(0) - starttime) > TOUT_TOTAL)
       action = A_END;

    switch (action)
    {
       case A_SEND_CR:
          cr_sent++;
          if (send_cr(sms,fd))
             action = A_END;
          else
             action = A_RCV_ID;

          prev_action = A_SEND_CR;
          break;

       case A_RCV_ID:
          res = rcv_packet(fd,buf,"ID=",sms,TOUT_CR);
          if (res == 0)
             action = A_SEND_ID;

          if (res < 0)
             action = A_END;    /* fehler beim lesen */

          if (res > 0)
          {  /* timeout */
             if (cr_sent >= MAXCR)
             {
                sms->result = -6;
                sms->retry = 1;   /* vielleicht klappt es beim n{chsten mal */
                p1 = strchr (buf,'\r');
                if (p1) *p1=0;
                sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nKein Login-Prompt vom D1-SMS-Center erhalten.\n%s%s",
                         *buf?"Meldung: ":"",buf);
                action = A_END;
             }
             else
             {
                action = A_SEND_CR;
             }
          }
          prev_action = A_RCV_ID;
          break;

       case A_SEND_ID:
          if (send_id(sms,fd))
             action = A_END;
          else
             action = A_RCV_LOGINRES;
          prev_action = A_SEND_ID;
          break;

       case A_RCV_LOGINRES:
          res = rcv_packet(fd,buf,"\033[p\r",sms,8);
          if (res == 0)
          {
             if (debug)
                fprintf (stderr, "Login erfolgreich\n");
             action = A_PAR_QUERY;
          }

          if (res <  0)
             action = A_END;    /* fehler beim lesen oder ende der conn*/

          if (res > 0)          /* timeout */
             action = A_SEND_ID;
          prev_action = A_RCV_LOGINRES;
          break;

       case A_PAR_QUERY:
          parquerycnt++;
          rcv_timeout = 3;
          if (parameter_query(sms,fd))
             action = A_END;
          else
             action = A_RCV_ANSW;
          prev_action = A_PAR_QUERY;
          break;

       case A_SEND_REQ:
          sms->trn++;
          if (sms->trn > MAXRETRY)
          {
             sms->result = -5;
             sms->retry  = 1;
             if (!(sms->result_str[0]))
                sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nKeine positive Antwort vom D1-SMS-Center.");
             return (A_END);
          }

          rcv_timeout = 10;
          if (send_transfer_req(sms,fd))
             action = A_END;
          else
             action = A_RCV_ANSW;
          prev_action = A_SEND_REQ;
          break;

       case A_RCV_ANSW:
          res = rcv_answer(fd,buf,sms,rcv_timeout);
          if (res < 0) /* fehler beim lesen oder conn-ende*/
             action = A_END;

          if (res > 0) /* timeout */
          {
             if (prev_action == A_PAR_QUERY)
             {
               if (parquerycnt >= MAXRETRY)
               {
                  sms->result = -5;
                  sms->retry = 1;
                  sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nErmittlung der Systemparamter des D1-SMS-Centers fehlgeschlagen.");
                  action = A_END;
               }
               else
                  action = A_PAR_QUERY;
             }
          }
          else
          {  /* ab hier liegt ein paket vor */
             action = check_answer(buf,sms);
          }
          prev_action = A_RCV_ANSW;
          break;

       case A_SEND_QUERY:
          if ((time(0) - querystart) > TOUT_NOTE)
          {
             action = A_END;
          }
          else
          {
             if (send_query(sms,fd))
                action = A_END;
             else
                action = A_RCV_ANSW;
          }
          prev_action = A_SEND_QUERY;
          break;

       default:

          sms->result = -5;
          sms->retry  = 1;
          sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nInterner Ablauffehler.");
          action = A_END;
          break;
    }

    if (action == A_END)
       break;
 }

 close_smsc(fd,sms);
 sms->duration = time(0) - t;
 return (0);
}

/*--------------------------------------------------------------------*/
static int check_answer(buf,sms)
char    *buf;
sms_typ *sms;
{
 char        *p1,*p2;
 static int   firstmessid = 1;

 sms->ackflag = 0;

 if (prev_action == A_PAR_QUERY)
 {
    sms->send_lim = 0;
    sms->quer_lim = 0;
    sms->dele_lim = 0;

    if (isinstr (buf,"\r\006\r"))
    {
       p2 = buf;
       p1 = strchr(p2,',');
       if (p1)
       {
          *p1 = 0;
          sms->send_lim = atoi(p2);
          if (debug)
             fprintf(stderr,"Sendlimit = %d\n",sms->send_lim);
          p2 = p1+1;
       }
       else
          return (A_SEND_REQ);

       p1 = strchr(p2,',');
       if (p1)
       {
          *p1 = 0;
          sms->quer_lim = atoi(p2);
          if (debug)
             fprintf(stderr,"Querylimit = %d\n",sms->quer_lim);
          p2 = p1+1;
       }
       else
          return (A_SEND_REQ);
       /* hier mu ich nach , oder CR suchen, da nicht 3 sondern mgl. 4
          parameter gesendet werden */
       p1 = strchr(p2,',');
       if (!p1)
          p1 = strchr(p2,'\r');

       if (p1)
       {
          *p1 = 0;
          sms->dele_lim = atoi(p2);
          if (debug)
             fprintf(stderr,"Deletelimit = %d\n",sms->dele_lim);
       }
    }
    return (A_SEND_REQ);
 }

 if (prev_action == A_SEND_REQ)
 {
    if (isinstr(buf,"Operation failed"))
    {
       sms->result = -5;
       sms->retry  = 1;
       p1 = strchr (buf,'\r');
       if (p1) *p1=0;
       sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nMeldung: %-70s",
                buf);
       return (A_SEND_REQ);
    }

    if (isinstr(buf,"confirm failed"))
    {
       if (isinstr(buf,"subscriber not allowed to receive messages"))
       {
          sms->result = -5;
          sms->retry  = 0;
          sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nTeilnehmer hat keine Berechtigung zum Empfang von\nKurzmitteilungen.");
          return (A_END);
       }
       if (isinstr(buf,"subscriber not on database"))
       {
          sms->result = -5;
          sms->retry  = 0;
          sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nTeilnehmer ist nicht in der Datenbank des D1-SMS-Centers.");
          return (A_END);
       }
       if (isinstr(buf,"no message text provided"))
       {
          sms->result = -5;
          sms->retry  = 0;
          sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nKein Mitteilungstext uebergeben.");
          return (A_END);
       }

       if (isinstr(buf,"system problem"))
       {
          sms->result = -5;
          sms->retry  = 1;
          sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nSystem-Problem im D1-SMS-Center.");
          return (A_END);
       }
       else
       {
          sms->result = -5;
          sms->retry  = 0;
          p1 = strchr (buf,'\r');
          if (p1) *p1=0;
          sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nMeldung: %-70s",
                   buf);
          return (A_END);
       }
    }

    if (isinstr (buf,"successful"))
    {
       sms->ackflag = 1;
       if (sms->wait_note)
       {
          if (firstmessid)
          {  /* damit beim langen Messages nur die Besttigung fr den ersten
                teil berprft wird */
             firstmessid = 0;
             p1=strpos(buf,"Message");
             if (p1)
             {
                strncpy (sms->messid,&p1[8],15);
                sms->messid[15]=0;
                p1 = strchr(sms->messid,' ');
             }
             if (p1)
                *p1 = 0;
             else
             {
                sprintf (sms->result_str,"Kurzmitteilung erfolgreich an das D1-SMS-Center uebergeben.\nDie Auslieferung an das D1-Handy wurde nicht bestaetigt.\nFehler beim Bestimmen der Message-ID.");
                sms->result = 0;
                sms->retry  = 0;
                return (A_END);
             }
          }
       }
       if (sms->more_to_send)
          return (A_SEND_REQ);

       if (prev_action == A_SEND_REQ)
          querystart = time(0);

       if (isinstr (buf,"message has been delivered"))
       {
          sms->result = 1;
          sms->retry  = 0;
          sprintf (sms->result_str,"Kurzmitteilung erfolgreich an das D1-Handy ausgeliefert.");
          return (A_END);
       }
       else
       {
          sprintf (sms->result_str,"Kurzmitteilung erfolgreich an das D1-SMS-Center uebergeben.\nDie Auslieferung an das D1-Handy wurde nicht bestaetigt.");
          sms->result = 0;
          sms->retry  = 0;

          if (sms->wait_note)
          {
             if (isinstr (buf,"limit reached"))
                return (A_END);

             if (sms->quer_lim)
                isdn_sleep(8); /* jetzt lieber langsamer fragen */
             else
                isdn_sleep(1);

             return (A_SEND_QUERY);
          }
          else
             return (A_END);
       }
    }

    sms->result = -5;
    sms->retry  = 1;
    p1 = strchr (buf,'\r');
    if (p1) *p1=0;
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nMeldung: %-70s",
             buf);
    return (A_END);
 }

 if (prev_action == A_SEND_QUERY)
 {
    if (isinstr (buf,"successful"))
    {
       sms->ackflag = 1;

       if (sms->more_to_send)
          return (A_SEND_REQ);

       if (prev_action == A_SEND_REQ)
          querystart = time(0);

       if (isinstr (buf,"message has been delivered"))
       {
          sms->result = 1;
          sms->retry  = 0;
          sprintf (sms->result_str,"Kurzmitteilung erfolgreich an das D1-Handy ausgeliefert.");
          return (A_END);
       }
       else
       {
          sprintf (sms->result_str,"Kurzmitteilung erfolgreich an das D1-SMS-Center uebergeben.\nDie Auslieferung an das D1-Handy wurde nicht bestaetigt.");
          sms->result = 0;
          sms->retry  = 0;

          if (sms->wait_note)
          {
             if (isinstr (buf,"limit reached"))
                return (A_END);

             if (sms->quer_lim)
                isdn_sleep(8); /* jetzt lieber langsamer fragen */
             else
                isdn_sleep(1);

             return (A_SEND_QUERY);
          }
          else
             return (A_END);
       }
    }

    if (isinstr(buf,"query failed"))
    {
       if (isinstr(buf,"message not available") ||
           isinstr(buf,"subscriber id mismatch"))
       {
          sms->result = -3;
          sms->retry  = 0;
          sprintf (sms->result_str,"Kurzmitteilung wurde nicht versendet.\nDas D1-SMS-Center konnte die Kurzmitteilung nicht ausliefern.\nMgl. ungltige D1-Teilnehmernummer.");
       }
       else
       {
          sms->result = -3;
          sms->retry  = 0;
          sprintf (sms->result_str,"Kurzmitteilung wurde nicht versendet.\nMeldung vom D1-SMS-Center: %s",buf);
       }
    }
    return (A_END);
 }

 if (isinstr (buf,"\004\r")) /* EOT */
 {
    sms->result = -5;
    sms->retry  = 1;
    p1 = strchr (buf,'\r');
    if (p1) *p1=0;
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nMeldung: %-70s",
             buf);
    return (A_END);
 }

 if (isinstr (buf,"\r\017\r")) /* NAK */
 {
    if ((prev_action == A_SEND_REQ) || (prev_action == A_SEND_QUERY))
    {
       sms->result = -5;
       sms->retry  = 0;
       p1 = strchr (buf,'\r');
       if (p1) *p1=0;
       sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nMeldung: %-70s",
                buf);
       return (prev_action);
    }
 }

 sms->result = -5;
 sms->retry  = 0;
 p1 = strchr (buf,'\r');
 if (p1) *p1=0;
 sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nMeldung: %-70s",
          buf);
 return (A_END);
}

/*--------------------------------------------------------------------*/
static int do_retry(cause)
int cause;
{
 switch (cause)
 {
    case 0x00: /* kein Modemkontakt*/
    case 0x01: /* no channel avail */
    case 0x08: /* cannot activate L1 */
    case 0x09: /* cannot get TEI */
    case 0x80: /* Gegenseite hat aufgelegt */
    case 0x81: /* invalid call reference value */
    case 0x8a: /* no channel avail */
    case 0xa1: /* busy */
    case 0xb9: /* out of order */
    case 0xba: /* no user responding */
    case 0xbb: /* user access busy */
    case 0xbd: /* incoming calls barred */
    case 0xbe: /* call rejected */
    case 0xd9: /* network congestion */
    case 0xda: /* remote user initiated */
    case 0xf0: /* local procedure error */
    case 0xf1:
    case 0xf2:
    case 0xf3:
    case 0xf4:
       return (1);
    default :
       return (0); /* es macht keine sinn es nochmal zu versuchen */
 }
}

/*--------------------------------------------------------------------*/
static char *cause_text(cause)
int cause;
{
 static char   buf[81];

 switch (cause)
 {
    case 0x00:
       return ("Modemkontakt fehlgeschlagen");
    case 0x01: /* no channel avail */
    case 0x8a: /* no channel avail */
       return ("Kein B-Kanal verfuegbar");
    case 0x08: /* cannot activate L1 */
       return ("Kann nicht auf den ISDN-Anschluss zugreifen");
    case 0x02:
       return ("Ungueltige Protokoll-Optionen");
    case 0x03:
       return ("Ungueltige ISDN-Adresse");
    case 0x0a:
       return ("Protokoll-Verletztung auf Schicht 2");
    case 0x39:
       return ("Interner Protokoll-Fehler");
    case 0x09: /* cannot get TEI */
       return ("Kann kein TEI holen");
    case 0x80: /* wahrscheinlich von gegenstelle abgebaut */
       return ("Abbruch des Verbindungsaufbaus vom D1-SMS-Center");
    case 0x81: /* invalid call reference value */
       return ("Ungueltiger Ruf-Referenzwert");
    case 0xa1: /* busy */
    case 0xbb: /* user access busy */
       return ("Anschluss zum D1-SMS-Centerist besetzt");
    case 0xb9: /* out of order */
       return ("Anschluss des D1-SMS-Centers ist ausser Betreib");
    case 0xbd: /* incoming calls barred */
       return ("Eingehende Rufe werden abgelehnt");
    case 0xbe: /* call rejected */
       return ("Ruf wurde von der Gegenstelle abgelehnt");
    case 0xd9: /* network congestion */
       return ("Voruebergehende ISDN-Netzwerkueberlastung");
    case 0xda: /* remote user initiated */
       return ("Verbindung wurde vom D1-SMS-Center abgebrochen");
    case 0xb5:
       return ("Kein Anschluss unter dieser Nummer");
    case 0xba:
       return ("Gegenstelle hebt nicht ab");
    default :
       strcpy (buf,isi_cause(cause));
       if (!(*buf))
          sprintf (buf,"Unbekannt: cause %x",cause);
       return (buf);
 }
}

/*************************************************************/
static int open_smsc(sms)
sms_typ *sms;
{
 struct t_call *callp;
 struct t_bind *bindp;
 struct t_discon disc;
 int    fd,event;
 char   *escape;
 char   *isdn_prot,restelno[50];
 char   isdn_service[20];

 fd = t_open("/dev/isdn",O_RDWR,NULL);
 if (fd < 0)
 {
    sms->result  = -2;
    sms->t_errno = t_errno;
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nt_open() (%s)",
             t_errlist[t_errno]);
    return(-1);
 }

 if (sms->conn_mode == 0)
 {
    strcpy (isdn_service, MODEMSERVICE); /* modem */
    if (!sms->smsc[0])
       strcpy (sms->smsc,SMSC_MODEM1);
 }
 else
 {
    strcpy (isdn_service,ISDNSERVICE);
    if (!sms->smsc[0])
       strcpy (sms->smsc,SMSC_ISDN1);
 }

 if (!sms->smsc[0]) /* keine SMSC-Nummer vorhanden */
 {
    sms->result  = -2;
    if (sms->conn_mode == 0)
       sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nKeine Telefonummer fr den Modemzugang des D1-SMS-Centers bekannt");
    else
       sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nKeine Telefonummer fr den ISDN-Zugang des D1-SMS-Centers bekannt");
    t_close(fd);
    return(-1);
 }

 bindp=(struct t_bind*)isi_bindaddr(isdn_service,0);
 if (t_bind(fd,bindp,NULL) < 0)
 {
    sms->result  = -2;
    sms->t_errno = t_errno;
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nt_bind() (%s)",
             t_errlist[t_errno]);
    t_close(fd);
    return(-1);
 }

 escape = isi_default("BASE_escape",NULL);
 if (!*escape)
    sprintf (restelno,"=%s",sms->smsc);
 else
    sprintf (restelno,"=%s%s",escape,sms->smsc);

 callp = isi_getaddr(restelno,isdn_service);
 if (!callp)
 {
    sms->result  = -2;
    sms->t_errno = t_errno;
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nisi_getaddr() (%s)\nberprfen Sie bitte die Eintrge in\n/usr/isi/config/services",
             t_errlist[t_errno]);
    t_close(fd);
    return(-1);
 }

/*
 if (sms->conn_mode == 0)
    strcpy (isdn_prot,"NOL3;NOL2;MODEM(bpc=7,parenb=1,parodd=0)");
 else
    strcpy (isdn_prot,"NOL3;NOL2;ASYNC(speed=9600,parodd=0,parenb=0)");
*/

 isdn_prot = isi_getopts("*",isdn_service);
 if (!isdn_prot)
 {
    sms->result  = -5;  /* interner Fehler */
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nProtokolleinstellungen nicht ermittelbar.\nisi_getprot(\"*\",%s) fehlgeschlagen\nberprfen Sie bitte die Eintrge in\n/usr/isi/config/services",
             isdn_service);
    t_close(fd);
    return(-1);
 }

 if (!isi_filloptions (isdn_prot,callp))
 {
    sms->result  = -5;  /* interner Fehler */
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nisi_filloptions(%s) fehlgeschlagen\nberprfen Sie bitte die Eintrge in\n/usr/isi/config/services",
             isdn_service);
    t_close(fd);
    return(-1);
 }
/*
 isi_default("BASE_escape",&escape);

 if (sms->smsc[0])
 {
    if (sms->conn_mode == 0)
       sprintf (callp->addr.buf,"001002%s%s",escape,sms->smsc);
    if (sms->conn_mode == 1)
       sprintf (callp->addr.buf,"007197%s%s",escape,sms->smsc);
 }
 else
 {
    if (sms->conn_mode == 0)
       sprintf (callp->addr.buf,"001002%s%s",escape,SMSC_MODEM1);
    if (sms->conn_mode == 1)
       sprintf (callp->addr.buf,"007197%s%s",escape,SMSC_ISDN1);
 }
*/

 connect_timeout = 0;
 signal (SIGALRM, catch_alarm);
 alarm (TOUT_CONNECT);
 callp->addr.len = strlen(callp->addr.buf);
 if (t_connect(fd, callp,callp) == -1)
 {
    signal (SIGALRM, SIG_IGN);
    alarm (0);

    memset (&disc,0,sizeof (disc));
    t_rcvdis (fd,&disc);

    if (disc.reason)
    {
       sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nKeine Verbindung zum D1-SMS-Center.\nISDN-Ursache : %s",
       cause_text (disc.reason));
       sms->cause  = disc.reason;
       sms->retry  = do_retry(sms->cause);
       sms->result = -1;  /* keine Verbindung */
    }
    else
    {
       if (connect_timeout)
       {
          sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nZeitberschreitung beim Verbindungsaufbau zum D1-SMS-Center.");
          sms->retry   = 1;
          sms->result  = -6;
       }
       else
       {
          if (t_errno == TLOOK)
          {
             event = t_look(fd);
             switch (event)
             {
                case T_DISCONNECT:
                   sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nVerbindungsaufbau unerwartet vom D1-SMS-Center abgebrochen.");
                   sms->retry   = 1;
                   sms->result  = -6;
                   break;
                default:
                   sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nVerbindungsaufbau zum D1-SMS-Center fehlgeschlagen.\nUnerwartetes Ereignis %d\n",
                            event);
                   sms->retry   = 1;
                   sms->result  = -6;
                   break;
             }
          }
          else
          {
             sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nVerbindgunsaufbau zum D1-SMS-Center fehlgeschlagen.\nTLI-Fehler : %s",
                      t_errlist[t_errno]);
             sms->t_errno = t_errno;
             sms->retry  =   1;
             sms->result  = -1;  /* keine Verbindung */
          }
       }
    }

    sms->gebuehr = isi_getcharge(fd);
    t_close (fd);
    return (-1);
 }

 signal (SIGALRM, SIG_IGN);
 alarm (0);

 /*
 if (fcntl (fd,F_SETFL,O_NDELAY) < 0)
 {
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nInterner Fehler.\nfcntl() : %s",
             sys_errlist[errno]);
    sms->errno   = errno;
    sms->result  = -2;
    sms->gebuehr = isi_getcharge(fd);
    t_close (fd);
    return (-1);
 }
   */
 if (sms->conn_mode == 0) /* modem */
 {         /* braucht das Modem */
    isdn_sleep (2);    /* mit signal nicht debugfaehig */
 }
 else
 { /* die eine sekunde braucht der ISDN-Terminal-Adapter des SMSC */
    isdn_sleep (1);    /* mit signal nicht debugfaehig */
 }
 return(fd);
}

/*--------------------------------------------------------------------*/
static char *checksum(buf)
char *buf;
{
 int         sum=0;
 char        *p;
 static char chksum[4];

 for (p=buf;*p != 0;p++)
    sum += (*p & 0x7f);

 sum &= 0xfff;
 sprintf (chksum,"%c%c%c",(((sum & 0xf00)>>8)+ 0x30),
                          (((sum & 0xf0) >>4)+ 0x30),
                          (((sum & 0xf)  >>0)+ 0x30));
 return (chksum);
}

/*--------------------------------------------------------------------*/
static int send_transfer_req(sms,fd)
sms_typ *sms;
int      fd;
{
 int  res;
 char buf[MAXMSGLEN];
 char buf2[MAXMSGLEN];
 char *p;
 static int packs,actpack,firsttime=1;
 static int offset[MAXMSG],len[MAXMSG];
 char tmpdest[40];

 if (firsttime)
 {
    if (sms->dest[0] == '0')
    {
       strcpy (tmpdest,"49");
       strcat (tmpdest,&(sms->dest[1]));
       strcpy (sms->dest,tmpdest);
    }

    packs = get_offsets(sms->message,offset,len);
    actpack   = 0;
    firsttime = 0;
    sms->ackflag = 0;
 }

 if (sms->ackflag)
 {
    actpack++;
    sms->trn = 0;
 }

 strncpy (buf2,&(sms->message[offset[actpack]]),len[actpack]);
 buf2[len[actpack]] = 0;
 sprintf (buf,"\002%s\r%s%s\r\003",sms->dest,buf2,")#*&(C");
 sprintf (buf2,"%s%s\r",buf,checksum(buf));

 res = t_snd(fd,buf2,strlen(buf2),0);
 if (res < 0)
 {
    if (debug)
       t_error ("t_snd() ");
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nFehler beim Senden zum D1-SMS-Center.\nt_snd() (%s)",
             t_errlist[t_errno]);
    sms->result = -2;
    sms->t_errno = t_errno;
    return (-1);
 }
 if (debug)
 {
    strcpy (buf,buf2);
    for (p=buf;*p;p++)
       if (*p=='\r')
          *p='!';
    fprintf (stderr,"gesendet %s\n",buf);
 }

 if (packs > (actpack + 1))
    sms->more_to_send = 1;
 else
    sms->more_to_send = 0;
 return (0);
}

/*--------------------------------------------------------------------*/
static int get_offsets (mess,off,len)
char *mess;
int  *off;
int  *len;
{
 int   i,pnr;
 char *ptr;

 off[0] = 0;
 mess[MAXMSG*160] = 0;
 for (pnr=0;pnr<MAXMSG;pnr++)
 {
    ptr = &mess[off[pnr]];
    len[pnr] = strlen(ptr);
    if (len[pnr] <= 160)
    {
       if (pnr<(MAXMSG-1))
          len[pnr+1] = 0;
       return (pnr+1);
    }

    /* jetzt von 160 rckwrts nach dem ersten leerzeichen suchen */
    for (i=159;i>145;i--)
    {
       if ((ptr[i] == ' ') || (ptr[i] == '\n'))
       {
          i++; /* i1 ist jetzt der offset des 2. packs */
          if (pnr < (MAXMSG - 1))
             off[pnr+1] = off[pnr] + i;
          len[pnr]   = i - 1;
          break;
       }
    }

    if (i==145)
    {
       if (pnr < (MAXMSG-1))
          off[pnr+1] = off[pnr] + 160;
       len[pnr] = 160;
    }
 }

 return (pnr);
}

/*--------------------------------------------------------------------*/
static int send_query(sms,fd)
sms_typ *sms;
int      fd;
{
 int  res;
 char buf[MAXMSGLEN];
 char buf2[MAXMSGLEN];
 char *p;

 sprintf (buf,"\002%s\r%s%s\r\003",sms->dest,")#*&(Q",sms->messid);
 sprintf (buf2,"%s%s\r",buf,checksum(buf));
 res = t_snd(fd,buf2,strlen(buf2),0);
 if (res < 0)
 {
    if (debug)
       t_error ("t_snd() ");
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nFehler beim Senden zum D1-SMS-Center.\nt_snd() (%s)",
             t_errlist[t_errno]);
    sms->result = -2;
    sms->t_errno = t_errno;
    return (-1);
 }

 if (debug)
 {
    strcpy (buf,buf2);
    for (p=buf;*p;p++)
       if (*p=='\r')
          *p='!';
    fprintf (stderr,"Status-Query gesendet: %s\n",buf);
 }
 return (0);
}

/*--------------------------------------------------------------------*/
static int parameter_query(sms,fd)
sms_typ *sms;
int      fd;
{
 int  res;
 char buf[MAXMSGLEN];
 char buf2[MAXMSGLEN];
 char *p;

 sprintf (buf,"\002%s\r%s\r\003",sms->dest,")#*&(P");
 sprintf (buf2,"%s%s\r",buf,checksum(buf));
 res = t_snd(fd,buf2,strlen(buf2),0);
 if (res < 0)
 {
    if (debug)
       t_error ("t_snd() ");
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nFehler beim Senden zum D1-SMS-Center.\nt_snd() (%s)",
             t_errlist[t_errno]);
    sms->result = -2;
    sms->retry  = 1;
    sms->t_errno = t_errno;
    return (-1);
 }
 if (debug)
 {
    strcpy (buf,buf2);
    for (p=buf;*p;p++)
       if (*p=='\r')
          *p='!';
    fprintf (stderr,"Parameter-Query gesendet: %s",buf);
 }
 return (0);
}

/*--------------------------------------------------------------------*/
int d1SendApp::send_cr(sms_type *sms,int fd)
{
 char cr=0x0d; /* <CR> */

if(inputModem(&cr, 1,0) != TRUE)
{

    if (debug)
       t_error ("t_snd() ");
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nFehler beim Senden zum D1-SMS-Center.\nt_snd() (%s)",
             t_errlist[t_errno]);
    sms->result = -2;
    sms->t_errno = t_errno;
    return (-1);
 }

 if (debug)
    fprintf (stderr,"<CR> gesendet\n");
 return (0);
}

/*--------------------------------------------------------------------*/
int d1SendApp::send_id(sms_typ *sms,int fd)
{
 char buf[20];

 *buf=0x1b;
 sprintf(&buf[1],"PG1\r");

if(inputModem(buf, strlen(buf), 0) != TRUE)
 {
    if (debug)
       t_error ("t_snd() ");
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nFehler beim Senden zum D1-SMS-Center.\nt_snd() (%s)",
             t_errlist[t_errno]);
    sms->result = -2;
    sms->retry  = 1;
    sms->t_errno = t_errno;
    return (-1);
 }
 if (debug)
    fprintf (stderr,"gesendet : %s\n",buf);
 return (0);
}

/*--------------------------------------------------------------------*/
int pageSendApp::close_smsc(int fd,sms_typ *sms)
{
 inputModem("\004\n",2,0); /* EOT */
 /* sms->gebuehr = isi_getcharge(fd); */
 sms->gebuehr = 0;
 return (0);
}

/*--------------------------------------------------------------------*/
static int rcv_packet(fd,packet,pattern,sms,timeout)
int      fd;
char    *packet;
char    *pattern;
sms_typ *sms;
int      timeout;

{
 int            flags,rec,rcode,event,offset;
 char           buf [MAXMSGLEN];
 char           buf1[MAXMSGLEN];
 char           *p,*p1;
 struct pollfd  fds[1];

 fds[0].fd     = fd;
 fds[0].events = POLLIN;
 *packet = 0;

 while (1)
 {
    rcode = poll (fds,1,timeout * 1000);
    if (rcode == 0)
    { /* normaler Timeout */
       if (debug)
          fprintf (stderr,"\n Timeout !!! Emfangen %d Bytes\n %s\n",strlen(packet),packet);
       return (1);
    }
    if (rcode < 0)
    {
       switch (errno)
       {
          case EAGAIN:
          case EINTR:   /* signal eingefangen, message da */
  	     continue;
          default:
             sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nInterner Fehler.\npoll() : %s",
                      sys_errlist[errno]);
             sms->result  = -5;
             sms->retry   = 1;
             sms->errno   = errno;
	     return (-1);
       }
    }
    /* jetzt ist mal wieder ein paket da */

    rec = t_rcv (fd,buf,MAXMSGLEN,&flags);
    if (rec < 0)
    {
       if (t_errno == TLOOK)
       {
          event = t_look(fd);
          switch (event)
          {
             case T_DISCONNECT:
                sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nVerbindung unerwartet vom D1-SMS-Center abgebaut.");
                sms->retry   = 1;
                sms->result  = -6;
                return (-1);

             default:
                continue;
          }
       }
       if (t_errno != TNODATA)
       {
          sms->t_errno = t_errno;
          sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nFehler beim Empfang vom D1-SMS-Center.\nt_rcv() (%s)",
                   t_errlist[t_errno]);
          sms->result  = -2;
          sms->retry   = 1;
          return (-1);
       }
    }
    if (rec > 0)
    {
       buf[rec] = 0;
       /* jetzt mu xon xoff raus */
       for (p=buf,p1=buf1,*p1=0;*p;p++)
       {
          if ((*p != 17) && (*p != 19))
          {
             *p1 = *p;
             p1++;
             *p1 = 0;
          }
       }
       strcat (packet,buf1);
       if (*pattern)
       {
          offset = strlen(packet) - strlen(pattern);
          if (offset >= 0)
          {
             if (!strcmp(&packet[offset],pattern))
             {
                if (debug)
                {
                   strcpy (buf,packet);
                   for (p=buf;*p;p++)
                      if (*p=='\r')
                         *p='!';
                   fprintf (stderr,"\nEmpfangen %s\n",buf);
                }
                return (0);
             }
          }
       }
       continue;
    }
 }
}

/*--------------------------------------------------------------------*/
static int rcv_answer(fd,packet,sms,timeout)
int      fd;
char    *packet;
sms_typ *sms;
int      timeout;

{
 int         flags,rec,rcode,event;
 char        buf [MAXMSGLEN];
 char        buf1[MAXMSGLEN];
 char        *p,*p1;
 struct pollfd  fds[1];

 fds[0].fd     = fd;
 fds[0].events = POLLIN;
 *packet = 0;

 while (1)
 {
    rcode = poll (fds,1,timeout * 1000);
    if (rcode == 0)
    { /* normaler Timeout */
       if (debug)
          fprintf (stderr,"\n Emfangen %d Bytes\n %s\n",strlen(packet),packet);
       return (1);
    }
    if (rcode < 0)
    {
       switch (errno)
       {
          case EAGAIN:
          case EINTR:   /* signal eingefangen, message da */
  	     continue;
          default:
             sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nInterner Fehler.\npoll() : %s",
                      sys_errlist[errno]);
             sms->errno   = errno;
             sms->retry   = 1;
             sms->result  = -5;
	     return (-1);
       }
    }
    /* jetzt ist mal wieder ein paket da */

    rec = t_rcv (fd,buf,MAXMSGLEN,&flags);
    if (rec < 0)
    {
       if (t_errno == TLOOK)
       {
          event = t_look(fd);
          switch (event)
          {
             case T_DISCONNECT:
                sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nVerbindung unerwartet vom D1-SMS-Center abgebaut.");
                sms->retry   = 1;
                sms->result  = -6;
                return (-1);

             default:
                continue;
          }
       }
       if (t_errno != TNODATA)
       {
          sms->t_errno = t_errno;
          sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nFehler beim Empfang vom D1-SMS-Center.\nt_rcv() (%s)",
                   t_errlist[t_errno]);
          sms->result  = -2;
          sms->retry   = 1;
          return (-1);
       }
    }
    if (rec > 0)
    {
       buf[rec] = 0;
       /* jetzt mu xon xoff raus */
       for (p=buf,p1=buf1,*p1=0;*p;p++)
       {
          if ((*p != 17) && (*p != 19))
          {
             *p1 = *p;
             p1++;
             *p1 = 0;
          }
       }
       strcat (packet,buf1);
       /* jetzt erst mal schauen ob das Packet komplett ist */
       if (isinstr (packet,"\r\006\r") ||  /* ACK */
           isinstr (packet,"\004\r")   ||  /* EOT */
           isinstr (packet,"\r\017\r") ||  /* NAK */
           isinstr (packet,"\r\036\r"))    /* RS */
       {
          if (debug)
          {
             strcpy (buf,packet);
             for (p=buf;*p;p++)
                if (*p=='\r')
                   *p='!';
             fprintf (stderr,"\nEmpfangen %s\n",buf);
          }
          return (0);
       }
       continue;
    }
 }
}

/*-------------------------------------------------------------*/
static void catch_alarm(dummy)
int dummy;
{
   connect_timeout++;
   return;
}


/*--------------------------------------------------------------------*/

/* Sucht nach 'muster' in 'str' und gibt Pointer auf Anfang zurueck
*/
static char *strpos(str, muster)
char *str,
     *muster;
{
char *hilf;
uint lenmuster = strlen (muster);

   do {
        hilf = strchr(str,*muster);
        if (hilf != (char *) NULL)
        {
           if (strlen (hilf) < lenmuster)  break;       /* BS */
           if (strncmp(hilf,muster, lenmuster) == 0)
              return(hilf);
           else str = ++hilf;
        }
   }
   while(hilf != (char *) NULL );
   return ((char *) NULL);
}

