/*******************************************************************************
** $BASIS/pds/isdn/cprg/isdn_d2.c
**
*******************************************************************************/

/*
#define TEST_MAIN
*/

#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include "pds/pdsisdn.h"
#include <isdn/l_lib.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

static char *ErrorIntern =
"Die Kurzmitteilung wurde nicht versendet. Der Grund ist ein interner Fehler in den Kommunikationsanwendung. Wenden Sie sich zu Kl{rung mit folgender Fehlermeldung an die PDS-Hotline:\n\n";

typedef struct
{
  char ack;           /* 'A' oder 'N' */
  char mvp[11];       /* Modified validity period */
  char sm[400];       /* System-Message in IA5 */
  char empf_nr[17];   /* Empfaenger-Nummer */
  char empf_zeit[13]; /* Uhrzeit des Empfangs */
  int  ec;            /* error-code */
} ack_typ;

typedef struct
{
  char empf[17];      /* Empfaenger-Nummer */
  char abs[17];       /* Absender-Nummer */
  char auth[200];     /* authentifications-code (momentan nicht verwendet) */
  int  mess_type;      /* message type */
  char message[500];  /* Numerische Message */
} call_in_typ;


typedef struct
{
 int         trn;  /* transaction reference number */
 char        op;   /* operation, 'O' oder 'R' */
 int         ot;   /* opertion type siehe OT_... */
 ack_typ     ack;  /* Werte des ACK-Paketes */
 call_in_typ cin;  /* Werte der Notification */
} pack_typ;

/* Wed Mar  6 15:10:13 GMT 1996 michel */

#ifndef R_UNIXWARE
extern int _xti_error        TB_PROTO (( char * ));
#endif

static char *ascii_to_ia5	TB_PROTO(( char * ));
static char *cause_text	        TB_PROTO(( int ));
static char *decode_ec	        TB_PROTO(( int ));
static char *decode_mvp	        TB_PROTO(( char * ));
static char *ia5_to_ascii	TB_PROTO(( char * ));
static char *prep_save_time	TB_PROTO(( int ));
static char *timestamp_to_timestr	TB_PROTO(( char * ));
static int checksum	        TB_PROTO(( char * ));
static int close_smsc	        TB_PROTO(( int, sms_typ * ));
static int decode_packet	TB_PROTO(( char *, pack_typ * ));
static int do_retry	        TB_PROTO(( int ));
static int open_smsc	        TB_PROTO(( sms_typ * ));
static int rcv_packet	        TB_PROTO(( int, char *, sms_typ *, int ));
static int send_alert	        TB_PROTO(( sms_typ *, int ));
static int send_transfer_req	TB_PROTO(( sms_typ *, int ));

#define MODEMSERVICE  "smsc_a_d2"
#define ISDNSERVICE   "smsc_d_d2"

#define MAXMSGLEN     4000
#define MAXRETRY      2        /* also max 3 sende versuche */

#define A_SEND_REQ    1
#define A_SEND_ACK    2
#define A_RCV_ANSW    3
#define A_END         4
#define A_SEND_ALERT  5

#define TOUT_ACK      10
#define TOUT_NOTE     30

#define OT_CALL_INPUT      1
#define OT_SMS_TRANSFER   30
#define OT_SMT_ALERT      31

#define MT_TONE            1
#define MT_NUMERIC         2
#define MT_ALPHANUM        3
#define MT_TRANSPARENT     4

#define SMSC_MODEM1        "01722278020"
#define SMSC_ISDN1         "01722278000"
#define SMSC_ISDN2         "01722278010"
#define SMSC_ISDN3         "02111733214"

/*--------------------------------------------------------------------*/
extern char *sys_errlist[];
extern char *t_errlist[];

#ifndef R_UNIXWARE
extern int   t_errno;
#endif

#ifdef TEST_MAIN
int    debug = 1;
#else
int    debug = 0;
#endif
/*--------------------------------------------------------------------*/
int send_d2_message(sms)
sms_typ *sms;
{
 int  fd,res,action,rcv_timeout=0;
 char buf[MAXMSGLEN];
 pack_typ pack;
 time_t t=time(0);

 sms->result  = -5;
 sms->retry   = 0;
 sms->t_errno = 0;
 sms->errno   = 0;
 sms->cause   = 0;
 sms->duration= 0;
 sms->ec      = 0;   /* error code vom smsc */
 sms->gebuehr = 0;
 sms->trn     = 0;
 sms->result_str[0] = 0;
 sms->sendezeit[0]  = 0;
 action       = A_SEND_REQ;

 fd = open_smsc(sms);
 if (fd < 0)
    return (-1);

 while (1)
 {
    switch (action)
    {
       case A_SEND_ALERT:
          if (send_alert(sms,fd))
          {
             action = A_END;
          }
          else
          {
             rcv_timeout = TOUT_NOTE;
             action = A_RCV_ANSW;
          }
          break;

       case A_SEND_REQ:
          if (send_transfer_req(sms,fd))
          {
             action = A_END;
          }
          else
          {
             rcv_timeout = TOUT_ACK;
             action = A_RCV_ANSW;
          }
          break;

       case A_SEND_ACK:
          /*
          send_acknowledge(fd,sms);
          */
          action = A_END;
          break;

       case A_RCV_ANSW:
          res = rcv_packet(fd,buf,sms,rcv_timeout);
          if (res == -1) /* fehler beim lesen */
          {
             action = A_END;
             break;
          }

          if (res == -2) /* timeout (keine antwort) */
          {
             if (pack.ack.ack == 'A')
             {
                action = A_END;
                break;
             }

             if (sms->trn >= MAXRETRY)
             {
                sms->result = -4; /* nach retry versuchen immer noch fehlerhaft */
                sms->retry = 1;   /* bei isdn-verbindung will er machmal nicht */
                sprintf (sms->result_str,"Die Kurzmitteilung konnte nach %d Versuchen nicht an das D2-SMS-Center }bergeben werden!",
                         1 + sms->trn);
                action = A_END;
             }
             else
             {
                sms->trn++;
                action = A_SEND_REQ;
             }
             break;
          }
          /* ab hier liegt ein paket vor */
          res = decode_packet(buf,&pack);
          if (res)
          {
             if (debug)
                fprintf (stderr,"decode_packet() = %d\n",res);

             if (res == -1) /* bad checksum in der Antwort*/
             {
                if (pack.ack.ack == 'A')
                {  /* bad checksum bei der notification */
                   action = A_END;
                   break;
                }
                else
                {
                   if (sms->trn >= MAXRETRY)
                   {
                      sms->result = -4; /* nach retry versuchen immer noch fehlerhaft */
                      sms->retry = 1;
                      sprintf (sms->result_str,"Die Kurzmitteilung konnte nach %d Versuchen nicht an das D2-SMS-Center }bergeben werden!",
                               1 + sms->trn);
                      action = A_END;
                   }
                   else
                   {
                      sms->trn++;
                      action = A_SEND_REQ;
                   }
                }
             }
             else
             { /* res muss jetzt < -1 sein */
                if (pack.ack.ack == 'A')
                {  /* anderes nach dem ACK */
                   action = A_END;
                   break;
                }
                else
                {
                   action = A_RCV_ANSW;
                   break;
                }
             }
             action = A_END;
             break;
          }
          else
          { /* jetzt ist ein ordentliches Paket gekommen */
             if ((pack.op == 'R') && (pack.ot == OT_SMS_TRANSFER))
             { /* reply auf die sms-transfer-message */
                if (pack.ack.ack == 'A')
                {
                   strcpy (sms->sendezeit,timestamp_to_timestr(pack.ack.empf_zeit));
                   sprintf (sms->result_str,"Die Kurzmitteilung wurde erfolgreich an das D2-SMS-Center }bergeben. Auf eine Best{tigung f}r die Auslieferung an das Mobiltelefon wurde nicht gewartet.");
                   rcv_timeout = TOUT_NOTE;
                   sms->result = 0;
                   if (sms->wait_note)
                      action = A_RCV_ANSW;
                   else
                      action = A_END;
                   break;
                }
                else
                { /* ab hier muss pack.ack.ack != 'A' sein */
                   if (pack.ack.ec == 1) /* checksum error */
                   {
                      sms->ec = pack.ack.ec;
                      if (sms->trn >= MAXRETRY)
                      {
                         sms->result = -4; /* nach retry versuchen immer noch fehlerhaft */
                         sprintf (sms->result_str,"Kurzmitteilung konnte nach %d Versuchen nicht an das D2-SMS-Center }bergeben werden!",
                                  1 + sms->trn);
                         action = A_END;
                      }
                      else
                      {
                         sms->trn++;
                         action = A_SEND_REQ;
                      }
                      break;
                   }
                   else
                   {
                      sms->result = -3;
                      sms->ec = pack.ack.ec;
                      sprintf (sms->result_str,"Die Kurzmitteilung ist nicht versendet worden, weil die Annahme vom D2-SMS-Center abgelehnt oder die ]bermittlung unterbrochen wurde.\n\nUrsache: %s ",
                               decode_ec(sms->ec));
                      action = A_END;
                      break;
                   }
                }
             }
             else
             {  /* jetzt muss es der Call-input-info sein */
                strcpy (sms->result_str,pack.cin.message);
                if (isinstr(pack.cin.message,"Code 107"))
                {
                   if (pack.ack.mvp[0])
                   {
                      sprintf (buf,"\nDie Kurzmitteilung wird bis %s im SMS-Center gespeichert.",
                               decode_mvp(pack.ack.mvp));
                      strcat (sms->result_str,buf);
                   }
                }
                sms->result = 1; /* alles paletti */
                action = A_END;
                break;
             }
          }
          break;
    }

    if (action == A_END)
       break;
 }

 close_smsc(fd,sms);
 sms->duration = time(0) - t;
 return (0);
}



/*--------------------------------------------------------------------*/
static int do_retry(cause)
int cause;
{
 switch (cause)
 {
    case 0x00: /* z.B. keine Modemverbindung */
    case 0x01: /* no channel avail */
    case 0x08: /* cannot activate L1 */
    case 0x09: /* cannot get TEI */
    case 0x80: /* Gegenstelle hat einfach aufgelegt */
    case 0x81: /* invalid call reference value */
    case 0x8a: /* no channel avail */
    case 0xa1: /* busy */
    case 0xb9: /* out of order */
    case 0xbb: /* user access busy */
    case 0xbd: /* incoming calls barred */
    case 0xbe: /* call rejected */
    case 0xd9: /* network congestion */
    case 0xda: /* remote user initiated */
    case 0xf0: /* local procedure error */
    case 0xf1:
    case 0xf2:
    case 0xf3:
    case 0xf4:
       return (1);
    default :
       return (0); /* es macht keine sinn es nochmal zu versuchen */
 }
}

/*--------------------------------------------------------------------*/
static char *cause_text(cause)
int cause;
{
static char errbuf[101];

 switch (cause)
 {
    case 0x00:
       return ("Modem-Kontakt fehlgeschlagen");
    case 0x01: /* no channel avail */
    case 0x8a: /* no channel avail */
       return ("Kein B-Kanal verf}gbar");
    case 0x08: /* cannot activate L1 */
       return ("Kann nicht auf den ISDN-Anschluss zugreifen");
    case 0x02:
       return ("Ung}ltige Protokoll-Optionen");
    case 0x03:
       return ("Ung}ltige ISDN-Adresse");
    case 0x0a:
       return ("Protokoll-Verletztung auf Schicht 2");
    case 0x39:
       return ("Interner Protokoll-Fehler");
    case 0x09: /* cannot get TEI */
       return ("Kann kein TEI holen");
    case 0x80:
    case 0xda:
       return ("Verbindung vom D2-SMS-Center unterbrochen");
    case 0x81: /* invalid call reference value */
       return ("Ung}ltiger Ruf-Referenzwert");
    case 0xa1: /* busy */
    case 0xbb: /* user access busy */
       return ("Anschluss zum D2-SMS-Center ist besetzt");
    case 0xb9: /* out of order */
       return ("Anschluss zum D2-SMS-Center ist ausser Betreib");
    case 0xbd: /* incoming calls barred */
       return ("Eingehende Rufe werden vom D2-SMS-Center abgelehnt");
    case 0xbe: /* call rejected */
       return ("Keine Zugangsberechtigung zum D2-SMS-Center");
    case 0xd9: /* network congestion */
       return ("Vor}bergehende ISDN-Netzwerk}berlastung");
    case 0xb5:
       return ("Kein Anschluss unter dieser Nummer");
    case 0xba:
       return ("Gegenstelle (D2-SMS-Center) hebt nicht ab");
    default :
       sprintf(errbuf, "Fehler %x", cause);
       return(errbuf);
 }
}

/*************************************************************/
static int open_smsc(sms)
sms_typ *sms;
{
 struct t_call *callp;
 struct t_bind *bindp;
 struct t_discon disc;
 int    fd,event;
 char   *escape;
 char   *isdn_prot,isdn_service[40],restelno[50];

 fd = t_open("/dev/isdn",O_RDWR,NULL);
 if (fd < 0)
 {
    sms->result  = -2;
    sms->t_errno = t_errno;
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nt_open() (%s)",
             t_errlist[t_errno]);
    return(-1);
 }

 if (sms->conn_mode == 0)
 {
    strcpy (isdn_service, MODEMSERVICE); /* modem */
    if (!sms->smsc[0])
       strcpy (sms->smsc,SMSC_MODEM1);
 }
 else
 {
    strcpy (isdn_service,ISDNSERVICE); /* isdn v110 */
    if (!sms->smsc[0])
       strcpy (sms->smsc,SMSC_ISDN1);
 }

 if (!sms->smsc[0]) /* keine SMSC-Nummer vorhanden */
 {
    sms->result  = -2;
    if (sms->conn_mode == 0)
       sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nKeine Telefonummer fr den Modemzugang des D2-SMS-Centers bekannt");
    else
       sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nKeine Telefonummer fr den ISDN-Zugang des D2-SMS-Centers bekannt");
    t_close(fd);
    return(-1);
 }

 bindp=(struct t_bind*)isi_bindaddr(isdn_service,0);
 if (t_bind(fd,bindp,NULL) < 0)
 {
    sms->result  = -2;
    sms->t_errno = t_errno;
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nisi_bindaddr(%s) (%s)\nberprfen Sie bitte /usr/isi/config/services",
             isdn_service, t_errlist[t_errno]);
    t_close(fd);
    return(-1);
 }

 escape = isi_default("BASE_escape",NULL);
 if (!*escape)
    sprintf (restelno,"=%s",sms->smsc);
 else
    sprintf (restelno,"=%s%s",escape,sms->smsc);

 callp = isi_getaddr(restelno,isdn_service);
 if (!callp)
 {
    sms->result  = -2;
    sms->t_errno = t_errno;
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nisi_getaddr() (%s)\nberprfen Sie bitte die Eintrge in\n/usr/isi/config/services",
             t_errlist[t_errno]);
    t_close(fd);
    return(-1);
 }

 isdn_prot = isi_getopts("*",isdn_service);
 if (!isdn_prot)
 {
    sms->result  = -5;  /* interner Fehler */
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nProtokolleinstellungen nicht ermittelbar.\nisi_getprot(\"*\",%s) fehlgeschlagen\nberprfen Sie bitte die Eintrge in\n/usr/isi/config/services",
             isdn_service);
    t_close(fd);
    return(-1);
 }

 if (!isi_filloptions (isdn_prot,callp))
 {
    sms->result  = -5;  /* interner Fehler */
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nisi_filloptions(%s) fehlgeschlagen\nberprfen Sie bitte die Eintrge in\n/usr/isi/config/services",
             isdn_service);
    t_close(fd);
    return(-1);
 }

/*
 bindp=(struct t_bind*)isi_bindaddr("nokia",0);
 if (t_bind(fd,bindp,NULL) < 0)
 {
    sms->result  = -2;
    sms->t_errno = t_errno;
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nt_bind() (%s)",
             t_errlist[t_errno]);
    t_close(fd);
    return(-1);
 }

 if ((callp = (struct t_call*)t_alloc(fd,T_CALL,T_ALL)) == 0)
 {
    sms->result  = -2;
    sms->t_errno = t_errno;
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nt_alloc() (%s)",
             t_errlist[t_errno]);
    t_close(fd);
    return(-1);
 }

 if (sms->conn_mode == 0)
    strcpy (isdn_prot,"NOL3;NOL2;MODEM");
 else
    strcpy (isdn_prot,"NOL3;NOL2;ASYNC(speed=9600,parodd=0,parenb=0)");

 if (!isi_filloptions (isdn_prot,callp))
 {
    sms->result  = -5;
    sprintf (sms->result_str,"%s isi_filloptions() fehlgeschlagen", ErrorIntern);
    t_close(fd);
    return(-1);
 }

 isi_default("BASE_escape",&escape);

 if (sms->smsc[0])
 {
    if (sms->conn_mode == 0)
       sprintf (callp->addr.buf,"001002%s%s",escape,sms->smsc);
    if (sms->conn_mode == 1)
       sprintf (callp->addr.buf,"007197%s%s",escape,sms->smsc);
 }
 else
 {
    if (sms->conn_mode == 0)
    {
       sprintf (callp->addr.buf,"001002%s%s",escape,SMSC_MODEM);
       strcpy(sms->smsc, SMSC_MODEM);
    }

    if (sms->conn_mode == 1)
    {
       sprintf (callp->addr.buf,"007197%s%s",escape,SMSC_ISDN1);
       strcpy(sms->smsc, SMSC_ISDN1);
    }
 }

 callp->addr.len = strlen(callp->addr.buf);
*/

 if (t_connect(fd, callp,callp) == -1)
 {
    memset (&disc,0,sizeof (disc));
    t_rcvdis (fd,&disc);

    if (disc.reason)
    {
       sprintf (sms->result_str,"Diese Kurzmitteilung ist nicht versendet worden, da die Verbindung zum D2-SMS-Center (Rufnummer %s) nicht hergestellt werden konnte.\n\nUrsache : %s ",
       sms->smsc,
       cause_text (disc.reason));
       sms->cause  = disc.reason;
       sms->retry  = do_retry(sms->cause);
       sms->result = -1;  /* keine Verbindung */
    }
    else
    {
       if (t_errno == TLOOK)
       {
          event = t_look(fd);
          switch (event)
          {
             case T_DISCONNECT:
                sprintf (sms->result_str,"Diese Kurzmitteilung wurde nicht versendet, da Der Verbindungsaufbau vom D2-SMS-Center abgebrochen wurde. Bitte die Nachricht nocheinmal versenden!");
                sms->result  = -6;
                break;
             default:
                sprintf (sms->result_str,"Die Verbindung zum D2-SMS-Center (Rufnummer %s) konnte nicht hergestellt werden!\nDie Verbindung zum Modem wurde unterbrochen oder konnte nicht korrekt hergestellt werden!\nBitte die Nachricht nocheinmal versenden!", sms->smsc);
                sms->result  = -6;
                break;
          }
       }
       else
       {
          sprintf (sms->result_str,"%s TLI-Fehler %s (t_errno %d)",
                   ErrorIntern,
                   t_errlist[t_errno],
                   t_errno);
          sms->t_errno = t_errno;
          sms->result  = -1;  /* keine Verbindung */
       }
    }

    sms->gebuehr = isi_getcharge(fd);
    t_close (fd);
    return (-1);
 }

 /*
 if (fcntl (fd,F_SETFL,O_NDELAY) < 0)
 {
    sprintf (sms->result_str,"%s fcntl() : %s",
             ErrorIntern,
             sys_errlist[errno]);
    sms->errno   = errno;
    sms->result  = -2;
    sms->gebuehr = isi_getcharge(fd);
    t_close (fd);
    return (-1);
 }
   */
 if (sms->conn_mode == 0) /* modem */
 {         /* muss wegen V42bis sein */
    isdn_sleep(13);
 }
 else
 { /* die eine sekunde braucht der ISDN-Terminal-Adapter des SMSC */
    isdn_sleep(1);
 }
 return(fd);
}

/*--------------------------------------------------------------------*/
static int checksum(buf)
char *buf;
{
 int   sum=0;
 char *p;

 for (p=buf;*p != 0;p++)
    sum += *p;

 sum &= 0xff;
 return (sum);
}

/*--------------------------------------------------------------------*/
static char *ascii_to_ia5(message)
char *message;
{
 int i,len;
 char *p;
 static char ia5[2001];

 if (strlen (message) > 1000)
    message[1000] = 0;

 len = strlen (message);
 for (i=0;i<len;i++)
 {
    switch (message[i] & 0x7f)
    {  /* die folgenden zeichen werden leider falsch dargestellt */
       /* sie werden auf leerzeichen gemappt */
       case 0x5F: /* '_' */
       case 0x5E: /* '^' */
       case 0x78: /* '' */
          message[i] = 0x20; /* ' ' */
    }
    sprintf (&ia5[i*2],"%-2.2x",message[i] & 0x7f);
 }

 for (p=ia5;*p!=0;p++)
    *p = (char) toupper(*p);

 return (ia5);
}


/*--------------------------------------------------------------------*/
static char *ia5_to_ascii(ia5)
char *ia5;
{
 static char string[1000];
 char buf[3];
 int i,len;
 unsigned int value;

 len = strlen(ia5)/2;
 for (i=0;i<len;i++)
 {
    memset (buf,0,3);
    strncpy(buf,&ia5[2*i],2);
    if (sscanf (buf,"%x",&value) != 1)
       break;
    else
       string[i] = (char) value;
 }

 string[i] = 0;
 return (string);
}

/*--------------------------------------------------------------------*/
static char *prep_save_time(st)
int st;
{
 time_t      t;
 struct tm  *tt;
 static char buf[20];

 if (st <= 0)
 {
    *buf = 0;
 }
 else
 {
    t = time(0) + (st * 3600);
    tt = localtime (&t);
    sprintf (buf,"%2.2d%2.2d%2.2d%2.2d%2.2d",
                  tt->tm_mday,1 + tt->tm_mon,tt->tm_year,tt->tm_hour,tt->tm_min);
 }
 return (buf);
}

/*--------------------------------------------------------------------*/
static int send_transfer_req(sms,fd)
sms_typ *sms;
int      fd;
{
 int  res;
 char buf[MAXMSGLEN];
 char buf2[MAXMSGLEN];

 sprintf (buf2,"/O/%2.2d/%s/%s//1/////%s/%s/",OT_SMS_TRANSFER,
          sms->dest,sms->orig,prep_save_time(sms->save_time),
          ascii_to_ia5 (sms->message));
 sprintf (buf,"%-2.2d/%-5.5d%s",sms->trn,strlen(buf2) + 10,buf2);
 sprintf (buf2,"\002%s%-2.2x\003",buf,checksum(buf));

 res = t_snd(fd,buf2,strlen(buf2),0);
 if (res < 0)
 {
    if (debug)
       t_error ("t_snd() ");
    sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nFehler beim Senden zum D2-SMS-Center.\nt_snd() (%s)",
             t_errlist[t_errno]);
    sms->result = -2;
    sms->t_errno = t_errno;
    return (-1);
 }
 if (debug)
    fprintf (stderr,"gesendet %s\n",buf2);
 return (0);
}

/*--------------------------------------------------------------------*/
static int send_alert(sms,fd)
sms_typ *sms;
int      fd;
{
 int  res;
 char buf[MAXMSGLEN];
 char buf2[MAXMSGLEN];

 sprintf (buf2,"/O/31/%s/0139/",
          sms->orig);
 sprintf (buf,"%-2.2d/%-5.5d%s",sms->trn,strlen(buf2) + 10,buf2);
 sprintf (buf2,"\002%s%-2.2x\003",buf,checksum(buf));

 if (debug)
    fprintf (stderr,"gesendet %s\n",buf2);
 res = t_snd(fd,buf2,strlen(buf2),0);
 if (res < 0)
 {
    if (debug)
       t_error ("t_snd() ");
    return (-1);
 }
 return (0);
}

/*--------------------------------------------------------------------*/
static char *decode_ec (ec)
int ec;
{
 static char buf[100];

 switch (ec)
 {
    case 1:
       return ("Fehler in der Checksumme der Sendeanfrage");
    case 2:
       return ("Syntaxfehler in der Sendeanfrage");
    case 4:
       return ("Operation zu diesem Zeitpunkt nicht erlaubt");
    case 5:
       return ("Rufsperre zu diesem Teilnehmer aktiviert");
    case 6:
       return ("Ung}ltige Zielrufnummer");
    case 7:
       return ("Fehler bei der Authentisierung");
    case 8:
       return ("Legitimierungscode fehlerhaft");
    case 22:
       return ("Ung}ltige Zeitperiode");
    case 24:
       return ("Message ist zu lang");
    case 26:
       return ("Messageart ist f}r dieses Endger{t nicht erlaubt");
    default:
       sprintf (buf,"Unbekannter Fehlercode %d",ec);
       return (buf);
 }
}

/*--------------------------------------------------------------------*/
static int decode_packet (packet,pkt)
char     *packet;
pack_typ *pkt;
{
 int  chksum;
 char buf[1000];
 char *p,*p1;

 sscanf (&packet[strlen(packet) - 2],"%x",&chksum);
 packet[strlen(packet) - 2] = 0;
 if (chksum != checksum (packet))
    return (-1); /* ungueltige checksum */

 strncpy (buf,packet,2);
 buf[2] = 0;
 pkt->trn = atoi(buf);

 pkt->op = packet[9];
 if ((pkt->op != 'O') && (pkt->op != 'R'))
    return (-2);  /* ungueltige operation */

 strncpy (buf,&packet[11],2);
 buf[2] = 0;
 pkt->ot = atoi (buf);
 if ((pkt->ot != OT_SMS_TRANSFER) && (pkt->ot != OT_CALL_INPUT))
    return (-3);  /* unbekannter (nicht erwarteter) operation type */

 if (pkt->ot == OT_SMS_TRANSFER)
 {
    if (pkt->op == 'O') /* response */
       return (-4);  /* nicht verwertbar */

    pkt->ack.ack = packet[14];
    if ((pkt->ack.ack != 'A') && (pkt->ack.ack != 'N'))
       return (-5);  /* unerwarteter Wert */

    if (pkt->ack.ack == 'A')
    {
       if (packet[16] != '/')
       {  /* dann muss hier die mvp stehen */
          strncpy (pkt->ack.mvp,&packet[16],10);
          pkt->ack.mvp[10]=0;
          p = &packet[27];
       }
       else
       {
          p = &packet[17];
       }
       /* p zeigt auf die system-message */
       if (*p == '/')
          pkt->ack.sm[0] = 0;
       else
       {
          strncpy (pkt->ack.sm,p,29);
          pkt->ack.sm[29]=0;
          p1 = strchr(pkt->ack.sm,'/');
          if (p1)
             *p1 = 0;
          strncpy (pkt->ack.empf_nr,p,16);
          pkt->ack.empf_nr[16] = 0;
          p1 = strchr(pkt->ack.empf_nr,':');
          if (p1)
             *p1 = 0;
          p1 = strchr(pkt->ack.sm,':');
          if (p1)
             *p1 = 0;
          p1++;
          /* p1 zeigt jetzt auf die empf_zeit */
          strncpy (pkt->ack.empf_zeit,p1,12);
          pkt->ack.empf_zeit[12] = 0;
       }
       return (0);
    }
    if (pkt->ack.ack == 'N')
    {
       strncpy (buf,&packet[16],2);
       buf[2]=0;
       pkt->ack.ec = atoi(buf);
       strncpy (pkt->ack.sm,&packet[19],200);
       p = strchr (pkt->ack.sm,'/');
       if (p)
          *p = 0;
    }
    return (0);
 }
 if (pkt->ot == OT_CALL_INPUT)
 {
    if (pkt->op == 'R') /* response */
       return (-7);  /* nicht verwertbar */

    /* jetzt muss es ein CALL-INPUT fuer uns sein */
    strncpy (pkt->cin.empf,&packet[14],16);
    pkt->cin.empf[16]=0;
    p = strchr (pkt->cin.empf,'/');
    if (p)
       *p = 0;

    p = strchr (&packet[14],'/');
    if (p)
       p++; /* p zeigt jetzt auf den absender */

    strncpy (pkt->cin.abs,p,16);
    pkt->cin.abs[16]=0;
    p1 = strchr (pkt->cin.abs,'/');
    if (p1)
       *p1 = 0;

    p1 = strchr (p,'/');
    if (p1)
       p1++; /* p1 zeigt jetzt auf den auth-code */

    strncpy (pkt->cin.auth,p1,200);
    pkt->cin.auth[200]=0;
    p = strchr (pkt->cin.auth,'/');
    if (p)
       *p = 0;

    p = strchr (p1,'/');
    if (p)
       p++; /* p zeigt jetzt auf den message-type */

    strncpy (buf,p,1);
    buf[1]=0;
    pkt->cin.mess_type = atoi(buf);
    p1 = p + 2; /* p1 zeigt jetzt auf die message */

    switch (pkt->cin.mess_type)
    {
       case MT_NUMERIC:
          strncpy (pkt->cin.message,p1,300);
          pkt->cin.message[300]=0;
          p = strchr (pkt->cin.message,'/');
          if (p)
             *p = 0;
          return (0);
       case MT_ALPHANUM:
          strncpy (buf,p1,300);
          buf[300] = 0;
          p = strchr (buf,'/');
          if (p)
             *p = 0;
          strcpy (pkt->cin.message,ia5_to_ascii(buf));
          return (0);
       default:
          return (-8);
    }
 }
 return (-6);
}

/*--------------------------------------------------------------------*/
static char *timestamp_to_timestr(ts)
char *ts;
{
 static char string[30];
 char buf[3];
 int  i;

 string[0] = 0;
 for (i=3;i<6;i++)
 {
    strncpy (buf,&ts[2*i],2);
    buf[2]=0;
    strcat (string,buf);
    if (i<5)
       strcat (string,":");
    else
       strcat (string," am ");
 }

 for (i=0;i<3;i++)
 {
    strncpy (buf,&ts[2*i],2);
    buf[2]=0;
    strcat (string,buf);
    if (i<2)
       strcat (string,".");
 }

 return (string);
}

/*--------------------------------------------------------------------*/
static char *decode_mvp(mvp)
char *mvp;
{
 static char string[30];
 char buf[3];
 int  i;

 string[0] = 0;
 for (i=0;i<3;i++)
 {
    strncpy (buf,&mvp[2*i],2);
    buf[2]=0;
    strcat (string,buf);
    if (i<2)
       strcat (string,".");
    else
       strcat (string," um ");
 }

 for (i=3;i<5;i++)
 {
    strncpy (buf,&mvp[2*i],2);
    buf[2]=0;
    strcat (string,buf);
    if (i<4)
       strcat (string,":");
 }
 return (string);
}

/*--------------------------------------------------------------------*/
static int close_smsc(fd,sms)
int      fd;
sms_typ *sms;
{

 sms->gebuehr = isi_getcharge(fd);
 t_close(fd);
 return (0);
}

/*--------------------------------------------------------------------*/
static int rcv_packet(fd,packet,sms,timeout)
int      fd;
char    *packet;
sms_typ *sms;
int      timeout;

{
 int         flags,rec,rcode,event;
 static int  firsttime = 1;
 static char buf [MAXMSGLEN];
 char        buf2[MAXMSGLEN];
 char        *p,*p1;
 time_t      starttime;
 struct pollfd  fds[1];

 fds[0].fd     = fd;
 fds[0].events = POLLIN;


 *packet = 0;
 *buf2 = 0;
 if (firsttime)
 {
    *buf=0;
    firsttime = 0;
 }
 starttime = time(0);

 while (time(0) < (starttime + timeout))
 {
    rcode = poll (fds,1,1000);
    if (rcode == 0)
    { /* normaler Timeout */
       continue;
    }
    if (rcode < 0)
    {
       switch (errno)
       {
          case EAGAIN:
          case EINTR:   /* signal eingefangen, message da */
  	     continue;
          default:
             sprintf (sms->result_str,"%s poll() : %s",
                      ErrorIntern,
                      sys_errlist[errno]);
             sms->errno   = errno;
	     continue;
       }
    }
    /* jetzt ist mal wieder ein paket da */

    rec = t_rcv (fd,buf,MAXMSGLEN,&flags);
    if (rec < 0)
    {
       if (t_errno == TLOOK)
       {
          event = t_look(fd);
          switch (event)
          {
             case T_DISCONNECT:
                sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nVerbindung unerwartet vom D2-SMS-Center abgebaut.");
                sms->result  = -6;
                return (-1);

             default:
                break;
          }
       }
       if (t_errno != TNODATA)
       {
          sms->t_errno = t_errno;
          sprintf (sms->result_str,"Kurzmitteilung nicht versendet.\nFehler beim Empfang vom D2-SMS-Center.\nt_rcv() (%s)",
                   t_errlist[t_errno]);
          sms->result  = -2;
          return (-1);
       }
       continue;
    }
    if (rec > 0)
    {
       buf[rec] = 0;
       if (*packet == 0)
       { /* jetzt muss zuerst stx (0x02) kommen */
          if (*buf == 2)
             strcpy (packet,&buf[1]);  /* ohne stx abspeichern */
       }
       else
       {
          strcat (packet,buf);
       }

       if ((p = strchr(packet,3)) != 0)
       {
         *p=0; /* ohne etx, jetzt ist das paket fertig */
         if ((p = strchr (buf,3)) != 0)
         {
            if ((p1 = strchr (p,2)) != 0)
            {   /* der anfang des naechsten packetes ist auch schon da */
               strcpy (buf2,p1);
               strcpy (buf,buf2);
            }
         }
         if (debug)
            fprintf (stderr,"\n Emfangen %s\n",packet);
         return (0);
       }
    }
 }
 return (-2); /* time out */
}


/*--------------------------------------------------------------------*/
