#ifndef _H_ISDNFAX
#define _H_ISDNFAX

#ifndef  TB_PROTO
#ifdef __STDC__
#define TB_PROTO(ARGS) ARGS
#else
#define TB_PROTO(ARGS) ()
#endif
#endif

#ifndef SMS_EOT
#define SMS_EOT '\0'
#endif

#ifdef R_UNIXWARE
#define  OSICOM_REL   "PDS.03.04.01"
#else
#define  OSICOM_REL   "PDS.01.04.01"
#endif

#ifndef UNIX_REL4
#define UNIX_REL4 (access("/proc",0)==0)
#endif

#define  BINTEC4_3   (access("/usr/bianca", 0) == 0)

#define  ISDN_DIALCODES   "W"

/* hinrichs 11.06.96 */
#include <time.h>
/* L{ngen-Definition von Variablen
**
**
*/

#define ISDN_PATH_LEN       	512
#define ISDN_FILE_LEN       	512
#define ISDN_BUF_LEN        	512
#define ISDN_LEN_GROUP		4096
#define ISDN_MAX_ANSCHLUESSE	12
#define ISDN_LEN_RUFNUMMER		31
#define ISDN_NAME_LEN              32    /* Siehe pdsfax.h = NAME_LEN           */

#define  MAX_KOPFZL             70
#define  MAX_FAXE               999
#define  MAX_GRP                45    /* Max. Anzahl Gruppenteilnehmer       */

#define uchar unsigned char


/* Verzeichnisse aus BinTec-Software
**
*/

#define ISDN_PATH_HOSTS            "/usr/isi/config/hosts"
#define ISDN_HOSTS_TEMP		"/usr/isi/config/hosts.neu"

/* Unterverzeichnisse und deren Dateien in ../pds/isdn
**
*/

#define ISDN_SERVER_PRG		"prg/isdn_jobsend"
#define ISDN_SERVER_PID 	"pid/server"
#define ISDN_OCSCA_PRG		"ositel/bin/ocs_ca"
#define ISDN_OCSLA_PRG		"ositel/bin/ocs_la"
#define ISDN_OCSCA_PID		"pid/ocs_ca"
#define ISDN_OCSLA_PID		"pid/ocs_la"
#define ISDN_SERVER_FIFO	"fifos/server"
#define ISDN_DOKUMENTE          "dokumente"
#define ISDN_STATUS             "status"
#define ISDN_CMD_PRG            "prg/isdn_cmd"
#define ISDN_OSITELBIN          "ositel/bin"
#define ISDN_OSITELAPPLI        "ositel/appli"
#define ISDN_SENDTDD            "sendtdd"
#define ISDN_RECTDD             "empfang"
#define ISDN_RECSTATUS          "empfang/status"
#define ISDN_FAXFILE            "faxfiles"
#define ISDN_DXJ_SEITEN         "dateien/dxjseiten"
#define ISDN_TESTFAX		"dateien/test.pcx"

/* Unterverzeichnisse und deren Dateien in ../oli/pds/fax
**
*/

#define  F_LOGO                 "logo"
#define  F_BENUTZER             "benutzer"
#define  F_KOEPFE               "koepfe"
#define  F_GRUPPEN              "gruppen"

/* Unterverzeichnisse und deren Dateien in ../daten/isdn
**
*/

#define ISDN_LOGBUCH		"logbuch"
#define ISDN_KONFIGURATION		"konfiguration"
#define ISDN_FAXNUMMER   		"faxnummer"
#define ISDN_CITYRUFNR             "cityrufnr"
#define ISDN_SMSNR   	        "smsnr"
#define ISDN_EMPFANGSNR            "empfangsnr"
#define ISDN_TRANSFERNR            "transfernr"
#define ISDN_PDSHOSTS              "hosts"

#define ISDN_LOGGRP		"bekannte"

/* Standard-IP-Protokollart
**
*/

#define ISDN_STD_IPPROT		"tcp/ip3"
#define ISDN_STD_FV64S 		"fv"




/* --------------------------------------------------------------------------
** Paramterblock fr SMS
**
*/

typedef struct
{
 char smsc[33];        /* Nummer der SMSC, optional */
 int  conn_mode;       /* Art der Verbindung zum SMSC, 0 = MODEM, 1 = ISDN */
 int  wait_note;       /* wenn = 1 dann wird max 40 s auf notification gewartet */
 int  save_time;       /* max anzahl stunden, die das smsc die message speichert */
 char message[1001];   /* Kurzmitteilung */
 char orig[17];        /* Tel.nr des Absenders */
 char dest[17];        /* Zielnummer mit Vorwahl */
 char messid[20];      /* Message-ID bei D1 */
 int  send_lim;        /* Maximale Anzahl Messages je Session */
 int  quer_lim;        /* Maximale Anzahl Status-Queries je Session */
 int  dele_lim;        /* Maximale Anzahl Delete-Messages je Session */
 int  result;          /* ergebnis des gesamten Versuchs, 0 = OK */
 int  retry;           /* wenn true, dann ist ein spterer Versuch sinnvoll */
 int  cause;           /* isdn-cause, grund fr 'keine Verbindung' mit SMSC */
 int  t_errno;         /* tli-fehler */
 int  errno;           /* fehler */
 int  ec;              /* error code von SMSC */
 int  duration;        /* Dauer des Versuches */
 int  trn;             /* transaction-reference-number = Anzahl Versuche -1 */
 int  more_to_send;    /* flagge, es sind noch messages zu senden */
 int  ackflag;         /* flagge, letze aktion wurde besttigt */
 char result_str[400]; /* Klartextmeldung des Sendeversuches */
 char sendezeit[30];   /* Uhrzeit als String */
 int  gebuehr;         /* anzahl der angefallenen Gebhreneinheiten */
} sms_typ;


/*------------------------------------------------------------------------------
** Defines fuer den Wert "status"
**
*/

#define  S_HOLD         (1)
#define  S_FEHLER       (2)           /* Abbruch nach Error -> diagnostic     */
#define  S_READY_2_SENT (3)           /* Bereit zum Senden                    */
#define  S_SENDING      (4)           /* Fax wird gesendet                    */
#define  S_SENT         (5)           /* Fax wurde gesendet                   */
#define  S_READY_2_REC  (6)           /* Bereit zum Empfangen                 */
#define  S_RECEIVING    (7)           /* Empfaengt                            */
#define  S_RECEIVED     (8)           /* Empfangen                            */
#define  S_INCOMMING    (9)           /* Eingehender Ruf durch Senden         */
#define  S_READY_2_LOAD (10)          /* Download                             */
#define  S_LOADING      (11)          /* Download wird durchgefuehrt          */
#define  S_LOADED       (12)          /* Download abgeschlossen               */
#define  S_READY_2_CONF (13)          /* Laden EEPROM                         */
#define  S_CONFIGURING  (14)          /* Laden wird durchgefuehrt             */
#define  S_CONFIGURED   (15)          /* Laden abgeschlossen                  */
#define  S_READY_2_TALK (16)          /* Bereit zum Dialog (Cityruf)          */
#define  S_TALKING      (17)          /* Dialog wird durchgefuehrt            */
#define  S_TALKED       (18)          /* Dialog abgeschlossen                 */
#define  S_NORETRY      (19)          /* Weiterer Versuch nicht sinnvoll */
#define  S_KEINRETRY    (19)          /* jetzt ok, wegen neuem pdsmenu */

#define  S_DELETED      (1000)        /* PDS-Eigen                            */

/*------------------------------------------------------------------------------
** Defines fuer den Wert "diagnostic"
** G3-Fehler
*/


/* SMS-Errors
**
*/

#define  D_SMS_NOCONN   (70)         /* Keine Verbindung mit SMSC  */
#define  D_SMS_TLIERR   (71)         /* TLI-Fehler */
#define  D_SMS_SMSCERR  (72)         /* Fehlermeldung vom SMSC */



/* Standard Cityrufzugang
**
*/

#define  ISDN_CITYRUF_ZUGANG "01691"

/* Returnwerte von isdn_protokoll()
**
*/

#define ISDN_PROT_FV	0
#define ISDN_PROT_1TR6	1
#define ISDN_PROT_DSS1	2



typedef struct
{
/* Eingangsparameter */
 char sourcepath[512];
 char telno[40];
/* Ausgangsparameter */
 int  result;
 char result_str[400];
 int  diagnostic;
 int  errno;
 int  t_errno;
 int  cause;
 int  retry;
 int  duration;
 int  charge;
 int  gebuehr;
} xmt_typ;


/*D-Kanal-Fehler*/
#define  D_NOPHYS       (33)
#define  D_NOBCHAN      (34)
#define  D_NOLAY1       (35)
#define  D_BADSERV      (36)
#define  D_LOCKED       (37)
#define  D_OCCUPIE      (38)
#define  D_NOPARTN      (39)
#define  D_NOAVAIL      (40)
#define  D_NOANSWE      (41)
#define  D_DISCHAR      (42)
#define  D_NOINCAL      (43)
#define  D_NETLOAD      (44)

/* ISDN-Fehler     -> D_XXX = (LA_ERR_XXX + 19)
** CA-Fehler*/
#define  D_PROTO        (20)
#define  D_NOCHAN       (21)
#define  D_INTERN       (22)
#define  D_CAPFIT       (23)
#define  D_NOTACEPT     (24)
#define  D_NODTAM       (25)
#define  D_NOSERV       (26)
#define  D_OPNFIL       (27)
#define  D_CMDSESS      (28)
#define  D_UNEXPID      (29)
#define  D_WRITFIL      (30)
#define  D_TRIGREQ      (31)
#define  D_BADKONT      (32)


#define  D_DISSIG_FAIL  (100)         /* Disconnect after signal failed       */
#define  D_NO_CONNECT   (101)         /* Keine Verbindung zur Fax-Karte       */
#define  D_DISC_FAILED  (102)         /* Disconnect failed                    */
#define  D_INTERNAL     (103)         /* Interner Error (Nicht spezifiert)    */
#define  D_WRITE_ERROR  (104)         /* Empfang: Schreibfehler Datei         */

/*------------------------------------------------------------------------------
** Defines fuer den Wert "diagnostic"
** G3-Fehler
*/

#define  D_OK           (0)
#define  D_NO_DIALTONE  (1)           /* Kein Waehlton durch die Amtsleitung  */
#define  D_AB_DIALTONE  (2)           /* Waehlton zu kurz                     */
#define  D_OCCUPIED     (3)           /* Besetzt                              */
#define  D_NO_ANSWER    (4)           /* Keine Antwort                        */
#define  D_LOOP_LOST    (5)           /* Kein Schleifenstrom                  */
#define  D_SENDING      (6)           /* Karte Sendet bereits                 */
#define  D_DIALTIMEOUT  (7)           /* Timeout beim Waehlen                 */
#define  D_NEG_CONFIRM  (8)           /* Negative Bestaetigung                */
#define  D_FTT_ONLY     (9)           /* Schlechte Leitungsqualitaet          */
#define  D_TX_TIMEOUT   (10)          /* Timeout beim Senden                  */
#define  D_OFF_HOOK     (11)          /* Die Leitung fuer die Karte ist belegt*/
#define  D_DIAL_LOCKED  (12)          /* Karte gesperrt                       */
#define  D_TX_ABORTED   (13)          /* Lokale Unterbrechung                 */
#define  D_RETRY_ERROR  (14)          /* Gegenstelle reagiert nicht           */
#define  D_DISCONNECT   (15)          /* Uebertragung durch Gegenstelle unter */
#define  D_ABORTED      (16)          /* Uebertragung abgebrochen             */
#define  D_NOTCOMPATIB  (17)          /* Nicht Faxkomp. Antwort               */

#define  D_NOFAX        (45)
#define  D_BADLINE      (46)
#define  D_TOOSLOW      (47)
#define  D_BADKOMM      (48)
#define  D_CONCLOS      (49)
#define  D_CONBROK      (50)
#define  D_BADMODE      (51)
#define  D_DATAFAI      (52)
#define  D_NOT30        (53)
/*
#define  D_LA_USER      (54)
#define  D_LA_SYS       (55)
*/
#define  D_UNKNOWN      (56)
#define  D_ACTINT       (57)

/* ** Defines fr den ISDN-Filetransfer
**
*/
#define FTXFER_SERVICE     "filetrans"
#define FT_DATALEN       4000
#define FTOP_ACK         0             /*allg. quittung */
#define FTOP_DATA        1             /*Daten          */
#define FTOP_ERROR       2             /*Fehler (NR., Text)    */

#endif
