/*******************************************************************************
**
** Session-Keep-alive-Listener
**
** xchanges
** 02.02.96 hinrichs
**          Anpassung f}r den Ressourcenserver vorgenommen
** 25.04.96 hinrichs
**          charge_reply() eingef}gt
** 01.07.96 hinrichs
**          '_al' jetzt auch f}r 1tr6-ip-partner anh{ngen
**                wegen Umstellung von services und hosts
** 30.09.96 hinrichs
**          get_host_by_ip()
**          bestimmung des ISDN-teilnehmers aus der ip-adresse f}r DOS-Router
**          angepa~t (get_router() eingef}gt)
**          process_isdn_data()
**          '::' aus telno f}r dosrouter rausgenommen
**          dadurch problem mit festverbindungsteilnehmer in hosts beseitigt
** 08.01.98 hinrichs
**          anpassungen (vorbereitungen) fr linux-version
*******************************************************************************/
#ident "@(#)alived.c 1.13.07"
#define VERSION		"1.13.07   08.01.98"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netdb.h>
#include <netinet/in.h>
#include <fcntl.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <pds/pdsisdn.h>
#include <pds/fetsrv.h>
#include "alived.h"

int    debug = 0;
int    xdebug = 0;
int    xxdebug = 0;
time_t t;
int    sessmaxcnt = 0;
int    fdcnt,d_al_fd;
char   tt[100];

struct servent srvalive_service;
struct servent sessalive_service;
struct servent killer_service;
int            alivesock;
int            srvalivesock;
int            killersock;
char           serverinfo[BUFSIZE];
struct pollfd  fds[2];
d_al_hd_typ    d_al_callp;

fetsrvstat_typ       r_list[MAX_ROUTER];
sessionlist_typ      sessionlist[MAX_SESSIONS];
rem_sessionlist_typ  rem_sesslist[MAX_SESSIONS];
ziel_router_typ      ziel_router[MAX_ROUTER];
IsdnHostInfo         My_info;

/*--------------------------------------------------------------------*/
extern char    *inet_ntoa   TB_PROTO(( unsigned long ));
extern u_long  inet_addr    TB_PROTO(( char * ));
#ifndef R_UNIXWARE
extern int 	get_ip_telno(int);
unsigned long get_broadcast_addr(int);
#endif

int get_sockets             TB_PROTO(( void ));
int get_services            TB_PROTO(( void ));
int get_FetInfo             TB_PROTO(( char *, int, FetInfo * ));
int check_sessionlist       TB_PROTO(( void ));
int update_sessionlist      TB_PROTO(( struct sockaddr_in, unsigned short, unsigned long ));
int update_isdn_fetlist     TB_PROTO(( char *, int, int ));
int process_remote_session  TB_PROTO(( struct sockaddr_in, unsigned long, short ));
int send_rem_sessinfo       TB_PROTO(( int ));
int send_killinfo           TB_PROTO(( struct sockaddr_in ));
int process_isdn_data       TB_PROTO(( struct sockaddr_in, char *, int ));
int process_d_alive         TB_PROTO(( int, d_al_hd_typ, char * ));
int process_serverinfo      TB_PROTO(( char * ));
int process_getname         TB_PROTO(( char *, struct sockaddr_in ));
int send_isdn_alive         TB_PROTO(( void ));
int check_isdn_sessions     TB_PROTO(( void ));
int prepare_d_alive         TB_PROTO(( int ));
int send_d_alive            TB_PROTO(( int ));
int get_d_al_telno          TB_PROTO(( unsigned long, d_al_hd_typ* ));
int is_online               TB_PROTO(( int ));
int fill_my_info            TB_PROTO(( void ));
int init_from_fetstatd      TB_PROTO(( void ));
int process_ack             TB_PROTO(( struct sockaddr_in ));
int init_d_alive_rec        TB_PROTO(( int *, d_al_hd_typ* ));
int init_isdn               TB_PROTO(( void ));
int check_routerlist        TB_PROTO(( void ));
int check_router_for_session TB_PROTO(( int ));
int charge_reply            TB_PROTO(( struct sockaddr_in ));
int update_partnerlist      TB_PROTO(( char *, int ));
int print_socktest          TB_PROTO(( char * ));
unsigned long get_nwaddr    TB_PROTO(( char * ));

/*--------------------------------------------------------------------*/
extern int isdn_lms_start          TB_PROTO(( char * ));
extern int isdn_lms_stop           TB_PROTO(( char * ));
 
extern int get_host_by_ip          TB_PROTO(( unsigned long, char * ));
extern unsigned long get_router    TB_PROTO(( unsigned long ));
extern char *hostbytelno(char *telno);
extern char *get_escape(char **escape);
extern int   end_d_alive(int fd);

/*------------------------------------------------------------------------------
** Fehler auf stderr ausgeben
** wird von libpdsisdn.a ben|tigt. sonst linkerror tb_error not found
*/
#ifdef __STDC__
void isdn_error(const char *fmt, ...)
#else
void isdn_error(va_alist)
va_dcl
#endif
{
va_list  args;
char     msg[128];
char    *p;

#ifdef __STDC__
   va_start(args, fmt);
#else
char    *fmt;

  va_start(args);

  fmt = va_arg(args, char *);
#endif

  (void) vsprintf(msg, fmt, args);
  va_end(args);

  if ((p = strrchr(msg, '\n')))
     *p = '\0';

  fprintf(stderr, "%s\n", msg);
  fflush(stderr);
}

/*--------------------------------------------------------------------*/
#ifdef __STDC__
uint Strlen (const char *str);
uint Strlen (const char *str)
#else
int Strlen(str)
char *str;
#endif
{  return (strlen (str)); }

/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
static int my_sendto (int sock, char *data, int len_data ,int mode ,
	struct sockaddr *adr, int adr_len)
{
int rc;

m1:
rc = sendto (sock, data, len_data, mode , adr, adr_len);

#ifndef R_UNIXWARE
if(rc < 0 && errno == ECONNREFUSED) goto m1;
#endif

return(rc);
}
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
int main(int argc,char *argv[])

{
int                received=0, sent, old_session,rcode,FalscherAlarmPrinted=0;
size_t		   addrlen;
struct sockaddr_in remote;
char               buffer[BUFSIZE];
unsigned long      *unix_ip,*alived_ip;
unsigned short     answer=OP_ACK;
unsigned short     r_kennung;

   if (argc > 1)
      debug = 1;
   else
      debug = 0;

   if (argc > 2)
      xdebug = 1;
   else
      xdebug = 0;

   if (argc > 3)
      xxdebug = 1;
   else
      xxdebug = 0;

   if (debug)
      fprintf(stderr,"alived Version %s\n\n",VERSION);

   setuid(0); /* owner root */


   if (!freopen("/dev/null","r",stdin))
      fprintf (stderr,"alived: Umleitung von stdin nach /dev/null fehlgeschlagen\n");
   if (!freopen("/dev/null","w",stdout))
      fprintf (stderr,"alived: Umleitung von stdout nach /dev/null fehlgeschlagen\n");

   if (!get_services())
   {
      fclose (stderr);
      exit (1);
   }

   if (!get_sockets())
   {
      fclose (stderr);
      exit (1);
   }

   memset(&remote, 0,sizeof(remote));
   remote.sin_family = AF_INET;
   remote.sin_addr.s_addr = INADDR_ANY;
   remote.sin_port = sessalive_service.s_port;

   addrlen = sizeof(remote);

   if (bind (alivesock, (struct sockaddr *)&remote, addrlen) < 0)
   {
      perror ("bind(), alive");
      fclose (stderr);
      exit(1);
   }

   fds[0].fd     = alivesock;
   fds[0].events = POLLIN;
   fdcnt = 1;


   init_from_fetstatd();

   while(1)
   {
      check_routerlist();
      check_sessionlist();
      check_isdn_sessions();
      send_isdn_alive();
      rcode = poll (fds,fdcnt,SESSLIST_UPDATE_TIMEOUT * 1000);
      if (rcode == 0)
         continue;

      if (rcode < 0)
      {
	 if (errno == EAGAIN)
         {
	    continue;
         }
         else
	 {
            fprintf(stderr,"%s: Fehler beim poll()/ %s,errno=%d\n",argv[0],sys_errlist[errno],errno);
	    sleep (1);
	    continue;
         }
      }
      /* jetzt ist mal wieder ein paket da */

      if (fds[0].revents & POLLIN) /* wars ein Session-Alive ?*/
      {
         received = recvfrom (alivesock, buffer, sizeof(buffer), 0 ,(struct sockaddr *)&remote, (size_t *)&addrlen);

         if (received > 0)
         {
            memcpy ((char*)&r_kennung,buffer,2);
            switch (r_kennung)
            {
               case OP_ACK:
                  process_ack(remote);
                  continue;
               case KE_CHARGE_ASK:  /* geb}hrenanfrage vom fet */
                  charge_reply(remote);
                  continue;
               case KE_SERVERSTAT:
                  process_serverinfo(buffer);
                  continue;
               case KE_FET_GETNAME:
                  process_getname(buffer,remote);
                  continue;
               case KE_SESSION_START:
                  if (received == 2)
                  {
                     if (xdebug)
                        fprintf (stderr,"alived: alte Sessionstart von %s erhalten!\n",inet_ntoa(remote.sin_addr.s_addr));
                     continue;
                  }
                  unix_ip   = (unsigned long *)&buffer[2];/*IP von telnetd */
                  alived_ip = (unsigned long *)&buffer[6];/*IP dieser Maschine*/
                  if (*unix_ip == *alived_ip)
                  { /* fet mit lokaler session */
                     old_session = update_sessionlist(remote,KE_SESSION_START,NO_ISDN);
                     if (old_session)
		     {
		        if (debug)
			   fprintf (stderr,"Kill f}r alte Session gesendet !!!\n");
                        send_killinfo(remote);
		     }
                  }
                  else
                  { /* fet mit remote-session, diese maschine ist nur router */
                     process_remote_session (remote,*unix_ip,KE_SESSION_START);
                  }
                  break;
               case KE_SESSION_ALIVE:
                  if (received == 2)
                  {
                     if (xdebug)
                        fprintf (stderr,"alived: altes Sessionalive von %s erhalten!\n",inet_ntoa(remote.sin_addr.s_addr));
                     continue;
                  }
                  unix_ip   = (unsigned long *)&buffer[2];
                  alived_ip = (unsigned long *)&buffer[6];
                  if (*unix_ip == *alived_ip)
                  { /* fet mit lokaler session */
                     old_session = update_sessionlist(remote,KE_SESSION_ALIVE,NO_ISDN);
                     if (old_session)
		     {
		        if (debug)
			   fprintf (stderr,"Kill f}r alte Session gesendet !!!\n");
                        send_killinfo(remote);
		     }
                  }
                  else
                  { /* fet mit remote-session, diese maschine ist nur router */
                     process_remote_session (remote,*unix_ip,KE_SESSION_ALIVE);
                  }
                  break;
               case KE_SESSION_STOP:
                  if (received == 2)
                  {
                     if (xdebug)
                        fprintf (stderr,"alived: altes Sessionstop von %s erhalten!\n",inet_ntoa(remote.sin_addr.s_addr));
                     continue;
                  }
                  unix_ip   = (unsigned long *)&buffer[2];
                  alived_ip = (unsigned long *)&buffer[6];
                  if (*unix_ip == *alived_ip)
                  {  /* fet mit lokaler session */
                     update_sessionlist(remote,KE_SESSION_STOP,NO_ISDN);
                  }
                  else
                  {  /* fet mit remote-session, diese maschine ist nur router */
                     process_remote_session (remote,*unix_ip,KE_SESSION_STOP);
                  }
                  break;
               default:
                  if (process_isdn_data(remote,buffer,received))
                  {          /* ack senden */

#ifdef R_UNIXWARE
                     if (remote.sin_addr.s_addr != htonl(0x7f000001))  /* local */
#endif

#ifndef R_UNIXWARE
 		     if (remote.sin_addr.s_addr != get_broadcast_addr(0))  /* local */
#endif

	             {
                        sent = my_sendto (alivesock, (char *)&answer, sizeof(answer), 0 ,(struct sockaddr *)&remote, addrlen);
                        if (sent < 0)
                           fprintf(stderr,"%s, error in my_sendto() on alivesock,%s\n",argv[0],sys_errlist[errno]);
                     }
                  }
                  break;
            }
         }
         else
         {
	    printf("recvfrom error: errno = %d (%s)\n",errno,sys_errlist[errno]);
            continue;
         }
      }

      if ((fdcnt == 2) && (fds[1].revents & POLLIN)) /* wars ein D-Alive ?*/
      {
         if (process_d_alive(d_al_fd,d_al_callp,buffer))
            process_isdn_data(remote,buffer,received);
         continue;
      }

      if (((fds[0].revents & POLLIN) ||
          ((fdcnt == 2) && (fds[1].revents & POLLIN))) == 0)
      {
	 if (!FalscherAlarmPrinted)
	 {
            fprintf (stderr,"! Falscher Alarm von Poll !!!!! Kein FD hat was f}r mich!\n");
	    FalscherAlarmPrinted = 1;
         }
         continue;
      }
   }
 return (0);
}

/***************************************************************************/
int update_sessionlist (fet_addr, kennung,isdn)
struct sockaddr_in fet_addr;
unsigned short      kennung;
unsigned long       isdn;

{
 int i,j;

 for (i=0;i<MAX_SESSIONS;i++)  /* zundchst passende Session suchen */
 {
    if ((fet_addr.sin_addr.s_addr == sessionlist[i].ip) &&
        (fet_addr.sin_port        == sessionlist[i].port))
    {
       switch (kennung)
       {
          case KE_SESSION_START:
             if (debug)
                fprintf (stderr," ++ Start fuer bestehende Session Nr. %d erhalten, FET %s Port %x \n",i+1,inet_ntoa(fet_addr.sin_addr.s_addr),htons(fet_addr.sin_port));
             sessionlist[i].time = time(0) + (sessionlist[i].isdn?ISDN_TOUT:LAN_TOUT);
             return (1);
          case KE_SESSION_ALIVE:
                if (sessionlist[i].isdn)
                {
                  if (xdebug)
                     fprintf (stderr,"ISDN-FET %s Port %x lebt\n",inet_ntoa(fet_addr.sin_addr.s_addr),htons(fet_addr.sin_port));
                }
                else
                  if (xxdebug)
                     fprintf (stderr,"LAN-FET %s Port %x lebt\n",inet_ntoa(fet_addr.sin_addr.s_addr),htons(fet_addr.sin_port));

             sessionlist[i].time = time(0) + (sessionlist[i].isdn?ISDN_TOUT:LAN_TOUT);
             break;
          case KE_SESSION_STOP:    /* jetzt fliegt er raus, alles ok */
             if (debug)
	     {
		t=time(0);
		strcpy(tt,ctime(&t));
		tt[19]=0;
                fprintf (stderr,"%s | FET %s Port %x sauber beendet\n",&tt[4],inet_ntoa(fet_addr.sin_addr.s_addr),htons(fet_addr.sin_port));
	     }
             sessionlist[i].ip = 0L;
             break;
          default:
             break;
       }
       return (0);
    }
 }

 if (i == MAX_SESSIONS)
 {  /* jetzt hat er ihn noch nicht drin */
    switch (kennung)
    {
       case KE_SESSION_START:
       case KE_SESSION_ALIVE:
          for (j=0;j<MAX_SESSIONS;j++)
          {
             if (sessionlist[j].ip == 0L)
             {
                sessionlist[j].ip   = fet_addr.sin_addr.s_addr;
                sessionlist[j].port = fet_addr.sin_port;
                sessionlist[j].isdn = isdn;
                sessionlist[j].time = time(0) + (sessionlist[j].isdn?ISDN_TOUT:LAN_TOUT);
                if (debug)
		{
                   t = time(0);
		   strcpy(tt,ctime(&t));
		   tt[19]=0;
                   fprintf (stderr,"%s | FET %s Port %x | Session Nr. %d neu",&tt[4],inet_ntoa(fet_addr.sin_addr.s_addr),htons(fet_addr.sin_port),j+1);
		   if (kennung == KE_SESSION_START)
		      fprintf(stderr,"\n");
                   else
		      fprintf(stderr," durch alive!\n");
		}
                if (j > sessmaxcnt)
		   sessmaxcnt = j;

                return (0);
             }
          }
          if (j == MAX_SESSIONS)
             fprintf (stderr,"alived: Sessionliste ist voll!\n");
          return (0);
       default:
          return (0);
    }
 }
 return (0);
}

/***************************************************************************/
int check_sessionlist ()

{
 int i;
 static unsigned long lasttime=0;
 long difft;
 struct sockaddr_in fet_addr;
 unsigned long now;
 char tt1[50];
 char tt2[50];

 now = time(0);

 if (lasttime == 0)
    lasttime = now;

 difft = now - lasttime;
 if ((difft > 5) || (difft < 0))
 {
    if (debug)
    {
      strcpy (tt1,ctime((time_t *)&now));
      tt1[19]=0;
      strcpy (tt2,ctime((time_t *)&lasttime));
      tt2[19]=0;
      fprintf (stderr,"\n\n%s -- %s | Clock was set, all timers new set !!\n\n",&tt1[4],&tt2[4]);
    }

    for (i=0;i<=sessmaxcnt;i++)
      if (sessionlist[i].ip != 0)
         sessionlist[i].time = now + (sessionlist[i].isdn?ISDN_TOUT:LAN_TOUT);
 }

 lasttime = now;

 for (i=0;i<=sessmaxcnt;i++)
 {
    if (sessionlist[i].ip && (sessionlist[i].time < now))
    {
       fet_addr.sin_port        = sessionlist[i].port;
       fet_addr.sin_addr.s_addr = sessionlist[i].ip;
       if (debug)
       {
          t=time(0);
	  strcpy (tt1,ctime(&t));
	  tt1[19]=0;
          fprintf (stderr,"%s | FET %s Port %x | Timeout\n",&tt1[4],inet_ntoa(fet_addr.sin_addr.s_addr),htons(fet_addr.sin_port));
       }
       send_killinfo (fet_addr);
       sessionlist[i].ip = 0L;
    }
 }
 return (0);
}

/***************************************************************************/
int send_killinfo (fet_addr)
struct sockaddr_in fet_addr;

{
 unsigned short     s_kennung = KE_KILL_FETJOBS,port;
 unsigned long      ip;
 char               buf[8];
 struct sockaddr_in remote;
 int                addrlen,rcode;

 ip   = fet_addr.sin_addr.s_addr;
 port = htons(fet_addr.sin_port);

 memcpy (buf,&s_kennung,sizeof(s_kennung));
 memcpy (&buf[2],&ip,4);
 memcpy (&buf[6],&port,2);

 memset(&remote, 0,sizeof(remote));
 remote.sin_family = AF_INET;

#ifdef R_UNIXWARE
 remote.sin_addr.s_addr = htonl(0xffffffff);  /* IP-Rundfunk */
#endif


#ifndef R_UNIXWARE
 remote.sin_addr.s_addr = get_broadcast_addr(1);
#endif

 remote.sin_port = killer_service.s_port;
 addrlen = sizeof(remote);

 rcode = my_sendto (killersock, buf, 8, 0 ,(struct sockaddr *)&remote, addrlen);
 if (rcode < 0)
 {
    fprintf(stderr,"error in my_sendto() on killersock, errno=%d\n",errno);
    return (0);
 }


#ifdef R_UNIXWARE
 remote.sin_addr.s_addr = htonl(0x7f000001);  /* local */
#endif

#ifndef R_UNIXWARE
 remote.sin_addr.s_addr = get_broadcast_addr(0);  /* local */
#endif

 rcode = my_sendto (killersock, buf, 8, 0 ,(struct sockaddr *)&remote, addrlen);
 if (rcode < 0)
 {
    fprintf(stderr,"error in my_sendto() on killersock, errno=%d\n",errno);
    return (0);
 }

 if (debug)
    fprintf(stderr, "$$$$$$ KILL FETJOBS gesendet !!!!!!!!!!!!\n");
 return (1);
}


/***************************************************************************/
int process_isdn_data (from,buffer,received)
struct sockaddr_in from;
char *buffer;
int received;

{
 int                r_no,rcode, addrlen, d_message = 0,new_router = 0;
 int                namelen,i;
 static int         srv_infolen,first_time=1;
 struct sockaddr_in remote;
 FILE               *fptr;
 char               *iescape,head[30];
 char               rem_telno[33],*r_host,d_host[40];
 unsigned short     r_kennung, s_kennung = KE_ISDNSRV_ALIVE;
 /*
 unsigned long      *RouterTime  =(unsigned long *)  buffer;
 unsigned short     *IsdnSlotSize=(unsigned short *)&buffer[4];
 */
 unsigned short     *IsdnSlots   =(unsigned short *)&buffer[6];
 IsdnHostInfo       *IsdnHosts   =(IsdnHostInfo *)  &buffer[8];
 LocalHostInfo      *LocalHosts  =(LocalHostInfo *) &buffer[8];
 FetInfo            *FetList;
 PrintInfo          *PrintInfoList;
 unsigned short     *LocalSlots, *LocalSlotSize, *NumFets, *NumPrintInfos;


 memcpy ((char*)&r_kennung,buffer,2);
 switch (r_kennung)
 {
    case KE_D_CHAN_ALIVE:
       if (xdebug)
       {
          fprintf (stderr, "--- D-Alive erhalten---");
          fprintf (stderr, "Addr = %s  Caller = %s\n",&buffer[2],&buffer[52]);
       }

       r_host = hostbytelno(&buffer[52]);
       if (r_host==NULL)
       {
          fprintf (stderr,"Konnte D-Alive von %s keinem ISDN-Hostnamen zuordnen\n",&buffer[52]);
          return (0);
       }
       for (r_no=0;r_no<MAX_ROUTER;r_no++)
       {
          strcpy (d_host,r_host);
          if (strcmp(d_host,r_list[r_no].hostname))
          {  /* jetzt ist es vielleicht ein euro-partner -> alive von
                hostname_al */
             namelen = strlen(d_host);
             if (namelen > 3)
             {
                d_host[namelen-3] = 0; /* _al abschneiden */
                if (!strcmp(d_host,r_list[r_no].hostname))
                   break;
             }
          }
          else
          {  /* hat direkt geklappt */
             break;
          }
       }

       if (r_no == MAX_ROUTER)
       {
          fprintf (stderr,"Konnte D-Alive von %s <%s> keinem ISDN-Router zuordnen\n",r_host,&buffer[52]);
          if (debug)
          {
             fprintf(stderr,"Liste der registrierten Router:\n");
             for (i=0;i<MAX_ROUTER;i++)
                if (r_list[i].hostname[0])
                   fprintf (stderr,"%s\n",r_list[i].hostname);
          }

          return (0);
       }

       d_message = 1;
       break;
    case KE_CHARGE_MESS:
       if (first_time)
       {
	  first_time = 0;
   	  init_isdn(); 
       }

       /* zundchst den Router via ip-addr. in der Liste suchen */
       for (r_no=0;r_no<MAX_ROUTER;r_no++)
       {
          if (from.sin_addr.s_addr == r_list[r_no].ip)
             break;
       }

       if (r_no == MAX_ROUTER)
       {   /* via ip-addr nicht in der Liste gefunden */
#ifdef R_UNIXWARE
          /* also jetzt nach telno suchen */
	  /* nur fr UNIXWARE, Bintec relevant */
          for (r_no=0;r_no<MAX_ROUTER;r_no++)
          {
             if (!strcmp (IsdnHosts[(*IsdnSlots) - 1].telno,r_list[r_no].telno))
                break;
          }
#endif

          if (r_no == MAX_ROUTER)   /* nicht in der Liste gefunden */
          { /* also neu anlegen */
             for (r_no = 0;r_no<MAX_ROUTER;r_no++)
             {
                if (r_list[r_no].ip == 0)
                   break; /* freies pldtzchen gefunden */
             }
             if (r_no >= MAX_ROUTER)
             {
                 fprintf (stderr, "Routerliste ist voll!!!!");
                 return (1);
             }
             /* jetzt ist ein neuer platz gefunden */
             r_list[r_no].ip = from.sin_addr.s_addr;
#ifdef R_UNIXWARE
             if (get_escape(&iescape))
                sprintf(head,"007000%s",iescape);

             if (strncmp (IsdnHosts[(*IsdnSlots) - 1].telno,"007000",6))
                sprintf (r_list[r_no].telno,"%s%s",head,IsdnHosts[(*IsdnSlots) - 1].telno);
             else
                strcpy (r_list[r_no].telno,IsdnHosts[(*IsdnSlots) - 1].telno);
#else
	     r_list[r_no].telno[0]=0;
#endif

             if (!get_host_by_ip(r_list[r_no].ip,r_list[r_no].hostname))
             {
#ifdef R_UNIXWARE
                r_host = hostbytelno(r_list[r_no].telno);
                if (r_host != NULL)
                   strcpy (r_list[r_no].hostname,r_host);
                else
                {
                   if (debug)
                      fprintf (stderr,"Aufl|sung ohne T2 klappt nicht!\n");
                   sprintf (r_list[r_no].telno,"007000T2%s::",IsdnHosts[(*IsdnSlots) - 1].telno);
                   strcpy (rem_telno,r_list[r_no].telno);
                   r_host = hostbytelno(rem_telno);
                   if (r_host != NULL)
                      strcpy (r_list[r_no].hostname,r_host);
                   else
                   {
                      fprintf (stderr,"alived: Konnte ISDN-Hostname (Nr=%s) nicht bestimmen!\n",r_list[r_no].telno);
                      return (1);
                   }
                }
#else
                if (debug)
                   fprintf (stderr,"Konnte den Absende-Router anhand der IP-Adresse nicht bestimmen!\n");	
		return (1);
#endif
             }
             memcpy (r_list[r_no].lastpack, buffer, BUFSIZE);
             new_router = 1;
             update_partnerlist(r_list[r_no].hostname,1);
             if (debug)
             {
                fprintf (stderr,"Neuer Routereintrag <%s> angelegt !!!!\n",r_list[r_no].hostname);
             }
          }
       }
       if (xdebug)
       {
          t=time(0);
          strcpy(tt,ctime(&t));
          tt[19]=0;
          fprintf (stderr,"%s | ISDN-Sessioninfo von %s erhalten\n",&tt[4],inet_ntoa(r_list[r_no].ip));
       }
       d_message = 0;
       break;
    default:
       if (debug)
          fprintf (stderr,"Ung}ltige Message von %s erhalten (%15s)\n",inet_ntoa(from.sin_addr.s_addr),buffer);
       return (0);
 }

 if (!d_message)
 {
    LocalSlotSize = (unsigned short *)&IsdnHosts[*IsdnSlots];
    LocalSlots    = (unsigned short *)&LocalSlotSize[1];
    LocalHosts    = (LocalHostInfo *)&LocalSlotSize[2];

    /* bereichs-check, zur sicherheit */
    if (((char *)&LocalHosts[*LocalSlots] - (char *)buffer) >received)
    {
       fprintf (stderr,"!!!alived: ISDN-Router-Packet enth{lt keine sinnvollen Daten!\n");
       fprintf (stderr,"LocalHosts[*LocalSlots] zeigt in die Wicken!\n");
       fptr=fopen("/usr/tmp/alived.badpac","w+b");
       if (fptr != NULL)
       {
          fwrite(buffer,received,1,fptr);
          fclose (fptr);
          fprintf (stderr,"Datei /usr/tmp/alived.badpac erstellt!\n");
       }
       return(0);
    }

    NumFets = (unsigned short *)&LocalHosts[*LocalSlots];
    FetList = (FetInfo *)&NumFets[1];

    /* bereichs-check, zur sicherheit */
    if (((char *)&FetList[*NumFets] - (char *)buffer) >received)
    {
       fprintf (stderr,"!!!alived: ISDN-Router-Packet enth{lt keine sinnvollen Daten!\n");
       fprintf (stderr,"FetList[*NumFets] zeigt in die Wicken!\n");
       fptr=fopen("/usr/tmp/alived.badpac","w+b");
       if (fptr != NULL)
       {
          fwrite(buffer,received,1,fptr);
          fclose (fptr);
          fprintf (stderr,"Datei /usr/tmp/alived.badpac erstellt!\n");
       }
       return(0);
    }
    NumPrintInfos = (unsigned short *)&FetList[*NumFets];
    PrintInfoList = (PrintInfo *) &NumPrintInfos[1];

    /* bereichs-check, zur sicherheit */
    if (((char *)&PrintInfoList[*NumPrintInfos] - (char *)buffer) >received)
    {
       fprintf (stderr,"!!!alived: ISDN-Router-Packet enth{lt keine sinnvollen Daten!\n");
       fprintf (stderr,"PrintInfoList[*NumPrintInfos] zeigt in die Wicken!\n");
       fptr=fopen("/usr/tmp/alived.badpac","w+b");
       if (fptr != NULL)
       {
          fwrite(buffer,received,1,fptr);
          fclose (fptr);
          fprintf (stderr,"Datei /usr/tmp/alived.badpac erstellt!\n");
       }
       return(0);
    }
    if (xdebug)
       print_socktest(buffer);

    update_isdn_fetlist (buffer,r_no,new_router);

    srv_infolen = 2 + (*NumPrintInfos * sizeof(PrintInfo));
    memcpy (r_list[r_no].buf,(char*)&s_kennung,2);
    memcpy (&(r_list[r_no].buf[2]),r_list[r_no].telno,35);
    memcpy (&(r_list[r_no].buf[37]),(char *)NumPrintInfos,srv_infolen);
    memcpy (r_list[r_no].lastpack,buffer,BUFSIZE);
    check_router_for_session (r_no);
 }
 else
 {
    update_isdn_fetlist (r_list[r_no].lastpack,r_no,0);
 }

 r_list[r_no].lasttime = time(0);

 memset(&remote, 0,sizeof(remote));
 remote.sin_family = AF_INET;

#ifdef R_UNIXWARE
 remote.sin_addr.s_addr = htonl(0xffffffff);  /* IP-Rundfunk */
#endif


#ifndef R_UNIXWARE
 remote.sin_addr.s_addr = get_broadcast_addr(1);
#endif

/* remote.sin_addr.s_addr = htonl(0x7f000001);*/  /*IP-local */
 remote.sin_port = srvalive_service.s_port;
 addrlen = sizeof(remote);

 rcode = my_sendto (srvalivesock, (char *)r_list[r_no].buf, srv_infolen + 2 + 35, 0 ,(struct sockaddr *)&remote, addrlen);

 if (rcode < 0)
 {
    fprintf(stderr,"error in my_sendto() on srvalivesock %d, %s\n",errno, sys_errlist[errno]);
    return (1);
 }

#ifdef R_UNIXWARE
 remote.sin_addr.s_addr = htonl(0x7f000001);  /* IP-local */
#endif

#ifndef R_UNIXWARE
 remote.sin_addr.s_addr = get_broadcast_addr(0);  /* IP-Local */
#endif

 rcode = my_sendto (srvalivesock, (char *)r_list[r_no].buf, srv_infolen + 2 + 35, 0 ,(struct sockaddr *)&remote, addrlen);
 if (rcode < 0)
 {
    fprintf(stderr,"error in my_sendto() on srvalivesock, %s\n",sys_errlist[errno]);
    return (1);
 }


 if (xdebug)
    fprintf(stderr,"FET-Server-Message geschickt!\n");

 return (1);
}

int init_from_fetstatd()
{
 char data[39];
 int  datalen;
 int  addrlen,rcode;

 struct sockaddr_in remote;

 memset (data,0,39);
 *((unsigned short *)data) = KE_ISDNSRV_ALIVE;
 strcpy (&data[2],"999999999999999999"); /* hierdurch wei~ fetstatd bescheid */
 *((unsigned short *)&data[37]) = 0; /* 0 server bedeutet 'schick mir info' */

 memset(&remote, 0,sizeof(remote));
 remote.sin_family = AF_INET;

#ifdef R_UNIXWARE
 remote.sin_addr.s_addr = htonl(0xffffffff);  /* IP-Rundfunk */
#endif

#ifndef R_UNIXWARE
 remote.sin_addr.s_addr = get_broadcast_addr(1);  
#endif

 remote.sin_port = srvalive_service.s_port;
 addrlen = sizeof(remote);
 datalen =2 + 35 + 2;
 rcode = my_sendto (srvalivesock, data,datalen, 0 ,(struct sockaddr *)&remote, addrlen);
 if (rcode < 0)
 {
    fprintf(stderr,"error in my_sendto() on srvalivesock, %s\n",sys_errlist[errno]);
 }


#ifdef R_UNIXWARE
 remote.sin_addr.s_addr = htonl(x7f000001);  /* IP-local */
#endif

#ifndef R_UNIXWARE
 remote.sin_addr.s_addr = get_broadcast_addr(0); /* IP-local */ 
#endif

 rcode = my_sendto (srvalivesock, data, datalen, 0 ,(struct sockaddr *)&remote, addrlen);
 if (rcode < 0)
 {
    fprintf(stderr,"error in my_sendto() on srvalivesock, %s\n",sys_errlist[errno]);
 }
 return (1);
}

/***************************************************************************/
int update_isdn_fetlist (buffer,router_nr,new_router)
char *buffer;
int   router_nr;
int   new_router;

{
 int i,j,d_seq,d_alive,res;
 struct sockaddr_in fet_addr;
 FetInfo  newinfo,oldinfo;

 for (i=0;;i++)
 {
   if (get_FetInfo (buffer,i,&newinfo))
   {  /* weiteres FET in Liste gefunden */
      fet_addr.sin_port        = newinfo.socket;
      fet_addr.sin_addr.s_addr = *((long *)newinfo.ip_adr);

      if (new_router)
      {
         if (debug)
         {
            fprintf (stderr,"%d-te Session von neuem Router in Bearbeitung!!!!\n",i+1);
         }

         if (newinfo.alive == 1)
         {
            update_sessionlist (fet_addr,KE_SESSION_START,r_list[router_nr].ip);
            continue;
         }
         if ((newinfo.alive == 0) || (newinfo.alive == 2))
         {
            update_sessionlist (fet_addr,KE_SESSION_STOP,r_list[router_nr].ip);
            continue;
         }
         if (debug)
            fprintf (stderr, "newrouter = 1, 0 > alive > 2 !!!!!!");

         continue;
      }
      else
      {
         for (j=0;;j++)
         {
            res = get_FetInfo (r_list[router_nr].lastpack,j,&oldinfo);
            if (res)
            {
               if ((!memcmp(oldinfo.ip_adr,newinfo.ip_adr,4)) &&
                   (oldinfo.socket == newinfo.socket))
                  break;
               else
                  continue;
            }
            else
               break;
         }

         if (res) /* sonst hat er nicht die richtige session gefunden */
         {
            d_seq   = newinfo.seq   - oldinfo.seq;
            d_alive = newinfo.alive - oldinfo.alive;
            if (d_seq > 0) /* ein weiteres start ohne vorheriges stop erhalten */
            {
               if (oldinfo.alive == 1)
               {
                  if (newinfo.alive == 1)
                  {
                      /* start f}r bestehende session erhalten */
                     update_sessionlist (fet_addr,KE_SESSION_START,r_list[router_nr].ip);
                     if (debug)
                     {
                        fprintf(stderr,"old-alive = %d | new-alive = %d | old-seq = %d | new-seq = %d\n",
                                       oldinfo.alive,newinfo.alive,oldinfo.seq,newinfo.seq);
                     }
                     send_killinfo(fet_addr);
                  }
                  else
                  {    /* newinfo.alive == 2 oder 0 */
                     update_sessionlist (fet_addr,KE_SESSION_STOP,r_list[router_nr].ip);
                     if (debug)
                     {
                        fprintf (stderr, "verd{chtige kombinat: ");
                        fprintf(stderr,"old-alive = %d | new-alive = %d | old-seq = %d | new-seq = %d\n",
                                       oldinfo.alive,newinfo.alive,oldinfo.seq,newinfo.seq);
                     }
                  }
               }
               else
               { /* jetzt mu_ oldinfo.alive == 2 oder 0 sein */
                  if (newinfo.alive == 1)
                  {  /* ganz normaler isdn-start */
                     update_sessionlist (fet_addr,KE_SESSION_START,r_list[router_nr].ip);
                  }
               }
               continue;
            }

            if (d_seq < 0)
            {
               if (oldinfo.alive == 1)
               {
                  if (newinfo.alive == 0)
                  {  /* ganz normaler stop */
                     update_sessionlist (fet_addr,KE_SESSION_STOP,r_list[router_nr].ip);
                     continue;
                  }
                  if (newinfo.alive == 1)
                  {
                     if (debug)
                     {
                        fprintf (stderr, "verd{chtige kombination: ");
                        fprintf(stderr,"old-alive = %d | new-alive = %d | old-seq = %d | new-seq = %d\n",
                                       oldinfo.alive,newinfo.alive,oldinfo.seq,newinfo.seq);
                     }
                     update_sessionlist (fet_addr,KE_SESSION_ALIVE,r_list[router_nr].ip);
                     continue;
                  }
                  else
                  {  /* newinfo.alive == 2 */
                     if (debug)
                     {
                        fprintf (stderr, "verd{chtige kombination: ");
                        fprintf(stderr,"old-alive = %d | new-alive = %d | old-seq = %d | new-seq = %d\n",
                                       oldinfo.alive,newinfo.alive,oldinfo.seq,newinfo.seq);
                     }
                     update_sessionlist (fet_addr,KE_SESSION_STOP,r_list[router_nr].ip);
                     continue;
                  }
               }
               else
               { /* oldinfo.alive == 2 oder 0 */
                  if (debug)
                  {
                     fprintf (stderr, "verd{chtige kombination: ");
                     fprintf(stderr,"old-alive = %d | new-alive = %d | old-seq = %d | new-seq = %d\n",
                                    oldinfo.alive,newinfo.alive,oldinfo.seq,newinfo.seq);
                  }
                  if (newinfo.alive == 1)
                     update_sessionlist (fet_addr,KE_SESSION_ALIVE,r_list[router_nr].ip);
               }
               continue;
            }
            /* delta-seq ist jetzt == 0 */

            if (oldinfo.alive == 1)
            {
               if (newinfo.alive == 1)
               {  /* ganz normaler alive */
                  update_sessionlist (fet_addr,KE_SESSION_ALIVE,r_list[router_nr].ip);
                  continue;
               }
               if (newinfo.alive == 2)
               {  /* ganz normaler timeout vom router signalisiert */
                  if (debug)
                  {
                     fprintf(stderr,"old-alive = %d | new-alive = %d | old-seq = %d | new-seq = %d\n",
                                    oldinfo.alive,newinfo.alive,oldinfo.seq,newinfo.seq);
                  }
                  send_killinfo(fet_addr);
                  update_sessionlist (fet_addr,KE_SESSION_STOP,r_list[router_nr].ip);
                  continue;
               }
               else
               {  /* newinfo.alive == 0 */
                  if (debug)
                  {
                     fprintf (stderr, "verd{chtige kombination: ");
                     fprintf(stderr,"old-alive = %d | new-alive = %d | old-seq = %d | new-seq = %d\n",
                                    oldinfo.alive,newinfo.alive,oldinfo.seq,newinfo.seq);
                  }
                  update_sessionlist (fet_addr,KE_SESSION_STOP,r_list[router_nr].ip);
                  continue;
               }
            }
            else
            { /* oldinfo.alive == 2 oder 0 */
               if (d_alive != 0)
               {
                  if (debug)
                  {
                     fprintf (stderr, "verd{chtige kombination: ");
                     fprintf(stderr,"old-alive = %d | new-alive = %d | old-seq = %d | new-seq = %d\n",
                                    oldinfo.alive,newinfo.alive,oldinfo.seq,newinfo.seq);
                  }
               }
               if (newinfo.alive == 1)
               {
                  update_sessionlist (fet_addr,KE_SESSION_ALIVE,r_list[router_nr].ip);
               }
               continue;
            }
         }
         else
         {  /* neue, unbekannte session von bereits bekanntem router */
            if (newinfo.alive == 1)
            {
               update_sessionlist (fet_addr,KE_SESSION_START,r_list[router_nr].ip);
               continue;
            }

            if (debug)
            {
               fprintf(stderr,"Neue Session von bekanntem Router, aber nicht aktiv!!\n");
            }
            continue;
         }
      }
   }
   else
      break;
 }
 return (0);
}

/***************************************************************************/
int get_FetInfo (buffer,slotnr,FetBuf)
char    *buffer;
int      slotnr;
FetInfo *FetBuf;

{
 /*
 unsigned long  *RouterTime=(unsigned long *)buffer;
 unsigned short *IsdnSlotSize=(unsigned short *)&buffer[4];
 */
 unsigned short *IsdnSlots=(unsigned short *)&buffer[6];
 IsdnHostInfo   *IsdnHosts=(IsdnHostInfo *)&buffer[8];
 LocalHostInfo  *LocalHosts=(LocalHostInfo *)&buffer[8];
 FetInfo        *FetList;
 /*
 PrintInfo      *PrintInfoList;
 */
 unsigned short *LocalSlots, *LocalSlotSize, *NumFets;
 /*
 unsigned short *NumPrintInfos;
 */

 LocalSlotSize = (unsigned short *)&IsdnHosts[*IsdnSlots];
 LocalSlots    = (unsigned short *)&LocalSlotSize[1];
 LocalHosts    = (LocalHostInfo *)&LocalSlotSize[2];
 NumFets       = (unsigned short *)&LocalHosts[*LocalSlots];
 FetList       = (FetInfo *)&NumFets[1];

 if (slotnr >= *NumFets)
    return (0);

 memcpy (FetBuf,&FetList[slotnr],sizeof (FetInfo));
 return (1);
}


/**********************************************************************/
int get_services()
{
struct servent *service;

   if ((service = getservbyname("alive", "udp")) == NULL)
   {
      fprintf(stderr,"getservbyname(\"alive\",\"udp\"), errno=%d\n",errno);
      fflush(stderr);
      return (0);
   }
   else
      memcpy (&sessalive_service,service,sizeof (struct servent));

   if ((service = getservbyname("serveralive", "udp")) == NULL)
   {
      fprintf(stderr,"getservbyname(\"serveralive\",\"udp\"), errno=%d\n",errno);
      fflush(stderr);
      return (0);
   }
   else
      memcpy (&srvalive_service,service,sizeof (struct servent));

   if ((service = getservbyname("killer", "udp")) == NULL)
   {
      fprintf(stderr,"getservbyname(\"killer\",\"udp\"), errno=%d\n",errno);
      fflush(stderr);
      return (0);
   }
   else
      memcpy (&killer_service,service,sizeof (struct servent));
 return (1);
}

/**********************************************************************/
int get_sockets()
{
int rundfunk = 1;

   if ((alivesock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
   {
      printf("error in socket(), errno=%d\n",errno);
      return (0);
   }

   if ((srvalivesock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
   {
      printf("error in socket(), errno=%d\n",errno);
      return (0);
   }

   if (setsockopt (srvalivesock,SOL_SOCKET,SO_BROADCAST,(char *)&rundfunk,
                                                      sizeof (rundfunk)))
   {
      fprintf(stderr,"setsockopt(),%s\n",sys_errlist[errno]);
      return (0);
   }

   if ((killersock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
   {
      printf("error in socket(), errno=%d\n",errno);
      return (0);
   }

   if (setsockopt (killersock,SOL_SOCKET,SO_BROADCAST,(char *)&rundfunk,
                                                      sizeof (rundfunk)))
   {
      fprintf(stderr,"setsockopt(),%s\n",sys_errlist[errno]);
      return (0);
   }

 return (1);
}


/***************************************************************************/
int print_socktest (buffer)
char *buffer;

{
/*
 unsigned long  *RouterTime=(unsigned long *)buffer;
 unsigned short *IsdnSlotSize=(unsigned short *)&buffer[4];
 */
 unsigned short *IsdnSlots=(unsigned short *)&buffer[6];
 IsdnHostInfo   *IsdnHosts=(IsdnHostInfo *)&buffer[8];
 LocalHostInfo  *LocalHosts=(LocalHostInfo *)&buffer[8];
 FetInfo        *FetList;
 PrintInfo      *PrintInfoList;
 unsigned short *LocalSlots, *LocalSlotSize, *NumFets, *NumPrintInfos;
 int i;
/*
 printf ("%d ISDN hosts:\n", *IsdnSlots);
 printf ("Routername|Number         |Bytes In|BytesOut|PktIn|PktOut|Takt|ICharge|OCharge\n");
 for(i=0; i<*IsdnSlots; i++)
   printf ("%-10s|%-15s|%-8lu|%-8lu|%-5lu|%-6lu|%-4lu|%-7u|%-7lu\n",
           IsdnHosts[i].hostname, IsdnHosts[i].telno,
           IsdnHosts[i].outbytes, IsdnHosts[i].inbytes,
           IsdnHosts[i].outpkt, IsdnHosts[i].inpkt,
           IsdnHosts[i].chargeticks * 55 / 1000,
           IsdnHosts[i].incharge,
           IsdnHosts[i].outcharge
          );
  */
 LocalSlotSize = (unsigned short *)&IsdnHosts[*IsdnSlots];
 LocalSlots    = (unsigned short *)&LocalSlotSize[1];
 LocalHosts    = (LocalHostInfo *)&LocalSlotSize[2];
 /*
 printf("\n%d local host connections, size = %d\n", *LocalSlots, *LocalSlotSize);
 printf ("Routername|Local ip address|Bytes In|BytesOut|PktIn|PktOut\n");
 for(i=0; i<*LocalSlots; i++)
     printf("%-10s|%3d.%3d.%3d.%3d |%-8lu|%-8lu|%-5lu|%-6lu\n",
           IsdnHosts[LocalHosts[i].IsdnHostIndex].hostname,
           (unsigned short) LocalHosts[i].ip_adr[0],
           (unsigned short) LocalHosts[i].ip_adr[1],
           (unsigned short) LocalHosts[i].ip_adr[2],
           (unsigned short) LocalHosts[i].ip_adr[3],
	   *(unsigned long *) &(LocalHosts[i].pktbytes[12]),
	   *(unsigned long *) &(LocalHosts[i].pktbytes[8]),
	   *(unsigned long *) &(LocalHosts[i].pktbytes[4]),
	   *(unsigned long *) &(LocalHosts[i].pktbytes[0])
           );
   */
 NumFets = (unsigned short *)&LocalHosts[*LocalSlots];
 FetList = (FetInfo *)&NumFets[1];
 fprintf(stderr,"\n%d FETs in der alive list\n", *NumFets);
 for(i=0;i < *NumFets; i++)
 {
   fprintf(stderr,"%3d.%3d.%3d.%3d : alive=%d, seq=%d, socket=%04x\n",
          (unsigned short) FetList[i].ip_adr[0],
          (unsigned short) FetList[i].ip_adr[1],
          (unsigned short) FetList[i].ip_adr[2],
          (unsigned short) FetList[i].ip_adr[3],
          (unsigned short) FetList[i].alive,
          (unsigned short) FetList[i].seq,
                           htons(FetList[i].socket)
         );
 }
 NumPrintInfos = (unsigned short *)&FetList[*NumFets];
 PrintInfoList = (PrintInfo *) &NumPrintInfos[1];
 if (*NumPrintInfos > 0)
    fprintf(stderr,"\n%d PrintServer im Netz %d.%d.%d\n", *NumPrintInfos,
          (unsigned short) PrintInfoList[0].fetip[0],
          (unsigned short) PrintInfoList[0].fetip[1],
          (unsigned short) PrintInfoList[0].fetip[2]);
 else
   fprintf(stderr,"\n0 PrintServer im Netz \n");
 for(i=0;i < *NumPrintInfos; i++)
 {
   fprintf(stderr,"%3d.%3d.%3d.%3d : LPT1=%d LPT2=%d LPT3=%d COM1=%d COM2=%d COM3=%d COM4=%d\n",
          (unsigned short) PrintInfoList[i].fetip[0],
          (unsigned short) PrintInfoList[i].fetip[1],
          (unsigned short) PrintInfoList[i].fetip[2],
          (unsigned short) PrintInfoList[i].fetip[3],
          (unsigned char)PrintInfoList[i].printinfo[0],
          (unsigned char)PrintInfoList[i].printinfo[1],
          (unsigned char)PrintInfoList[i].printinfo[2],
          (unsigned char)PrintInfoList[i].printinfo[3],
          (unsigned char)PrintInfoList[i].printinfo[4],
          (unsigned char)PrintInfoList[i].printinfo[5],
          (unsigned char)PrintInfoList[i].printinfo[6]
         );
 }
 return (0);
}


/***************************************************************************/
int process_remote_session (remote,unix_ip,kennung)
struct sockaddr_in remote;
unsigned long unix_ip;
short kennung;

{
int sessnr=0,rnr=0;
unsigned long router_ip=get_router(unix_ip);
char router[100];
char unixname[100];
static int first_time=1;

 if (first_time)
 {
    first_time=0;
    init_isdn();
 }

 if (router_ip == 0)
 {
    fprintf (stderr,"alived: Konnte IP von ISDN-Zielrouter f}r %s nicht bestimmen!\n",inet_ntoa(unix_ip));
    router_ip = unix_ip;
 }

 if (xxdebug)
 {
    strcpy (unixname,(char *)inet_ntoa(unix_ip));
    strcpy (router,(char *)inet_ntoa(router_ip));
    fprintf (stderr,"alived: Ziel-UNIX-Rechner: %s   Router: %s\n",
             unixname,router);
 }
 /* zundchst mal suchen ob die session schon da ist oder war */
 for (sessnr = 0;sessnr < MAX_SESSIONS;sessnr ++)
 {
    if ((rem_sesslist[sessnr].fet_ip   == remote.sin_addr.s_addr) &&
        (rem_sesslist[sessnr].fet_port == remote.sin_port))
    {  /* session gefunden */
       switch (kennung)
       {
          case KE_SESSION_START:
             /* hier kommt er nur hin, wenn das fet ausgeschaltet wurde */
             rem_sesslist[sessnr].seq++;
             rem_sesslist[sessnr].alive = 1;
             rem_sesslist[sessnr].time = time(0);
             break;
          case KE_SESSION_ALIVE:
             rem_sesslist[sessnr].time = time(0);
             break;
          case KE_SESSION_STOP:
             if (rem_sesslist[sessnr].seq > 0)
                rem_sesslist[sessnr].seq--;
             rem_sesslist[sessnr].alive = 0;
             /* normal gestorbene fliegen aus der liste */
             /*
             if ((rem_sesslist[sessnr].alive == 0) &&(rem_sesslist[sessnr].seq == 0))
             {
                rem_sesslist[sessnr].fet_ip  = 0;
                rem_sesslist[sessnr].unix_ip = 0;
             }
             */
             break;
          default:
             break;
       }
       if ((kennung == KE_SESSION_START) || (kennung == KE_SESSION_STOP))
       {  /* zielrouter mu_ ein paket bekommen! */
          for (rnr=0;(rnr<MAX_ROUTER) && (ziel_router[rnr].ip != 0);rnr++)
          {
             if (ziel_router[rnr].ip == router_ip)
             {  /* gefunden */
                ziel_router[rnr].sendit = 1;
                break;
             }
          }
          if (rnr == MAX_ROUTER)
          {
             fprintf (stderr, "alived: Zielrouter nicht gefunden, obwohl Session bereits da");
          }
       }
       break;
    }
 }

 if (sessnr == MAX_SESSIONS)
 {  /* session nicht gefunden */
    /* neueintrag,wenn kennung = start oder alive, sonst ignorieren */
    if ((kennung == KE_SESSION_START) || (kennung == KE_SESSION_ALIVE))
    {
       for (sessnr = 0;sessnr <MAX_SESSIONS;sessnr ++)
       {  /* den ndchsten leeren platz suchen */
          if (rem_sesslist[sessnr].fet_ip == 0L)
          { /*gefunden */
             rem_sesslist[sessnr].fet_ip   = remote.sin_addr.s_addr;
             rem_sesslist[sessnr].fet_port = remote.sin_port;
             rem_sesslist[sessnr].unix_ip  = unix_ip;
             rem_sesslist[sessnr].router_ip= router_ip;
             rem_sesslist[sessnr].time     = time(0);
             rem_sesslist[sessnr].alive    = 1;
             if (kennung == KE_SESSION_START)
                rem_sesslist[sessnr].seq   = 1;
             else
                rem_sesslist[sessnr].seq   = 0;

             /* Ziel_router suchen oder anlegen */
             for (rnr=0;rnr<MAX_ROUTER;rnr++)
             {
                if (ziel_router[rnr].ip == unix_ip)
                {  /* gefunden */
                   ziel_router[rnr].sendit = 1;
                   break;
                }
             }
             if (rnr == MAX_ROUTER)
             {
                for (rnr = 0;rnr <MAX_ROUTER;rnr++)
                {    /* nachsten leeren suchen */
                   if (ziel_router[rnr].ip == 0L)
                   {
                      ziel_router[rnr].ip     = unix_ip;
                      ziel_router[rnr].sendit = 1;
                      ziel_router[rnr].sendcount = 0;
                      ziel_router[rnr].activ_sessions = 0;
#ifndef R_UNIXWARE
		      get_ip_telno(rnr); /* fr den is-online test telno holen */
#endif
                      prepare_d_alive(rnr);
                      update_partnerlist(ziel_router[rnr].hostname,1);
                      break;
                   }
                }
                if (rnr == MAX_ROUTER)
                {
                   fprintf (stderr,"alived: Remoterouter-List full!\n");
                }
             }
             break;
          }
       }
       if (sessnr == MAX_SESSIONS)
       {
          fprintf (stderr,"alived: Remotesession-List full!\n");
       }
    }
 }
 if (xxdebug)
 {
    fprintf (stderr,"alived: vor send_rem_sess_info\n");
 }

 send_rem_sessinfo(rnr); /* sende wenn es was neues gibt */
 if (xxdebug)
 {
    fprintf (stderr,"alived: nach send_rem_sess_info\n");
 }
 return(1);
}

int send_rem_sessinfo(router_nr)
int router_nr;

{
 int sessnr,addrlen,sent;
 unsigned long datalen;
 struct sockaddr_in rem_unix;
 char data[10000];
 unsigned short *kennung    = (unsigned short *)data;
 unsigned short *dummy      = (unsigned short *)&kennung[1];
 char           *waehrung   = (char           *)&dummy[1];
 unsigned short *isdn_hosts = (unsigned short *)&waehrung[2];
 IsdnHostInfo   *my_info    = (IsdnHostInfo   *)&isdn_hosts[1]; /* 76 bytes lang */
 unsigned short *ppu        = (unsigned short *)&my_info[1];
 unsigned short *local_slots= (unsigned short *)&ppu[1];
 unsigned short *sess_cnt   = (unsigned short *)&local_slots[1];
 FetInfo        *rem_sess   = (FetInfo        *)&sess_cnt[1];
 unsigned short *server_cnt,*srvcount=(unsigned short *)serverinfo;
 PrintInfo      *rem_server;

 if (ziel_router[router_nr].sendit == 0)
    return(0);  /* nichts neues da */

 ziel_router[router_nr].sendit = 0;
 ziel_router[router_nr].time = time(0);

 *kennung = KE_CHARGE_MESS; /* stammt aus der zeit dos-router-geb}hreninfo */
 strcpy (waehrung,"DM");
 *isdn_hosts = 1; /* nur ich selbst */
 memcpy (my_info,&My_info,sizeof(My_info));

 *local_slots = 0;
 *sess_cnt = 0;

 for (sessnr=0;sessnr<MAX_SESSIONS;sessnr++)
 {      /* nur relevate sitzungen sammeln und senden */
    if (rem_sesslist[sessnr].router_ip == ziel_router[router_nr].ip)
    {
       memcpy ((void*) (rem_sess[*sess_cnt].ip_adr),
               (void*)&(rem_sesslist[sessnr].fet_ip),
               4);
       rem_sess[*sess_cnt].timeout = 0; /* unsigned short */
       rem_sess[*sess_cnt].alive   = rem_sesslist[sessnr].alive;
       rem_sess[*sess_cnt].seq     = rem_sesslist[sessnr].seq;
       rem_sess[*sess_cnt].socket  = rem_sesslist[sessnr].fet_port;
       (*sess_cnt)++;
    }
 }
 if (*sess_cnt == 0)
 {
    if (xdebug)
       fprintf (stderr,"alived: sendewunsch vorhanden, aber keine session!\n");
 }
 server_cnt = (unsigned short*)rem_sess[*sess_cnt].ip_adr;
 rem_server = (PrintInfo*) &server_cnt[1];

 *server_cnt = *srvcount;
 if (*server_cnt > 0)
    memcpy (rem_server,&serverinfo[2],*server_cnt * sizeof(PrintInfo));

 datalen = (unsigned long) &rem_server[*server_cnt] - (unsigned long)data;

 if (datalen >BUFSIZE)
 {
    fprintf (stderr,"alived: ISDN-Info-Paket w}rde gr|~er als %d Byte!\n",BUFSIZE);
    fprintf (stderr,"alived: Abbruch\n");
    fclose (stderr);
    exit (1);
 }

 ziel_router[router_nr].activ_sessions = 0;
 for (sessnr=0;sessnr<*sess_cnt;sessnr++)
 {
    if (rem_sess[sessnr].alive == 1)
       ziel_router[router_nr].activ_sessions ++;
 }

 if ((ziel_router[router_nr].old_datalen == datalen) &&
     (memcmp(data,ziel_router[router_nr].old_data,datalen) == 0) &&
     !is_online(router_nr) &&
     !ziel_router[router_nr].sendcount)
 {
    send_d_alive(router_nr);
 }
 else
 {
    memset(&rem_unix, 0,sizeof(rem_unix));
    rem_unix.sin_family = AF_INET;
    rem_unix.sin_addr.s_addr = ziel_router[router_nr].ip;
    rem_unix.sin_port = sessalive_service.s_port;

    addrlen = sizeof(rem_unix);
    sent = my_sendto (alivesock, data, datalen, 0 ,(struct sockaddr *)&rem_unix, addrlen);
    if (sent != datalen)
    {
       fprintf (stderr,"alived: my_sendto() on alivesock %d (%s)",errno,sys_errlist[errno]);
    }

    memcpy (ziel_router[router_nr].old_data,data,datalen);
    ziel_router[router_nr].old_datalen = datalen;
    ziel_router[router_nr].sendcount++;  /* sooft-1 wurde ohne ack gesendet */

    if (xdebug)
    {
       t=time(0);
       strcpy(tt,ctime(&t));
       tt[19]=0;
       fprintf (stderr,"%s | ISDN-Sessioninfo an %s verschickt\n",&tt[4],inet_ntoa(ziel_router[router_nr].ip));
       print_socktest(data);
    }

    if (ziel_router[router_nr].sendcount > MAX_XMIT)
    {
       if (xdebug)
          fprintf (stderr,"KEINE Antwort vom ISDN-Router %s !\n",inet_ntoa(rem_unix.sin_addr.s_addr));
       process_ack(rem_unix);
       return(0);
    }
 }

 return (1);
}

/**************************************************************************/
int send_isdn_alive()
{
 int router_nr;
 time_t now=time(0);

 for (router_nr = 0;router_nr < MAX_ROUTER;router_nr++)
 {
    if (ziel_router[router_nr].ip != 0)
    {
       if (ziel_router[router_nr].time)
       {
         if (ziel_router[router_nr].sendcount)
         {              /* jetzt wird wegen fehlendem ACK gesendet */
            if ((now - ziel_router[router_nr].time) > REXMIT_TIMEOUT)
               ziel_router[router_nr].sendit = 1;
         }
         else
         {             /* normales ALIVE */
            if  ((now - ziel_router[router_nr].time) > ISDN_ALIVE_TIMEOUT)
               ziel_router[router_nr].sendit = 1;
         }
       }
       if (ziel_router[router_nr].sendit)
       {
          send_rem_sessinfo(router_nr);
       }
    }
 }
 return(0);
}

/*********************************************************************/
int check_isdn_sessions()
{
 int    sessnr,router_nr;
 time_t now=time(0);
 static unsigned long lasttime=0;
 long difft;

 if (lasttime == 0)
    lasttime = now;

 difft = now - lasttime;
 if ((difft > 5) || (difft < 0))
 {
    for (sessnr=0;sessnr<MAX_SESSIONS;sessnr++)
    {
       if (rem_sesslist[sessnr].fet_ip)
          rem_sesslist[sessnr].time = now;
    }
 }
 lasttime = now;

 for (sessnr=0;sessnr<MAX_SESSIONS;sessnr++)
 {
    if (rem_sesslist[sessnr].fet_ip)
    {
       if (rem_sesslist[sessnr].alive == 1)
       {
          if((now - rem_sesslist[sessnr].time) > ISDN_SESSION_TIMEOUT)
          {  /* jetzt fliegt er raus */
             rem_sesslist[sessnr].time = now;
             rem_sesslist[sessnr].alive = 2;
             /* jetzt nocht den zielrouter suchen */
             for (router_nr=0;router_nr<MAX_ROUTER;router_nr++)
             {
                if (rem_sesslist[sessnr].router_ip == ziel_router[router_nr].ip)
                {
                   ziel_router[router_nr].sendit = 1;
                   break;
                }
             }
             if (router_nr == MAX_ROUTER)
             { /* den richtigen router nicht gefunden */
                fprintf (stderr,"alived: Zielrouter f}r eine gestorbene Session nicht gefunden\n");
             }
          }
       }
    }
 }
 return (0);
}


/*************************************************************************/
int process_serverinfo(buffer)
char *buffer;
{
unsigned short *NumInfos = (unsigned short *)&buffer[2];
int datalen,rnr;

 datalen = sizeof(*NumInfos) + (*NumInfos * sizeof(PrintInfo));
 memcpy (serverinfo,NumInfos,datalen);
 for (rnr=0;rnr<MAX_ROUTER;rnr++)
 {
    if (ziel_router[rnr].ip && ziel_router[rnr].time)
       ziel_router[rnr].sendit = 1; /* nur dann schicken wenn eine session aktiv ist */
 }
 return(1);
}

/*************************************************************************/
int check_routerlist()
{
 int r;
 time_t now=time(0);
 static unsigned long lasttime=0;
 long difft;

 /* der folgende code dient zur ]berwachung der Uhrzeitverstellung */
 if (lasttime == 0)
    lasttime = now;

 difft = now - lasttime;
 if ((difft > 5) || (difft < 0))
 {  /* jetzt wurde die Systemzeit verstellt */
    for (r=0;r<MAX_ROUTER;r++)
    {
       if (r_list[r].ip)
          r_list[r].lasttime = now;
    }
 }
 lasttime = now;

 /* im folgenden werden tote Router rausgeschmissen */
 for (r=0;r<MAX_ROUTER;r++)
 {
    if (r_list[r].ip)
    {
       if ((now - r_list[r].lasttime) > ROUTER_IDLE_TIMEOUT)
       {
          if (xdebug)
             fprintf (stderr,"Router %s hat sich %ld s nicht gemeldet, raus!!\n",
                      inet_ntoa(r_list[r].ip),ROUTER_IDLE_TIMEOUT);
          update_partnerlist(r_list[r].hostname,0);
          memset (&r_list[r],0,sizeof(r_list[r]));
          continue;
       }
       /* ]berpr}fung, ob ein Router }berhaupt noch aktive Sessions hat */
       /* wenn nicht, dann raus mit ihm */
       if (r_list[r].no_sessions)
       {
          if (xdebug)
             fprintf (stderr,"Router %s hat sich keine aktive Session mehr, raus!!\n",
                      inet_ntoa(r_list[r].ip));
          update_partnerlist(r_list[r].hostname,0);
          memset (&r_list[r],0,sizeof(r_list[r]));
       }
    }
 }

 return(0);
}

/*************************************************************************/
int process_ack(remote)
struct sockaddr_in remote;
{
 int r,sessnr;

 for (r=0;r<MAX_ROUTER;r++)
 {
    if (ziel_router[r].ip == remote.sin_addr.s_addr)
    {
       break;
    }
 }
 if (r == MAX_ROUTER)
 {
    if (debug)
    {
       fprintf (stderr,"Konnte ack von ISDN-Router nicht zuordnen!\n");
       return(1);
    }
 }

 ziel_router[r].sendcount = 0; /* ok, vielen dank f}rs ack */

 if (xdebug)
 {
    fprintf (stderr,"ACK von ISDN-Router %s erhalten!\n",
             inet_ntoa(remote.sin_addr.s_addr));
 }

 /* nun noch nach 0-0 -Sessions f}r diesen Router suchen und raus damit */
 for (sessnr=0;sessnr<MAX_SESSIONS;sessnr++)
 {      /* nur relevante sitzungen sammeln */
    if ((rem_sesslist[sessnr].router_ip == ziel_router[r].ip) &&
        (rem_sesslist[sessnr].alive == 0) &&
        (rem_sesslist[sessnr].seq == 0))
    {
      if (xdebug)
         fprintf(stderr,"Remote-Session %s %x fliegt wegen al=0 seq=0 raus!\n",
                 inet_ntoa(rem_sesslist[sessnr].fet_ip),rem_sesslist[sessnr].fet_port);
       memset (&rem_sesslist[sessnr],0,sizeof (rem_sessionlist_typ));
    }
 }

 if (ziel_router[r].activ_sessions == 0)
 { /* jetzt kann der zielrouter mit all seinen alten sessions raus */
    for (sessnr=0;sessnr<MAX_SESSIONS;sessnr++)
    {      /* nur relevante sitzungen sammeln */
       if (rem_sesslist[sessnr].router_ip == ziel_router[r].ip)
       {
         if (xdebug)
            fprintf(stderr,"Remote-Session %s %x fliegt raus!\n",
                    inet_ntoa(rem_sesslist[sessnr].fet_ip),rem_sesslist[sessnr].fet_port);
          memset (&rem_sesslist[sessnr],0,sizeof (rem_sessionlist_typ));
       }
    }
    if (xdebug)
       fprintf(stderr,"Ziel-Router %s fliegt aus der Liste!\n",
               inet_ntoa(ziel_router[r].ip));
    end_d_alive(ziel_router[r].fd);
/*
    t_unbind(ziel_router[r].fd);
    t_close(ziel_router[r].fd);
*/
    update_partnerlist(ziel_router[r].hostname,0);
    memset (&ziel_router[r],0,sizeof(ziel_router_typ));
 }
 return(1);
}

/******************************************************************************************/
unsigned long get_nwaddr(buf)
char *buf;
{
 int i;
 unsigned long addr=0,part;
 char *p,*pp,dummy;

 pp=buf;
 for (i=0;i<4;i++)
 {
    if ((p = strchr (pp,'.')) == 0)
    {
       if (!isdigit(*pp))
          break;
       else
       {
          if ((p=strchr (pp,' ')) == 0)
             p=&dummy;
       }
    }
    *p = 0;
    if ((part = atol (pp)) == 0)
       break;
    else
       addr += part<<(i*8);
    pp = p+1;
 }

 return(addr);
}


/*************************************************************************/
int process_getname (buffer,remote)
char   *buffer;
struct sockaddr_in remote;
{
 char answer[200],absender[100],terminal[100];
 int  r_no,sess_no,sendlen=4,sent;
 short rw=254,kennung=KE_FET_GIVENAME;
 unsigned long *rec_ip=(unsigned long *)&buffer[2];

 memset (answer,0,200);
 memcpy (answer,&kennung,2);

 if (xdebug)
 {
    strcpy (absender,(char *)inet_ntoa(remote.sin_addr.s_addr));
    strcpy (terminal,(char *)inet_ntoa((u_long)*rec_ip));

    fprintf (stderr,"GETNAME-Anfrage von %s fr Terminal %s erhalten!\n",
                    absender,terminal);
 }

 for (sess_no=0;sess_no<MAX_SESSIONS;sess_no++)
 {
     if (*rec_ip == sessionlist[sess_no].ip)
        break;
 }

 if (sess_no < MAX_SESSIONS)
 {
    if (sessionlist[sess_no].isdn)
    {
       for (r_no=0;r_no<MAX_ROUTER;r_no++)
       {
          if (sessionlist[sess_no].isdn == r_list[r_no].ip)
          {
             strcpy (&answer[4],r_list[r_no].hostname);
             sendlen += strlen(r_list[r_no].hostname) + 1;
             rw = 1;
             break;
          }
       }
       if (r_no == MAX_ROUTER)
       {
	  rw = 254;
       }
    }
    else
    {
       rw = 0;
    }
 }
 else
 {
    rw = 255;
 }

 memcpy (&answer[2],&rw,2);
 sent = my_sendto (alivesock, answer, sendlen, 0 ,(struct sockaddr *)&remote, sizeof(remote));
 if (sent < 0)
 {
    fprintf(stderr,"alived: error in my_sendto() on alivesock,%s\n",sys_errlist[errno]);
    return(0);
 }

 return (1);
}

/*************************************************************************/
int check_router_for_session (r_no)
int r_no;
{
/*
 unsigned long  *RouterTime=(unsigned long *)r_list[r_no].lastpack;
 unsigned short *IsdnSlotSize=(unsigned short *)&r_list[r_no].lastpack[4];
 */
 unsigned short *IsdnSlots=(unsigned short *)&r_list[r_no].lastpack[6];
 IsdnHostInfo   *IsdnHosts=(IsdnHostInfo *)&r_list[r_no].lastpack[8];
 LocalHostInfo  *LocalHosts=(LocalHostInfo *)&r_list[r_no].lastpack[8];
 FetInfo        *FetList;
 /*
 PrintInfo      *PrintInfoList;
 */
 unsigned short *LocalSlots, *LocalSlotSize, *NumFets, fetnr;
 /*
 unsigned short *NumPrintInfos,fetnr;
 */

 LocalSlotSize = (unsigned short *)&IsdnHosts[*IsdnSlots];
 LocalSlots    = (unsigned short *)&LocalSlotSize[1];
 LocalHosts    = (LocalHostInfo *)&LocalSlotSize[2];
 NumFets       = (unsigned short *)&LocalHosts[*LocalSlots];
 FetList       = (FetInfo *)&NumFets[1];

 r_list[r_no].no_sessions = 1;
 for (fetnr=0;fetnr<*NumFets;fetnr++)
 {
    if (FetList[fetnr].alive == 1)
    {
       r_list[r_no].no_sessions = 0;
       return (1);
    }
 }
 return (1);
}

/*************************************************************************/
int update_partnerlist(partner, neu)
char *partner;
int   neu;
{
 static partner_typ part[MAX_ROUTER];
 int p;

 for (p=0;p<MAX_ROUTER;p++)
 {
    if (!strcmp (partner,part[p].name))
    {
       if (neu)
          part[p].cnt++;
       else
       {
          part[p].cnt--;
          if (part[p].cnt == 0)
          {
             isdn_lms_stop(partner); 
             strcpy (part[p].name,"");
          }
       }
       break;
    }
 }

 if (!neu) /* da kann ich nichts machen */
    return (0);

 if (p==MAX_ROUTER)
 {
    for (p=0;p<MAX_ROUTER;p++)
    {
       if (part[p].name[0] == 0)
       {
          isdn_lms_start(partner);
          strcpy (part[p].name,partner);
          part[p].cnt = 1;
          break;
       }
    }
    if (p==MAX_ROUTER)
       fprintf (stderr,"ISDN-Partner-Liste (%d) ist voll!",MAX_ROUTER);
 }
 return (0);
}

/*************************************************************************/
int charge_reply(remote)
struct sockaddr_in remote;
{
 short answer=KE_NO_CHARGE_MESS;
 int   sent;

 sent = my_sendto (alivesock, (char *)&answer, 2, 0 ,(struct sockaddr *)&remote, sizeof(remote));
 if (sent < 0)
 {
    fprintf(stderr,"alived: error in my_sendto() on alivesock,%s\n",sys_errlist[errno]);
    return(0);
 }

 return (1);
}

