#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netdb.h>
#include <netinet/in.h>
#include <fcntl.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#ifdef R_UNIXWARE
#include <isdn/l_lib.h>
#endif
#include <pds/pdsisdn.h>
#include <pds/fetsrv.h>
#include "alived.h"

int prepare_d_alive(int rnr);
int send_d_alive(int rnr);
int end_d_alive(int fd);
int get_d_al_telno(unsigned long ip,struct t_call **callp);
int init_d_alive_rec(int *fd,struct t_call **callp);
int fill_my_info(void);
int process_d_alive(int fd,struct t_call *callp,char *buffer);
int init_isdn(void);
int is_online               TB_PROTO(( int ));
char *hostbytelno(char *telno);
char *isi_bindir;
char *get_escape(char **escape);
unsigned long get_router(unsigned long unix_ip);
int get_host_by_ip(unsigned long ip,char *hostname);

extern int    	      debug,xdebug,xxdebug;
extern time_t         t;
extern int            sessmaxcnt;
extern int            fdcnt,d_al_fd;
extern char           tt[100];
extern struct servent srvalive_service;
extern struct servent sessalive_service;
extern struct servent killer_service;
extern int            alivesock;
extern int            srvalivesock;
extern int            killersock;
extern char           serverinfo[BUFSIZE];
extern struct pollfd  fds[2];
extern d_al_hd_typ    d_al_callp;

extern fetsrvstat_typ       r_list[MAX_ROUTER];
extern sessionlist_typ      sessionlist[MAX_SESSIONS];
extern rem_sessionlist_typ  rem_sesslist[MAX_SESSIONS];
extern ziel_router_typ      ziel_router[MAX_ROUTER];
extern IsdnHostInfo         My_info;
/*--------------------------------------------------------------------*/

extern char    *inet_ntoa   TB_PROTO(( unsigned long ));
extern u_long  inet_addr    TB_PROTO(( char * ));

extern int get_sockets             TB_PROTO(( void ));
extern int get_services            TB_PROTO(( void ));
extern int get_FetInfo             TB_PROTO(( char *, int, FetInfo * ));
extern int check_sessionlist       TB_PROTO(( void ));
extern int update_sessionlist      TB_PROTO(( struct sockaddr_in, unsigned short, unsigned long ));
extern int update_isdn_fetlist     TB_PROTO(( char *, int, int ));
extern int process_remote_session  TB_PROTO(( struct sockaddr_in, unsigned long, short ));
extern int send_rem_sessinfo       TB_PROTO(( int ));
extern int send_killinfo           TB_PROTO(( struct sockaddr_in ));
extern int process_isdn_data       TB_PROTO(( struct sockaddr_in, char *, int ));
extern int process_serverinfo      TB_PROTO(( char * ));
extern int process_getname         TB_PROTO(( char *, struct sockaddr_in ));
extern int check_isdn_sessions     TB_PROTO(( void ));
extern int init_from_fetstatd      TB_PROTO(( void ));
extern int process_ack             TB_PROTO(( struct sockaddr_in ));
extern int check_routerlist        TB_PROTO(( void ));
extern int check_router_for_session TB_PROTO(( int ));
extern int charge_reply            TB_PROTO(( struct sockaddr_in ));
extern int update_partnerlist      TB_PROTO(( char *, int ));
extern int print_socktest          TB_PROTO(( char * ));
extern unsigned long get_nwaddr    TB_PROTO(( char * ));



/*************************************************************/
int prepare_d_alive(int rnr)
{
 struct t_call *callp;
 struct t_bind *bindp;
 char          *isdndev;

 isdndev = isi_default("BASE_isdndev",NULL);
 if (!isdndev)
 {
    fprintf (stderr,"alived: kann isdndev nicht bestimmen!\n");
    return(0);
 }

 if (xxdebug)
 {
    fprintf (stderr,"alived: vor t_open\n");
 }
 ziel_router[rnr].fd = t_open(isdndev,O_NONBLOCK|O_RDWR,NULL);
 if (ziel_router[rnr].fd < 0)
 {
    t_error("alived: t_open failed");
    return(0);
 }

 if (xxdebug)
 {
    fprintf (stderr,"alived: nach t_open\n");
 }
 bindp=(struct t_bind*)isi_bindaddr("alive",0);
 if (xxdebug)
 {
    fprintf (stderr,"alived: nach isi_bindaddr\n");
 }

 if (t_bind(ziel_router[rnr].fd,bindp,NULL) < 0)
 {
    t_error("alived: t_bind failed");
    t_close(ziel_router[rnr].fd);
    return(0);
 }

 if (xxdebug)
 {
    fprintf (stderr,"alived: nach t_bind\n");
 }
 if (!get_host_by_ip(ziel_router[rnr].ip,ziel_router[rnr].hostname))
 {
    fprintf (stderr,"alived: konnte Hostname von Ziel-ISDN-Router %s nicht bestimmen!\n",inet_ntoa(ziel_router[rnr].ip));
    t_unbind(ziel_router[rnr].fd);
    t_close(ziel_router[rnr].fd);
    return(0);
 }

 if (xxdebug)
 {
    fprintf (stderr,"alived: nach get_host_by_ip\n");
 }
 /* jetzt mu_ m}hselig die d_alive-nummer des zielrouters gesucht werden */
 if (!get_d_al_telno(ziel_router[rnr].ip,&callp))
 {
    fprintf (stderr,"alived: prepare_d_alive(): konnte D-Alive-Telno aus IP nicht bestimmen!\n");
    t_close(ziel_router[rnr].fd);
    ziel_router[rnr].fd = 0;
    return(0);
 }

 ziel_router[rnr].d_al_hand = callp;

 return(1);
}

/*************************************************************/
int send_d_alive(int rnr)
{
 if (ziel_router[rnr].fd == 0)
 {
    fprintf (stderr,"alived: Konnte ISDN-D-Kanal-Alive an %s nicht verschicken!!!\n",inet_ntoa(ziel_router[rnr].ip));
    return(0);
 }

 t_rcvdis(ziel_router[rnr].fd,NULL);
 t_connect(ziel_router[rnr].fd,ziel_router[rnr].d_al_hand,NULL);
 if (xdebug)
 {
    t=time(0);
    strcpy(tt,ctime(&t));
    tt[19]=0;
    fprintf (stderr,"%s | ISDN-D-Kanal-Alive an %s verschickt\n",&tt[4],ziel_router[rnr].d_al_hand->addr.buf);
 }
 return(0);
}

/*************************************************************************/
int get_d_al_telno(unsigned long ip,struct t_call **callp)
{
 int hosts,hnr;
 IsdnHost *hostdaten[1000];
 char	  d_hostname[100];

 memset (hostdaten,0,1000*sizeof(IsdnHost*));
 if ((hosts = isdn_hosts_lesen(0, hostdaten, 1000, 1))<= 0)
 {
    fprintf (stderr,"alived: isdn_host_lesen(), keine Hosts gelesen!\n");
    return(0);
 }

 for (hnr=0;hnr<hosts;hnr++)
 {
    if (inet_addr(hostdaten[hnr]->ipadr) == ip)
       break;
 }

 if (hnr==hosts)
 {
    for (hnr=0;hnr<hosts;hnr++)
       free (hostdaten[hnr]);
    return (0);
 }

 strcpy (d_hostname,hostdaten[hnr]->hostname);
 strcat (d_hostname,"_al"); /* JH 01.07.96 ab jetzt immer anh{ngen */

 *callp = isi_getaddr(d_hostname,"alive");
 if (*callp == NULL)
 {
    fprintf(stderr,"alived: D-Alive-Hostname %s nicht gefunden!\n",d_hostname);
    fprintf(stderr,"alived: D-Alive zu ISDN-Router nicht m|glich!\n");
    for (hnr=0;hnr<hosts;hnr++)
       free(hostdaten[hnr]);
    return(0);
 }

 for (hnr=0;hnr<hosts;hnr++)
    free(hostdaten[hnr]);
 return (1);
}


/*************************************************************/
int fill_my_info(void)
{
/* IsdnHost my_data; */
 struct t_call *callp;
 unsigned int    nrnr;
 char   *p1;
 char   hostname[40];

 strcpy (My_info.hostname,Isdnkonf.allg.myhost); /* = ?? */

 /* zuerst eigene ip-nummer ermitteln */
 /* services btx hat keine eaz */
 sprintf (hostname,"%s_eaz2",My_info.hostname);
 nrnr=0;
 if ((callp = isi_getaddr1(hostname,"btx",&nrnr)) == NULL)
 { /* wenn nicht gefunden, dann bin ich nicht euro */
    if ((callp = isi_getaddr1(My_info.hostname,"tcp/ip",&nrnr)) == NULL)
    {
       fprintf (stderr,"alived: fill_my_info():_kann meine eigene Telno nicht bestimmen!\n");
       return(0);
    }
 }
 strncpy (My_info.telno,&(callp->addr.buf[6]),15); /* ?? */
 p1=strchr(My_info.telno,':');
 if (p1)  /* : wegschmei_en */
   *p1=0;
 t_free((char *)callp,0);

 /* dann d-alive-nummer ermitteln */
 /* services btx hat keine eaz */
 sprintf (hostname,"%s_eaz3",My_info.hostname);
 nrnr=1;
 if ((callp = isi_getaddr1(hostname,"btx",&nrnr)) == NULL)
 { /* wenn nicht gefunden, dann bin ich nicht euro */
    if ((callp = isi_getaddr1(My_info.hostname,"alive",&nrnr)) == NULL)
    {
       fprintf (stderr,"alived: fill_my_info():_kann meine eigene Telno nicht bestimmen!\n");
       return(0);
    }
 }
 strncpy (My_info.d_alive_telno,&(callp->addr.buf[6]),15); /* ?? */
 p1=strchr(My_info.d_alive_telno,':');
 if (p1)  /* : wegschmei_en */
   *p1=0;
 t_free((char *)callp,0);

 if (debug)
 {
    fprintf(stderr,"My_info.hostname      = %s\n",My_info.hostname);
    fprintf(stderr,"My_info.telno         = %s\n",My_info.telno);
    fprintf(stderr,"My_info.d_alive_telno = %s\n",My_info.d_alive_telno);
 }
 return(1);
}

/*************************************************************/
int init_d_alive_rec(int *fd,struct t_call **callp)
{
 struct t_bind *bindp;

 *fd = t_open("/dev/isdn",O_RDWR|O_NDELAY,NULL);
 if (*fd < 0)
 {
    t_error("alived: t_open failed");
    return(0);
 }

 bindp=(struct t_bind*)isi_bindaddr("alive",1);

 if (t_bind(*fd,bindp,NULL) < 0)
 {
    t_error("alived: t_bind failed");
    t_close(*fd);
    return(0);
 }

 if ((*callp = (struct t_call*)t_alloc(*fd,T_CALL,T_ALL)) == 0)
 {
    t_error("alived: t_alloc failed");
    t_close(*fd);
    return(0);
 }

 return (1);
}


/*************************************************************/
int process_d_alive(int fd,struct t_call *callp,char *buffer)
{
 unsigned short     kennung = KE_D_CHAN_ALIVE;
 int flags;
 int event = t_look(fd);
 switch(event)
 {
    case T_LISTEN:
       if (t_listen(fd,callp) < 0)
       {
          t_error("alived: t_listen failed");
          t_close(fd);
          return(0);
       }
/* Wenn t_accept ausgef}hrt wird, kommt es m|glicherweise zu Geb}hren */
/*
       if (t_accept (fd,fd,callp) < 0)
       {
          t_error("alived: t_accept failed");
          t_close(fd);
          return(0);
       }
*/
       if (t_snddis(fd,callp) < 0)
       {
          t_error("alived: t_snddis failed");
          t_close(fd);
          return(0);
       }

       memset (buffer, 0, BUFSIZE);
       memcpy (buffer, &kennung, 2);
       memcpy (&buffer[52],callp->addr.buf,strlen(callp->addr.buf)+1);
       return (1);

    case T_CONNECT:
       fprintf (stderr,"T_CONNECT am D-Alive-Eingang erhalten!\n");
       t_rcvconnect (fd,callp);
       t_snddis(fd,callp);
       return(0);

    case T_DISCONNECT:
       fprintf (stderr,"T_DISCONNECT am D-Alive-Eingang erhalten!\n");
       t_rcvdis(fd,NULL);
       return(0);

    case T_DATA:
       fprintf (stderr,"T_DATA am D-Alive-Eingang erhalten!\n");
       t_rcv(fd,buffer,BUFSIZE,&flags);
       return(0);

    case T_ERROR:
       fprintf (stderr,"T_ERROR am D-Alive-Eingang erhalten!\n");
       t_close(fd);
       return(0);

   default:
       fprintf(stderr,"Unerwartetes Event auf dem D-Alive-Eingang: event = %d\n",event);
 }
 return (1);
}


/*************************************************************/
int init_isdn(void)
{
static int first_time=1;

 if (first_time)
 {
    first_time = 0;
    if (debug)
       fprintf (stderr,"Initialisierung der ISDN-Bereiche\n");

    isdn_konf_lesen();
    fill_my_info();
    isi_default("BASE_bindir",&isi_bindir);

    if (init_d_alive_rec(&d_al_fd,&d_al_callp))
    {
       fds[1].fd     = d_al_fd;
       fds[1].events = POLLIN;
       fdcnt = 2;
    }
    else
    {
       fprintf(stderr,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
       fprintf(stderr,"Konnte D-Alive-Empfang nicht einrichten!\n");
       fprintf(stderr,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
    }
 }
 return (1);
}


/*************************************************************/
int is_online(int rnr)
{
 char cmdbuf[300];
 int rw;

 if (xxdebug)
 {
    fprintf (stderr,"alived: vor is_online\n");
 }

 if (ziel_router[rnr].hostname[0] == 0)
 {
    fprintf (stderr,"Hostname von Zielrouter %s ist nicht bekannt!\n",
             inet_ntoa(ziel_router[rnr].ip));
    return (-1);
 }

 sprintf (cmdbuf,"is_online()\n{\nRESUL=`%s/isipctl list | grep CONNECT | grep '%s'`\nif [ \"$RESUL\" != \"\" ]\nthen\nexit 1\nelse\nexit 0\nfi\n}\nis_online",isi_bindir,ziel_router[rnr].hostname);
 if (xxdebug)
    fprintf (stderr,"cmdbuf: %s \n",cmdbuf);
 rw = system (cmdbuf);
 if (xdebug)
    if (rw)
       fprintf (stderr,"alived: Router %s ist online!\n",ziel_router[rnr].hostname);
    else
       fprintf (stderr,"alived: Router %s ist NICHT online!\n",ziel_router[rnr].hostname);

 return (rw);
}

/*************************************************************/
char *hostbytelno(char *telno)
{
	return(isi_hostbytelno(telno));
}

/*************************************************************/
char *get_escape(char **escape)
{
	return(isi_default("BASE_iescape",escape));
}

int end_d_alive(int fd)
{
    t_unbind(fd);
    t_close(fd);
    return (0);
}

/***************************************************************************/
unsigned long get_router(unsigned long unix_ip)
{
 static unsigned long timeout=0;
 static int firsttime=1;
 static struct
 {
   unsigned long zielnetz;
   unsigned long gateway;
   int           is_gw;
 } route[200];
 unsigned long now=time(0);
 unsigned long zielnetmask;
 char *fname={"/usr/tmp/routelist"};
 char *param={" -nr | grep is | grep U >"};
 char command[100];
 char *zielnet;
 FILE *fptr;
 char buf[200];
 int  res,rn;
 struct stat statbuf;

 if (firsttime || (now > timeout))
 {      /* nur isdn-routen, die Used sind */
    strcpy (command,"/usr/ucb/netstat");
    if (stat(command,&statbuf))
    {
       /* jetzt in /usr/bin f}r unixware oder sco */
       strcpy (command,"/usr/bin/netstat");
       if (stat(command,&statbuf))
       {
          fprintf (stderr, "alived: konnte 'netstat' nicht finden!\n");
          return (0);
       }
    }
    sprintf (buf,"%s%s%s",command,param,fname);
    res=system(buf); /*achtung roby */
    if (res)
    {
       fprintf (stderr, "alived: %s fehlgeschlagen\n",buf);
       return (0);
    }
    fptr = fopen(fname,"rb+");
    if (!fptr)
    {
       fprintf (stderr, "alived: konnte %s nicht |ffnen!\n",fname);
       return (0);
    }

    rn=0;
    while (fgets(buf,200,fptr))
    {
       buf[15] = 0;
       route[rn].is_gw = 0;
       route[rn].zielnetz = 0;
       route[rn].zielnetz = get_nwaddr(buf);
       if (route[rn].zielnetz == 0)
          continue;

       if (isdigit(buf[17]))
       { /* dies ist nur bei sco der fall */
          buf[32] = 0;
          route[rn].gateway = inet_addr(&buf[17]);
       }
       else
       { /* interactive und unixware */
          buf[36] = 0;
          route[rn].gateway = inet_addr(&buf[21]);
       }
       if (route[rn].gateway == 0)
       {
          route[rn].zielnetz = 0;
          continue;
       }
       if (buf[43] == 'G')
          route[rn].is_gw = 1;
       rn++;
    }
    fclose (fptr);
    if (firsttime)
       timeout = now + 30;  /* falls sich die tabellen beim weiteren hochfahren noch dndern */
    else
       timeout = now + 300; /* falls sich die routen {ndern */
    firsttime = 0;
 }
 /* ab hier sind in route alle direkt erreichbaren Router und die dar}ber
    erreichbaren Netze verf}gbar */

 /* zundchst alle direkt erreichbaren durchsuchen */
 for (rn=0;route[rn].zielnetz != 0; rn++)
 {
    if (unix_ip == route[rn].gateway)
       return(route[rn].gateway);
 }

 /* nun die erreichbaren netze durchsuchen, und den Router f}r das Zielnetz
    zur}ckgeben */

 for (rn=0;route[rn].zielnetz != 0; rn++)
 {
    zielnet=(char *)&(route[rn].zielnetz);
    /*   zielnetmask = 0xffffffff; wird von gcc angemeckert */
    /*
    memset (&zielnetmask,0xff,4);
    */
    zielnetmask = 0xffffffffUL;
    if (!zielnet[3])
       zielnetmask = 0xffffff;
    if (!zielnet[2])
       zielnetmask = 0xffff;
    if (!zielnet[1])
       zielnetmask = 0xff;
    if ((unix_ip & zielnetmask) == (route[rn].zielnetz))
       if (route[rn].is_gw)
          return(route[rn].gateway);
       else
          return(unix_ip);
 }

 /* hat nicht geklappt */
 return (0);
}

/*************************************************************************/
int get_host_by_ip(unsigned long ip,char *hostname)
{
 int hosts,hnr;
 unsigned long router_ip;
 IsdnHost *hostdaten[1000];

 memset (hostdaten,0,1000*sizeof(IsdnHost*));
 if ((hosts = isdn_hosts_lesen(0, hostdaten, 1000, 1))<= 0) /* achtung roby */
 {
    fprintf (stderr,"alived: konnte keine ISDN-Hostdaten lesen!\n");
    return(0);
 }

 router_ip = get_router(ip);
 for (hnr=0;hnr<hosts;hnr++)
 {
    if (inet_addr(hostdaten[hnr]->ipadr) == ip)
       break;
 }

 if (hnr>=hosts)
 { /* hostname konnte mit absende-ip des alive-paketes nicht ermittelt werden */    if (router_ip)
    {
       for (hnr=0;hnr<hosts;hnr++)
       {
          if (inet_addr(hostdaten[hnr]->ipadr) == router_ip)
             break;
       }
    }
 }

 if (hnr<hosts)
 { /* hostname konnte aus absende-ip ermittelt werden */
    strcpy (hostname,hostdaten[hnr]->hostname);
    for (hnr=0;hnr<hosts;hnr++)
       free(hostdaten[hnr]);
    return (1);
 }
 else
 {
    for (hnr=0;hnr<hosts;hnr++)
       free(hostdaten[hnr]);
    return (0);
 }
}

