/*------------------------------------------------------------------------------
* BEREICH: PDS-OSIcom office
* DIR    : ../pds/isdn/lprg
* NAME   : isdn_resc.c
*-------------------------------------------------------------------------------
* INHALT : Ressourcen-Anfrage/Sperrung und Freigabe
* VON    : Michel/PDS    07.06.95
* VON    : Hinrichs/PDS  05.02.96   Umstellung auf Ressourcen-Server mit
*                                   Message-Queue
*	   Hinrichs/PDS  15.11.96   rcv_msg_1(), EINTR abgefangen
*-----------------------------------------------------------------------------*/

#include "tool/tool.h"
#undef STR

#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <signal.h>
#include <errno.h>
/*
#include <unistd.h>
*/
#include <time.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stropts.h>

#include "pds/fetsrv.h"
#include "pds/isdn_resc.h"
#include "pds/pdsisdn.h"

int   msg_timeout = 0;

static char *clean_nr	TB_PROTO(( char * ));
static char *seit_str	TB_PROTO(( time_t, char * ));
static int do_request	TB_PROTO(( msg_typ *, int ));
static int fill_info	TB_PROTO(( char ( *info ) [81] ));
static int get_server_pid	TB_PROTO(( void ));
static int open_msgq	TB_PROTO(( void ));
static int rcv_msg_1	TB_PROTO(( int, msg_typ *, long int ));
static void catch_alarm	TB_PROTO(( void ));

extern char *sys_errlist[];

static int   qid;

/*-----------------------------------------------------------------------
   isdn_resource_anfrage()

   Aufgabe:
   --------
   Anfrage fuer die Reservierung eines B-Kanals

   Parameter:
   ----------
   progbez    Programmbezeichung
   name       Programmname
   partner    ISDN-Teilnehmer (aus der Datei /usr/isi/config/hosts) oder
	      Telefonnummer, wenn Teilnehmer nicht bekannt
   lms        wenn TRUE  -> Anfrage ohne Reservierung
                            es wird nur geschaut, ob eine Verbindung aufgebaut
                            werden kann.
                            mu~ nicht wieder freigegeben werden
              wenn FALSE -> Anfrage mit Reservierung
                            mu~ explizit wieder freigegeben werden

   Returnwerte:
   ------------
   > 0 ok wenn lms=true, sonst b-kanal-nr
   -1 nichts frei
   -2 tempor{r belegt
   -3 interner Fehler z.B. channeld nicht aktiv
      Fehlermeldung wird auf stderr ausgegeben
----------------------------------------------------------------------*/
int isdn_resource_anfrage(progbez, name, partner,lms)

char  *progbez,
      *name,
      *partner;
int    lms;

{
 int result;
 msg_typ msg;
 char *envptr;

 if ((envptr = (char *)getenv ("LOGNAME")) == NULL)
 {
    fprintf (stderr, "isdn_resource_anfrage(): Umgebungsvariable LOGNAME nicht gesetzt!\n");
    return (-3);
 }

 msg.infotyp = IT_ANFRAGE;
 memcpy (msg.data.anfr.progbez,progbez,sizeof(msg.data.anfr.progbez));
 memcpy (msg.data.anfr.name,   name,   sizeof(msg.data.anfr.name));
 memcpy (msg.data.anfr.partner,partner, sizeof(msg.data.anfr.partner));
 strncpy(msg.data.anfr.user, envptr,20);
 msg.data.anfr.lms      = lms;
 msg.data.anfr.chan_cnt = 1;
 result = do_request (&msg,sizeof(anfrage_typ) + 12);
 if (result)
    return (-3);

 return (msg.data.anfr_a.port);
}

/*------------------------------------------------------------------------
   isdn_resource_aendern()

   Aufgabe:
   --------
   Aendern der Proze~-ID frage fuer die Reservierung eines B-Kanals

   Parameter:
   ----------
   port     Nummer der B-Kanals (1,2,....)
   pid      neue Prozess-ID

   Returnwerte:
   ------------
    0 OK
   -1 Fehler
      m|gliche Fehlermeldung wird auf stderr ausgegeben
----------------------------------------------------------------------*/
int isdn_resource_aendern(port, pid)

int port,
    pid;

{
 msg_typ msg;
 int result;

 msg.infotyp = IT_AENDERN;
 msg.data.aend.port = port;
 msg.data.aend.pid  = pid;
 result = do_request (&msg,sizeof(isdn_aendern_typ) + 12);
 if (result)
    return (-1);

 return (msg.data.res);
}

/*------------------------------------------------------------------------
   isdn_resource_freigabe()

   Aufgabe:
   --------
   Freigabe eines reservierten B-Kanals

   Parameter:
   ----------
   port     Nummer der B-Kanals (1,2,....)
            mu~ identisch sein mit der Portnr der vorangegangenen Anfrage

   Returnwerte:
   ------------
    0 OK
   -1 Fehler
      m|gliche Fehlermeldung wird auf stderr ausgegeben
----------------------------------------------------------------------*/
int isdn_resource_freigabe(port)

int port;
{
 int     result;
 msg_typ msg;

 msg.infotyp = IT_FREIGABE;
 msg.data.frei.port = port;
 result = do_request (&msg,sizeof(freigabe_typ) + 12);
 if (result)
    return (-1);

 return (msg.data.res);
}

/*----------------------------------------------------------------------------
** isdn_resource_anzeige()
**----------------------------------------------------------------------------
** R}ckgabe statistischer Daten aus der Ressourcendatenhaltung
**
** ]bergabe : int    kz = 0    Erste Zeile
**                   kz = 1    N{chste Zeile
**
**            char  *buf       Zeiger auf die Zeile
**
** R}ckgabe : int    -1        Fehler beim Aufruf
**                    0        Ende der Ausgabe
**                   >0        Zeil in buf abgelegt
*/

int isdn_resource_anzeige(kz, buf)

int   kz;
char *buf;
{
static char info[MAX_DYNPORTS+4][81];
static zeile;

   if (kz == 0)
   {
      if (fill_info(info) == -1)
         return (-1);
      zeile = 0;
   }
   strcpy (buf,info[zeile]);
   zeile++;
   return (strlen(buf));
}

/*------------------------------------------------------------------------
   int isdn_lms_start(partner)

   Aufgabe:
   --------
   Mitteilung an der channeld, da~ eine neue LMS-Verbindung besteht.
   Wird vom alived aufgerufen.

   Parameter:
   ----------
   partner  Name des neuen LMS-Partners aus /usr/isi/config/hosts

   Returnwerte:
   ------------
    0 OK
   -1 Fehler
      m|gliche Fehlermeldung wird auf stderr ausgegeben
----------------------------------------------------------------------*/
int isdn_lms_start(partner)

char  *partner;

{
 int result;
 msg_typ msg;

 msg.infotyp = IT_LMSSTART;
 memcpy (msg.data.lms_start.partner,partner,sizeof(msg.data.lms_start.partner));
 result = do_request (&msg,sizeof(lmsstart_typ) + 12);
 if (result)
    return (-1);

 return (msg.data.res);
}

/*------------------------------------------------------------------------
   int isdn_lms_stop(partner)

   Aufgabe:
   --------
   Mitteilung an der channeld, da~ eine neue LMS-Verbindung beendet ist.
   Wird vom alived aufgerufen.

   Parameter:
   ----------
   partner  Name des LMS-Partners aus /usr/isi/config/hosts

   Returnwerte:
   ------------
    0 OK
   -1 Fehler
      m|gliche Fehlermeldung wird auf stderr ausgegeben
----------------------------------------------------------------------*/
int isdn_lms_stop(partner)

char  *partner;

{
 int result;
 msg_typ msg;

 msg.infotyp = IT_LMSSTOP;
 memcpy (msg.data.lms_stop.partner,partner,sizeof(msg.data.lms_stop.partner));
 result = do_request (&msg,sizeof(lmsstop_typ) + 12);
 if (result)
    return (-1);

 return (msg.data.res);
}

/*------------------------------------------------------------------------
   int create_msgq()

   Aufgabe:
   --------
   Anlegen einer neuen Message-Queue.
   Wenn bereits eine Message-Queue besteht wird sie gel|scht und neu angelegt.
   Wird vom channeld aufgerufen.

   Parameter:
   ----------

   Returnwerte:
   ------------
   >= 0 QID (Queue-ID)
   -1   Fehler (Fehlerursache in errno)
----------------------------------------------------------------------*/
int create_msgq()
{
int msgqid;

   if ((msgqid=msgget(QKEY, IPC_PRIVATE|0666)) != -1)
      remove_msgq (msgqid);
   msgqid=msgget(QKEY, IPC_CREAT|0666);
   return (msgqid);
}


/*------------------------------------------------------------------------
   int remove_msgq(msgqid)

   Aufgabe:
   --------
   Entfernen der Message-Queue.
   Wird vom channeld aufgerufen.

   Parameter:
   ----------
   msgqid  ID der Queue

   Returnwerte:
   ------------
   0    OK
   -1   Fehler (Fehlerursache in errno)
----------------------------------------------------------------------*/
int remove_msgq(msgqid)
int msgqid;
{
 struct msqid_ds buf;

   return (msgctl(msgqid, IPC_RMID, &buf));
}

/*----------------------------------------------------------------------------
** isdn_update_timeres()
**----------------------------------------------------------------------------
** Info an den channeld, da~ die Zeitl. Reservierung ge{ndert wurde
**
** ]bergabe : keine
**
** R}ckgabe : int    -1        Fehler beim Aufruf
**                    0        OK
*/

int isdn_update_timeres ()
{
 int     result;
 msg_typ msg;

 msg.infotyp = IT_UPTIMERES;
 result = do_request (&msg,sizeof(update_typ) + 12);
 if (result)
    return (-1);

 return (msg.data.res);
}


/*-------------------------------------------------------------*/
static void catch_alarm()
{
   msg_timeout++;
   return;
}


/*------------------------------------------------------------------------
   int send_qmsg(qid,msg,msglen)

   Aufgabe:
   --------
   Verschicken einer Message.
   Wird vom channeld aufgerufen.
   Es wird max. 2s lang versucht

   Parameter:
   ----------
   qid    ID der Queue
   msg    Stuktur mit Message
   msg_len

   Returnwerte:
   ------------
   0    OK
   -1   Fehler (Fehlerursache m|gl. in errno)
----------------------------------------------------------------------*/
int send_qmsg(qqid, msg, msglen)
int      qqid;
msg_typ *msg;
int      msglen;
{
 int rw;

 while (1)
 {
    msg_timeout = 0;
    signal (SIGALRM, (void*) catch_alarm);
    alarm (2);
    rw = msgsnd(qqid, (struct msgbuf *)msg, msglen, 0);
    signal (SIGALRM, SIG_IGN);
    alarm (0);
    if (rw)
    {
       if (errno == EINTR)
          if (!msg_timeout) /* dann kann es kein alarm gewesen sein */
             continue;
       return (-1);
    }
    else
       return (0);
 }
}

/*------------------------------------------------------------------------
   int rcv_msg(qqid,msg,mtyp)

   Aufgabe:
   --------
   Nichtblockierendes Empfangen einer Message.
   Wird vom channeld aufgerufen.

   Parameter:
   ----------
   qid    ID der Queue
   msg    Stuktur mit Message
   mtyp   Message-Typ (f}r channeld per Definition = 1)

   Returnwerte:
   ------------
   >  0    Anzahl gelesener Bytes
   <= 0    nichts gelesen
----------------------------------------------------------------------*/
int rcv_msg(qqid,msg,mtyp)
int       qqid;
msg_typ  *msg;
long      mtyp;
{
   return (msgrcv(qqid, msg, MAX_MSGLEN, mtyp, IPC_NOWAIT));
}

/***********************************************************************/
int isinstr(s1,s2)
char *s1;
char *s2;
{
 int len1,len2,i;

 if ((!s1) || !(s2))
    return (0);

 len1=strlen(s1),
 len2=strlen(s2);
 if (len1 < len2)
    return(0);
 for (i=0;i<=len1-len2;i++)
 {
    if (!strncmp(&s1[i],s2,len2))
       return (1);
 }

 return (0);
}

static int fill_info(info)
char info[MAX_DYNPORTS+4][81];
{
 B_status_typ bstat[MAX_DYNPORTS];
 reserve_typ  res[MAX_DYNPORTS];
 msg_typ      msg;
 line_typ     l;
 int          b,bnr,zeile,result;
 int          bchans,len;
 int          pid;

 pid = getpid();
 msg.infotyp = IT_GETSTAT;
 result = do_request (&msg,sizeof(stat_typ) + 12);
 if (result)
    return (-1);

 bchans = msg.data.stat_a.bchans;
 memcpy (&bstat[0],&(msg.data.stat_a.bstat),sizeof (B_status_typ));
 memcpy (&res[0],&(msg.data.stat_a.res),sizeof (reserve_typ));

 for (b=1;b<bchans;b++)
 {
    len = rcv_msg_1(qid,&msg,pid);
    if (len <= 0)
    {
       if (msg_timeout)
       {
          msg_timeout = 0;
          isdn_error ("do_request(): Keine Antwort von channeld: Timeout!");
       }
       else
          isdn_error ("do_request(): Keine Antwort von channeld %s!",
                       sys_errlist[errno]);
       return (-1);
    }
    else
    {
       memcpy (&bstat[b],&(msg.data.stat_a.bstat),sizeof (B_status_typ));
       memcpy (&res[b],&(msg.data.stat_a.res),sizeof (reserve_typ));
    }
 }

 /* jetzt kann's losgehen */
 zeile  = 0;
 l.kanal  = 1;
 sprintf (info[zeile++], "AKTUELLE BELEGUNG DER B-KAN[LE/W[HLVERBINDUNGEN");
 sprintf (info[zeile++], "   ");
 sprintf (info[zeile++], "KANAL  PROG/DIENST      BENUTZER        GEGENSTELLE     BELEGT SEIT");

 /* zun{chst die reservierten Leitungen */
 for (b=0;b<bchans;b++)
 {
    if (res[b].reserved)
    {
       seit_str(res[b].seit,l.seit);
       if (res[b].lms)
       {
          strcpy (l.gegen,res[b].partner);
          strcpy (l.progbez,"LMS-VERBINDUNG");
          strcpy (l.user,"----------");
       }
       else
       {
          strcpy (l.user,res[b].user);
          strcpy (l.progbez,res[b].progbez);
          strcpy (l.gegen,res[b].partner);
          if (!l.gegen[0])
             strcpy (l.gegen,"----------");
       }
       /* jetzt die zeile abspeichern */
       sprintf (info[zeile++],"%2d     %-15.15s  %-15.15s %-15.15s %-15.15s",
                l.kanal,l.progbez,l.user,l.gegen,l.seit);
       l.kanal++;
    }
 }
 /* jetzt die physikalische Belegung, es d}rfen nur eingehende aufgenommen
    werden, die nicht schon in einer LMS-Reservierung aufgenommen sind */
 for (b=0;(b<bchans)&& (l.kanal <= bchans);b++)
 {
    if ((bstat[b].status == B_CONNECT) && (!bstat[b].outgoing))
    {
       /* erst mal schauen, ob es nicht eine LMS-Verbindung ist */
       for (bnr=0;bnr<bchans;bnr++)
       {
          if (res[bnr].lms &&
              (!strcmp (bstat[b].partner,res[bnr].partner)))
             break;
       }
       if (bnr < bchans) /* dann wars eine LMS-verbindung */
          continue;

       /* scheinbar ist alles ok */
       seit_str(bstat[b].time,l.seit);
       if (strcmp (bstat[b].partner,"UNBEKANNT"))
          strcpy (l.gegen,bstat[b].partner);
       else
          strcpy (l.gegen, clean_nr (bstat[b].rem_addr));
       if (strcmp (bstat[b].partner,"unbekannt"))
          strcpy (l.progbez,bstat[b].service);
       else
       {
          strncpy (l.progbez,bstat[b].loc_addr,6);
          l.progbez[6] = 0;
       }
       strcpy (l.user,"----------");
       sprintf (info[zeile++],"%2d     %-15.15s  %-15.15s %-15.15s %-15.15s",
                l.kanal,l.progbez,l.user,l.gegen,l.seit);
       l.kanal++;
    }
 }

 /* jetzt die physikalische Belegung von noch bestehenden ausgehenden
    ip-Verbindungen, die keine LMS-Reservierung mehr haben */
 for (b=0;(b<bchans)&& (l.kanal <= bchans);b++)
 {
    if ((bstat[b].status == B_CONNECT) && bstat[b].outgoing &&
         isinstr (bstat[b].service,"tcp/ip"))
    {
       for (bnr=0;bnr<bchans;bnr++)
       {
          if (res[bnr].lms &&
              (!strcmp (bstat[b].partner,res[bnr].partner)))
             break;
       }
       if (bnr < bchans) /* dann wars eine LMS-verbindung */
          continue;

       /* scheinbar ist alles ok */
       seit_str(bstat[b].time,l.seit);
       if (strcmp (bstat[b].partner,"UNBEKANNT"))
          strcpy (l.gegen,bstat[b].partner);
       else
          strcpy (l.gegen, clean_nr (bstat[b].rem_addr));
       if (strcmp (bstat[b].partner,"unbekannt"))
          strcpy (l.progbez,bstat[b].service);
       else
       {
          strncpy (l.progbez,bstat[b].loc_addr,6);
          l.progbez[6] = 0;
       }
       strcpy (l.user,"----------");
       sprintf (info[zeile++],"%2d     %-15.15s  %-15.15s %-15.15s %-15.15s",
                l.kanal,l.progbez,l.user,l.gegen,l.seit);
       l.kanal++;
    }
 }
 return (0);
}

static char *clean_nr(addr)
char *addr;
{
 char *p,buf[40];
 int  i;

 strcpy (buf,&addr[6]);
 p = strchr (buf,':');
 if (p) *p=0;

 for (i=0,p=buf;(buf[i]!=0) && (i<40);i++)
 {
    if (!isdigit(buf[i]))
    {
       p = &buf[i+2];
       i++;
    }
 }
 return (p);
}

static char *seit_str (seit,str)
time_t  seit;
char   *str;
{
 struct tm *loczeit;

 loczeit = localtime(&seit);
 sprintf (str,"%-2.2d.%-2.2d %-2.2d:%-2.2d:%-2.2d",
          loczeit->tm_mday,1 + loczeit->tm_mon,
          loczeit->tm_hour,loczeit->tm_min,loczeit->tm_sec);
 return (str);
}

/*-----------------------------------------------------------------------------
** open_msgq
** rcv_msg_1
** catch_alarm
** do_request
**-----------------------------------------------------------------------------
**
** Interne Funktionen zur Kommunikation via Message-Queue
**
*/

static int open_msgq()
{
int msgflags=IPC_PRIVATE|0666;
int msgqid;

   msgqid=msgget(QKEY, msgflags);
   return (msgqid);
}

/*-------------------------------------------------------------*/
static int rcv_msg_1(qqid,msg,mtyp)
int      qqid;
msg_typ *msg;
long     mtyp;
{
 int rw;

 do
 {
    errno = 0;
    msg_timeout = 0;
    signal (SIGALRM, (void*) catch_alarm);
    alarm (5);
    rw = msgrcv(qqid, (struct msgbuf *)msg, MAX_MSGLEN, mtyp, 0);
    signal (SIGALRM, SIG_IGN);
    alarm (0);
 }
 while (errno == EINTR);
 return (rw);
}

/*--------------------------------------------------------------------*/
static int get_server_pid ()
{
 char *envptr,fname[200],pidstr[11];
 FILE *pidfile;

 memset (pidstr,0,11);
 if ((envptr = (char *)getenv ("BASIS")) == NULL)
 {
    fprintf (stderr, "Umgebungsvariable BASIS nicht gesetzt!");
    return (0);
 }

 sprintf (fname,"%s/pds/isdn/pid/channeld.pid",envptr);

 pidfile = fopen (fname,"r");
 if (!pidfile)
 {
    isdn_error ("Fehler beim \ffnen des PID-Files %s",fname);
    return (0);
 }

 fgets (pidstr,10,pidfile);
 fclose (pidfile);
 return (atoi (pidstr));
}

/*--------------------------------------------------------------------*/
static int do_request (msg,msglen)
msg_typ *msg;
int      msglen;
{
 int  pid,server_pid;
 int  len;

 qid = open_msgq();
 if (qid == -1)
 {
    if (errno == ENOENT)
       isdn_error ("do_request(): Msg-Queue nicht vorhanden, B-Kanal-Server nicht aktiv");
    else
       isdn_error ("do_request(): Konnte Msg-Queue nicht |ffnen (%s)",sys_errlist[errno]);
    return (-1);
 }
 server_pid = get_server_pid ();
 if (!server_pid)
 {
    isdn_error ("do_request(): Kann PID des Servers nicht bestimmen!");
    return (-1);
 }

 if (kill (server_pid,0) == -1)
 {
    if (errno == ESRCH)
       isdn_error ("do_request(): B-Kanal-Server nicht aktiv");
    else
       isdn_error ("do_request(): Konnte Signal an Server nicht senden (%s)",sys_errlist[errno]);

    return (-1);
 }

 msg->mtype = 1;
 msg->pid = pid = getpid();

 if (send_qmsg (qid,msg,msglen))
 {
    if (msg_timeout)
    {
       msg_timeout = 0;
       isdn_error ("do_request(): send_qmsg(): Timeout");
    }
    else
       isdn_error ("do_request(): send_qmsg(): %s",sys_errlist[errno]);
    return (-1);
 }

 if (kill (server_pid,SIGUSR1))
 {
    if (errno == ESRCH)
       isdn_error ("do_request(): B-Kanal-Server nicht aktiv");
    else
       isdn_error ("do_request(): Konnte Signal an Server nicht senden (%s)",
                    sys_errlist[errno]);
    return (-1);
 }

 len = rcv_msg_1(qid,msg,pid);
 if (len <= 0)
 {
    if (msg_timeout)
    {
       msg_timeout = 0;
       isdn_error ("do_request(): Keine Antwort von channeld: Timeout!");
    }
    else
       isdn_error ("do_request(): Keine Antwort von channeld %s!",
                    sys_errlist[errno]);
    return (-1);
 }
 return(0);
}
