/******************************************************************************
**
** Dead-Session-Killer
**
** xchanges
** JH 13.06.95 vor anlegen einer neuen session wird jetzt geschaut, ob
**             bereits eine session mit dem gleichen tty besteht.
**             wenn ja, wird diese zunchst aus der liste geworfen und danach
**             die neue angelegt.
*******************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
/*
#include <malloc.h>
*/
#include <sys/types.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <netdb.h>
#include <netinet/in.h>
#include <string.h>
#include <signal.h>
#include <time.h>

#include "fetsrv.h"

/*--------------------------------------------------------------------*/
#define REGISTER_SESSION        1
#define KILL_SESSION            2
#define KILL_END_SESSION        3
/*--------------------------------------------------------------------*/
int    debug = 0;
char tt[50];
time_t t;

struct servent killer_service;
int            killer_socket;

/*--------------------------------------------------------------------*/

char *FindSession		TB_PROTO(( char * ));
char *FindSession_by_tty	TB_PROTO(( char * ));
int InsertSession		TB_PROTO(( char * ));
int KillProcesses		TB_PROTO(( char * ));
int KillSession			TB_PROTO(( char * ));
int RemoveSession_by_tty	TB_PROTO(( char * ));
int get_services		TB_PROTO(( void ));
int get_sockets			TB_PROTO(( void ));

/*--------------------------------------------------------------------*/
typedef struct SessionInfo
{
  char           ip[4];
  unsigned short socket;
  char           xsum[2];
  char           tty[15];
  void           *next;
} SessionInfo;

SessionInfo *head=NULL;
/*--------------------------------------------------------------------*/
int InsertSession(ip)
char *ip;
{ SessionInfo *new;

  if ((new = (SessionInfo *) malloc(sizeof(SessionInfo))) == NULL)
    return 0;
  new->next = (void *) head;
  head = new;
  memcpy(new, ip, sizeof(SessionInfo)-sizeof(head->next));
  return 1;
}


/*--------------------------------------------------------------------*/
char *FindSession(ip)
char *ip;
{ SessionInfo *act;

  for (act=head; act!=NULL; act=(SessionInfo *)act->next)
    if (memcmp(ip, act->ip, 6) == 0)
      return act->tty;

  return NULL;
}
/*--------------------------------------------------------------------*/
char *FindSession_by_tty(tty)
char *tty;
{ SessionInfo *act;

  for (act=head; act!=NULL; act=(SessionInfo *)act->next)
    if (strncmp (tty, act->tty,15) == 0)
      return act->tty;

  return NULL;
}


/*--------------------------------------------------------------------*/
int KillSession(ip)
char *ip;
{ SessionInfo *act, *last=NULL;

  for (act=head; act!=NULL; act=(SessionInfo *) act->next)
    if (memcmp(ip, act->ip, 6) == 0)
      break;
    else
      last = act;

  if (act == NULL) return 0;
  if (last != NULL)
    last->next = act->next;
  else
    head = (SessionInfo *) act->next;
  free(act);
  return 1;
}

/*--------------------------------------------------------------------*/
int RemoveSession_by_tty(tty)
char *tty;
{ SessionInfo *act, *last=NULL;

  for (act=head; act!=NULL; act=(SessionInfo *) act->next)
    if (strncmp(tty,act->tty,15) == 0)
      break;
    else
      last = act;

  if (act == NULL) return 0;
  if (last != NULL)
    last->next = act->next;
  else
    head = (SessionInfo *) act->next;
  free(act);
  return 1;
}

/*--------------------------------------------------------------------*/

static int isdigit(c)
char c;
{
  return (c>='0') && (c<='9');
}

int KillProcesses(tty)
char *tty;
{ char cmd[80], *filename="/tmp/killer.list", *buf;
  int ret, retval=0, nread, n, i, j;
  int killsig[5];
  int processnr;
  unsigned bufsize;
  FILE *fp;

  if (debug)
  {
    t=time(0);
    strcpy (tt, (char*) ctime(&t));
    tt[19]=0;
    fprintf(stderr, "%s | KILLER: I want to kill processes for %s\n",tt, tty);
  }

  sprintf(cmd, "ps -ft %s > %s", tty,filename);
  ret = system(cmd);
  if (debug)
    fprintf(stderr, "KILLER: system returned %d\n", ret);

/* jetzt beginnt erst das eigentliche gemetzel */
  if ((fp=fopen(filename, "r")) == NULL)
  {
    if (debug)
      fprintf(stderr, "KILLER: failed to open killer file %s!\n", filename);
    return 0;
  }
  fseek(fp,  0, SEEK_END);
  bufsize = (unsigned) ftell(fp);
  rewind(fp);
  if (debug)
    bufsize++;

  if ((buf=(char *) malloc(bufsize)) == NULL)
  {
    if (debug)
      fprintf(stderr, "KILLER: cannot allocate buffer for reading process list from %s!\n", filename);
    goto closefile;
  }

  if (debug)
    bufsize--;

  if ((nread=fread(buf, 1, bufsize, fp)) != bufsize)
  {
    if (debug)
      fprintf(stderr, "KILLER: cannot read process list from %s!\n", filename);
    goto freebuffer;
  }

  if (debug)
  {
     fprintf(stderr, "***********************************************\n");
     buf[nread] = (char) 0;
     fprintf(stderr, "%s",buf);
     fprintf(stderr, "-----------------------------------------------\n");
  };

/* jetzt die einzelnen zeilen abgrasen */
  killsig[0]=15; killsig[1]=1; killsig[2]=2; killsig[3]=3; killsig[4]=9;
  for(n=0;n<5;n++)
  {
    for(i=0; i<nread; i++)
    {
        if (i==0)
           goto nextline;

/* jetzt erst mal hinter das login springen JH 26.08.97 */
        for( ;(buf[i] != ' ') && (buf[i] != 9); i++) ;

        if (isdigit(buf[i]))
        {
          for (j=i;buf[j]!=':';j++) ;
          for ( ; (buf[j]!=' ') && (buf[j]!= ((char) 9)); j++) ;
          for ( ; (buf[j]==' ') || (buf[j]== ((char) 9)); j++) ;
          if (memcmp(tty, &buf[j], strlen(tty)))
            goto nextline;

	  processnr=atoi(&buf[i]);
	  if (debug && n == 0)
          {
             fprintf(stderr,"Ich kille jetzt %d\n",processnr);
	     if (processnr > 100)
                fprintf(stderr,"Ich kille jetzt %d\n",processnr);
             else
                fprintf(stderr,"Die Process-ID %d ist verd{chtig. Kein Kill\n",processnr);
          }
 
	  if (processnr > 100)
	     kill(processnr, killsig[n]);

nextline:
          for( ;buf[i] != 0x0a; i++) ;
        }
    }
  sleep(2);
  }
  retval = 1;

freebuffer:
  free(buf);

closefile:
  fclose(fp);
  return retval;
}

/*--------------------------------------------------------------------*/

int main(argc,argv)
int argc;
char *argv[];

{
int                received, i;
short 		   port;
size_t		   addrlen;
struct sockaddr_in remote;
char               buffer[1024], *tty, c;
unsigned long      r_addr;
unsigned short    *cmd=(unsigned short *)buffer;
struct in_addr    in;

   if (argc > 1)
      debug = 1;
   else
      debug = 0;

   if (!get_services())
      exit (1);

   if (!get_sockets())
      exit (1);

   setuid(0); /* owner root */
   freopen("/dev/null","r",stdin);
   freopen("/dev/null","w",stdout);

   bzero(&remote, sizeof(remote));
   remote.sin_family = AF_INET;
   remote.sin_addr.s_addr = INADDR_ANY;
   remote.sin_port = killer_service.s_port;

   addrlen = sizeof(remote);
   if (bind (killer_socket, (struct sockaddr *) &remote, addrlen) < 0)
   {
      perror ("bind");
      exit (1);
   }

   while(1)
   {
      received = recvfrom (killer_socket, buffer, sizeof(buffer), 0 , (struct sockaddr *) &remote, &addrlen);

      if (received > 0)
      {
         if (debug)
         {
	    r_addr = ntohl(remote.sin_addr.s_addr);
	    t=time(0);
	    strcpy (tt, (char*) ctime(&t));
	    tt[19]=0;
	    fprintf(stderr,"%s | Got packet from %s\n",tt, (char*) inet_ntoa(remote.sin_addr));
	    fprintf (stderr, "    cmd=%04x, ",*cmd);
	    in.s_addr = *((long*)&buffer[2]);
	    memcpy (&port,&buffer[6],2);
            fprintf (stderr, " FET=%s, socket=%x", (char*) inet_ntoa(in),port);
            if (*cmd == REGISTER_SESSION)
              fprintf(stderr, ", tty=%s", (char *) &buffer[10]);
            fprintf(stderr, "\n");
	    fflush(stderr);
         }

         switch (*cmd)
         {
           case REGISTER_SESSION:
/* checksum */
                 c = 0;
                 for(i=10;buffer[i];i++)
                   c ^= buffer[i];
                 if (c != buffer[8])
                 {
                   if (debug)
                     fprintf(stderr, "wrong checksum, calc=%d, got %d!\n", (int) c, (int) buffer[8]);
                   continue;
                 }
                 if ((i-10) != ((int) buffer[9]))
                 {
                   if (debug)
                     fprintf(stderr, "wrong len, ttylen=%d, got %d!\n", (int) (i-10), (int) buffer[9]);
                   continue;
                 }
/* checksum */
                 if (FindSession(&buffer[2]) != NULL)
                 {
                   if (debug)
                     fprintf(stderr, "KILLER: Can't register session, it's already there !\n");
		     fflush(stderr);
                 }
                 else
                 {
                    if (FindSession_by_tty(&buffer[10]) != NULL)
                    {
                       if (debug)
                       {
                          fprintf(stderr,"KILLER: bereits andere Session mit gleichem TTY gefunden\n");
                          fprintf(stderr,"        lsche alte Session zuerst aus Liste \n");
		          fflush(stderr);
                       }
                       RemoveSession_by_tty(&buffer[10]);
                    }

                    InsertSession(&buffer[2]);
                 }
                 break;
           case KILL_SESSION:
                 if ( (tty = FindSession(&buffer[2])) == NULL)
                 {
                   if (debug)
                     fprintf(stderr, "KILLER: Can't kill unknown session !\n");
                 }
                 else
                 {
                   KillProcesses(tty);
                   KillSession(&buffer[2]);
                 };
                 break;
           case KILL_END_SESSION:
                 if ((tty = FindSession(&buffer[2])) == NULL)
                 {
                   if (debug)
                     fprintf(stderr, "KILLER: Can't stop unknown session on %s!\n", tty);
                 }
                 else
                   if (!KillSession(&buffer[2]))
                   {
                     if (debug)
                       fprintf(stderr, "KILLER: Can't stop unknown session on %s!\n", tty);
                   }
                   else
                   {
                     if (debug)
                       fprintf(stderr, "KILLER: stop session on %s!\n", tty);
                   }
                 break;
           default:
                 if (debug)
                   fprintf(stderr, "KILLER: Got unknown command !\n");
                 break;
         }
      }
      else if (debug)
	       fprintf(stderr, "KILLER: recvfrom error: errno = %d\n",errno);
   fflush(stderr);
   }
}


/***************************************************************************/

/**********************************************************************/
int get_services()
{
struct servent *service;

   if ((service = getservbyname("killer", "udp")) == NULL)
   {
      fprintf(stderr, "KILLER: error in getservbyname(), errno=%d\n",errno);
      return (0);
   }
   else
      bcopy (service,&killer_service,sizeof (struct servent));

 return (1);
}

/**********************************************************************/
int get_sockets()
{
   if ((killer_socket = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
   {
      fprintf(stderr, "KILLER: error in socket(), errno=%d\n",errno);
      return (0);
   }

 return (1);
}
